/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene50;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public final class Lucene50LiveDocsFormat
extends LiveDocsFormat {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene50LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        block12: {
            long gen = info.getDelGen();
            String name = IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)EXTENSION, (long)gen);
            int length = info.info.maxDoc();
            try (ChecksumIndexInput input = EndiannessReverserUtil.openChecksumInput(dir, name, context);){
                Bits bits;
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)0, (byte[])info.info.getId(), (String)Long.toString(gen, 36));
                    FixedBitSet fbs = this.readFixedBitSet((IndexInput)input, length);
                    if (fbs.length() - fbs.cardinality() != info.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info.getDelCount(), (DataInput)input);
                    }
                    bits = fbs.asReadOnlyBits();
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                    }
                    catch (Throwable throwable) {
                        CodecUtil.checkFooter((ChecksumIndexInput)input, priorE);
                        throw throwable;
                    }
                    CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
                    break block12;
                }
                CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
                return bits;
            }
        }
        throw new AssertionError();
    }

    private FixedBitSet readFixedBitSet(IndexInput input, int length) throws IOException {
        long[] data = new long[FixedBitSet.bits2words((int)length)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = input.readLong();
        }
        return new FixedBitSet(data, length);
    }

    public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        int delCount;
        long gen = info.getNextDelGen();
        String name = IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)EXTENSION, (long)gen);
        try (IndexOutput output = EndiannessReverserUtil.createOutput(dir, name, context);){
            CodecUtil.writeIndexHeader((DataOutput)output, (String)CODEC_NAME, (int)0, (byte[])info.info.getId(), (String)Long.toString(gen, 36));
            delCount = this.writeBits(output, bits);
            CodecUtil.writeFooter((IndexOutput)output);
        }
        if (delCount != info.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + delCount + " info.delcount=" + info.getDelCount() + " newdelcount=" + newDelCount, name);
        }
    }

    private int writeBits(IndexOutput output, Bits bits) throws IOException {
        int delCount = 0;
        int longCount = FixedBitSet.bits2words((int)bits.length());
        for (int i = 0; i < longCount; ++i) {
            int j;
            long currentBits = 0L;
            int end = Math.min(j + 63, bits.length() - 1);
            for (j = i << 6; j <= end; ++j) {
                if (bits.get(j)) {
                    currentBits |= 1L << j;
                    continue;
                }
                ++delCount;
            }
            output.writeLong(currentBits);
        }
        return delCount;
    }

    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)EXTENSION, (long)info.getDelGen()));
        }
    }
}

