/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class PopupMenuAction
extends WidgetAction.Adapter {
    private PopupMenuProvider provider;

    public PopupMenuAction(PopupMenuProvider popupMenuProvider) {
        this.provider = popupMenuProvider;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.handleMouseEvent(widget, widgetMouseEvent);
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.handleMouseEvent(widget, widgetMouseEvent);
    }

    protected WidgetAction.State handleMouseEvent(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (widgetMouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = this.provider.getPopupMenu(widget, widgetMouseEvent.getPoint());
            if (jPopupMenu != null) {
                Scene scene = widget.getScene();
                Point point = scene.convertSceneToView(widget.convertLocalToScene(widgetMouseEvent.getPoint()));
                jPopupMenu.show(scene.getView(), point.x, point.y);
            }
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        if (widgetKeyEvent.getKeyCode() == 525 || (widgetKeyEvent.getModifiers() & 1) == 1 && widgetKeyEvent.getKeyCode() == 121) {
            JComponent jComponent;
            JPopupMenu jPopupMenu = this.provider.getPopupMenu(widget, null);
            if (jPopupMenu != null && (jComponent = widget.getScene().getView()) != null) {
                Rectangle rectangle = widget.getBounds();
                Point point = new Point(rectangle.x + 5, rectangle.y + 5);
                point = widget.convertLocalToScene(point);
                point = widget.getScene().convertSceneToView(point);
                jPopupMenu.show(jComponent, point.x, point.y);
            }
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }
}

