/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.config.ConfigIO;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultWorkflowExecutor
extends WorkflowExecutor {
    private static final Logger LOGGER = LogManager.getLogger();

    public DefaultWorkflowExecutor(State state) {
        super(WorkflowExecutorType.DEFAULT, state);
    }

    @Override
    public void executeWorkflow() throws WorkflowExecutionException {
        List<TlsContext> allTlsContexts = this.state.getAllTlsContexts();
        if (this.config.isWorkflowExecutorShouldOpen().booleanValue()) {
            for (TlsContext ctx : allTlsContexts) {
                AliasedConnection con = ctx.getConnection();
                if (con.getLocalConnectionEndType() == ConnectionEndType.SERVER) {
                    LOGGER.info("Waiting for incoming connection on " + con.getHostname() + ":" + con.getPort());
                } else {
                    LOGGER.info("Connecting to " + con.getHostname() + ":" + con.getPort());
                }
                ctx.initTransportHandler();
                LOGGER.debug("Connection for " + ctx + " initiliazed");
            }
        }
        for (TlsContext ctx : this.state.getAllTlsContexts()) {
            ctx.initRecordLayer();
        }
        this.state.getWorkflowTrace().reset();
        int numTlsContexts = allTlsContexts.size();
        List<TlsAction> tlsActions = this.state.getWorkflowTrace().getTlsActions();
        for (TlsAction action : tlsActions) {
            if (numTlsContexts == 1 && this.state.getTlsContext().isEarlyCleanShutdown()) {
                LOGGER.debug("Clean shutdown of execution flow");
                break;
            }
            if (this.state.getConfig().isStopActionsAfterFatal().booleanValue() && this.isReceivedFatalAlert()) {
                LOGGER.debug("Skipping all Actions, received FatalAlert, StopActionsAfterFatal active");
                break;
            }
            if (this.state.getConfig().getStopActionsAfterIOException().booleanValue() && this.isIoException()) {
                LOGGER.debug("Skipping all Actions, received IO Exception, StopActionsAfterIOException active");
                break;
            }
            try {
                action.execute(this.state);
            }
            catch (PreparationException | WorkflowExecutionException ex) {
                throw new WorkflowExecutionException("Problem while executing Action:" + action.toString(), ex);
            }
            if (!this.config.isStopTraceAfterUnexpected().booleanValue() || action.executedAsPlanned()) continue;
            LOGGER.debug("Skipping all Actions, action did not execute as planned.");
            break;
        }
        if (this.state.getConfig().isWorkflowExecutorShouldClose().booleanValue()) {
            for (TlsContext ctx : this.state.getAllTlsContexts()) {
                try {
                    ctx.getTransportHandler().closeConnection();
                }
                catch (IOException ex) {
                    LOGGER.warn("Could not close connection for context " + ctx);
                    LOGGER.debug((Object)ex);
                }
            }
        }
        if (this.state.getConfig().isResetWorkflowtracesBeforeSaving().booleanValue()) {
            this.state.getWorkflowTrace().reset();
        }
        this.state.storeTrace();
        if (this.config.getConfigOutput() != null) {
            ConfigIO.write(this.config, new File(this.config.getConfigOutput()));
        }
    }

    private boolean isReceivedFatalAlert() {
        for (TlsContext ctx : this.state.getAllTlsContexts()) {
            if (!ctx.isReceivedFatalAlert()) continue;
            return true;
        }
        return false;
    }

    private boolean isIoException() {
        for (TlsContext ctx : this.state.getAllTlsContexts()) {
            if (!ctx.isReceivedTransportHandlerException()) continue;
            return true;
        }
        return false;
    }
}

