/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.model.Context;

public class ContextSelectComboBox
extends JComboBox<Context> {
    private static final long serialVersionUID = 6177823947839642740L;

    public ContextSelectComboBox() {
        this.reloadContexts(false);
        this.setRenderer(new ContextComboBoxRenderer());
    }

    public void reloadContexts(boolean keepSelected) {
        Context selected = null;
        if (keepSelected) {
            selected = (Context)this.getSelectedItem();
        }
        List<Context> contexts = Model.getSingleton().getSession().getContexts();
        Context[] contextsArray = contexts.toArray(new Context[contexts.size()]);
        DefaultComboBoxModel<Context> model = new DefaultComboBoxModel<Context>(contextsArray);
        model.setSelectedItem(selected);
        this.setModel(model);
    }

    public Context getSelectedContext() {
        return (Context)this.getSelectedItem();
    }

    private static class ContextComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final Border BORDER = new EmptyBorder(2, 8, 2, 8);
        private static final long serialVersionUID = 3272133514462699823L;

        private ContextComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                Context item = (Context)value;
                this.setText(item.getName());
                this.setBorder(BORDER);
            }
            return this;
        }
    }
}

