from __future__ import (absolute_import, division, print_function)
# Copyright (c) 2022 Fortinet
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

__metaclass__ = type

import json


SCHEMA_DATA = '''
{
    "dvmdb_adom_objectmember": {
        "stated": true,
        "options": {
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "vdom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvmdb_script_objectmember": {
        "stated": true,
        "options": {
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "vdom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pkg_firewall_interfacepolicy_sectionvalue": {
        "stated": true,
        "options": {
            "attr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "label",
                    "global-label"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pkg_firewall_interfacepolicy6_sectionvalue": {
        "stated": true,
        "options": {
            "attr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "label",
                    "global-label"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pkg_firewall_policy_sectionvalue": {
        "stated": true,
        "options": {
            "attr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "label",
                    "global-label"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pkg_firewall_policy6_sectionvalue": {
        "stated": true,
        "options": {
            "attr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "label",
                    "global-label"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            }
        }
    },
    "pkg_firewall_proxypolicy_sectionvalue": {
        "stated": true,
        "options": {
            "attr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "label",
                    "global-label"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvmdb_group_objectmember": {
        "stated": true,
        "options": {
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "vdom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pkg_firewall_consolidated_policy_sectionvalue": {
        "stated": true,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "deny",
                    "accept",
                    "ipsec"
                ],
                "type": "str"
            },
            "app-category": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "app-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "application": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "application-list": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "auto-asic-offload": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "av-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "cifs-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "comments": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "diffserv-forward": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diffserv-reverse": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diffservcode-forward": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "diffservcode-rev": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "dlp-sensor": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "dnsfilter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "dstaddr4": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "dstaddr6": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "dstintf": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "emailfilter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "fixedport": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "groups": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "http-policy-redirect": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "icap-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "inbound": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "inspection-mode": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "proxy",
                    "flow"
                ],
                "type": "str"
            },
            "internet-service": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "internet-service-custom": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-custom-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-id": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-src": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "internet-service-src-custom": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-src-custom-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-src-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-src-id": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "ippool": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ips-sensor": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "logtraffic": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "all",
                    "utm"
                ],
                "type": "str"
            },
            "logtraffic-start": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "mms-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "nat": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "outbound": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "per-ip-shaper": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "policyid": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "poolname4": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "poolname6": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "profile-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "profile-protocol-options": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "profile-type": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "single",
                    "group"
                ],
                "type": "str"
            },
            "schedule": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "service": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "session-ttl": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "srcaddr4": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "srcaddr6": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "srcintf": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "ssh-filter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "ssh-policy-redirect": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ssl-ssh-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "tcp-mss-receiver": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "tcp-mss-sender": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "traffic-shaper": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "traffic-shaper-reverse": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "url-category": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "users": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "utm-status": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "uuid": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "voip-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "vpntunnel": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "waf-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "wanopt": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "wanopt-detection": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "active",
                    "passive",
                    "off"
                ],
                "type": "str"
            },
            "wanopt-passive-opt": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "default",
                    "transparent",
                    "non-transparent"
                ],
                "type": "str"
            },
            "wanopt-peer": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "wanopt-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "webcache": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webcache-https": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webfilter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "webproxy-forward-server": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "webproxy-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "captive-portal-exempt": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dstaddr-negate": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fsso-groups": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "global-label": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-negate": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "internet-service-src-negate": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "service-negate": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "srcaddr-negate": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "pkg_firewall_securitypolicy_sectionvalue": {
        "stated": true,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "deny",
                    "accept"
                ],
                "type": "str"
            },
            "app-category": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "app-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "application": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "application-list": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "av-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "cifs-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "comments": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dlp-sensor": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": false
                },
                "type": "str"
            },
            "dnsfilter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dstaddr4": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "dstaddr6": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dstintf": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "emailfilter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "enforce-default-app-port": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "groups": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "icap-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "internet-service-custom": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-custom-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-id": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-negate": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "internet-service-src": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "internet-service-src-custom": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-src-custom-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-src-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-src-id": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "internet-service-src-negate": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ips-sensor": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "logtraffic": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "all",
                    "utm"
                ],
                "type": "str"
            },
            "logtraffic-start": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "mms-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "policyid": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "profile-group": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "profile-protocol-options": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "profile-type": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "single",
                    "group"
                ],
                "type": "str"
            },
            "schedule": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "service": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "service-negate": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "srcaddr4": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "srcaddr6": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "srcintf": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ssh-filter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ssl-ssh-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "url-category": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "users": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "utm-status": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "uuid": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "voip-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "webfilter-profile": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "fsso-groups": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "global-label": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "send-deny-packet": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dstaddr": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-name": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "internet-service-src-name": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "srcaddr": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dstaddr-negate": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "file-filter-profile": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "srcaddr-negate": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "learning-mode": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "videofilter-profile": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "_policy_block": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            },
            "dlp-profile": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "nat46": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "nat64": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "sctp-filter-profile": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pm_config_pblock_firewall_policy_sectionvalue": {
        "stated": true,
        "options": {
            "attr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "label",
                    "global-label"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pm_config_pblock_firewall_securitypolicy_sectionvalue": {
        "stated": true,
        "options": {
            "attr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "label",
                    "global-label"
                ],
                "type": "str"
            },
            "name": {
                "required": true,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "exec_fgfm_reclaimdevtunnel": {
        "stated": true,
        "options": {
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "force",
                    "get_info"
                ]
            }
        }
    },
    "dvm_cmd_update_devlist": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            },
            "update-dev-member-list": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "dvm_cmd_update_device": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "device": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            }
        }
    },
    "sys_logout": {
        "stated": true,
        "options": {}
    },
    "dvm_cmd_del_devlist": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "del-dev-member-list": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            }
        }
    },
    "dvm_cmd_del_device": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "device": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            }
        }
    },
    "dvmdb_device_replace_sn": {
        "stated": true,
        "options": {
            "sn": {
                "required": false,
                "type": "str"
            }
        }
    },
    "securityconsole_install_device": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dev_rev_comments": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "preview",
                    "auto_lock_ws"
                ]
            },
            "scope": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "securityconsole_install_package": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "adom_rev_comments": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "adom_rev_name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dev_rev_comments": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "cp_all_objs",
                    "preview",
                    "generate_rev",
                    "copy_assigned_pkg",
                    "unassign",
                    "ifpolicy_only",
                    "no_ifpolicy",
                    "objs_only",
                    "auto_lock_ws",
                    "check_pkg_st",
                    "copy_only"
                ]
            },
            "pkg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "scope": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "securityconsole_install_preview": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "device": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "json"
                ]
            },
            "vdoms": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvm_cmd_add_devlist": {
        "stated": true,
        "options": {
            "add-dev-list": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "adm_pass": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "adm_usr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "desc": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "device action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "faz.quota": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "meta fields": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "mgmt_mode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unreg",
                            "fmg",
                            "faz",
                            "fmgfaz"
                        ],
                        "type": "str"
                    },
                    "mr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "os_type": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "fos",
                            "fsw",
                            "foc",
                            "fml",
                            "faz",
                            "fwb",
                            "fch",
                            "fct",
                            "log",
                            "fmg",
                            "fsa",
                            "fdd",
                            "fac",
                            "fpx",
                            "fna"
                        ],
                        "type": "str"
                    },
                    "os_ver": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "0.0",
                            "1.0",
                            "2.0",
                            "3.0",
                            "4.0",
                            "5.0",
                            "6.0",
                            "7.0",
                            "8.0"
                        ],
                        "type": "str"
                    },
                    "patch": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "platform_str": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sn": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "device blueprint": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            }
        }
    },
    "dvm_cmd_add_device": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "device": {
                "required": false,
                "type": "dict",
                "options": {
                    "adm_pass": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "adm_usr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "desc": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "device action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "faz.quota": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "meta fields": {
                        "required": false,
                        "type": "dict"
                    },
                    "mgmt_mode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unreg",
                            "fmg",
                            "faz",
                            "fmgfaz"
                        ],
                        "type": "str"
                    },
                    "mr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "os_type": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "fos",
                            "fsw",
                            "foc",
                            "fml",
                            "faz",
                            "fwb",
                            "fch",
                            "fct",
                            "log",
                            "fmg",
                            "fsa",
                            "fdd",
                            "fac",
                            "fpx",
                            "fna"
                        ],
                        "type": "str"
                    },
                    "os_ver": {
                        "required": false,
                        "choices": [
                            "unknown",
                            "0.0",
                            "1.0",
                            "2.0",
                            "3.0",
                            "4.0",
                            "5.0",
                            "6.0",
                            "7.0",
                            "8.0"
                        ],
                        "type": "str"
                    },
                    "patch": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "platform_str": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sn": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "device blueprint": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            },
            "groups": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "dvm_cmd_changehaseq": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "device": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            },
            "new_master": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvm_cmd_discover_device": {
        "stated": true,
        "options": {
            "device": {
                "required": false,
                "type": "dict",
                "options": {
                    "adm_pass": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "adm_usr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "dvm_cmd_import_devlist": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            },
            "import-adom-members": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "adom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "dev": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "import-adoms": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "desc": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "flags": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "migration",
                            "db_export",
                            "no_vpn_console",
                            "backup",
                            "other_devices",
                            "central_sdwan",
                            "is_autosync",
                            "per_device_wtp",
                            "policy_check_on_install",
                            "install_on_policy_check_fail",
                            "auto_push_cfg",
                            "per_device_fsw"
                        ]
                    },
                    "log_db_retention_hours": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log_disk_quota": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log_disk_quota_alert_thres": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log_disk_quota_split_ratio": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log_file_retention_hours": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "meta fields": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "dict"
                    },
                    "mig_mr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "mig_os_ver": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "0.0",
                            "1.0",
                            "2.0",
                            "3.0",
                            "4.0",
                            "5.0",
                            "6.0",
                            "7.0",
                            "8.0"
                        ],
                        "type": "str"
                    },
                    "mode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "ems",
                            "gms",
                            "provider"
                        ],
                        "type": "str"
                    },
                    "mr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "os_ver": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "0.0",
                            "1.0",
                            "2.0",
                            "3.0",
                            "4.0",
                            "5.0",
                            "6.0",
                            "7.0",
                            "8.0"
                        ],
                        "type": "str"
                    },
                    "restricted_prds": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "fos",
                            "foc",
                            "fml",
                            "fch",
                            "fwb",
                            "log",
                            "fct",
                            "faz",
                            "fsa",
                            "fsw",
                            "fmg",
                            "fdd",
                            "fac",
                            "fpx",
                            "fna",
                            "fdc",
                            "ffw",
                            "fsr",
                            "fad",
                            "fap",
                            "fxt",
                            "fts",
                            "fai",
                            "fwc"
                        ]
                    },
                    "state": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "uuid": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "create_time": {
                        "required": false,
                        "revision": {
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "workspace_mode": {
                        "required": false,
                        "revision": {
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "import-devices": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "adm_pass": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "adm_usr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "app_ver": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "av_ver": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "beta": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "branch_pt": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "build": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "checksum": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "conf_status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "insync",
                            "outofsync"
                        ],
                        "type": "str"
                    },
                    "conn_mode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "active",
                            "passive"
                        ],
                        "type": "str"
                    },
                    "conn_status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "UNKNOWN",
                            "up",
                            "down"
                        ],
                        "type": "str"
                    },
                    "db_status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "nomod",
                            "mod"
                        ],
                        "type": "str"
                    },
                    "desc": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "dev_status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "none",
                            "unknown",
                            "checkedin",
                            "inprogress",
                            "installed",
                            "aborted",
                            "sched",
                            "retry",
                            "canceled",
                            "pending",
                            "retrieved",
                            "changed_conf",
                            "sync_fail",
                            "timeout",
                            "rev_revert",
                            "auto_updated"
                        ],
                        "type": "str"
                    },
                    "fap_cnt": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "faz.full_act": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "faz.perm": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "faz.quota": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "faz.used": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "fex_cnt": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "flags": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "has_hdd",
                            "vdom_enabled",
                            "discover",
                            "reload",
                            "interim_build",
                            "offline_mode",
                            "is_model",
                            "fips_mode",
                            "linked_to_model",
                            "ip-conflict",
                            "faz-autosync"
                        ]
                    },
                    "foslic_cpu": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "foslic_dr_site": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "foslic_inst_time": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "foslic_last_sync": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "foslic_ram": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "foslic_type": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "temporary",
                            "trial",
                            "regular",
                            "trial_expired"
                        ],
                        "type": "str"
                    },
                    "foslic_utm": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "fw",
                            "av",
                            "ips",
                            "app",
                            "url",
                            "utm",
                            "fwb"
                        ]
                    },
                    "fsw_cnt": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ha_group_id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ha_group_name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "ha_mode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "standalone",
                            "AP",
                            "AA",
                            "ELBC",
                            "DUAL",
                            "enabled",
                            "unknown",
                            "fmg-enabled",
                            "autoscale"
                        ],
                        "type": "str"
                    },
                    "ha_slave": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "options": {
                            "idx": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "name": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "prio": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "role": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "choices": [
                                    "slave",
                                    "master"
                                ],
                                "type": "str"
                            },
                            "sn": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "status": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            }
                        }
                    },
                    "hdisk_size": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "hostname": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "hw_rev_major": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "hw_rev_minor": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "ips_ext": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ips_ver": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "last_checked": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "last_resync": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "latitude": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "lic_flags": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "lic_region": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "location_from": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "logdisk_size": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "longitude": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "maxvdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "meta fields": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "dict"
                    },
                    "mgmt_id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "mgmt_if": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "mgmt_mode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unreg",
                            "fmg",
                            "faz",
                            "fmgfaz"
                        ],
                        "type": "str"
                    },
                    "mgt_vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "mr": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "os_type": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "fos",
                            "fsw",
                            "foc",
                            "fml",
                            "faz",
                            "fwb",
                            "fch",
                            "fct",
                            "log",
                            "fmg",
                            "fsa",
                            "fdd",
                            "fac",
                            "fpx",
                            "fna",
                            "fdc",
                            "ffw",
                            "fsr",
                            "fad",
                            "fap",
                            "fxt",
                            "fts",
                            "fai",
                            "fwc"
                        ],
                        "type": "str"
                    },
                    "os_ver": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "unknown",
                            "0.0",
                            "1.0",
                            "2.0",
                            "3.0",
                            "4.0",
                            "5.0",
                            "6.0",
                            "7.0",
                            "8.0"
                        ],
                        "type": "str"
                    },
                    "patch": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "platform_str": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "psk": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sn": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "options": {
                            "comments": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "name": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "opmode": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "choices": [
                                    "nat",
                                    "transparent"
                                ],
                                "type": "str"
                            },
                            "rtm_prof_id": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "status": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "meta fields": {
                                "required": false,
                                "revision": {
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "dict"
                            },
                            "vpn_id": {
                                "required": false,
                                "revision": {
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "vdom_type": {
                                "required": false,
                                "revision": {
                                    "7.2.0": true
                                },
                                "choices": [
                                    "traffic",
                                    "admin"
                                ],
                                "type": "str"
                            }
                        }
                    },
                    "version": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "vm_cpu": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "vm_cpu_limit": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "vm_lic_expire": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "vm_mem": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "vm_mem_limit": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "vm_status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "module_sn": {
                        "required": false,
                        "revision": {
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "prefer_img_ver": {
                        "required": false,
                        "revision": {
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "prio": {
                        "required": false,
                        "revision": {
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "role": {
                        "required": false,
                        "revision": {
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "master",
                            "ha-slave",
                            "autoscale-slave"
                        ],
                        "type": "str"
                    },
                    "hyperscale": {
                        "required": false,
                        "revision": {
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "nsxt_service_name": {
                        "required": false,
                        "revision": {
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "private_key": {
                        "required": false,
                        "revision": {
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "private_key_status": {
                        "required": false,
                        "revision": {
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "import-group-members": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "adom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "dev": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "grp": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "dvm_cmd_reload_devlist": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "create_task",
                    "nonblocking",
                    "log_dev"
                ]
            },
            "from": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "um",
                    "fgfm",
                    "apache",
                    "dvm",
                    "fwm",
                    "xml",
                    "json"
                ],
                "type": "str"
            },
            "reload-dev-member-list": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "tag": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvmdb_workflow_approve": {
        "stated": true,
        "options": {
            "desc": {
                "required": false,
                "type": "str"
            }
        }
    },
    "dvmdb_workflow_discard": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workflow_drop": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workflow_reject": {
        "stated": true,
        "options": {
            "desc": {
                "required": false,
                "type": "str"
            }
        }
    },
    "dvmdb_workflow_repair": {
        "stated": true,
        "options": {
            "desc": {
                "required": false,
                "type": "str"
            }
        }
    },
    "dvmdb_workflow_revert": {
        "stated": true,
        "options": {
            "desc": {
                "required": false,
                "type": "str"
            },
            "fmgip": {
                "required": false,
                "type": "str"
            },
            "mail_user": {
                "required": false,
                "type": "str"
            },
            "no_diff": {
                "required": false,
                "type": "int"
            },
            "no_mail": {
                "required": false,
                "type": "int"
            }
        }
    },
    "dvmdb_workflow_review": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workflow_save": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workflow_start": {
        "stated": true,
        "options": {
            "desc": {
                "required": false,
                "type": "str"
            },
            "name": {
                "required": false,
                "type": "str"
            }
        }
    },
    "dvmdb_workflow_submit": {
        "stated": true,
        "options": {
            "desc": {
                "required": false,
                "type": "str"
            },
            "fmgip": {
                "required": false,
                "type": "str"
            },
            "mail_user": {
                "required": false,
                "type": "str"
            },
            "no_diff": {
                "required": false,
                "type": "int"
            },
            "no_mail": {
                "required": false,
                "type": "int"
            }
        }
    },
    "securityconsole_preview_result": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "device": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "securityconsole_assign_package": {
        "stated": true,
        "options": {
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "cp_all_objs",
                    "copy_assigned_pkg",
                    "unassign"
                ]
            },
            "pkg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "target": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "adom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "excluded": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pkg": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "sys_api_sdnconnector": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "command": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "connector_name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "sys_login_challenge": {
        "stated": true,
        "options": {
            "answer": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "session": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "sys_login_user": {
        "stated": true,
        "options": {
            "passwd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "user": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvmdb_script_execute": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "type": "str"
            },
            "package": {
                "required": false,
                "type": "str"
            },
            "scope": {
                "required": false,
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "script": {
                "required": false,
                "type": "str"
            }
        }
    },
    "securityconsole_abort": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "sys_generate_wsdl": {
        "stated": true,
        "options": {
            "endpoint": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "target": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "securityconsole_package_cancel_install": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "securityconsole_package_clone": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dst_name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dst_parent": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "pkg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "scope": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "securityconsole_package_commit": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "scope": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            }
        }
    },
    "securityconsole_package_move": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dst_name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dst_parent": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "pkg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "securityconsole_import_dev_objs": {
        "stated": true,
        "options": {
            "add_mappings": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dst_name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dst_parent": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "if_all_objs": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "none",
                    "all",
                    "filter"
                ],
                "type": "str"
            },
            "if_all_policy": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "import_action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "do",
                    "policy_search",
                    "obj_search"
                ],
                "type": "str"
            },
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "position": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "bottom",
                    "top"
                ],
                "type": "str"
            },
            "vdom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "securityconsole_sign_certificate_template": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "scope": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vdom": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "template": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvmdb_workspace_commit": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_commit_dev": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_commit_obj": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_commit_pkg": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_lock": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_lock_dev": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_lock_obj": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_lock_pkg": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_unlock": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_unlock_dev": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_unlock_obj": {
        "stated": true,
        "options": {}
    },
    "dvmdb_workspace_unlock_pkg": {
        "stated": true,
        "options": {}
    },
    "sys_proxy_json": {
        "stated": true,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "get",
                    "post",
                    "put",
                    "delete"
                ],
                "type": "str"
            },
            "payload": {
                "required": false,
                "type": "dict"
            },
            "resource": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "target": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list"
            },
            "timeout": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "securityconsole_pblock_clone": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dst_name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "pblock": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "securityconsole_reinstall_package": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "none",
                    "cp_all_objs",
                    "preview",
                    "generate_rev",
                    "copy_assigned_pkg",
                    "unassign",
                    "ifpolicy_only",
                    "no_ifpolicy",
                    "objs_only",
                    "auto_lock_ws",
                    "check_pkg_st",
                    "copy_only"
                ]
            },
            "target": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "pkg": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "scope": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "options": {
                            "name": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "vdom": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            }
                        }
                    }
                }
            }
        }
    },
    "devprof_import": {
        "stated": true,
        "options": {
            "device": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "devprof": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "pm_config_upgrade": {
        "stated": true,
        "options": {}
    },
    "pm_config_workspace_commit": {
        "stated": true,
        "options": {}
    },
    "pm_config_workspace_lock": {
        "stated": true,
        "options": {}
    },
    "pm_config_workspace_unlock": {
        "stated": true,
        "options": {}
    },
    "pm_config_reset_database": {
        "stated": true,
        "options": {
            "mr": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "version": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "sys_reboot": {
        "stated": true,
        "options": {
            "message": {
                "required": false,
                "revision": {
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "sys_hitcount": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "adom_oid": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            },
            "pkg": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "pkg_oid": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "securityconsole_cliprof_check": {
        "stated": true,
        "options": {
            "adom": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "cliprof": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "sys_task_result": {
        "stated": true,
        "options": {
            "taskid": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "fmupdate_fctservices": {
        "stated": false,
        "options": {
            "port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_ntp": {
        "stated": false,
        "options": {
            "ntpserver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "authentication": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "key": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "key-id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ntpv3": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "server": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "maxpoll": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "minpoll": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "sync_interval": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": false
                },
                "type": "int"
            }
        }
    },
    "fmupdate_avips_advancedlog": {
        "stated": false,
        "options": {
            "log-fortigate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-server": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "fmupdate_avips_webproxy": {
        "stated": false,
        "options": {
            "ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "ip6": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "proxy",
                    "tunnel"
                ],
                "type": "str"
            },
            "password": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "username": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "address": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "fmupdate_serveraccesspriorities": {
        "stated": false,
        "options": {
            "access-public": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "av-ips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "private-server": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "ip6": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "time_zone": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "web-spam": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_saml": {
        "stated": false,
        "options": {
            "acs-url": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "cert": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "entity-id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "idp-cert": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "idp-entity-id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "idp-single-logout-url": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "idp-single-sign-on-url": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "login-auto-redirect": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "role": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "IDP",
                    "SP",
                    "FAB-SP"
                ],
                "type": "str"
            },
            "server-address": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "service-providers": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "idp-entity-id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "idp-single-logout-url": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "idp-single-sign-on-url": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "prefix": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sp-cert": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sp-entity-id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sp-single-logout-url": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sp-single-sign-on-url": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sp-adom": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "sp-profile": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "sls-url": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "default-profile": {
                "required": false,
                "revision": {
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "fabric-idp": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "dev-id": {
                        "required": false,
                        "revision": {
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "idp-cert": {
                        "required": false,
                        "revision": {
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "idp-entity-id": {
                        "required": false,
                        "revision": {
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "idp-single-logout-url": {
                        "required": false,
                        "revision": {
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "idp-single-sign-on-url": {
                        "required": false,
                        "revision": {
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "idp-status": {
                        "required": false,
                        "revision": {
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "forticloud-sso": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "user-auto-create": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "devprof_log_fortianalyzer_setting": {
        "stated": false,
        "options": {
            "certificate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "conn-timeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "enc-algorithm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "high",
                    "low",
                    "disable",
                    "high-medium",
                    "low-medium"
                ],
                "type": "str"
            },
            "hmac-algorithm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "sha256",
                    "sha1"
                ],
                "type": "str"
            },
            "ips-archive": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "monitor-failure-retry-period": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "monitor-keepalive-period": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "reliable": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ssl-min-proto-version": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "TLSv1",
                    "TLSv1-1",
                    "TLSv1-2",
                    "SSLv3",
                    "TLSv1-3"
                ],
                "type": "str"
            },
            "upload-day": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "upload-interval": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "daily",
                    "weekly",
                    "monthly"
                ],
                "type": "str"
            },
            "upload-option": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "store-and-upload",
                    "realtime",
                    "1-minute",
                    "5-minute"
                ],
                "type": "str"
            },
            "upload-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "access-config": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "certificate-verification": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "max-log-rate": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "priority": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "default"
                ],
                "type": "str"
            },
            "interface": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "interface-select-method": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "auto",
                    "sdwan",
                    "specify"
                ],
                "type": "str"
            },
            "preshared-key": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "devprof_log_syslogd_filter": {
        "stated": false,
        "options": {
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            }
        }
    },
    "devprof_log_syslogd_setting": {
        "stated": false,
        "options": {
            "certificate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "enc-algorithm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "high",
                    "low",
                    "disable",
                    "high-medium"
                ],
                "type": "str"
            },
            "facility": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "kernel",
                    "user",
                    "mail",
                    "daemon",
                    "auth",
                    "syslog",
                    "lpr",
                    "news",
                    "uucp",
                    "cron",
                    "authpriv",
                    "ftp",
                    "ntp",
                    "audit",
                    "alert",
                    "clock",
                    "local0",
                    "local1",
                    "local2",
                    "local3",
                    "local4",
                    "local5",
                    "local6",
                    "local7"
                ],
                "type": "str"
            },
            "mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "udp",
                    "legacy-reliable",
                    "reliable"
                ],
                "type": "str"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "server": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ssl-min-proto-version": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "TLSv1-1",
                    "TLSv1-2",
                    "SSLv3",
                    "TLSv1"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "max-log-rate": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "priority": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "default"
                ],
                "type": "str"
            },
            "interface": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "interface-select-method": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "auto",
                    "sdwan",
                    "specify"
                ],
                "type": "str"
            },
            "format": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "csv",
                    "cef",
                    "rfc5424"
                ],
                "type": "str"
            }
        }
    },
    "devprof_device_profile_fortianalyzer": {
        "stated": false,
        "options": {
            "managed-sn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "target": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "none",
                    "this-fmg",
                    "managed",
                    "others"
                ],
                "type": "str"
            },
            "target-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "target-sn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "devprof_device_profile_fortiguard": {
        "stated": false,
        "options": {
            "target": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "none",
                    "direct",
                    "this-fmg"
                ],
                "type": "str"
            },
            "target-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "fmupdate_publicnetwork": {
        "stated": false,
        "options": {
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_global": {
        "stated": false,
        "options": {
            "admin-lockout-duration": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "admin-lockout-threshold": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "adom-mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "normal",
                    "advanced"
                ],
                "type": "str"
            },
            "adom-rev-auto-delete": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "by-revisions",
                    "by-days"
                ],
                "type": "str"
            },
            "adom-rev-max-backup-revisions": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "adom-rev-max-days": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "adom-rev-max-revisions": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "adom-select": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "adom-status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "clt-cert-req": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable",
                    "optional"
                ],
                "type": "str"
            },
            "console-output": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "standard",
                    "more"
                ],
                "type": "str"
            },
            "country-flag": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "create-revision": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "daylightsavetime": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "default-disk-quota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "detect-unregistered-log-device": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "device-view-mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "regular",
                    "tree"
                ],
                "type": "str"
            },
            "dh-params": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "1024",
                    "1536",
                    "2048",
                    "3072",
                    "4096",
                    "6144",
                    "8192"
                ],
                "type": "str"
            },
            "disable-module": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "fortiview-noc",
                    "none",
                    "fortirecorder",
                    "siem",
                    "soc",
                    "ai"
                ]
            },
            "enc-algorithm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high",
                    "custom"
                ],
                "type": "str"
            },
            "faz-status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm-local-cert": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "fgfm-ssl-protocol": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "sslv3",
                    "tlsv1.0",
                    "tlsv1.1",
                    "tlsv1.2",
                    "tlsv1.3"
                ],
                "type": "str"
            },
            "ha-member-auto-grouping": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hitcount_concurrent": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "hitcount_interval": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "int"
            },
            "hostname": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "import-ignore-addr-cmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "language": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "english",
                    "simch",
                    "japanese",
                    "korean",
                    "spanish",
                    "trach"
                ],
                "type": "str"
            },
            "latitude": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ldap-cache-timeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "ldapconntimeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "lock-preempt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-checksum": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "none",
                    "md5",
                    "md5-auth"
                ],
                "type": "str"
            },
            "log-forward-cache-size": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "longitude": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "max-log-forward": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-running-reports": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "oftp-ssl-protocol": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "sslv3",
                    "tlsv1.0",
                    "tlsv1.1",
                    "tlsv1.2",
                    "tlsv1.3"
                ],
                "type": "str"
            },
            "partial-install": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "partial-install-force": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "partial-install-rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "perform-improve-by-ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "policy-hit-count": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "policy-object-in-dual-pane": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pre-login-banner": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pre-login-banner-message": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "remoteauthtimeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "search-all-adoms": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ssl-low-encryption": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ssl-protocol": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "tlsv1.2",
                    "tlsv1.1",
                    "tlsv1.0",
                    "sslv3",
                    "tlsv1.3"
                ]
            },
            "ssl-static-key-ciphers": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "task-list-size": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "tftp": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "timezone": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "00",
                    "01",
                    "02",
                    "03",
                    "04",
                    "05",
                    "06",
                    "07",
                    "08",
                    "09",
                    "10",
                    "11",
                    "12",
                    "13",
                    "14",
                    "15",
                    "16",
                    "17",
                    "18",
                    "19",
                    "20",
                    "21",
                    "22",
                    "23",
                    "24",
                    "25",
                    "26",
                    "27",
                    "28",
                    "29",
                    "30",
                    "31",
                    "32",
                    "33",
                    "34",
                    "35",
                    "36",
                    "37",
                    "38",
                    "39",
                    "40",
                    "41",
                    "42",
                    "43",
                    "44",
                    "45",
                    "46",
                    "47",
                    "48",
                    "49",
                    "50",
                    "51",
                    "52",
                    "53",
                    "54",
                    "55",
                    "56",
                    "57",
                    "58",
                    "59",
                    "60",
                    "61",
                    "62",
                    "63",
                    "64",
                    "65",
                    "66",
                    "67",
                    "68",
                    "69",
                    "70",
                    "71",
                    "72",
                    "73",
                    "74",
                    "75",
                    "76",
                    "77",
                    "78",
                    "79",
                    "80",
                    "81",
                    "82",
                    "83",
                    "84",
                    "85",
                    "86",
                    "87",
                    "88",
                    "89",
                    "90",
                    "91"
                ],
                "type": "str"
            },
            "tunnel-mtu": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "usg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "vdom-mirror": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webservice-proto": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "tlsv1.2",
                    "tlsv1.1",
                    "tlsv1.0",
                    "sslv3",
                    "sslv2",
                    "tlsv1.3"
                ]
            },
            "workflow-max-sessions": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "workspace-mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "normal",
                    "workflow",
                    "per-adom"
                ],
                "type": "str"
            },
            "clone-name-option": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "keep"
                ],
                "type": "str"
            },
            "fgfm-ca-cert": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "mc-policy-disabled-adoms": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "adom-name": {
                        "required": false,
                        "revision": {
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "policy-object-icon": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "private-data-encryption": {
                "required": false,
                "revision": {
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "per-policy-lock": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "multiple-steps-upgrade-in-autolink": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "object-revision-db-max": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "object-revision-mandatory-note": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "object-revision-object-max": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "object-revision-status": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "normalized-intf-zone-only": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ssl-cipher-suites": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "cipher": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "priority": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "version": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "choices": [
                            "tls1.2-or-below",
                            "tls1.3"
                        ],
                        "type": "str"
                    }
                }
            }
        }
    },
    "antivirus_profile_contentdisarm": {
        "stated": false,
        "options": {
            "cover-page": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "detect-only": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-embed": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-hylink": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-linked": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-macro": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "original-file-destination": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "fortisandbox",
                    "quarantine",
                    "discard"
                ],
                "type": "str"
            },
            "pdf-act-form": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-gotor": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-java": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-launch": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-movie": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-act-sound": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-embedfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-hyperlink": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "pdf-javacode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-action": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "office-dde": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "error-action": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "block",
                    "log-only",
                    "ignore"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_ftp": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_http": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor",
                    "strict-file"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-optimize": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_imap": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_mapi": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_nacquar": {
        "stated": false,
        "options": {
            "expiry": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "infected": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "none",
                    "quar-src-ip",
                    "quar-interface"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_nntp": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_pop3": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_smb": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "list",
                "choices": [
                    "scan",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive"
                ],
                "type": "str"
            }
        }
    },
    "antivirus_profile_smtp": {
        "stated": false,
        "options": {
            "archive-block": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "archive-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "encrypted",
                    "corrupted",
                    "multipart",
                    "nested",
                    "mailbomb",
                    "unhandled",
                    "partiallycorrupted",
                    "fileslimit",
                    "timeout"
                ]
            },
            "content-disarm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "emulator": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "executables": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "virus"
                ],
                "type": "str"
            },
            "options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "scan",
                    "file-filter",
                    "quarantine",
                    "avquery",
                    "avmonitor"
                ]
            },
            "outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disabled",
                    "files",
                    "full-archive",
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "av-scan": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "external-blocklist": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "monitor",
                    "block"
                ],
                "type": "str"
            },
            "quarantine": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortindr": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            },
            "fortisandbox": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "block",
                    "monitor"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_addresslist": {
        "stated": false,
        "options": {
            "blocked-address": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "blocked-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "trusted-address": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "waf_profile_constraint": {
        "stated": false,
        "options": {
            "content-length": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "exception": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "address": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "content-length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "header-length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "hostname": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "line-length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "malformed": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-cookie": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-header-line": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-range-segment": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-url-param": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "method": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "param-length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "pattern": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "regex": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "url-param-length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "version": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "header-length": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "hostname": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "line-length": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "malformed": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "max-cookie": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-cookie": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "max-header-line": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-header-line": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "max-range-segment": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-range-segment": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "max-url-param": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "max-url-param": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "method": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "param-length": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "url-param-length": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "length": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "version": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            }
        }
    },
    "waf_profile_constraint_contentlength": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "length": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_headerlength": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "length": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_hostname": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_linelength": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "length": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_malformed": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_maxcookie": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "max-cookie": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_maxheaderline": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "max-header-line": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_maxrangesegment": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "max-range-segment": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_maxurlparam": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "max-url-param": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_method": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_paramlength": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "length": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_urlparamlength": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "length": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_constraint_version": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_method": {
        "stated": false,
        "options": {
            "default-allowed-methods": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "delete",
                    "get",
                    "head",
                    "options",
                    "post",
                    "put",
                    "trace",
                    "others",
                    "connect"
                ]
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "method-policy": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "address": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "allowed-methods": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "delete",
                            "get",
                            "head",
                            "options",
                            "post",
                            "put",
                            "trace",
                            "others",
                            "connect"
                        ]
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "pattern": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "regex": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "waf_profile_signature": {
        "stated": false,
        "options": {
            "credit-card-detection-threshold": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "custom-signature": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block",
                            "erase"
                        ],
                        "type": "str"
                    },
                    "case-sensitivity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "direction": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "request",
                            "response"
                        ],
                        "type": "str"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "pattern": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "target": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "arg",
                            "arg-name",
                            "req-body",
                            "req-cookie",
                            "req-cookie-name",
                            "req-filename",
                            "req-header",
                            "req-header-name",
                            "req-raw-uri",
                            "req-uri",
                            "resp-body",
                            "resp-hdr",
                            "resp-status"
                        ]
                    }
                }
            },
            "disabled-signature": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "disabled-sub-class": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "main-class": {
                "required": false,
                "type": "dict",
                "options": {
                    "action": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "allow",
                            "block",
                            "erase"
                        ],
                        "type": "str"
                    },
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "log": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "severity": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "low",
                            "medium",
                            "high"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            }
        }
    },
    "waf_profile_signature_mainclass": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "allow",
                    "block",
                    "erase"
                ],
                "type": "str"
            },
            "id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "low",
                    "medium",
                    "high"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "spamfilter_profile_gmail": {
        "stated": false,
        "options": {
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "spamfilter_profile_imap": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "pass",
                    "tag"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "tag-msg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "tag-type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "list",
                "choices": [
                    "subject",
                    "header",
                    "spaminfo"
                ]
            }
        }
    },
    "spamfilter_profile_mapi": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "pass",
                    "discard"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "spamfilter_profile_msnhotmail": {
        "stated": false,
        "options": {
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "spamfilter_profile_pop3": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "pass",
                    "tag"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "tag-msg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "tag-type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "list",
                "choices": [
                    "subject",
                    "header",
                    "spaminfo"
                ]
            }
        }
    },
    "spamfilter_profile_smtp": {
        "stated": false,
        "options": {
            "action": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "pass",
                    "tag",
                    "discard"
                ],
                "type": "str"
            },
            "hdrip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "local-override": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "tag-msg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "tag-type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "list",
                "choices": [
                    "subject",
                    "header",
                    "spaminfo"
                ]
            }
        }
    },
    "spamfilter_profile_yahoomail": {
        "stated": false,
        "options": {
            "log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": false,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "fmupdate_fdssetting": {
        "stated": false,
        "options": {
            "User-Agent": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "fds-clt-ssl-protocol": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "sslv3",
                    "tlsv1.0",
                    "tlsv1.1",
                    "tlsv1.2",
                    "tlsv1.3"
                ],
                "type": "str"
            },
            "fds-ssl-protocol": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "sslv3",
                    "tlsv1.0",
                    "tlsv1.1",
                    "tlsv1.2",
                    "tlsv1.3"
                ],
                "type": "str"
            },
            "fmtr-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warn",
                    "notice",
                    "info",
                    "debug",
                    "disable"
                ],
                "type": "str"
            },
            "linkd-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warn",
                    "notice",
                    "info",
                    "debug",
                    "disable"
                ],
                "type": "str"
            },
            "max-av-ips-version": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-work": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "push-override": {
                "required": false,
                "type": "dict",
                "options": {
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "port": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "push-override-to-client": {
                "required": false,
                "type": "dict",
                "options": {
                    "announce-ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "options": {
                            "id": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "ip": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "port": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            }
                        }
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "send_report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "send_setup": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "server-override": {
                "required": false,
                "type": "dict",
                "options": {
                    "servlist": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "options": {
                            "id": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "ip": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "ip6": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "port": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "service-type": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "list",
                                "choices": [
                                    "fds",
                                    "fct"
                                ]
                            }
                        }
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "system-support-fct": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "4.x",
                    "5.0",
                    "5.2",
                    "5.4",
                    "5.6",
                    "6.0",
                    "6.2",
                    "6.4",
                    "7.0"
                ]
            },
            "system-support-fgt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "5.4",
                    "5.6",
                    "6.0",
                    "6.2",
                    "6.4",
                    "7.0",
                    "7.2"
                ]
            },
            "system-support-fml": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "4.x",
                    "5.x",
                    "6.x",
                    "6.0",
                    "6.2",
                    "6.4",
                    "7.0"
                ]
            },
            "system-support-fsa": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "1.x",
                    "2.x",
                    "3.x",
                    "4.x",
                    "3.0",
                    "3.1",
                    "3.2"
                ]
            },
            "system-support-fsw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": false
                },
                "type": "list",
                "choices": [
                    "5.4",
                    "5.6",
                    "6.0",
                    "6.2",
                    "4.x",
                    "5.0",
                    "5.2",
                    "6.4"
                ]
            },
            "umsvc-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warn",
                    "notice",
                    "info",
                    "debug",
                    "disable"
                ],
                "type": "str"
            },
            "unreg-dev-option": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "ignore",
                    "svc-only",
                    "add-service"
                ],
                "type": "str"
            },
            "update-schedule": {
                "required": false,
                "type": "dict",
                "options": {
                    "day": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "Sunday",
                            "Monday",
                            "Tuesday",
                            "Wednesday",
                            "Thursday",
                            "Friday",
                            "Saturday"
                        ],
                        "type": "str"
                    },
                    "frequency": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "every",
                            "daily",
                            "weekly"
                        ],
                        "type": "str"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "time": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    }
                }
            },
            "wanip-query-mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "ipify"
                ],
                "type": "str"
            },
            "fortiguard-anycast": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiguard-anycast-source": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "fortinet",
                    "aws"
                ],
                "type": "str"
            },
            "system-support-fdc": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "3.x",
                    "4.x"
                ]
            },
            "system-support-fts": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "3.x",
                    "4.x",
                    "7.x"
                ]
            }
        }
    },
    "fmupdate_fdssetting_pushoverride": {
        "stated": false,
        "options": {
            "ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "fmupdate_fdssetting_pushoverridetoclient": {
        "stated": false,
        "options": {
            "announce-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "port": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "fmupdate_fdssetting_serveroverride": {
        "stated": false,
        "options": {
            "servlist": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "ip6": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "port": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "service-type": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "fds",
                            "fct"
                        ]
                    }
                }
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "fmupdate_fdssetting_updateschedule": {
        "stated": false,
        "options": {
            "day": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "Sunday",
                    "Monday",
                    "Tuesday",
                    "Wednesday",
                    "Thursday",
                    "Friday",
                    "Saturday"
                ],
                "type": "str"
            },
            "frequency": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "every",
                    "daily",
                    "weekly"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "system_dns": {
        "stated": false,
        "options": {
            "ip6-primary": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ip6-secondary": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "primary": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "secondary": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "dvmdb_device": {
        "stated": false,
        "options": {
            "adm_pass": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "adm_usr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "app_ver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "av_ver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "beta": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "branch_pt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "build": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "checksum": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "conf_status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "unknown",
                    "insync",
                    "outofsync"
                ],
                "type": "str"
            },
            "conn_mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "active",
                    "passive"
                ],
                "type": "str"
            },
            "conn_status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "UNKNOWN",
                    "up",
                    "down"
                ],
                "type": "str"
            },
            "db_status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "unknown",
                    "nomod",
                    "mod"
                ],
                "type": "str"
            },
            "desc": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "dev_status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "none",
                    "unknown",
                    "checkedin",
                    "inprogress",
                    "installed",
                    "aborted",
                    "sched",
                    "retry",
                    "canceled",
                    "pending",
                    "retrieved",
                    "changed_conf",
                    "sync_fail",
                    "timeout",
                    "rev_revert",
                    "auto_updated"
                ],
                "type": "str"
            },
            "fap_cnt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "faz.full_act": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "faz.perm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "faz.quota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "faz.used": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "fex_cnt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "has_hdd",
                    "vdom_enabled",
                    "discover",
                    "reload",
                    "interim_build",
                    "offline_mode",
                    "is_model",
                    "fips_mode",
                    "linked_to_model",
                    "ip-conflict",
                    "faz-autosync"
                ]
            },
            "foslic_cpu": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "foslic_dr_site": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "foslic_inst_time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "foslic_last_sync": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "foslic_ram": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "foslic_type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "temporary",
                    "trial",
                    "regular",
                    "trial_expired"
                ],
                "type": "str"
            },
            "foslic_utm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "fw",
                    "av",
                    "ips",
                    "app",
                    "url",
                    "utm",
                    "fwb"
                ]
            },
            "fsw_cnt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "ha_group_id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "ha_group_name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ha_mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "standalone",
                    "AP",
                    "AA",
                    "ELBC",
                    "DUAL",
                    "enabled",
                    "unknown",
                    "fmg-enabled",
                    "autoscale"
                ],
                "type": "str"
            },
            "hdisk_size": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "hostname": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "hw_rev_major": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "hw_rev_minor": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ips_ext": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "ips_ver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "last_checked": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "last_resync": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "latitude": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "lic_flags": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "lic_region": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "location_from": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "logdisk_size": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "longitude": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "maxvdom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "meta fields": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "dict"
            },
            "mgmt_id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "mgmt_if": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "mgmt_mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "unreg",
                    "fmg",
                    "faz",
                    "fmgfaz"
                ],
                "type": "str"
            },
            "mgt_vdom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "mr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "os_type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "unknown",
                    "fos",
                    "fsw",
                    "foc",
                    "fml",
                    "faz",
                    "fwb",
                    "fch",
                    "fct",
                    "log",
                    "fmg",
                    "fsa",
                    "fdd",
                    "fac",
                    "fpx",
                    "fna",
                    "fdc",
                    "ffw",
                    "fsr",
                    "fad",
                    "fap",
                    "fxt",
                    "fts",
                    "fai",
                    "fwc"
                ],
                "type": "str"
            },
            "os_ver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "unknown",
                    "0.0",
                    "1.0",
                    "2.0",
                    "3.0",
                    "4.0",
                    "5.0",
                    "6.0",
                    "7.0",
                    "8.0"
                ],
                "type": "str"
            },
            "patch": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "platform_str": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "psk": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "sn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "vdom": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "comments": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "name": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "opmode": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "nat",
                            "transparent"
                        ],
                        "type": "str"
                    },
                    "rtm_prof_id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "vpn_id": {
                        "required": false,
                        "revision": {
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "meta fields": {
                        "required": false,
                        "revision": {
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "dict"
                    },
                    "vdom_type": {
                        "required": false,
                        "revision": {
                            "7.2.0": true
                        },
                        "choices": [
                            "traffic",
                            "admin"
                        ],
                        "type": "str"
                    }
                }
            },
            "version": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "vm_cpu": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "vm_cpu_limit": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "vm_lic_expire": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "vm_mem": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "vm_mem_limit": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "vm_status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "module_sn": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "prefer_img_ver": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "prio": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "role": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "master",
                    "ha-slave",
                    "autoscale-slave"
                ],
                "type": "str"
            },
            "hyperscale": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "nsxt_service_name": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "private_key": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "private_key_status": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_alertemail": {
        "stated": false,
        "options": {
            "authentication": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fromaddress": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "fromname": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "smtppassword": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "smtpport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "smtpserver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "smtpuser": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "fmupdate_service": {
        "stated": false,
        "options": {
            "avips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "query-antispam": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "query-antivirus": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "query-filequery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "query-geoip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "query-outbreak-prevention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "query-webfilter": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webfilter-https-traversal": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "query-iot": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_logfetch_serversettings": {
        "stated": false,
        "options": {
            "max-conn-per-session": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-sessions": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "session-timeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_fortiguard": {
        "stated": false,
        "options": {
            "antispam-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "antispam-cache-mpercent": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "antispam-cache-ttl": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "antispam-expiration": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "antispam-force-off": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "antispam-license": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "antispam-timeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "auto-join-forticloud": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ddns-server-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ddns-server-port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "load-balance-servers": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "outbreak-prevention-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "outbreak-prevention-cache-mpercent": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "outbreak-prevention-cache-ttl": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "outbreak-prevention-expiration": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "outbreak-prevention-force-off": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "outbreak-prevention-license": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "outbreak-prevention-timeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "53",
                    "80",
                    "8888",
                    "443"
                ],
                "type": "str"
            },
            "sdns-server-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "sdns-server-port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "service-account-id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "source-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "source-ip6": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "update-server-location": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "any",
                    "usa",
                    "automatic",
                    "eu"
                ],
                "type": "str"
            },
            "webfilter-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webfilter-cache-ttl": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "webfilter-expiration": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "webfilter-force-off": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webfilter-license": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "webfilter-timeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "protocol": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "udp",
                    "http",
                    "https"
                ],
                "type": "str"
            },
            "proxy-password": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "proxy-server-ip": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "proxy-server-port": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "proxy-username": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "sandbox-region": {
                "required": false,
                "revision": {
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "fortiguard-anycast": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiguard-anycast-source": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "fortinet",
                    "aws",
                    "debug"
                ],
                "type": "str"
            },
            "interface": {
                "required": false,
                "revision": {
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "interface-select-method": {
                "required": false,
                "revision": {
                    "6.2.5": true,
                    "6.4.0": false,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "auto",
                    "sdwan",
                    "specify"
                ],
                "type": "str"
            },
            "sdns-options": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "include-question-section"
                ]
            },
            "anycast-sdns-server-ip": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "anycast-sdns-server-port": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "persistent-connection": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "update-build-proxy": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "update-extdb": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "update-ffdb": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "update-uwdb": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "videofilter-expiration": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "videofilter-license": {
                "required": false,
                "revision": {
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "ddns-server-ip6": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "vdom": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "fmupdate_webspam_fgdsetting": {
        "stated": false,
        "options": {
            "as-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "as-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "nospam",
                    "all"
                ],
                "type": "str"
            },
            "as-preload": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "av-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "av-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "novirus",
                    "all"
                ],
                "type": "str"
            },
            "av-preload": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "av2-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "av2-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "noav2",
                    "all"
                ],
                "type": "str"
            },
            "av2-preload": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventlog-query": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd-pull-interval": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "fq-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "fq-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "nofilequery",
                    "all"
                ],
                "type": "str"
            },
            "fq-preload": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "linkd-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warn",
                    "notice",
                    "info",
                    "debug",
                    "disable"
                ],
                "type": "str"
            },
            "max-client-worker": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-log-quota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-unrated-site": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "restrict-as1-dbver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "restrict-as2-dbver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "restrict-as4-dbver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "restrict-av-dbver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "restrict-av2-dbver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "restrict-fq-dbver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "restrict-wf-dbver": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "server-override": {
                "required": false,
                "type": "dict",
                "options": {
                    "servlist": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "options": {
                            "id": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "ip": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "ip6": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "str"
                            },
                            "port": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "int"
                            },
                            "service-type": {
                                "required": false,
                                "revision": {
                                    "6.0.0": true,
                                    "6.2.1": true,
                                    "6.2.3": true,
                                    "6.2.5": true,
                                    "6.4.0": true,
                                    "6.4.2": true,
                                    "6.4.5": true,
                                    "7.0.0": true,
                                    "7.2.0": true
                                },
                                "type": "list",
                                "choices": [
                                    "fgd",
                                    "fgc",
                                    "fsa"
                                ]
                            }
                        }
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    }
                }
            },
            "stat-log-interval": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "stat-sync-interval": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "update-interval": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "update-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "wf-cache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "wf-dn-cache-expire-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "wf-dn-cache-max-number": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "wf-log": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "nourl",
                    "all"
                ],
                "type": "str"
            },
            "wf-preload": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iot-cache": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            },
            "iot-log": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "nofilequery",
                    "all"
                ],
                "type": "str"
            },
            "iot-preload": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "restrict-iots-dbver": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "fmupdate_webspam_fgdsetting_serveroverride": {
        "stated": false,
        "options": {
            "servlist": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "options": {
                    "id": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "ip": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "ip6": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "str"
                    },
                    "port": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "service-type": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "list",
                        "choices": [
                            "fgd",
                            "fgc",
                            "fsa"
                        ]
                    }
                }
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "fmupdate_webspam_webproxy": {
        "stated": false,
        "options": {
            "ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "ip6": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "mode": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "proxy",
                    "tunnel"
                ],
                "type": "str"
            },
            "password": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "port": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "username": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "address": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "system_autodelete": {
        "stated": false,
        "options": {
            "dlp-files-auto-deletion": {
                "required": false,
                "type": "dict",
                "options": {
                    "retention": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "days",
                            "weeks",
                            "months"
                        ],
                        "type": "str"
                    },
                    "runat": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "value": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "log-auto-deletion": {
                "required": false,
                "type": "dict",
                "options": {
                    "retention": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "days",
                            "weeks",
                            "months"
                        ],
                        "type": "str"
                    },
                    "runat": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "value": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "quarantine-files-auto-deletion": {
                "required": false,
                "type": "dict",
                "options": {
                    "retention": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "days",
                            "weeks",
                            "months"
                        ],
                        "type": "str"
                    },
                    "runat": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "value": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "report-auto-deletion": {
                "required": false,
                "type": "dict",
                "options": {
                    "retention": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "days",
                            "weeks",
                            "months"
                        ],
                        "type": "str"
                    },
                    "runat": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    },
                    "status": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "choices": [
                            "disable",
                            "enable"
                        ],
                        "type": "str"
                    },
                    "value": {
                        "required": false,
                        "revision": {
                            "6.0.0": true,
                            "6.2.1": true,
                            "6.2.3": true,
                            "6.2.5": true,
                            "6.4.0": true,
                            "6.4.2": true,
                            "6.4.5": true,
                            "7.0.0": true,
                            "7.2.0": true
                        },
                        "type": "int"
                    }
                }
            },
            "status-fake": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_autodelete_dlpfilesautodeletion": {
        "stated": false,
        "options": {
            "retention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "days",
                    "weeks",
                    "months"
                ],
                "type": "str"
            },
            "runat": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "value": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_autodelete_logautodeletion": {
        "stated": false,
        "options": {
            "retention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "days",
                    "weeks",
                    "months"
                ],
                "type": "str"
            },
            "runat": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "value": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_autodelete_quarantinefilesautodeletion": {
        "stated": false,
        "options": {
            "retention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "days",
                    "weeks",
                    "months"
                ],
                "type": "str"
            },
            "runat": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "value": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_autodelete_reportautodeletion": {
        "stated": false,
        "options": {
            "retention": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "days",
                    "weeks",
                    "months"
                ],
                "type": "str"
            },
            "runat": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "value": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_interface_ipv6": {
        "stated": false,
        "options": {
            "ip6-address": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "ip6-allowaccess": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "ping",
                    "https",
                    "ssh",
                    "snmp",
                    "http",
                    "webservice",
                    "https-logging"
                ]
            },
            "ip6-autoconf": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_disk_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_disk_setting": {
        "stated": false,
        "options": {
            "diskfull": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "overwrite",
                    "nolog"
                ],
                "type": "str"
            },
            "log-disk-full-percentage": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-log-file-size": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "roll-day": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "sunday",
                    "monday",
                    "tuesday",
                    "wednesday",
                    "thursday",
                    "friday",
                    "saturday"
                ]
            },
            "roll-schedule": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "none",
                    "daily",
                    "weekly"
                ],
                "type": "str"
            },
            "roll-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "server-type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "FTP",
                    "SFTP",
                    "SCP"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "upload": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "upload-delete-files": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "upload-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "uploaddir": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "uploadip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "uploadpass": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "uploadport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "uploadsched": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "uploadtype": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "event"
                ]
            },
            "uploaduser": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "uploadzip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-disk-quota": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-log-file-num": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_locallog_fortianalyzer_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_fortianalyzer_setting": {
        "stated": false,
        "options": {
            "reliable": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "secure-connection": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "server-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "realtime",
                    "upload"
                ],
                "type": "str"
            },
            "upload-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "server": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "peer-cert-cn": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "system_locallog_fortianalyzer2_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_fortianalyzer2_setting": {
        "stated": false,
        "options": {
            "reliable": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "secure-connection": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "server-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "realtime",
                    "upload"
                ],
                "type": "str"
            },
            "upload-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "server": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "peer-cert-cn": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "system_locallog_fortianalyzer3_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_fortianalyzer3_setting": {
        "stated": false,
        "options": {
            "reliable": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "secure-connection": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "server-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": false,
                    "6.2.5": false,
                    "6.4.0": false,
                    "6.4.2": false,
                    "6.4.5": false,
                    "7.0.0": false,
                    "7.2.0": false
                },
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "realtime",
                    "upload"
                ],
                "type": "str"
            },
            "upload-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "server": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "peer-cert-cn": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            }
        }
    },
    "system_locallog_memory_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_memory_setting": {
        "stated": false,
        "options": {
            "diskfull": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "overwrite",
                    "nolog"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_setting": {
        "stated": false,
        "options": {
            "log-interval-dev-no-logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log-interval-disk-full": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "log-interval-gbday-exceeded": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_locallog_syslogd_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_syslogd_setting": {
        "stated": false,
        "options": {
            "csv": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "facility": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "kernel",
                    "user",
                    "ntp",
                    "audit",
                    "alert",
                    "clock",
                    "mail",
                    "daemon",
                    "auth",
                    "syslog",
                    "lpr",
                    "news",
                    "uucp",
                    "cron",
                    "authpriv",
                    "ftp",
                    "local0",
                    "local1",
                    "local2",
                    "local3",
                    "local4",
                    "local5",
                    "local6",
                    "local7"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "syslog-name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "cert": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "reliable": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "secure-connection": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_syslogd2_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_syslogd2_setting": {
        "stated": false,
        "options": {
            "csv": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "facility": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "kernel",
                    "user",
                    "ntp",
                    "audit",
                    "alert",
                    "clock",
                    "mail",
                    "daemon",
                    "auth",
                    "syslog",
                    "lpr",
                    "news",
                    "uucp",
                    "cron",
                    "authpriv",
                    "ftp",
                    "local0",
                    "local1",
                    "local2",
                    "local3",
                    "local4",
                    "local5",
                    "local6",
                    "local7"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "syslog-name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "cert": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "reliable": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "secure-connection": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_syslogd3_filter": {
        "stated": false,
        "options": {
            "devcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "devops": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "diskquota": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "dvm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ediscovery": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "epmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "event": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "eventmgmt": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "faz": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fazsys": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fgfm": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fips": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmgws": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmlmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fmwmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "fortiview": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "glbcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ha": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "iolog": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdb": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logdev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "logfile": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "enable",
                    "disable"
                ],
                "type": "str"
            },
            "logging": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "lrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "objcfg": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rev": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "rtmon": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scfw": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scply": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scrmgr": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "scvpn": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "system": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "webport": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "incident": {
                "required": false,
                "revision": {
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "aid": {
                "required": false,
                "revision": {
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "docker": {
                "required": false,
                "revision": {
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_locallog_syslogd3_setting": {
        "stated": false,
        "options": {
            "csv": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "facility": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "kernel",
                    "user",
                    "ntp",
                    "audit",
                    "alert",
                    "clock",
                    "mail",
                    "daemon",
                    "auth",
                    "syslog",
                    "lpr",
                    "news",
                    "uucp",
                    "cron",
                    "authpriv",
                    "ftp",
                    "local0",
                    "local1",
                    "local2",
                    "local3",
                    "local4",
                    "local5",
                    "local6",
                    "local7"
                ],
                "type": "str"
            },
            "severity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "emergency",
                    "alert",
                    "critical",
                    "error",
                    "warning",
                    "notification",
                    "information",
                    "debug"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "syslog-name": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "cert": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "str"
            },
            "reliable": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "secure-connection": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_report_autocache": {
        "stated": false,
        "options": {
            "aggressive-schedule": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "order": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "oldest-first"
                ],
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_report_estbrowsetime": {
        "stated": false,
        "options": {
            "max-read-time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_report_setting": {
        "stated": false,
        "options": {
            "aggregate-report": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hcache-lossless": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "ldap-cache-timeout": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "max-table-rows": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "report-priority": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "high",
                    "low",
                    "auto"
                ],
                "type": "str"
            },
            "template-auto-install": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "default",
                    "english"
                ],
                "type": "str"
            },
            "week-start": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "sun",
                    "mon"
                ],
                "type": "str"
            },
            "capwap-port": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "capwap-service": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "exclude-capwap": {
                "required": false,
                "revision": {
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "by-port",
                    "by-service"
                ],
                "type": "str"
            },
            "max-rpt-pdf-rows": {
                "required": false,
                "revision": {
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "system_passwordpolicy": {
        "stated": false,
        "options": {
            "change-4-characters": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "expire": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "minimum-length": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "must-contain": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "upper-case-letter",
                    "lower-case-letter",
                    "number",
                    "non-alphanumeric"
                ]
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "system_backup_allsettings": {
        "stated": false,
        "options": {
            "cert": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "crptpasswd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "directory": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "passwd": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "protocol": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "sftp",
                    "ftp",
                    "scp"
                ],
                "type": "str"
            },
            "server": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "time": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "user": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "week_days": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "list",
                "choices": [
                    "monday",
                    "tuesday",
                    "wednesday",
                    "thursday",
                    "friday",
                    "saturday",
                    "sunday"
                ]
            }
        }
    },
    "system_snmp_sysinfo": {
        "stated": false,
        "options": {
            "contact_info": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "description": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "engine-id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "location": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "str"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "trap-cpu-high-exclude-nice-threshold": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "trap-high-cpu-threshold": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "trap-low-memory-threshold": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            }
        }
    },
    "voip_profile_sccp": {
        "stated": false,
        "options": {
            "block-mcast": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-call-summary": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-violations": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "max-calls": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "status": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "verify-header": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            }
        }
    },
    "voip_profile_sip": {
        "stated": false,
        "options": {
            "ack-rate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "block-ack": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-bye": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-cancel": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-geo-red-options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-info": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-invite": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-long-lines": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-message": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-notify": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-options": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-prack": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-publish": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-refer": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-register": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-subscribe": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-unknown": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "block-update": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "bye-rate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "call-keepalive": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "cancel-rate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "contact-fixup": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hnt-restrict-source-ip": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "hosted-nat-traversal": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "info-rate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "invite-rate": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "type": "int"
            },
            "ips-rtp": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-call-summary": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "log-violations": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "disable",
                    "enable"
                ],
                "type": "str"
            },
            "malformed-header-allow": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-call-id": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-contact": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-content-length": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-content-type": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-cseq": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-expires": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-from": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-max-forwards": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-p-asserted-identity": {
                "required": false,
                "revision": {
                    "6.0.0": true,
                    "6.2.1": true,
                    "6.2.3": true,
                    "6.2.5": true,
                    "6.4.0": true,
                    "6.4.2": true,
                    "6.4.5": true,
                    "7.0.0": true,
                    "7.2.0": true
                },
                "choices": [
                    "pass",
                    "discard",
                    "respond"
                ],
                "type": "str"
            },
            "malformed-header-rack": {
                "required": false,
               