/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Wire {
    private final Log log;
    private final String id;

    public Wire(Log log2, String id) {
        this.log = log2;
        this.id = id;
    }

    public Wire(Log log2) {
        this(log2, "");
    }

    private void wire(String header, InputStream inStream) throws IOException {
        int ch;
        StringBuilder buffer2 = new StringBuilder();
        while ((ch = inStream.read()) != -1) {
            if (ch == 13) {
                buffer2.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer2.append("[\\n]\"");
                buffer2.insert(0, "\"");
                buffer2.insert(0, header);
                this.log.debug(this.id + " " + buffer2.toString());
                buffer2.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer2.append("[0x");
                buffer2.append(Integer.toHexString(ch));
                buffer2.append("]");
                continue;
            }
            buffer2.append((char)ch);
        }
        if (buffer2.length() > 0) {
            buffer2.append('\"');
            buffer2.insert(0, '\"');
            buffer2.insert(0, header);
            this.log.debug(this.id + " " + buffer2.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream outStream) throws IOException {
        Args.notNull(outStream, "Output");
        this.wire(">> ", outStream);
    }

    public void input(InputStream inStream) throws IOException {
        Args.notNull(inStream, "Input");
        this.wire("<< ", inStream);
    }

    public void output(byte[] b, int off, int len) throws IOException {
        Args.notNull(b, "Output");
        this.wire(">> ", new ByteArrayInputStream(b, off, len));
    }

    public void input(byte[] b, int off, int len) throws IOException {
        Args.notNull(b, "Input");
        this.wire("<< ", new ByteArrayInputStream(b, off, len));
    }

    public void output(byte[] b) throws IOException {
        Args.notNull(b, "Output");
        this.wire(">> ", new ByteArrayInputStream(b));
    }

    public void input(byte[] b) throws IOException {
        Args.notNull(b, "Input");
        this.wire("<< ", new ByteArrayInputStream(b));
    }

    public void output(int b) throws IOException {
        this.output(new byte[]{(byte)b});
    }

    public void input(int b) throws IOException {
        this.input(new byte[]{(byte)b});
    }

    public void output(String s2) throws IOException {
        Args.notNull(s2, "Output");
        this.output(s2.getBytes());
    }

    public void input(String s2) throws IOException {
        Args.notNull(s2, "Input");
        this.input(s2.getBytes());
    }
}

