/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.BWLimitsMessageHandler;
import net.i2p.client.impl.ClientWriterRunner;
import net.i2p.client.impl.DestReplyMessageHandler;
import net.i2p.client.impl.DisconnectMessageHandler;
import net.i2p.client.impl.HostReplyMessageHandler;
import net.i2p.client.impl.I2PClientMessageHandlerMap;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.client.impl.I2PSessionImpl2;
import net.i2p.client.impl.SetDateMessageHandler;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.internal.InternalClientManager;
import net.i2p.internal.QueuedI2CPMessageReader;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SystemVersion;

public class I2PSimpleSession
extends I2PSessionImpl2 {
    private static final int BUF_SIZE = 1024;

    public I2PSimpleSession(I2PAppContext context, Properties options) throws I2PSessionException {
        super(context, options, new SimpleMessageHandlerMap(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void connect() throws I2PSessionException {
        this.changeState(I2PSessionImpl.State.OPENING);
        boolean success = false;
        try {
            Object object = this._stateLock;
            // MONITORENTER : object
            if (this._context.isRouterContext()) {
                InternalClientManager mgr = this._context.internalClientManager();
                if (mgr == null) {
                    throw new I2PSessionException("Router is not ready for connections");
                }
                this._queue = mgr.connect();
                this._reader = new QueuedI2CPMessageReader(this._queue, (I2CPMessageReader.I2CPMessageEventListener)this);
                this._reader.startReading();
            } else {
                if (Boolean.parseBoolean(this.getOptions().getProperty("i2cp.SSL"))) {
                    try {
                        I2PSSLSocketFactory fact = new I2PSSLSocketFactory(this._context, false, "certificates/i2cp");
                        this._socket = fact.createSocket(this._hostname, this._portNum);
                    }
                    catch (GeneralSecurityException gse) {
                        IOException ioe = new IOException("SSL Fail");
                        ioe.initCause(gse);
                        throw ioe;
                    }
                } else {
                    this._socket = new Socket(this._hostname, this._portNum);
                }
                this._socket.setKeepAlive(true);
                OutputStream out = this._socket.getOutputStream();
                out.write(42);
                out.flush();
                this._writer = new ClientWriterRunner(out, this);
                this._writer.startWriting();
                BufferedInputStream in = new BufferedInputStream(this._socket.getInputStream(), 1024);
                this._reader = new I2CPMessageReader(in, this);
                this._reader.startReading();
            }
            // MONITOREXIT : object
            if (!this._context.isRouterContext()) {
                Properties opts = this.getOptions();
                if (!opts.containsKey("i2cp.username") && !opts.containsKey("i2cp.password")) {
                    String configUser = this._context.getProperty("i2cp.username");
                    String configPW = this._context.getProperty("i2cp.password");
                    if (configUser != null && configPW != null) {
                        opts.setProperty("i2cp.username", configUser);
                        opts.setProperty("i2cp.password", configPW);
                    }
                }
                if (opts.containsKey("i2cp.username") && opts.containsKey("i2cp.password")) {
                    OrderedProperties auth = new OrderedProperties();
                    auth.setProperty("i2cp.username", opts.getProperty("i2cp.username"));
                    auth.setProperty("i2cp.password", opts.getProperty("i2cp.password"));
                    this.sendMessage_unchecked(new GetDateMessage("0.9.54", auth));
                } else {
                    this.sendMessage_unchecked(new GetDateMessage("0.9.54"));
                }
                this.waitForDate();
            }
            success = true;
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + " simple session connected");
            }
            this.changeState(success ? I2PSessionImpl.State.OPEN : I2PSessionImpl.State.CLOSED);
        }
        catch (InterruptedException ie) {
            try {
                throw new I2PSessionException("Interrupted", ie);
                catch (UnknownHostException uhe) {
                    throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, uhe);
                }
                catch (IOException ioe) {
                    String msg;
                    if (this._context.isRouterContext()) {
                        msg = "Failed internal router binding";
                        throw new I2PSessionException(this.getPrefix() + msg, ioe);
                    }
                    if (SystemVersion.isAndroid() && Boolean.parseBoolean(this.getOptions().getProperty("i2cp.domainSocket"))) {
                        msg = "Failed to bind to the router";
                        throw new I2PSessionException(this.getPrefix() + msg, ioe);
                    }
                    msg = "Cannot connect to the router on " + this._hostname + ':' + this._portNum;
                    throw new I2PSessionException(this.getPrefix() + msg, ioe);
                }
            }
            catch (Throwable throwable) {
                this.changeState(success ? I2PSessionImpl.State.OPEN : I2PSessionImpl.State.CLOSED);
                throw throwable;
            }
        }
        return;
    }

    @Override
    public void updateOptions(Properties options) {
    }

    private static class SimpleMessageHandlerMap
    extends I2PClientMessageHandlerMap {
        public SimpleMessageHandlerMap(I2PAppContext context) {
            super(39);
            this._handlers[35] = new DestReplyMessageHandler(context);
            this._handlers[23] = new BWLimitsMessageHandler(context);
            this._handlers[30] = new DisconnectMessageHandler(context);
            this._handlers[39] = new HostReplyMessageHandler(context);
            this._handlers[33] = new SetDateMessageHandler(context);
        }
    }
}

