"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useI18nLoadingStep = exports.useI18nDisabledStep = exports.useI18nIncompleteStep = exports.useI18nErrorsStep = exports.useI18nWarningStep = exports.useI18nCompleteStep = exports.useI18nStep = void 0;

var _i18n = require("../i18n");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var useI18nStep = function useI18nStep(_ref) {
  var number = _ref.number,
      title = _ref.title;
  var string = (0, _i18n.useEuiI18n)('euiStepStrings.step', 'Step {number}: {title}', {
    number: number,
    title: title
  });
  var simpleString = (0, _i18n.useEuiI18n)('euiStepStrings.simpleStep', 'Step {number}', {
    number: number
  });
  return title ? string : simpleString;
};

exports.useI18nStep = useI18nStep;

var useI18nCompleteStep = function useI18nCompleteStep(_ref2) {
  var number = _ref2.number,
      title = _ref2.title;
  var string = (0, _i18n.useEuiI18n)('euiStepStrings.complete', 'Step {number}: {title} is complete', {
    number: number,
    title: title
  });
  var simpleString = (0, _i18n.useEuiI18n)('euiStepStrings.simpleComplete', 'Step {number} is complete', {
    number: number
  });
  return title ? string : simpleString;
};

exports.useI18nCompleteStep = useI18nCompleteStep;

var useI18nWarningStep = function useI18nWarningStep(_ref3) {
  var number = _ref3.number,
      title = _ref3.title;
  var string = (0, _i18n.useEuiI18n)('euiStepStrings.warning', 'Step {number}: {title} has warnings', {
    number: number,
    title: title
  });
  var simpleString = (0, _i18n.useEuiI18n)('euiStepStrings.simpleWarning', 'Step {number} has warnings', {
    number: number
  });
  return title ? string : simpleString;
};

exports.useI18nWarningStep = useI18nWarningStep;

var useI18nErrorsStep = function useI18nErrorsStep(_ref4) {
  var number = _ref4.number,
      title = _ref4.title;
  var string = (0, _i18n.useEuiI18n)('euiStepStrings.errors', 'Step {number}: {title} has errors', {
    number: number,
    title: title
  });
  var simpleString = (0, _i18n.useEuiI18n)('euiStepStrings.simpleErrors', 'Step {number} has errors', {
    number: number
  });
  return title ? string : simpleString;
};

exports.useI18nErrorsStep = useI18nErrorsStep;

var useI18nIncompleteStep = function useI18nIncompleteStep(_ref5) {
  var number = _ref5.number,
      title = _ref5.title;
  var string = (0, _i18n.useEuiI18n)('euiStepStrings.incomplete', 'Step {number}: {title} is incomplete', {
    number: number,
    title: title
  });
  var simpleString = (0, _i18n.useEuiI18n)('euiStepStrings.simpleIncomplete', 'Step {number} is incomplete', {
    number: number
  });
  return title ? string : simpleString;
};

exports.useI18nIncompleteStep = useI18nIncompleteStep;

var useI18nDisabledStep = function useI18nDisabledStep(_ref6) {
  var number = _ref6.number,
      title = _ref6.title;
  var string = (0, _i18n.useEuiI18n)('euiStepStrings.disabled', 'Step {number}: {title} is disabled', {
    number: number,
    title: title
  });
  var simpleString = (0, _i18n.useEuiI18n)('euiStepStrings.simpleDisabled', 'Step {number} is disabled', {
    number: number
  });
  return title ? string : simpleString;
};

exports.useI18nDisabledStep = useI18nDisabledStep;

var useI18nLoadingStep = function useI18nLoadingStep(_ref7) {
  var number = _ref7.number,
      title = _ref7.title;
  var string = (0, _i18n.useEuiI18n)('euiStepStrings.loading', 'Step {number}: {title} is loading', {
    number: number,
    title: title
  });
  var simpleString = (0, _i18n.useEuiI18n)('euiStepStrings.simpleLoading', 'Step {number} is loading', {
    number: number
  });
  return title ? string : simpleString;
};

exports.useI18nLoadingStep = useI18nLoadingStep;