'use strict'

const Ajv = require('ajv')
const fs = require('fs')
const path = require('path')
const pack = require('ajv-pack')

const ajv = new Ajv({
  sourceCode: true // this option is required by ajv-pack
})

const validate = ajv.compile(require('ajv/lib/refs/json-schema-draft-07.json'))

const moduleCode = `// This file is autogenerated by ${path.basename(__filename)}, do not edit

function nop () { return true }

${pack(ajv, validate).replace(/root\.refVal\[0\]/gm, 'nop')}
`

fs.writeFileSync(path.join(__dirname, 'schema-validator.js'), moduleCode)
