'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MetricsAggregationBase = require('./metrics-aggregation-base');

/**
 * A single-value metrics aggregation that keeps track and returns the
 * minimum value among the numeric values extracted from the aggregated
 * documents. These values can be extracted either from specific numeric fields
 * in the documents, or be generated by a provided script.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-min-aggregation.html)
 *
 * Aggregation that keeps track and returns the minimum value among numeric
 * values extracted from the aggregated documents.
 *
 * @example
 * const agg = esb.minAggregation('min_price', 'price');
 *
 * @example
 * // Use a file script
 * const agg = esb.minAggregation('min_price').script(
 *     esb.script('file', 'my_script').params({ field: 'price' })
 * );
 *
 * @example
 * // Value script to apply the conversion rate to every value
 * // before it is aggregated
 * const agg = esb.minAggregation('min_price').script(
 *     esb.script('inline', '_value * params.conversion_rate').params({
 *         conversion_rate: 1.2
 *     })
 * );
 *
 * @param {string} name The name which will be used to refer to this aggregation.
 * @param {string=} field The field to aggregate on
 *
 * @extends MetricsAggregationBase
 */

var MinAggregation = function (_MetricsAggregationBa) {
    (0, _inherits3.default)(MinAggregation, _MetricsAggregationBa);

    // eslint-disable-next-line require-jsdoc
    function MinAggregation(name, field) {
        (0, _classCallCheck3.default)(this, MinAggregation);
        return (0, _possibleConstructorReturn3.default)(this, (MinAggregation.__proto__ || Object.getPrototypeOf(MinAggregation)).call(this, name, 'min', field));
    }

    return MinAggregation;
}(MetricsAggregationBase);

module.exports = MinAggregation;