/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.catalina.storeconfig.StoreFactoryRule;
import org.apache.catalina.storeconfig.StoreRegistry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.SAXException;

public class StoreLoader {
    private static Log log = LogFactory.getLog(StoreLoader.class);
    protected static final Digester digester = StoreLoader.createDigester();
    private StoreRegistry registry;
    private URL registryResource;

    public StoreRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(StoreRegistry registry) {
        this.registry = registry;
    }

    protected static Digester createDigester() {
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(StoreRegistry.class.getClassLoader());
        digester.addObjectCreate("Registry", "org.apache.catalina.storeconfig.StoreRegistry", "className");
        digester.addSetProperties("Registry");
        digester.addObjectCreate("Registry/Description", "org.apache.catalina.storeconfig.StoreDescription", "className");
        digester.addSetProperties("Registry/Description");
        digester.addRule("Registry/Description", (Rule)new StoreFactoryRule("org.apache.catalina.storeconfig.StoreFactoryBase", "storeFactoryClass", "org.apache.catalina.storeconfig.StoreAppender", "storeAppenderClass"));
        digester.addSetNext("Registry/Description", "registerDescription", "org.apache.catalina.storeconfig.StoreDescription");
        digester.addCallMethod("Registry/Description/TransientAttribute", "addTransientAttribute", 0);
        digester.addCallMethod("Registry/Description/TransientChild", "addTransientChild", 0);
        long t2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digester for server-registry.xml created " + (t2 - t1)));
        }
        return digester;
    }

    protected File serverFile(String aFile) {
        File file;
        if (aFile == null || aFile.length() < 1) {
            aFile = "server-registry.xml";
        }
        if (!(file = new File(aFile)).isAbsolute()) {
            file = new File(System.getProperty("catalina.base") + "/conf", aFile);
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String aURL) {
        Digester digester = StoreLoader.digester;
        synchronized (digester) {
            File aRegistryFile = this.serverFile(aURL);
            try {
                this.registry = (StoreRegistry)StoreLoader.digester.parse(aRegistryFile);
                this.registryResource = aRegistryFile.toURI().toURL();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            catch (SAXException e) {
                log.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File home2;
        InputStream is = null;
        this.registryResource = null;
        try {
            String configUrl = StoreLoader.getConfigUrl();
            if (configUrl != null) {
                is = new URL(configUrl).openStream();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Find registry server-registry.xml from system property at url " + configUrl));
                }
                this.registryResource = new URL(configUrl);
            }
        }
        catch (Throwable configUrl) {
            // empty catch block
        }
        if (is == null) {
            try {
                home2 = new File(StoreLoader.getCatalinaBase());
                File conf = new File(home2, "conf");
                File reg = new File(conf, "server-registry.xml");
                is = new FileInputStream(reg);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Find registry server-registry.xml at file " + reg.getCanonicalPath()));
                }
                this.registryResource = reg.toURI().toURL();
            }
            catch (Throwable home2) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = StoreLoader.class.getResourceAsStream("/org/apache/catalina/storeconfig/server-registry.xml");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Find registry server-registry.xml at classpath resource");
                }
                this.registryResource = StoreLoader.class.getResource("/org/apache/catalina/storeconfig/server-registry.xml");
            }
            catch (Throwable home2) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                home2 = digester;
                synchronized (home2) {
                    this.registry = (StoreRegistry)digester.parse(is);
                }
            }
            catch (Throwable t) {
                log.error((Object)t);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException home2) {}
            }
        }
        if (is == null) {
            log.error((Object)"Failed to load server-registry.xml");
        }
    }

    private static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    private static String getCatalinaBase() {
        return System.getProperty("catalina.base", StoreLoader.getCatalinaHome());
    }

    private static String getConfigUrl() {
        return System.getProperty("catalina.storeconfig");
    }

    public URL getRegistryResource() {
        return this.registryResource;
    }
}

