/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    private static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    private static final String PROP_DRIVERCLASSNAME = "driverClassName";
    private static final String PROP_MAXACTIVE = "maxActive";
    private static final String PROP_MAXIDLE = "maxIdle";
    private static final String PROP_MINIDLE = "minIdle";
    private static final String PROP_INITIALSIZE = "initialSize";
    private static final String PROP_MAXWAIT = "maxWait";
    private static final String PROP_TESTONBORROW = "testOnBorrow";
    private static final String PROP_TESTONRETURN = "testOnReturn";
    private static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    private static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_VALIDATIONQUERY = "validationQuery";
    private static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVEABANDONED = "removeAbandoned";
    private static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOGABANDONED = "logAbandoned";
    private static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    private static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    private static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "driverClassName", "maxActive", "maxIdle", "minIdle", "initialSize", "maxWait", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "testWhileIdle", "password", "url", "username", "validationQuery", "accessToUnderlyingConnectionAllowed", "removeAbandoned", "removeAbandonedTimeout", "logAbandoned", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties"};

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < ALL_PROPERTIES.length; ++i) {
            String propertyName = ALL_PROPERTIES[i];
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return BasicDataSourceFactory.createDataSource(properties);
    }

    public static DataSource createDataSource(Properties properties) throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        String value = null;
        value = properties.getProperty(PROP_DEFAULTAUTOCOMMIT);
        if (value != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULTREADONLY)) != null) {
            dataSource.setDefaultReadOnly(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULTTRANSACTIONISOLATION)) != null) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + value);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    level = -1;
                }
            }
            dataSource.setDefaultTransactionIsolation(level);
        }
        if ((value = properties.getProperty(PROP_DEFAULTCATALOG)) != null) {
            dataSource.setDefaultCatalog(value);
        }
        if ((value = properties.getProperty(PROP_DRIVERCLASSNAME)) != null) {
            dataSource.setDriverClassName(value);
        }
        if ((value = properties.getProperty(PROP_MAXACTIVE)) != null) {
            dataSource.setMaxActive(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXIDLE)) != null) {
            dataSource.setMaxIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINIDLE)) != null) {
            dataSource.setMinIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_INITIALSIZE)) != null) {
            dataSource.setInitialSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXWAIT)) != null) {
            dataSource.setMaxWait(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_TESTONBORROW)) != null) {
            dataSource.setTestOnBorrow(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TESTONRETURN)) != null) {
            dataSource.setTestOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TIMEBETWEENEVICTIONRUNSMILLIS)) != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_NUMTESTSPEREVICTIONRUN)) != null) {
            dataSource.setNumTestsPerEvictionRun(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINEVICTABLEIDLETIMEMILLIS)) != null) {
            dataSource.setMinEvictableIdleTimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_TESTWHILEIDLE)) != null) {
            dataSource.setTestWhileIdle(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_PASSWORD)) != null) {
            dataSource.setPassword(value);
        }
        if ((value = properties.getProperty(PROP_URL)) != null) {
            dataSource.setUrl(value);
        }
        if ((value = properties.getProperty(PROP_USERNAME)) != null) {
            dataSource.setUsername(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATIONQUERY)) != null) {
            dataSource.setValidationQuery(value);
        }
        if ((value = properties.getProperty(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED)) != null) {
            dataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVEABANDONED)) != null) {
            dataSource.setRemoveAbandoned(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVEABANDONEDTIMEOUT)) != null) {
            dataSource.setRemoveAbandonedTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_LOGABANDONED)) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            dataSource.setPoolPreparedStatements(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_MAXOPENPREPAREDSTATEMENTS)) != null) {
            dataSource.setMaxOpenPreparedStatements(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_CONNECTIONPROPERTIES)) != null) {
            Properties p = BasicDataSourceFactory.getProperties(value);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                dataSource.addConnectionProperty(propertyName, p.getProperty(propertyName));
            }
        }
        return dataSource;
    }

    private static Properties getProperties(String propText) throws Exception {
        Properties p = new Properties();
        if (propText != null) {
            p.load(new ByteArrayInputStream(propText.replace(';', '\n').getBytes()));
        }
        return p;
    }
}

