/*
 MIT License: http://www.opensource.org/licenses/mit-license.php

 This implementation of the password fields shows a nice graph of how
 secure the password is.
 Original implementation for ExtJS 1.1 from http://testcases.pagebakers.com/PasswordMeter/.
*/
Ext.namespace("Zarafa.plugins.passwd");Zarafa.plugins.passwd.PasswdPlugin=Ext.extend(Zarafa.core.Plugin,{initPlugin:function(){Zarafa.plugins.passwd.PasswdPlugin.superclass.initPlugin.apply(this,arguments);this.registerInsertionPoint("context.settings.categories",this.createSettingsCategory,this)},createSettingsCategory:function(a,b,c){return{xtype:"zarafa.settingspasswdcategory",settingsContext:c}}});
Zarafa.onReady(function(){container.registerPlugin(new Zarafa.core.PluginMetaData({name:"passwd",displayName:_("Change Password"),about:Zarafa.plugins.passwd.ABOUT,pluginConstructor:Zarafa.plugins.passwd.PasswdPlugin}))});Ext.namespace("Zarafa.plugins.passwd.data");
Zarafa.plugins.passwd.data.PasswdResponseHandler=Ext.extend(Zarafa.core.data.AbstractResponseHandler,{callbackFn:void 0,scope:void 0,doError:function(a){var b=_("An unknown error occurred while changing password.");a.info&&(b=a.info.display_message);Ext.MessageBox.alert(_("Error"),b);this.callbackFn.apply(this.scope||this,[!1,a])},doSuccess:function(a){var b=_("Password is changed successfully.");a.info&&(b=a.info.display_message);Ext.MessageBox.alert(_("Success"),b);this.callbackFn.apply(this.scope||
this,[!0,a])}});Ext.namespace("Ext.ux.form.field");
Ext.ux.form.field.PasswordMeter=Ext.extend(Ext.form.TextField,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"ux.passwordmeterfield",inputType:"password",enableKeyEvents:!0});Ext.ux.form.field.PasswordMeter.superclass.constructor.call(this,a)},initComponent:function(){Ext.ux.form.field.PasswordMeter.superclass.initComponent.apply(this,arguments)},reset:function(){Ext.ux.form.field.PasswordMeter.superclass.reset.call(this);this.updateMeter()},onKeyUp:function(a){Ext.ux.form.field.PasswordMeter.superclass.onKeyUp.call(this);
this.updateMeter(this.getValue());this.fireEvent("keyup",this,a)},afterRender:function(){Ext.ux.form.field.PasswordMeter.superclass.afterRender.call(this);var a=this.getEl().getWidth();this.strengthMeterID=Ext.id();this.scoreBarID=Ext.id();a=Ext.DomHelper.insertAfter(this.getEl(),{tag:"div","class":"x-form-strengthmeter",id:this.strengthMeterID,style:{width:a+"px"}});Ext.DomHelper.append(a,{tag:"div","class":"x-form-strengthmeter-scorebar",id:this.scoreBarID});this.fireEvent("afterrender",this)},
getScore:function(){return this.calcStrength(this.getValue())},updateMeter:function(a){var b=Ext.get(this.strengthMeterID);var c=Ext.get(this.scoreBarID);b=b.getWidth();a?(a=this.calcStrength(a),a=b-b/100*a,c.applyStyles({margin:"0 0 0 "+(b-a)+"px"}),c.setWidth(a,!1)):(c.applyStyles({margin:"0"}),c.setWidth(b,!1))},calcStrength:function(a){var b=a.length,c=b;0<b&&4>=b?c+=b:5<=b&&7>=b?c+=6:8<=b&&15>=b?c+=12:16<=b&&(c+=18);a.match(/[a-z]/)&&(c+=1);a.match(/[A-Z]/)&&(c+=5);a.match(/\d/)&&(c+=5);a.match(/(?:.*?\d){3}/)&&
(c+=5);a.match(/[!,@,#,$,%,\^,&,\*,\?,_,~]/)&&(c+=5);a.match(/(?:.*?[!,@,#,$,%,\^,&,\*,\?,_,~]){2}/)&&(c+=5);a.match(/(?=.*[a-z])(?=.*[A-Z])/)&&(c+=2);a.match(/(?=.*\d)(?=.*[a-z])(?=.*[A-Z])/)&&(c+=2);a.match(/(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[!,@,#,$,%,\^,&,\*,\?,_,~])/)&&(c+=2);return Math.min(Math.round(2*c),100)}});Ext.reg("ux.passwordmeterfield",Ext.ux.form.field.PasswordMeter);Ext.namespace("Zarafa.plugins.passwd.settings");
Zarafa.plugins.passwd.settings.PasswdPanel=Ext.extend(Ext.form.FormPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"zarafa.passwdpanel",labelWidth:200,defaults:{width:200},border:!1,items:[{xtype:"displayfield",name:"username",fieldLabel:_("Account")},{xtype:"textfield",name:"current_password",ref:"current_password",fieldLabel:_("Current password"),inputType:"password",allowBlank:!1,listeners:{change:this.onFieldChange,scope:this}},{xtype:"ux.passwordmeterfield",name:"new_password",ref:"new_password",
allowBlank:!1,fieldLabel:_("New password"),listeners:{change:this.onFieldChange,scope:this}},{xtype:"ux.passwordmeterfield",name:"new_password_repeat",allowBlank:!1,ref:"new_password_repeat",fieldLabel:_("Retype new password"),listeners:{change:this.onFieldChange,scope:this}}]});this.addEvents("userchange");Zarafa.plugins.passwd.settings.PasswdPanel.superclass.constructor.apply(this,arguments);this.on("afterrender",this.initialize,this)},initialize:function(){this.getForm().setValues({username:container.getUser().getUserName()})},
onFieldChange:function(a,b,c){this.fireEvent("userchange",this)}});Ext.reg("zarafa.passwdpanel",Zarafa.plugins.passwd.settings.PasswdPanel);Ext.namespace("Zarafa.plugins.passwd.settings");
Zarafa.plugins.passwd.settings.SettingsPasswdCategory=Ext.extend(Zarafa.settings.ui.SettingsCategory,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:_("Change Password"),categoryIndex:9997,iconCls:"zarafa-settings-category-passwd",xtype:"zarafa.settingspasswdcategory",items:[{xtype:"zarafa.settingspasswdwidget",settingsContext:a.settingsContext},container.populateInsertionPoint("context.settings.category.passwd",this)]});Zarafa.plugins.passwd.settings.SettingsPasswdCategory.superclass.constructor.call(this,
a)}});Ext.reg("zarafa.settingspasswdcategory",Zarafa.plugins.passwd.settings.SettingsPasswdCategory);Ext.namespace("Zarafa.plugins.passwd.settings");
Zarafa.plugins.passwd.settings.SettingsPasswdWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:_("Change Password"),xtype:"zarafa.settingspasswdwidget",layout:"form",items:[{xtype:"zarafa.passwdpanel",ref:"passwdPanel",listeners:{userchange:this.setModelDirty,scope:this}}]});Zarafa.plugins.passwd.settings.SettingsPasswdWidget.superclass.constructor.call(this,a)},initEvents:function(){Zarafa.plugins.passwd.settings.SettingsPasswdWidget.superclass.initEvents.call(this);
var a=this.settingsContext.getModel();this.mon(a,"beforesavesettings",this.onBeforeSaveSettings,this);this.mon(a,"savesettings",this.onSaveSettings,this);this.mon(a,"discardsettings",this.onDiscardSettings,this)},onBeforeSaveSettings:function(){return 0==this.ownerCt.isVisible()?!0:this.passwdPanel.new_password.getValue()!=this.passwdPanel.new_password_repeat.getValue()?(Ext.MessageBox.alert(_("Error"),_("New passwords do not match.")),!1):Ext.isEmpty(this.passwdPanel.current_password.getValue())?
(Ext.MessageBox.alert(_("Error"),_("Current password is empty.")),!1):Ext.isEmpty(this.passwdPanel.new_password.getValue())||Ext.isEmpty(this.passwdPanel.new_password_repeat.getValue())?(Ext.MessageBox.alert(_("Error"),_("New password is empty.")),!1):this.passwdPanel.getForm().isValid()?container.getSettingsModel().get("zarafa/v1/plugins/passwd/enable_strict_check")&&70>this.passwdPanel.new_password.getScore()?(Ext.MessageBox.alert(_("Error"),_("Password is weak. Password should contain capital, non-capital letters and numbers. Password should have 8 to 20 characters.")),
!1):!0:(Ext.MessageBox.alert(_("Error"),_("One or more fields does contain errors.")),!1)},onSaveSettings:function(){if(this.ownerCt.isVisible()){this.ownerCt.displaySavingMask();var a=this.passwdPanel.getForm().getFieldValues();container.getRequest().singleRequest("passwdmodule","save",a,new Zarafa.plugins.passwd.data.PasswdResponseHandler({callbackFn:function(b,c){this.ownerCt.hideSavingMask(b);b&&this.passwdPanel.getForm().reset()},scope:this}))}},onDiscardSettings:function(){this.passwdPanel.getForm().reset()},
setModelDirty:function(){var a=this.settingsContext.getModel();a.hasChanges()||a.setDirty()}});Ext.reg("zarafa.settingspasswdwidget",Zarafa.plugins.passwd.settings.SettingsPasswdWidget);//# sourceMappingURL=passwd.js.map
