/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.PushBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PushBuilderImpl
implements PushBuilder {
    private static final Set<String> IGNORE;
    private static final Set<String> CONDITIONAL;
    private static final Set<String> INVALID_METHOD;
    private final HttpServletRequestImpl servletRequest;
    private String method;
    private String queryString;
    private String sessionId;
    private final HttpHeaders headers = new DefaultHttpHeaders();
    private String path;

    public PushBuilderImpl(HttpServletRequestImpl servletRequest) {
        this.servletRequest = servletRequest;
        this.method = "GET";
        this.queryString = servletRequest.getQueryString();
        HttpSession session = servletRequest.getSession(false);
        this.sessionId = session != null ? session.getId() : servletRequest.getRequestedSessionId();
        Collection headers = servletRequest.getExchange().getRequestHeaderNames();
        for (String string : headers) {
            if (IGNORE.contains(string)) continue;
            this.headers.add(string, (Iterable)servletRequest.getExchange().getRequestHeaders(string));
        }
        if (servletRequest.getQueryString() == null) {
            this.headers.add("Referer", (Object)servletRequest.getRequestURL().toString());
        } else {
            this.headers.add("Referer", (Object)(servletRequest.getRequestURL() + "?" + servletRequest.getQueryString()));
        }
        this.path = null;
        for (Map.Entry entry : servletRequest.getExchange().getResponseCookies().entrySet()) {
            if (((Cookie)entry.getValue()).getMaxAge() != null && ((Cookie)entry.getValue()).getMaxAge() <= 0) {
                List existing = this.headers.getAll("Cookie");
                if (existing == null) continue;
                Iterator it = existing.iterator();
                while (it.hasNext()) {
                    String val = (String)it.next();
                    if (!val.startsWith((String)entry.getKey() + "=")) continue;
                    it.remove();
                }
                continue;
            }
            if (((String)entry.getKey()).equals(servletRequest.getServletContext().getSessionCookieConfig().getName())) continue;
            this.headers.add("Cookie", (Object)((String)entry.getKey() + "=" + ((Cookie)entry.getValue()).getValue()));
        }
    }

    public PushBuilder method(String method) {
        if (method == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNullNPE("method");
        }
        if (INVALID_METHOD.contains(method)) {
            throw UndertowServletMessages.MESSAGES.invalidMethodForPushRequest(method);
        }
        this.method = method;
        return this;
    }

    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public PushBuilder setHeader(String name, String value) {
        this.headers.set(name, (Object)value);
        return this;
    }

    public PushBuilder addHeader(String name, String value) {
        this.headers.add(name, (Object)value);
        return this;
    }

    public PushBuilder removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    public PushBuilder path(String path) {
        this.path = path;
        return this;
    }

    public void push() {
        if (this.path == null) {
            throw UndertowServletMessages.MESSAGES.pathWasNotSet();
        }
        if (this.servletRequest.getExchange().isPushSupported()) {
            String path;
            HashMap<String, List<Object>> newHeaders = new HashMap<String, List<Object>>();
            for (Map.Entry entry : this.headers) {
                newHeaders.put((String)entry.getKey(), new ArrayList(this.headers.getAll((String)entry.getKey())));
            }
            if (this.sessionId != null) {
                newHeaders.put("Cookie", Collections.singletonList("JSESSIONID=" + this.sessionId));
            }
            if (!(path = this.path).startsWith("/")) {
                path = this.servletRequest.getContextPath() + "/" + path;
            }
            if (this.queryString != null && !this.queryString.isEmpty()) {
                path = path.contains("?") ? path + "&" + this.queryString : path + "?" + this.queryString;
            }
            this.servletRequest.getExchange().pushResource(path, this.method, newHeaders);
        }
        this.path = null;
        for (String h : CONDITIONAL) {
            this.headers.remove(h);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Set<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry name : this.headers) {
            names.add((String)name.getKey());
        }
        return names;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public String getPath() {
        return this.path;
    }

    static {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("If-Match");
        ignore.add("If-None-Match");
        ignore.add("If-Modified-Since");
        ignore.add("If-Unmodified-Since");
        ignore.add("If-Range");
        ignore.add("Range");
        ignore.add("Accept-Ranges");
        ignore.add("Expect");
        ignore.add("Referer");
        IGNORE = Collections.unmodifiableSet(ignore);
        HashSet<String> conditional = new HashSet<String>();
        conditional.add("If-Match");
        conditional.add("If-None-Match");
        conditional.add("If-Modified-Since");
        conditional.add("If-Unmodified-Since");
        conditional.add("If-Range");
        CONDITIONAL = Collections.unmodifiableSet(conditional);
        HashSet<String> invalid = new HashSet<String>();
        invalid.add("OPTIONS");
        invalid.add("PUT");
        invalid.add("POST");
        invalid.add("DELETE");
        invalid.add("CONNECT");
        invalid.add("TRACE");
        invalid.add("");
        INVALID_METHOD = Collections.unmodifiableSet(invalid);
    }
}

