/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.TemplateInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public abstract class TemplateInstanceBase
implements TemplateInstance {
    private static final Logger LOG = Logger.getLogger(TemplateInstanceBase.class);
    static final String DATA_MAP_KEY = "io.quarkus.qute.dataMap";
    static final Map<String, Object> EMPTY_DATA_MAP = Collections.singletonMap("io.quarkus.qute.dataMap", true);
    protected Object data;
    protected Map<String, Object> dataMap;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected List<Runnable> renderedActions;

    @Override
    public TemplateInstance data(Object data) {
        this.data = data;
        this.dataMap = null;
        return this;
    }

    @Override
    public TemplateInstance data(String key, Object data) {
        this.data = null;
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, Object>();
            this.dataMap.put(DATA_MAP_KEY, true);
        }
        this.dataMap.put(key, data);
        return this;
    }

    @Override
    public TemplateInstance setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public TemplateInstance onRendered(Runnable action) {
        if (this.renderedActions == null) {
            this.renderedActions = new ArrayList<Runnable>();
        }
        this.renderedActions.add(action);
        return this;
    }

    @Override
    public long getTimeout() {
        Object t;
        if (!this.attributes.isEmpty() && (t = this.getAttribute("timeout")) != null) {
            if (t instanceof Long) {
                return (Long)t;
            }
            try {
                return Long.parseLong(t.toString());
            }
            catch (NumberFormatException e) {
                LOG.warnf("Invalid timeout value set for " + this.toString() + ": " + t, new Object[0]);
            }
        }
        return this.engine().getTimeout();
    }

    protected Object data() {
        if (this.data != null) {
            return this.data;
        }
        if (this.dataMap != null) {
            return Mapper.wrap(this.dataMap);
        }
        return EMPTY_DATA_MAP;
    }

    protected abstract Engine engine();
}

