/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.email;

import java.io.IOException;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.email.EmailContentLocation;

public class EmailRepository
implements Repository {
    private MimeRegistry mimeRegistry;
    private EmailContentLocation root;
    private MimeMessage htmlEmail;
    private boolean treatHtmlContentAsBody;
    private MimeMultipart multipart;
    private MimeBodyPart bodypart;

    public EmailRepository(MimeRegistry mimeRegistry, Session mailSession) throws ContentIOException, MessagingException {
        if (mimeRegistry == null) {
            throw new NullPointerException();
        }
        this.mimeRegistry = mimeRegistry;
        this.root = new EmailContentLocation(this, null, "");
        this.htmlEmail = new MimeMessage(mailSession);
        this.bodypart = new MimeBodyPart();
        this.multipart = new MimeMultipart("related");
        this.multipart.addBodyPart((BodyPart)this.bodypart);
        this.htmlEmail.setContent((Multipart)this.multipart);
        this.treatHtmlContentAsBody = true;
    }

    public EmailRepository(MimeMessage htmlEmail, MimeRegistry mimeRegistry) throws ContentIOException, IOException, MessagingException {
        if (htmlEmail == null) {
            throw new NullPointerException();
        }
        if (mimeRegistry == null) {
            throw new NullPointerException();
        }
        this.htmlEmail = htmlEmail;
        Object content = this.htmlEmail.getContent();
        this.multipart = !(content instanceof MimeMultipart) ? new MimeMultipart("related") : (MimeMultipart)content;
        this.treatHtmlContentAsBody = true;
        this.mimeRegistry = mimeRegistry;
        this.root = new EmailContentLocation(this, null, "");
    }

    public EmailRepository(MimeMessage htmlEmail) throws ContentIOException, IOException, MessagingException {
        this(htmlEmail, new DefaultMimeRegistry());
    }

    public EmailRepository(Session session) throws ContentIOException, MessagingException {
        this(new DefaultMimeRegistry(), session);
    }

    @Override
    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    @Override
    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public void writeEmail(OutputStream out) throws ContentIOException {
        try {
            this.htmlEmail.writeTo(out);
        }
        catch (Exception ex) {
            throw new ContentIOException(ex.getMessage(), ex);
        }
    }

    public MimeMessage getEmail() {
        return this.htmlEmail;
    }

    public MimeMultipart getMultipart() {
        return this.multipart;
    }

    public boolean isTreatHtmlContentAsBody() {
        return this.treatHtmlContentAsBody;
    }

    public void setTreatHtmlContentAsBody(boolean treatHtmlContentAsBody) {
        this.treatHtmlContentAsBody = treatHtmlContentAsBody;
    }

    public MimeBodyPart getBodypart() {
        return this.bodypart;
    }
}

