/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.Convert;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConverterFactory;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.test.ConverterInfoList;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.openoffice.xmerge.util.registry.ConverterInfoMgr;
import org.openoffice.xmerge.util.registry.ConverterInfoReader;

public final class Driver {
    private String fromMime = null;
    private String toMime = null;
    private String mergeFile = null;
    private final ArrayList<String> deviceFiles = new ArrayList();
    private final String[] mimeTypes = new String[]{"sxc", "staroffice/sxc", "sxw", "staroffice/sxw"};

    public static void main(String[] stringArray) {
        try {
            Object object;
            String string = "ConverterInfoList.properties";
            ConverterInfoList converterInfoList = new ConverterInfoList(string);
            Iterator<String> iterator = converterInfoList.getJarFileEnum();
            while (iterator.hasNext()) {
                object = iterator.next();
                try {
                    ConverterInfoReader converterInfoReader = new ConverterInfoReader((String)object, false);
                    Iterator<ConverterInfo> iterator2 = converterInfoReader.getConverterInfoEnumeration();
                    ConverterInfoMgr.addPlugIn(iterator2);
                }
                catch (Exception exception) {
                    System.out.println("\nCannot not load <" + (String)object + "> from the <" + string + "> property file");
                }
            }
            object = new Driver();
            super.parseCommandLine(stringArray);
            super.doConversion();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getMessage();
            if (string != null) {
                System.out.println("\n" + string);
            }
            Driver.showUsage();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null) {
                System.out.println("\n" + string);
            }
            exception.printStackTrace();
        }
    }

    private static void close(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) {
            return;
        }
        try {
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws IllegalArgumentException {
        Object object;
        Object object2;
        ConverterFactory converterFactory = new ConverterFactory();
        Convert convert = converterFactory.getConverter(this.fromMime, this.toMime);
        String string2 = null;
        if (convert == null) {
            System.out.println("\nNo plug-in exists to convert from <" + this.fromMime + "> to <" + this.toMime + ">");
            throw new IllegalArgumentException();
        }
        try {
            for (String string2 : this.deviceFiles) {
                object2 = new File(string2);
                if (!((File)object2).exists()) {
                    System.out.println(string2 + " does not exist!");
                    System.exit(0);
                }
                object = new FileInputStream((File)object2);
                convert.addInputStream(((File)object2).getName(), (InputStream)object);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\nFile <" + string2 + "> is not in <" + this.fromMime + "> format", exception);
        }
        Object object3 = null;
        try {
            object3 = convert.convert();
        }
        catch (Exception exception) {
            System.out.println("\nThere was an error in the conversion");
            exception.printStackTrace();
        }
        if (object3 != null) {
            if (this.mergeFile == null) {
                object2 = ((ConvertData)object3).getDocumentEnumeration();
                while (object2.hasNext()) {
                    object = (Document)object2.next();
                    String string3 = object.getFileName();
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(string3);
                        object.write(fileOutputStream);
                        fileOutputStream.flush();
                    }
                    catch (Exception exception) {
                        try {
                            System.out.println("\nThere was a writing out file <" + string3 + ">");
                            exception.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            Driver.close(fileOutputStream);
                            throw throwable;
                        }
                        Driver.close(fileOutputStream);
                        continue;
                    }
                    Driver.close(fileOutputStream);
                }
            } else {
                try {
                    object2 = new FileInputStream(this.mergeFile);
                    object = convert.getOfficeDocument(this.mergeFile, (InputStream)object2);
                    DocumentMerger documentMerger = convert.getDocumentMerger((Document)object);
                    Iterator<Object> iterator = ((ConvertData)object3).getDocumentEnumeration();
                    Document document = (Document)iterator.next();
                    documentMerger.merge(document);
                    ((FileInputStream)object2).close();
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(this.mergeFile);
                        object.write(fileOutputStream);
                        fileOutputStream.flush();
                    }
                    catch (Throwable throwable) {
                        Driver.close(fileOutputStream);
                        throw throwable;
                    }
                    Driver.close(fileOutputStream);
                }
                catch (Exception exception) {
                    System.out.println("\nThere was an error in the merge");
                    exception.printStackTrace();
                }
            }
        }
    }

    private static void showUsage() {
        System.out.println("\nUsage:");
        System.out.println("\n   java org.openoffice.xmerge.test.Driver <args>");
        System.out.println("\n   where <args> is as follows:");
        System.out.println("   -from <MIMETYPE> -to <MIMETYPE> [ -merge <OrigDoc ] <document>\n");
    }

    private void parseCommandLine(String[] stringArray) throws IllegalArgumentException {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if ("-to".equals(string)) {
                this.toMime = this.extractArg(i, stringArray);
                for (n = 0; n < this.mimeTypes.length; n += 2) {
                    if (!this.mimeTypes[n].equals(this.extractArg(i, stringArray))) continue;
                    this.toMime = this.mimeTypes[n + 1];
                }
                ++i;
                continue;
            }
            if ("-from".equals(string)) {
                this.fromMime = this.extractArg(i, stringArray);
                for (n = 0; n < this.mimeTypes.length; n += 2) {
                    if (!this.mimeTypes[n].equals(this.extractArg(i, stringArray))) continue;
                    this.fromMime = this.mimeTypes[n + 1];
                }
                ++i;
                continue;
            }
            if ("-merge".equals(string)) {
                this.mergeFile = this.extractArg(i, stringArray);
                if (!this.isZip(this.mergeFile)) {
                    throw new IllegalArgumentException("Arg " + i + ": expected zip, got " + this.mergeFile);
                }
                ++i;
                continue;
            }
            this.deviceFiles.add(string);
        }
        System.out.println("\nConverting from " + this.fromMime + " to " + this.toMime + (this.mergeFile != null ? " with merge " : " "));
    }

    private String extractArg(int n, String[] stringArray) throws IllegalArgumentException {
        if (n + 1 < stringArray.length) {
            return stringArray[n + 1];
        }
        throw new IllegalArgumentException("Arg " + n + ": expected arg for " + stringArray[n]);
    }

    private boolean isZip(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith("sxw") || string.endsWith("sxc");
    }
}

