# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.orgs.projects.aaa.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class RoleBindings(VapiInterface):
    """
    
    """
    DELETE_IDENTITY_SOURCE_TYPE_VIDM = "VIDM"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.delete`.

    """
    DELETE_IDENTITY_SOURCE_TYPE_LDAP = "LDAP"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.delete`.

    """
    DELETE_IDENTITY_SOURCE_TYPE_OIDC = "OIDC"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_REMOTE_USER = "remote_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_REMOTE_GROUP = "remote_group"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_LOCAL_USER = "local_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_PRINCIPAL_IDENTITY = "principal_identity"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    GET_IDENTITY_SOURCE_TYPE_VIDM = "VIDM"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.get`.

    """
    GET_IDENTITY_SOURCE_TYPE_LDAP = "LDAP"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.get`.

    """
    GET_IDENTITY_SOURCE_TYPE_OIDC = "OIDC"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_REMOTE_USER = "remote_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_REMOTE_GROUP = "remote_group"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_LOCAL_USER = "local_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_PRINCIPAL_IDENTITY = "principal_identity"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    LIST_IDENTITY_SOURCE_TYPE_VIDM = "VIDM"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.list`.

    """
    LIST_IDENTITY_SOURCE_TYPE_LDAP = "LDAP"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.list`.

    """
    LIST_IDENTITY_SOURCE_TYPE_OIDC = "OIDC"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_REMOTE_USER = "remote_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_REMOTE_GROUP = "remote_group"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_LOCAL_USER = "local_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_PRINCIPAL_IDENTITY = "principal_identity"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.aaa.role_bindings'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RoleBindingsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               org_id,
               project_id,
               binding_id,
               cursor=None,
               identity_source_id=None,
               identity_source_type=None,
               included_fields=None,
               name=None,
               page_size=None,
               path=None,
               role=None,
               root_path=None,
               sort_ascending=None,
               sort_by=None,
               type=None,
               ):
        """
        Delete the user/group's role assignment on CSP. If the path is provided
        then deletes only the roles_for_paths that matches the path. If path is
        provided for the last roles_for_paths then the whole role binding is
        deleted provided it is not that of a local user.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  binding_id: :class:`str`
        :param binding_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  identity_source_id: :class:`str` or ``None``
        :param identity_source_id: Identity source ID (optional)
        :type  identity_source_type: :class:`str` or ``None``
        :param identity_source_type: Identity source type (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  name: :class:`str` or ``None``
        :param name: User/Group name (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  path: :class:`str` or ``None``
        :param path: Exact path of the context (optional)
        :type  role: :class:`str` or ``None``
        :param role: Role ID (optional)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('delete',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'binding_id': binding_id,
                            'cursor': cursor,
                            'identity_source_id': identity_source_id,
                            'identity_source_type': identity_source_type,
                            'included_fields': included_fields,
                            'name': name,
                            'page_size': page_size,
                            'path': path,
                            'role': role,
                            'root_path': root_path,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def get(self,
            org_id,
            project_id,
            binding_id,
            cursor=None,
            identity_source_id=None,
            identity_source_type=None,
            included_fields=None,
            name=None,
            page_size=None,
            path=None,
            role=None,
            root_path=None,
            sort_ascending=None,
            sort_by=None,
            type=None,
            ):
        """
        Get user/group's role information from CSP

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  binding_id: :class:`str`
        :param binding_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  identity_source_id: :class:`str` or ``None``
        :param identity_source_id: Identity source ID (optional)
        :type  identity_source_type: :class:`str` or ``None``
        :param identity_source_type: Identity source type (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  name: :class:`str` or ``None``
        :param name: User/Group name (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  path: :class:`str` or ``None``
        :param path: Exact path of the context (optional)
        :type  role: :class:`str` or ``None``
        :param role: Role ID (optional)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.RoleBinding`
        :return: com.vmware.nsx_policy.model.RoleBinding
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'binding_id': binding_id,
                            'cursor': cursor,
                            'identity_source_id': identity_source_id,
                            'identity_source_type': identity_source_type,
                            'included_fields': included_fields,
                            'name': name,
                            'page_size': page_size,
                            'path': path,
                            'role': role,
                            'root_path': root_path,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def list(self,
             org_id,
             project_id,
             cursor=None,
             identity_source_id=None,
             identity_source_type=None,
             included_fields=None,
             name=None,
             page_size=None,
             path=None,
             role=None,
             root_path=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Get all users and groups with their roles from CSP. If the root_path is
        provided then only return role bindings that start-with or are
        sub-trees of the provided root path. Also filter the roles_for_paths
        such that only those roles_for_paths appear that start-with or are
        sub-tree of the provided root path.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  identity_source_id: :class:`str` or ``None``
        :param identity_source_id: Identity source ID (optional)
        :type  identity_source_type: :class:`str` or ``None``
        :param identity_source_type: Identity source type (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  name: :class:`str` or ``None``
        :param name: User/Group name (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  path: :class:`str` or ``None``
        :param path: Exact path of the context (optional)
        :type  role: :class:`str` or ``None``
        :param role: Role ID (optional)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.RoleBindingListResult`
        :return: com.vmware.nsx_policy.model.RoleBindingListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'cursor': cursor,
                            'identity_source_id': identity_source_id,
                            'identity_source_type': identity_source_type,
                            'included_fields': included_fields,
                            'name': name,
                            'page_size': page_size,
                            'path': path,
                            'role': role,
                            'root_path': root_path,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })
class Roles(VapiInterface):
    """
    
    """
    LIST_SCOPE_ROOT = "ROOT"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """
    LIST_SCOPE_ORG = "ORG"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """
    LIST_SCOPE_PROJECT = "PROJECT"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """
    LIST_SCOPE_VPC = "VPC"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.aaa.roles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RolesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             org_id,
             project_id,
             cursor=None,
             included_fields=None,
             page_size=None,
             scope=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get information about all roles

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  scope: :class:`str` or ``None``
        :param scope: List only the roles which are applicable for this scope. (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.RoleListResult`
        :return: com.vmware.nsx_policy.model.RoleListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'scope': scope,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class UserInfo(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.aaa.user_info'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UserInfoStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            ):
        """
        This API will return the name and role information of the user invoking
        this API request on the particular project. The permissions parameter
        of the NsxRole has been deprecated. The response will contain the
        roles_for_paths to indicate roles of the user at various paths .

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.UserInfo`
        :return: com.vmware.nsx_policy.model.UserInfo
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            })
class _RoleBindingsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'binding_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'identity_source_id': type.OptionalType(type.StringType()),
            'identity_source_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'name': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'path': type.OptionalType(type.StringType()),
            'role': type.OptionalType(type.StringType()),
            'root_path': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/aaa/role-bindings/{binding-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'binding_id': 'binding-id',
            },
             header_parameters={
                                           },
            query_parameters={
                'cursor': 'cursor',
                'identity_source_id': 'identity_source_id',
                'identity_source_type': 'identity_source_type',
                'included_fields': 'included_fields',
                'name': 'name',
                'page_size': 'page_size',
                'path': 'path',
                'role': 'role',
                'root_path': 'root_path',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'binding_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'identity_source_id': type.OptionalType(type.StringType()),
            'identity_source_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'name': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'path': type.OptionalType(type.StringType()),
            'role': type.OptionalType(type.StringType()),
            'root_path': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/aaa/role-bindings/{binding-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'binding_id': 'binding-id',
            },
             header_parameters={
                                           },
            query_parameters={
                'cursor': 'cursor',
                'identity_source_id': 'identity_source_id',
                'identity_source_type': 'identity_source_type',
                'included_fields': 'included_fields',
                'name': 'name',
                'page_size': 'page_size',
                'path': 'path',
                'role': 'role',
                'root_path': 'root_path',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'identity_source_id': type.OptionalType(type.StringType()),
            'identity_source_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'name': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'path': type.OptionalType(type.StringType()),
            'role': type.OptionalType(type.StringType()),
            'root_path': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/aaa/role-bindings',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                                         },
            query_parameters={
                'cursor': 'cursor',
                'identity_source_id': 'identity_source_id',
                'identity_source_type': 'identity_source_type',
                'included_fields': 'included_fields',
                'name': 'name',
                'page_size': 'page_size',
                'path': 'path',
                'role': 'role',
                'root_path': 'root_path',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'RoleBinding'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'RoleBindingListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.aaa.role_bindings',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RolesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'scope': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/aaa/roles',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'scope': 'scope',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'RoleListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.aaa.roles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _UserInfoStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/aaa/user-info',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'UserInfo'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.aaa.user_info',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'RoleBindings': RoleBindings,
        'Roles': Roles,
        'UserInfo': UserInfo,
    }

