/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collection;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;

public class LoggingAttributeMatchingExplanationBuilder
implements AttributeMatchingExplanationBuilder {
    private static final AttributeMatchingExplanationBuilder INSTANCE = new LoggingAttributeMatchingExplanationBuilder();
    private static final Logger LOGGER = Logging.getLogger(LoggingAttributeMatchingExplanationBuilder.class);

    static AttributeMatchingExplanationBuilder logging() {
        if (LOGGER.isDebugEnabled()) {
            return INSTANCE;
        }
        return AttributeMatchingExplanationBuilder.NO_OP;
    }

    @Override
    public boolean canSkipExplanation() {
        return true;
    }

    @Override
    public <T extends HasAttributes> void noCandidates(AttributeContainerInternal requested) {
        LOGGER.debug("No candidates for {}. Select nothing.", (Object)requested);
    }

    @Override
    public <T extends HasAttributes> void singleMatch(T candidate, Collection<? extends T> candidates, AttributeContainerInternal requested) {
        LOGGER.debug("Selected match {} from candidates {} for {}", new Object[]{candidate, candidates, requested});
    }

    @Override
    public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
        LOGGER.debug("Candidate {} doesn't match attributes {}", candidate, (Object)requested);
    }

    @Override
    public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
        LOGGER.debug("Candidate {} attribute {} value {} doesn't requested value {}", new Object[]{candidate, attribute, candidateValue, requestedValue});
    }

    @Override
    public <T extends HasAttributes> void candidateAttributeMissing(T candidate, Attribute<?> attribute, Object requestedValue) {
        LOGGER.debug("Candidate {} doesn't have attribute {}", candidate, attribute);
    }

    @Override
    public <T extends HasAttributes> void candidateIsSuperSetOfAllOthers(T candidate) {
        LOGGER.debug("Candidate {} selected because its attributes are a superset of all other candidate attributes", candidate);
    }
}

