/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.gcp.gcs;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class GcsConnectionProperties {
    public static final String GCS_ENDPOINT_PROPERTY = "org.gradle.gcs.endpoint";
    public static final String GCS_SERVICE_PATH_PROPERTY = "org.gradle.gcs.servicePath";
    public static final String GCS_DISABLE_AUTH_PROPERTY = "org.gradle.gcs.disableAuthentication";
    private static final Set<String> SUPPORTED_SCHEMES = Sets.newHashSet((Object[])new String[]{"HTTP", "HTTPS"});
    private final URI endpoint;
    private final String servicePath;
    private final boolean disableAuthentication;

    GcsConnectionProperties() {
        this(System.getProperty(GCS_ENDPOINT_PROPERTY), System.getProperty(GCS_SERVICE_PATH_PROPERTY), System.getProperty(GCS_DISABLE_AUTH_PROPERTY));
    }

    GcsConnectionProperties(String endpoint, String servicePath, String disableAuthentication) {
        this(GcsConnectionProperties.configureEndpoint(endpoint), GcsConnectionProperties.configureServicePath(servicePath), GcsConnectionProperties.configureDisableAuthentication(disableAuthentication));
    }

    private GcsConnectionProperties(URI endpoint, String servicePath, boolean disableAuthentication) {
        this.endpoint = endpoint;
        this.servicePath = servicePath;
        this.disableAuthentication = disableAuthentication;
    }

    Optional<URI> getEndpoint() {
        return Optional.fromNullable((Object)this.endpoint);
    }

    Optional<String> getServicePath() {
        return Optional.fromNullable((Object)this.servicePath);
    }

    boolean requiresAuthentication() {
        return !this.disableAuthentication;
    }

    private static URI configureEndpoint(String property) {
        URI uri = null;
        if (StringUtils.isNotBlank((String)property)) {
            try {
                uri = new URI(property);
                if (StringUtils.isBlank((String)uri.getScheme()) || !SUPPORTED_SCHEMES.contains(uri.getScheme().toUpperCase())) {
                    throw new IllegalArgumentException("System property [org.gradle.gcs.endpoint=" + property + "] must have a scheme of 'http' or 'https'");
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("System property [org.gradle.gcs.endpoint=" + property + "]  must be a valid URI");
            }
        }
        return uri;
    }

    private static String configureServicePath(String property) {
        if (StringUtils.isNotBlank((String)property)) {
            return property;
        }
        return null;
    }

    private static boolean configureDisableAuthentication(String property) {
        return StringUtils.isNotBlank((String)property) && Boolean.parseBoolean(property);
    }
}

