/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ug extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "CNY", "\uffe5" },
            { "USD", "$" },
            { "adp", "\u0626\u0627\u0646\u062f\u0648\u0631\u0631\u0627\u0646 \u067e\u06d0\u0633\u06d0\u062a\u0627\u0633\u0649" },
            { "aed", "\u0626\u06d5\u0631\u06d5\u0628 \u0628\u0649\u0631\u0644\u06d5\u0634\u0645\u06d5 \u062e\u06d5\u0644\u0649\u067e\u0649\u0644\u0649\u0643\u0649 \u062f\u06d5\u0631\u06be\u06d5\u0645\u0649" },
            { "afa", "\u0626\u0627\u0641\u063a\u0627\u0646 \u0626\u0627\u0641\u063a\u0627\u0646\u0649 (1927\u20132002)" },
            { "afn", "\u0626\u0627\u0641\u063a\u0627\u0646 \u0626\u0627\u0641\u063a\u0627\u0646\u0649" },
            { "alk", "\u0626\u0627\u0644\u0628\u0627\u0646\u0649\u064a\u06d5 \u0644\u06d0\u0643\u0649 (1946\u20131965)" },
            { "all", "\u0626\u0627\u0644\u0628\u0627\u0646\u0649\u064a\u06d5 \u0644\u06d0\u0643\u0649" },
            { "amd", "\u0626\u06d5\u0631\u0645\u06d0\u0646\u0649\u064a\u06d5 \u062f\u0649\u0631\u0627\u0645\u0649" },
            { "ang", "\u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u0626\u0627\u0646\u062a\u0649\u0644\u0644\u06d0\u0646 \u06af\u06c7\u0644\u062f\u06d0\u0646\u0649" },
            { "aoa", "\u0626\u0627\u0646\u06af\u0648\u0644\u0627 \u0643\u06c7\u06cb\u0627\u0646\u0632\u0627\u0633\u0649" },
            { "aok", "\u0626\u0627\u0646\u06af\u0648\u0644\u0627 \u0643\u06c7\u06cb\u0627\u0646\u0632\u0627\u0633\u0649 (1977\u20131991)" },
            { "aon", "\u0626\u0627\u0646\u06af\u0648\u0644\u0627 \u064a\u06d0\u06ad\u0649 \u0643\u06c7\u06cb\u0627\u0646\u0632\u0627\u0633\u0649 (1990\u20132000)" },
            { "aor", "\u0626\u0627\u0646\u06af\u0648\u0644\u0627 \u0642\u0627\u064a\u062a\u0627 \u062a\u06d5\u06ad\u0634\u06d5\u0644\u06af\u06d5\u0646 \u0643\u06c7\u06cb\u0627\u0646\u0632\u0627\u0633\u0649 (1995\u20131999)" },
            { "ara", "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649" },
            { "arl", "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u067e\u06d0\u0633\u0648 \u0644\u06d0\u064a\u0649 (1970\u20131983)" },
            { "arm", "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u067e\u06d0\u0633\u0648\u0633\u0649 (1881\u20131970)" },
            { "arp", "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u067e\u06d0\u0633\u0648\u0633\u0649 (1983\u20131985)" },
            { "ars", "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "ats", "\u0626\u0627\u06cb\u0633\u062a\u0631\u0649\u064a\u06d5 \u0634\u0649\u0644\u0644\u0649\u06ad\u0649" },
            { "aud", "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "awg", "\u0626\u0627\u0631\u06c7\u0628\u0627\u0646 \u0641\u0649\u0644\u0648\u0631\u06c7\u0646\u0649" },
            { "azm", "\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646 \u0645\u0627\u0646\u0627\u062a\u0649 (1993\u20132006)" },
            { "azn", "\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646 \u0645\u0627\u0646\u0627\u062a\u0649" },
            { "bad", "\u0628\u0648\u0633\u0646\u0649\u064a\u06d5-\u062e\u06d0\u0631\u062a\u0633\u06d0\u06af\u0648\u06cb\u0649\u0646\u0627 \u062f\u0649\u0646\u0627\u0631\u0649 (1992\u20131994)" },
            { "bam", "\u0628\u0648\u0633\u0646\u0649\u064a\u06d5-\u062e\u06d0\u0631\u062a\u0633\u06d0\u06af\u0648\u06cb\u0649\u0646\u0627 \u0626\u0627\u0644\u0645\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634\u0686\u0627\u0646 \u0645\u0627\u0631\u0643\u0649" },
            { "ban", "\u0628\u0648\u0633\u0646\u0649\u064a\u06d5-\u062e\u06d0\u0631\u062a\u0633\u06d0\u06af\u0648\u06cb\u0649\u0646\u0627 \u064a\u06d0\u06ad\u0649 \u062f\u0649\u0646\u0627\u0631\u0649 (1994\u20131997)" },
            { "bbd", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "bdt", "\u0628\u0627\u06ad\u0644\u0627\u062f\u0649\u0634 \u062a\u0627\u0643\u0627\u0633\u0649" },
            { "bec", "\u0628\u06d0\u0644\u06af\u0649\u064a\u06d5 \u0641\u0631\u0627\u0646\u0643\u0649 (\u0626\u0627\u0644\u0645\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634\u0686\u0627\u0646)" },
            { "bef", "\u0628\u06d0\u0644\u06af\u0649\u064a\u06d5 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "bel", "\u0628\u06d0\u0644\u06af\u0649\u064a\u06d5 \u0641\u0631\u0627\u0646\u0643\u0649 (\u067e\u06c7\u0644\u2013\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5)" },
            { "bgl", "\u0628\u06c7\u0644\u063a\u0627\u0631\u0649\u064a\u06d5 \u0642\u0627\u062a\u062a\u0649\u0642 \u0644\u06d0\u06cb\u0627\u0633\u0649" },
            { "bgm", "\u0628\u06c7\u0644\u063a\u0627\u0631\u0649\u064a\u06d5 \u0626\u0649\u062c\u062a\u0649\u0645\u0627\u0626\u0649\u064a \u0644\u06d0\u06cb\u0627\u0633\u0649" },
            { "bgn", "\u0628\u06c7\u0644\u063a\u0627\u0631\u0649\u064a\u06d5 \u0644\u06d0\u06cb\u0627\u0633\u0649" },
            { "bgo", "\u0628\u06c7\u0644\u063a\u0627\u0631\u0649\u064a\u06d5 \u0644\u06d0\u06cb\u0627\u0633\u0649 (1879\u20131952)" },
            { "bhd", "\u0628\u06d5\u06be\u0631\u06d5\u064a\u0646 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "bif", "\u0628\u06c7\u0631\u06c7\u0646\u062f\u0649 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "bmd", "\u0628\u06d0\u0631\u0645\u06c7\u062f\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "bnd", "\u0628\u0649\u0631\u06c7\u0646\u06d0\u064a \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "bob", "\u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u06d5 \u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u0627\u0646\u0648\u0633\u0649" },
            { "bol", "\u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u06d5 \u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u0627\u0646\u0648\u0633\u0649 (1863\u20131963)" },
            { "bop", "\u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u06d5 \u067e\u0649\u0633\u0648\u0633\u0649" },
            { "bov", "\u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u06d5 \u0645\u06c7\u062f\u0648\u0644\u0649" },
            { "brb", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u064a\u06d0\u06ad\u0649 \u0643\u0631\u06c7\u0632\u06d0\u0631\u0648\u0633\u0649 (1967\u20131986)" },
            { "brc", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u0643\u0631\u06c7\u0632\u0627\u062f\u0648\u0633\u0649 (1986\u20131989)" },
            { "bre", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u064a\u06d0\u06ad\u0649 \u0643\u0631\u06c7\u0632\u06d0\u0631\u0648\u0633\u0649 (1990\u20131993)" },
            { "brl", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u0631\u0649\u064a\u0627\u0644\u0649" },
            { "brn", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u064a\u06d0\u06ad\u0649 \u0643\u0631\u06c7\u0632\u0627\u062f\u0648\u0633\u0649 (1989\u20131990)" },
            { "brr", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u0643\u0631\u06c7\u0632\u06d0\u0631\u0648\u0633\u0649 (1993\u20131994)" },
            { "brz", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u0643\u0631\u06c7\u0632\u06d0\u0631\u0648\u0633\u0649 (1942\u20131967)" },
            { "bsd", "\u0628\u0627\u06be\u0627\u0645\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "btn", "\u0628\u06c7\u062a\u0627\u0646 \u0646\u06af\u06c7\u0644\u062a\u0631\u06c7\u0645\u0649" },
            { "buk", "\u0628\u0649\u0631\u0645\u0627 \u0643\u0649\u064a\u0627\u062a\u0649" },
            { "bwp", "\u0628\u0648\u062a\u0633\u06cb\u0627\u0646\u0627 \u067e\u06c7\u0644\u0627\u0633\u0649" },
            { "byb", "\u0628\u06d0\u0644\u0627\u0631\u06c7\u0633\u0649\u064a\u06d5 \u064a\u06d0\u06ad\u0649 \u0631\u06c7\u0628\u0644\u0649\u0633\u0649 (1994\u20131999)" },
            { "byn", "\u0628\u06d0\u0644\u0627\u0631\u06c7\u0633\u0649\u064a\u06d5 \u0631\u06c7\u0628\u0644\u0649\u0633\u0649" },
            { "byr", "\u0628\u06d0\u0644\u0627\u0631\u06c7\u0633\u0649\u064a\u06d5 \u0631\u06c7\u0628\u0644\u0649\u0633\u0649 (\u06f2\u06f0\u06f0\u06f0\u2013\u06f2\u06f0\u06f1\u06f6)" },
            { "bzd", "\u0628\u06d0\u0644\u0649\u0632 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "cad", "\u0643\u0627\u0646\u0627\u062f\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "cdf", "\u0643\u0648\u0646\u06af\u0648 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "che", "WIR \u064a\u0627\u06cb\u0631\u0648" },
            { "chf", "\u0634\u0649\u06cb\u06d0\u062a\u0633\u0649\u064a\u06d5 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "chw", "WIR \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "cle", "\u0686\u0649\u0644\u0649 \u0626\u06d0\u0633\u0643\u06c7\u062f\u0648\u0633\u0649" },
            { "clf", "\u0686\u0649\u0644\u0649 \u06be\u06d0\u0633\u0627\u0628\u0627\u062a \u0628\u0649\u0631\u0644\u0649\u0643\u0649 (UF)" },
            { "clp", "\u0686\u0649\u0644\u0649 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "cnx", "\u062c\u06c7\u06ad\u06af\u0648 \u062e\u06d5\u0644\u0642 \u0628\u0627\u0646\u0643\u0649\u0633\u0649 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "cny", "\u062c\u06c7\u06ad\u06af\u0648 \u064a\u06c8\u06d5\u0646\u0649" },
            { "cop", "\u0643\u0648\u0644\u0648\u0645\u0628\u0649\u064a\u06d5 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "cou", "\u0643\u0648\u0644\u0648\u0645\u0628\u0649\u064a\u06d5 \u06be\u06d5\u0642\u0649\u0642\u0649\u064a \u0642\u0649\u0645\u0645\u06d5\u062a \u0628\u0649\u0631\u0644\u0649\u0643\u0649" },
            { "crc", "\u0643\u0648\u0633\u062a\u0627\u0631\u0649\u0643\u0627 \u0643\u0648\u0644\u0648\u0646\u0649" },
            { "csd", "\u0633\u06d0\u0631\u0628\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649 (2002\u20132006)" },
            { "csk", "\u0686\u06d0\u062e\u0633\u0649\u0644\u0648\u06cb\u0627\u0643\u0649\u064a\u06d5 \u0642\u0627\u062a\u062a\u0649\u0642 \u0643\u0648\u0631\u06c7\u0646\u0627\u0633\u0649" },
            { "cuc", "\u0643\u06c7\u0628\u0627 \u0626\u0627\u0644\u0645\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634\u0686\u0627\u0646 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "cup", "\u0643\u06c7\u0628\u0627 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "cve", "\u064a\u06d0\u0634\u0649\u0644 \u062a\u06c7\u0645\u0634\u06c7\u0642 \u0626\u06d0\u0633\u0643\u06c7\u062f\u0648\u0633\u0649" },
            { "cyp", "\u0633\u0649\u067e\u0631\u06c7\u0633 \u0641\u0648\u0646\u062f \u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "czk", "\u0686\u06d0\u062e \u062c\u06c7\u0645\u06be\u06c7\u0631\u0649\u064a\u0649\u062a\u0649 \u0643\u0648\u0631\u06c7\u0646\u0627\u0633\u0649" },
            { "ddm", "\u0634\u06d5\u0631\u0642\u0649\u064a \u06af\u06d0\u0631\u0645\u0627\u0646\u0649\u064a\u06d5 \u0645\u0627\u0631\u0643\u0649" },
            { "dem", "\u06af\u06d0\u0631\u0645\u0627\u0646\u0649\u064a\u06d5 \u0645\u0627\u0631\u0643\u0649" },
            { "djf", "\u062c\u0649\u0628\u06c7\u062a\u0649 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "dkk", "\u062f\u0627\u0646\u0649\u064a\u06d5 \u0643\u0631\u0648\u0646\u0649" },
            { "dop", "\u062f\u0648\u0645\u0649\u0646\u0649\u0643\u0627 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "dzd", "\u0626\u0627\u0644\u062c\u0649\u0631\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "ecs", "\u0626\u06d0\u0643\u06cb\u0627\u062f\u0648\u0631 \u0633\u06c7\u0643\u0631\u06d0\u0633\u0649" },
            { "ecv", "\u0626\u06d0\u0643\u06cb\u0627\u062f\u0648\u0631 \u062a\u06c7\u0631\u0627\u0642\u0644\u0649\u0642 \u0642\u0649\u0645\u0645\u06d5\u062a \u0628\u0649\u0631\u0644\u0649\u0643\u0649" },
            { "eek", "\u0626\u06d0\u0633\u062a\u0648\u0646\u0649\u064a\u06d5 \u0643\u0631\u06c7\u0646\u0649" },
            { "egp", "\u0645\u0649\u0633\u0649\u0631 \u0641\u0648\u0646\u062f \u0633\u0649\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "ern", "\u0626\u06d0\u0631\u0649\u062a\u0631\u06d0\u064a\u06d5 \u0646\u0627\u0643\u0641\u0627\u0633\u0649" },
            { "esa", "\u0626\u0649\u0633\u067e\u0627\u0646\u0649\u064a\u06d5 \u067e\u06d0\u0633\u06d0\u062a\u0627\u0633\u0649 (A \u06be\u06d0\u0633\u0627\u0628\u0627\u062a)" },
            { "esb", "\u0626\u0649\u0633\u067e\u0627\u0646\u0649\u064a\u06d5 \u067e\u06d0\u0633\u06d0\u062a\u0627\u0633\u0649 (\u0626\u0627\u0644\u0645\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634 \u06be\u06d0\u0633\u0627\u0628\u0627\u062a\u0649)" },
            { "esp", "\u0626\u0649\u0633\u067e\u0627\u0646\u0649\u064a\u06d5 \u067e\u06d0\u0633\u06d0\u062a\u0627\u0633\u0649" },
            { "etb", "\u0626\u06d0\u0641\u0649\u064a\u0648\u067e\u0649\u064a\u06d5 \u0628\u0649\u0631\u0631\u0649" },
            { "eur", "\u064a\u0627\u06cb\u0631\u0648" },
            { "fim", "\u0641\u0649\u0646\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u0645\u0627\u0631\u0643\u0643\u0627\u0633\u0649" },
            { "fjd", "\u0641\u0649\u062c\u0649 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "fkp", "\u0641\u0627\u0644\u0643\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u0641\u0648\u0646\u062f \u0633\u0649\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "frf", "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "gbp", "\u0626\u06d5\u0646\u06af\u0644\u0649\u064a\u06d5 \u0641\u0648\u0646\u062f \u0633\u0649\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "gek", "\u06af\u0649\u0631\u06c7\u0632\u0649\u064a\u06d5 \u0643\u06c7\u067e\u0648\u0646 \u0644\u0627\u0631\u0649\u062a\u0649" },
            { "gel", "\u06af\u0649\u0631\u06c7\u0632\u0649\u064a\u06d5 \u0644\u0627\u0631\u0649\u0633\u0649" },
            { "ghc", "\u06af\u0627\u0646\u0627 \u0633\u06d0\u062f\u0649\u0633\u0649 (1979\u20132007)" },
            { "ghs", "\u06af\u0627\u0646\u0627 \u0633\u06d0\u062f\u0649\u0633\u0649" },
            { "gip", "\u062c\u06d5\u0628\u0649\u0644\u062a\u0627\u0631\u0649\u0642 \u0641\u0648\u0646\u062f \u0633\u0649\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "gmd", "\u06af\u0627\u0645\u0628\u0649\u064a\u06d5 \u062f\u0627\u0644\u0627\u0633\u0649" },
            { "gnf", "\u06af\u0649\u06cb\u0649\u0646\u06d0\u064a\u06d5 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "gns", "\u06af\u0649\u06cb\u0649\u0646\u06d0\u064a\u06d5 \u0633\u0649\u0644\u0649\u0633\u0649" },
            { "gqe", "\u0626\u06d0\u0643\u06cb\u0627\u062a\u0648\u0631 \u06af\u0649\u06cb\u0649\u0646\u06d0\u064a\u06d5 \u0626\u06d0\u0643\u06cb\u06d0\u0644\u06d0\u0633\u0649" },
            { "grd", "\u06af\u0649\u0631\u06d0\u062a\u0633\u0649\u064a\u06d5 \u062f\u0631\u0627\u062e\u0645\u0627\u0633\u0649" },
            { "gtq", "\u06af\u0649\u06cb\u0627\u062a\u06d0\u0645\u0627\u0644\u0627 \u0643\u06c7\u06cb\u06d0\u062a\u0632\u0627\u0644\u0649" },
            { "gwe", "\u067e\u0648\u0631\u062a\u06c7\u06af\u0627\u0644\u0649\u064a\u06d5 \u06af\u0649\u06cb\u0649\u0646\u06d0\u064a\u06d5 \u0626\u06d0\u0633\u0643\u06c7\u062f\u0648\u0633\u0649" },
            { "gwp", "\u06af\u0649\u06cb\u0649\u0646\u06d0\u064a\u06d5-\u0628\u0649\u0633\u0633\u0627\u0626\u06c7 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "gyd", "\u06af\u0649\u06cb\u0649\u0626\u0627\u0646\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "hkd", "\u0634\u064a\u0627\u06ad\u06af\u0627\u06ad \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "hnl", "\u06be\u0648\u0646\u062f\u06c7\u0631\u0627\u0633 \u0644\u06d0\u0645\u067e\u0649\u0631\u0627\u0633\u0649" },
            { "hrd", "\u0643\u0649\u0631\u0648\u062f\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "hrk", "\u0643\u0649\u0631\u0648\u062f\u0649\u064a\u06d5 \u0643\u06c7\u0646\u0627\u0633\u0649" },
            { "htg", "\u06be\u0627\u064a\u062a\u0649 \u06af\u06c7\u0631\u062f\u06d0\u0633\u0649" },
            { "huf", "\u06cb\u06d0\u0646\u06af\u0649\u0631\u0649\u064a\u06d5 \u0641\u0648\u0631\u06d0\u0646\u062a\u0649" },
            { "idr", "\u06be\u0649\u0646\u062f\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5 \u0631\u06c7\u067e\u0649\u064a\u06d5\u0633\u0649" },
            { "iep", "\u0626\u0649\u0631\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "ilp", "\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644\u0649\u064a\u06d5 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "ilr", "\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644 \u0634\u06d0\u0643\u06d0\u0644\u0649 (1980\u20131985)" },
            { "ils", "\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644 \u064a\u06d0\u06ad\u0649 \u0634\u06d0\u0643\u06d0\u0644\u0649" },
            { "inr", "\u06be\u0649\u0646\u062f\u0649\u0633\u062a\u0627\u0646 \u0631\u06c7\u067e\u0649\u0633\u0649" },
            { "iqd", "\u0626\u0649\u0631\u0627\u0642 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "irr", "\u0626\u0649\u0631\u0627\u0646 \u0631\u0649\u064a\u0627\u0644\u0649" },
            { "isj", "\u0626\u0649\u0633\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u0643\u0631\u0648\u0646\u0627\u0633\u0649 (1918\u20131981)" },
            { "isk", "\u0626\u0649\u0633\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u0643\u0631\u0648\u0646\u0627\u0633\u0649" },
            { "itl", "\u0626\u0649\u062a\u0627\u0644\u0649\u064a\u06d5 \u0644\u0649\u0631\u0627\u0633\u0649" },
            { "jmd", "\u064a\u0627\u0645\u0627\u064a\u0643\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "jod", "\u0626\u0649\u064a\u0648\u0631\u062f\u0627\u0646\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "jpy", "\u064a\u0627\u067e\u0648\u0646\u0649\u064a\u06d5 \u064a\u06d0\u0646\u0649" },
            { "kes", "\u0643\u06d0\u0646\u0649\u064a\u06d5 \u0634\u0649\u0644\u0644\u0649\u06ad\u0649" },
            { "kgs", "\u0642\u0649\u0631\u063a\u0649\u0632\u0649\u0633\u062a\u0627\u0646 \u0633\u0648\u0645\u0649" },
            { "khr", "\u0643\u0627\u0645\u0628\u0648\u062f\u0698\u0627 \u0631\u0649\u0626\u06d0\u0644\u0649" },
            { "kmf", "\u0643\u0648\u0645\u0648\u0631\u0648 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "kpw", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0643\u0648\u0631\u06d0\u064a\u06d5 \u06cb\u0648\u0646\u0649" },
            { "krh", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0643\u0648\u0631\u06d0\u064a\u06d5 \u062e\u06cb\u0627\u0646\u0649 (1953\u20131962)" },
            { "kro", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0643\u0648\u0631\u06d0\u064a\u06d5 \u06cb\u0648\u0646\u0649 (1945\u20131953)" },
            { "krw", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0643\u0648\u0631\u06d0\u064a\u06d5 \u06cb\u0648\u0646\u0649" },
            { "kwd", "\u0643\u06c7\u06cb\u06d5\u064a\u062a \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "kyd", "\u0643\u0627\u064a\u0645\u0627\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "kzt", "\u0642\u0627\u0632\u0627\u0642\u0649\u0633\u062a\u0627\u0646 \u062a\u06d5\u06ad\u06af\u0649\u0633\u0649" },
            { "lak", "\u0644\u0627\u0626\u0648\u0633 \u0643\u0649\u067e\u0649" },
            { "lbp", "\u0644\u0649\u06cb\u0627\u0646 \u0641\u0648\u0646\u062f \u0633\u0649\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "lkr", "\u0633\u0649\u0631\u0649\u0644\u0627\u0646\u0643\u0627 \u0631\u06c7\u067e\u0649\u0633\u0649" },
            { "lrd", "\u0644\u0649\u0628\u06d0\u0631\u0649\u064a\u06d5 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "lsl", "\u0644\u06d0\u0633\u0648\u062a\u0648 \u0644\u0648\u062a\u0649\u0633\u0649" },
            { "ltl", "\u0644\u0649\u062a\u06cb\u0627 \u0644\u0649\u062a\u0627\u0633\u0649" },
            { "ltt", "\u0644\u0649\u062a\u06cb\u0627 \u062a\u0627\u0644\u0648\u0646\u0627\u0633\u0649" },
            { "luc", "\u0644\u064a\u06c7\u0643\u0633\u06d0\u0645\u0628\u06c7\u0631\u06af \u0626\u0627\u0644\u0645\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634\u0686\u0627\u0646 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "luf", "\u0644\u064a\u06c7\u0643\u0633\u06d0\u0645\u0628\u06c7\u0631\u06af \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "lul", "\u0644\u0649\u064a\u06c7\u0643\u0633\u06d0\u0645\u0628\u06c7\u0631\u06af \u067e\u06c7\u0644-\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "lvl", "\u0644\u0627\u062a\u06cb\u0649\u064a\u06d5 \u0644\u0627\u062a\u0649" },
            { "lvr", "\u0644\u0627\u062a\u06cb\u0649\u064a\u06d5 \u0631\u06c7\u0628\u0644\u0649\u0633\u0649" },
            { "lyd", "\u0644\u0649\u06cb\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "mad", "\u0645\u0627\u0631\u0627\u0643\u06d5\u0634 \u062f\u0649\u0631\u06be\u06d5\u0645\u0649" },
            { "maf", "\u0645\u0627\u0631\u0627\u0643\u06d5\u0634 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "mcf", "\u0645\u0648\u0646\u0627\u0643\u0648 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "mdc", "\u0645\u0648\u0644\u062f\u0648\u06cb\u0627 \u0643\u06c7\u067e\u0648\u0646\u0649" },
            { "mdl", "\u0645\u0648\u0644\u062f\u0648\u06cb\u0627 \u0644\u06d0\u06cb\u0649" },
            { "mga", "\u0645\u0627\u062f\u0627\u063a\u0627\u0633\u0642\u0627\u0631 \u0626\u0627\u0631\u0649\u0626\u0627\u0631\u0649\u0633\u0649" },
            { "mgf", "\u0645\u0627\u062f\u0627\u063a\u0627\u0633\u0642\u0627\u0631 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "mkd", "\u0645\u0627\u0643\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "mkn", "\u0645\u0627\u0643\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649 (1992\u20131993)" },
            { "mlf", "\u0645\u0627\u0644\u0649 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "mmk", "\u0645\u0649\u064a\u0627\u0646\u0645\u0627\u0631 \u0643\u0649\u064a\u0627\u062a\u0649" },
            { "mnt", "\u0645\u0648\u06ad\u063a\u06c7\u0644\u0649\u064a\u06d5 \u062a\u06c8\u06af\u0631\u0649\u0643\u0649" },
            { "mop", "\u0626\u0627\u06cb\u0645\u06d0\u0646 \u067e\u0627\u062a\u0627\u0643\u0627\u0633\u0649" },
            { "mro", "\u0645\u0627\u06cb\u0631\u0649\u062a\u0627\u0646\u0649\u064a\u06d5 \u0626\u06c7\u06af\u0649\u064a\u06d5\u0633\u0649 (1973\u20132017)" },
            { "mru", "\u0645\u0627\u06cb\u0631\u0649\u062a\u0627\u0646\u0649\u064a\u06d5 \u0626\u06c7\u06af\u0649\u064a\u06d5\u0633\u0649" },
            { "mtl", "\u0645\u0627\u0644\u062a\u0627 \u0644\u0649\u0631\u0627\u0633\u0649" },
            { "mtp", "\u0645\u0627\u0644\u062a\u0627 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "mur", "\u0645\u0627\u06cb\u0631\u0649\u062a\u0649\u0626\u06c7\u0633 \u0631\u06c7\u067e\u0649\u0633\u0649" },
            { "mvp", "\u0645\u0627\u0644\u062f\u0649\u06cb\u0649 \u0631\u06c7\u067e\u0649\u0633\u0649" },
            { "mvr", "\u0645\u0627\u0644\u062f\u0649\u06cb\u0649 \u0631\u06c7\u0641\u0649\u064a\u0627\u0633\u0649" },
            { "mwk", "\u0645\u0627\u0644\u0627\u06cb\u0649 \u0643\u06cb\u0627\u0686\u0627\u0633\u0649" },
            { "mxn", "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "mxp", "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u0643\u06c8\u0645\u06c8\u0634 \u067e\u06d0\u0633\u0648\u0633\u0649 (1861\u20131992)" },
            { "mxv", "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u0645\u06d5\u0628\u0644\u06d5\u063a \u0628\u0649\u0631\u0644\u0649\u0643\u0649" },
            { "myr", "\u0645\u0627\u0644\u0627\u064a\u0634\u0649\u064a\u0627 \u0631\u0649\u06ad\u06af\u0649\u062a\u0649" },
            { "mze", "\u0645\u0648\u0632\u0627\u0645\u0628\u0649\u0643 \u0626\u06d0\u0633\u0643\u06c7\u062f\u0648\u0633\u0649" },
            { "mzm", "\u0645\u0648\u0632\u0627\u0645\u0628\u0649\u0643 \u0645\u06d0\u062a\u0649\u0643\u0627\u0644\u0649 (1980\u20132006)" },
            { "mzn", "\u0645\u0648\u0632\u0627\u0645\u0628\u0649\u0643 \u0645\u06d0\u062a\u0649\u0643\u0627\u0644\u0649" },
            { "nad", "\u0646\u0627\u0645\u0649\u0628\u0649\u064a\u06d5 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "ngn", "\u0646\u0649\u06af\u06d0\u0631\u0649\u064a\u06d5 \u0646\u0627\u064a\u0631\u0627\u0633\u0649" },
            { "nic", "\u0646\u0649\u06af\u06d0\u0631\u0649\u064a\u06d5 \u0643\u0648\u0631\u062f\u0648\u0628\u0627\u0633\u0649 (1988\u20131991)" },
            { "nio", "\u0646\u0649\u06af\u06d0\u0631\u0649\u064a\u06d5 \u0643\u0648\u0631\u062f\u0648\u0628\u0627\u0633\u0649" },
            { "nlg", "\u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u06af\u06c8\u0644\u062f\u0649\u0646\u0649" },
            { "nok", "\u0646\u0648\u0631\u06cb\u06d0\u06af\u0649\u064a\u06d5 \u0643\u0631\u0648\u0646\u0649" },
            { "npr", "\u0646\u06d0\u067e\u0627\u0644 \u0631\u06c7\u067e\u0649\u0633\u0649" },
            { "nzd", "\u064a\u06d0\u06ad\u0649 \u0632\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "omr", "\u0626\u0648\u0645\u0627\u0646 \u0631\u0649\u064a\u0627\u0644\u0649" },
            { "pab", "\u067e\u0627\u0646\u0627\u0645\u0627 \u0628\u0627\u0644\u0628\u0648\u0626\u0627\u0633\u0649" },
            { "pei", "\u067e\u06d0\u0631\u06c7 \u0626\u0649\u0646\u062a\u0649\u0633\u0649" },
            { "pen", "\u067e\u06d0\u0631\u06c7 \u0633\u0648\u0644\u0649" },
            { "pes", "\u067e\u06d0\u0631\u06c7 \u0633\u0648\u0644\u0649 (1863\u20131965)" },
            { "pgk", "\u067e\u0627\u067e\u06c7\u0626\u0627 \u064a\u06d0\u06ad\u0649 \u06af\u0649\u06cb\u0649\u0646\u06d0\u064a\u06d5 \u0643\u0649\u0646\u0627\u0633\u0649" },
            { "php", "\u0641\u0649\u0644\u0649\u067e\u067e\u0649\u0646 \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "pkr", "\u067e\u0627\u0643\u0649\u0633\u062a\u0627\u0646 \u0631\u06c7\u067e\u0649\u0633\u0649" },
            { "pln", "\u067e\u0648\u0644\u0634\u0627 \u0632\u0649\u0644\u0648\u062a\u0649" },
            { "plz", "\u067e\u0648\u0644\u0634\u0627 \u0632\u0649\u0644\u0648\u062a\u0649 (1950\u20131995)" },
            { "pte", "\u067e\u0648\u0631\u062a\u06c7\u06af\u0627\u0644\u0649\u064a\u06d5 \u0626\u06d0\u0633\u0643\u06c7\u062f\u0648\u0633\u0649" },
            { "pyg", "\u067e\u0627\u0631\u0627\u06af\u06cb\u0627\u064a \u06af\u06c7\u0626\u0627\u0631\u0627\u0646\u0649\u0633\u0649" },
            { "qar", "\u0642\u0627\u062a\u0627\u0631 \u0631\u0649\u064a\u0627\u0644\u0649" },
            { "rhd", "\u0631\u0648\u062f\u06d0\u0632\u0649\u064a\u06d5 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "rol", "\u0631\u06c7\u0645\u0649\u0646\u0649\u064a\u06d5 \u0644\u06d0\u064a\u0649 (1952\u20132006)" },
            { "ron", "\u0631\u06c7\u0645\u0649\u0646\u0649\u064a\u06d5 \u0644\u06d0\u064a\u0649" },
            { "rsd", "\u0633\u06d0\u0631\u0628\u0649\u064a\u06d5 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "rub", "\u0631\u06c7\u0633\u0649\u064a\u06d5 \u0631\u06c7\u0628\u0644\u0649\u0633\u0649" },
            { "rur", "\u0631\u06c7\u0633\u0649\u064a\u06d5 \u0631\u06c7\u0628\u0644\u0649\u0633\u0649 (1991\u20131998)" },
            { "rwf", "\u0631\u06cb\u0627\u0646\u062f\u0627 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "sar", "\u0633\u06d5\u0626\u06c7\u062f\u0649 \u0631\u0649\u064a\u0627\u0644\u0649" },
            { "sbd", "\u0633\u0648\u0644\u0648\u0645\u0648\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "scr", "\u0633\u06d0\u064a\u0634\u06d0\u0644 \u0631\u06c7\u067e\u0649\u0633\u0649" },
            { "sdd", "\u0633\u06c7\u062f\u0627\u0646 \u062f\u0649\u0646\u0627\u0631\u0649 (1992\u20132007)" },
            { "sdg", "\u0633\u06c7\u062f\u0627\u0646 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "sdp", "\u0633\u06c7\u062f\u0627\u0646 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649 (1957\u20131998)" },
            { "sek", "\u0634\u0649\u06cb\u06d0\u062a\u0633\u0649\u064a\u06d5 \u0643\u0631\u0648\u0646\u0627\u0633\u0649" },
            { "sgd", "\u0633\u0649\u0646\u06af\u0627\u067e\u0648\u0631 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "shp", "\u0633\u0627\u064a\u0646\u0649\u062a-\u06be\u06d0\u0644\u06d0\u0646\u0627 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "sit", "\u0633\u0649\u0644\u0648\u06cb\u06d0\u0646\u0649\u064a\u06d5 \u062a\u0648\u0644\u0627\u0631\u0649" },
            { "skk", "\u0633\u0649\u0644\u0648\u06cb\u0627\u0643\u0649\u064a\u06d5 \u0643\u0648\u0631\u06c7\u0646\u0627\u0633\u0649" },
            { "sll", "\u0633\u06d0\u0631\u0631\u0627\u0644\u06d0\u0626\u0648\u0646 \u0644\u06d0\u0626\u0648\u0646\u06d0\u0633\u0649" },
            { "sos", "\u0633\u0648\u0645\u0627\u0644\u0649 \u0634\u0649\u0644\u0644\u0649\u06ad\u0649" },
            { "srd", "\u0633\u06c7\u0631\u0649\u0646\u0627\u0645 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "srg", "\u0633\u06c7\u0631\u0649\u0646\u0627\u0645 \u06af\u06c8\u0644\u062f\u0649\u0646\u0649" },
            { "ssp", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0633\u06c7\u062f\u0627\u0646 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "std", "\u0633\u0627\u0646-\u062a\u0648\u0645\u06d0 \u06cb\u06d5 \u067e\u0649\u0631\u0649\u0646\u0633\u0649\u067e\u0649 \u062f\u0648\u0628\u0631\u0627\u0633\u0649 (1977\u20132017)" },
            { "stn", "\u0633\u0627\u0646-\u062a\u0648\u0645\u06d0 \u06cb\u06d5 \u067e\u0649\u0631\u0649\u0646\u0633\u0649\u067e\u0649 \u062f\u0648\u0628\u0631\u0627\u0633\u0649" },
            { "sur", "\u0633\u0648\u06cb\u0649\u062a \u0631\u06c7\u0628\u0644\u0649\u0633\u0649" },
            { "svc", "\u0633\u0627\u0644\u06cb\u0627\u062f\u0648\u0631 \u0643\u0648\u0644\u0648\u0646\u0649" },
            { "syp", "\u0633\u06c8\u0631\u0649\u064a\u06d5 \u0641\u0648\u0646\u062f\u0633\u062a\u06d0\u0631\u0644\u0649\u06ad\u0649" },
            { "szl", "\u0633\u0649\u06cb\u06d0\u0632\u0649\u0644\u0627\u0646\u062f \u0644\u0649\u0644\u0627\u0646\u06af\u06d0\u0646\u0649" },
            { "thb", "\u062a\u0627\u064a\u0644\u0627\u0646\u062f \u0628\u0627\u062e\u062a\u0649" },
            { "tjr", "\u062a\u0627\u062c\u0649\u0643\u0649\u0633\u062a\u0627\u0646 \u0631\u06c7\u0628\u0644\u0649\u0633\u0649" },
            { "tjs", "\u062a\u0627\u062c\u0649\u0643\u0649\u0633\u062a\u0627\u0646 \u0633\u0648\u0645\u0648\u0646\u0649\u0633\u0649" },
            { "tmm", "\u062a\u06c8\u0631\u0643\u0645\u06d5\u0646\u0649\u0633\u062a\u0627\u0646 \u0645\u0627\u0646\u0627\u062a\u0649 (1993\u20132009)" },
            { "tmt", "\u062a\u06c8\u0631\u0643\u0645\u06d5\u0646\u0649\u0633\u062a\u0627\u0646 \u0645\u0627\u0646\u0627\u062a\u0649" },
            { "tnd", "\u062a\u06c7\u0646\u0649\u0633 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "top", "\u062a\u0648\u0646\u06af\u0627 \u067e\u0627\u0626\u0627\u0646\u06af\u0627\u0633\u0649" },
            { "tpe", "\u062a\u0649\u0645\u0648\u0631 \u0626\u06d0\u0633\u0643\u06c7\u062f\u0648\u0633\u0649" },
            { "trl", "\u062a\u06c8\u0631\u0643\u0649\u064a\u06d5 \u0644\u0649\u0631\u0627\u0633\u0649 (1922\u20132005)" },
            { "try", "\u062a\u06c8\u0631\u0643\u0649\u064a\u06d5 \u0644\u0649\u0631\u0627\u0633\u0649" },
            { "ttd", "\u062a\u0649\u0631\u0649\u0646\u0649\u062f\u0627\u062f \u06cb\u06d5 \u062a\u0648\u0628\u0627\u06af\u0648 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "twd", "\u064a\u06d0\u06ad\u0649 \u062a\u06d5\u064a\u06cb\u06d5\u0646 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "tzs", "\u062a\u0627\u0646\u0632\u0627\u0646\u0649\u064a\u06d5 \u0634\u0649\u0644\u0644\u0649\u06ad\u0649" },
            { "uah", "\u0626\u06c7\u0643\u0631\u0627\u0626\u0649\u0646\u0627 \u062e\u0631\u0649\u06cb\u0646\u0627\u0633\u0649" },
            { "uak", "\u0626\u06c7\u0643\u0631\u0627\u0626\u0649\u0646\u0627 \u0643\u0627\u0631\u0628\u0648\u06cb\u0627\u0646\u06d0\u062a\u0633\u0649" },
            { "ugs", "\u0626\u06c7\u06af\u0627\u0646\u062f\u0627 \u0634\u0649\u0644\u0644\u0649\u06ad\u0649 (1966\u20131987)" },
            { "ugx", "\u0626\u06c7\u06af\u0627\u0646\u062f\u0627 \u0634\u0649\u0644\u0644\u0649\u06ad\u0649" },
            { "usd", "\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "usn", "\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649 (\u0643\u06d0\u064a\u0649\u0646\u0643\u0649 \u0643\u06c8\u0646)" },
            { "uss", "\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u062f\u0648\u0644\u0644\u0649\u0631\u0649 (\u0626\u0648\u062e\u0634\u0627\u0634 \u0643\u06c8\u0646)" },
            { "uyi", "\u0626\u06c7\u0631\u06c7\u06af\u06cb\u0627\u064a \u067e\u06d0\u0633\u0648\u0633\u0649 (\u0626\u0649\u0646\u062f\u06d0\u0643\u0649\u0633\u0644\u0627\u0634 \u0628\u0649\u0631\u0644\u0649\u0643\u0649)" },
            { "uyp", "\u0626\u06c7\u0631\u06c7\u06af\u06cb\u0627\u064a \u067e\u06d0\u0633\u0648\u0633\u0649 (1975\u20131993)" },
            { "uyu", "\u0626\u06c7\u0631\u06c7\u06af\u06cb\u0627\u064a \u067e\u06d0\u0633\u0648\u0633\u0649" },
            { "uzs", "\u0626\u06c6\u0632\u0628\u06d0\u0643\u0649\u0633\u062a\u0627\u0646 \u0633\u0648\u0645\u0649" },
            { "veb", "\u06cb\u06d0\u0646\u06d0\u0632\u06c7\u0626\u06d0\u0644\u0627 \u0628\u0648\u0644\u0649\u06cb\u0627\u0631\u0649 (1871\u20132008)" },
            { "vef", "\u06cb\u06d0\u0646\u06d0\u0632\u06c7\u0626\u06d0\u0644\u0627 \u0628\u0648\u0644\u0649\u06cb\u0627\u0631\u0649 (2008\u20132018)" },
            { "ves", "\u06cb\u06d0\u0646\u06d0\u0632\u06c7\u0626\u06d0\u0644\u0627 \u0628\u0648\u0644\u0649\u06cb\u0627\u0631\u0649" },
            { "vnd", "\u06cb\u0649\u064a\u06d0\u062a\u0646\u0627\u0645 \u062f\u0648\u06ad\u0649" },
            { "vnn", "\u06cb\u0649\u064a\u06d0\u062a\u0646\u0627\u0645 \u062f\u0648\u06ad\u0649 (1978\u20131985)" },
            { "vuv", "\u06cb\u0627\u0646\u06c7\u0626\u0627\u062a\u06c7 \u06cb\u0627\u062a\u06c7\u0633\u0649" },
            { "wst", "\u0633\u0627\u0645\u0648\u0626\u0627 \u062a\u0627\u0644\u0627\u0633\u0649" },
            { "xaf", "\u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u0642\u0649\u062a\u0626\u06d5\u0633\u0649 \u067e\u06c7\u0644-\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5 \u0626\u0649\u062a\u062a\u0649\u067e\u0627\u0642\u0649 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "xag", "\u0643\u06c8\u0645\u06c8\u0634" },
            { "xau", "\u0626\u0627\u0644\u062a\u06c7\u0646" },
            { "xba", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u0645\u06c7\u0631\u06d5\u0643\u0643\u06d5\u067e \u0628\u0649\u0631\u0644\u0649\u0643\u0649" },
            { "xbb", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u067e\u06c7\u0644 \u0628\u0649\u0631\u0644\u0649\u0643\u0649 (XBB)" },
            { "xbc", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u06be\u06d0\u0633\u0627\u0628\u0627\u062a \u0628\u0649\u0631\u0644\u0649\u0643\u0649 (XBC)" },
            { "xbd", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u06be\u06d0\u0633\u0627\u0628\u0627\u062a \u0628\u0649\u0631\u0644\u0649\u0643\u0649 (XBD)" },
            { "xcd", "\u0634\u06d5\u0631\u0642\u0649\u064a \u0643\u0627\u0631\u0649\u0628 \u062f\u0648\u0644\u0644\u0649\u0631\u0649" },
            { "xdr", "\u0626\u0627\u0644\u0627\u06be\u0649\u062f\u06d5 \u067e\u06c7\u0644 \u0626\u06d0\u0644\u0649\u0634 \u06be\u0648\u0642\u06c7\u0642\u0649" },
            { "xeu", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u067e\u06c7\u0644 \u0628\u0649\u0631\u0644\u0649\u0643\u0649" },
            { "xfo", "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5 \u0626\u0627\u0644\u062a\u06c7\u0646 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "xfu", "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5 UIC \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "xof", "\u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u0642\u0649\u062a\u0626\u06d5\u0633\u0649 \u067e\u06c7\u0644-\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5 \u0626\u0649\u062a\u062a\u0649\u067e\u0627\u0642\u0649 \u0641\u0631\u0627\u0646\u0643\u0649 (BCEAO)" },
            { "xpd", "\u067e\u0627\u0644\u0644\u0627\u062f\u0649\u064a" },
            { "xpf", "\u062a\u0649\u0646\u0686 \u0626\u0648\u0643\u064a\u0627\u0646 \u067e\u06c7\u0644-\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5 \u0626\u0648\u0631\u062a\u0627\u0642 \u06af\u06d5\u06cb\u062f\u0649\u0633\u0649 \u0641\u0631\u0627\u0646\u0643\u0649" },
            { "xpt", "\u067e\u0649\u0644\u0627\u062a\u0649\u0646\u0627" },
            { "xre", "RINET \u0641\u0648\u0646\u062f\u0649" },
            { "xsu", "\u0633\u06c7\u0643\u0631\u06d0" },
            { "xts", "\u067e\u06c7\u0644 \u0633\u0649\u0646\u0627\u0634 \u0628\u0649\u0631\u0644\u0649\u0643\u0649" },
            { "xua", "\u0626\u0627\u0633\u0649\u064a\u0627 \u062a\u06d5\u0631\u06d5\u0642\u0642\u0649\u064a\u0627\u062a \u0628\u0627\u0646\u0643\u0649\u0633\u0649 \u06be\u06d0\u0633\u0627\u0628\u0627\u062a \u0628\u0649\u0631\u0644\u0649\u0643\u0649" },
            { "xxx", "\u064a\u0648\u0686\u06c7\u0646 \u067e\u06c7\u0644" },
            { "ydd", "\u064a\u06d5\u0645\u06d5\u0646 \u062f\u0649\u0646\u0627\u0631\u0649" },
            { "yer", "\u064a\u06d5\u0645\u06d5\u0646 \u0631\u0649\u064a\u0627\u0644\u0649" },
            { "yud", "\u064a\u06c7\u06af\u0648\u0633\u0644\u0627\u06cb\u0649\u064a\u06d5 \u0642\u0627\u062a\u062a\u0649\u0642 \u062f\u0649\u0646\u0627\u0631\u0649 (1966\u20131990)" },
            { "yum", "\u064a\u06c7\u06af\u0648\u0633\u0644\u0627\u06cb\u0649\u064a\u06d5 \u064a\u06d0\u06ad\u0649 \u062f\u0649\u0646\u0627\u0631\u0649 (1994\u20132002)" },
            { "yun", "\u064a\u06c7\u06af\u0648\u0633\u0644\u0627\u06cb\u0649\u064a\u06d5 \u0626\u0627\u0644\u0645\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634\u0686\u0627\u0646 \u062f\u0649\u0646\u0627\u0631\u0649 (1990\u20131992)" },
            { "yur", "\u064a\u06c7\u06af\u0648\u0633\u0644\u0627\u06cb\u0649\u064a\u06d5 \u0626\u0649\u0633\u0644\u0627\u06be\u0627\u062a \u062f\u0649\u0646\u0627\u0631\u0649 (1992\u20131993)" },
            { "zal", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u0631\u0627\u0646\u062f\u0649 (\u067e\u06c7\u0644\u2013\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5)" },
            { "zar", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u0631\u0627\u0646\u062f\u0649" },
            { "zmk", "\u0632\u0627\u0645\u0628\u0649\u064a\u06d5 \u0643\u06cb\u0627\u0686\u0627\u0633\u0649 (1968\u20132012)" },
            { "zmw", "\u0632\u0627\u0645\u0628\u0649\u064a\u06d5 \u0643\u06cb\u0627\u0686\u0627\u0633\u0649" },
            { "zrn", "\u0632\u0627\u064a\u0649\u0631 \u064a\u06d0\u06ad\u0649 \u0632\u0627\u064a\u0649\u0631\u0649 (1993\u20131998)" },
            { "zrz", "\u0632\u0627\u064a\u0649\u0631 \u0632\u0627\u064a\u0649\u0631\u0649 (1971\u20131993)" },
            { "zwd", "\u0632\u0649\u0645\u0628\u0627\u0628\u06cb\u06d0 \u062f\u0648\u0644\u0644\u0649\u0631\u0649 (1980\u20132008)" },
            { "zwl", "\u0632\u0649\u0645\u0628\u0627\u0628\u06cb\u06d0 \u062f\u0648\u0644\u0644\u0649\u0631\u0649 (2009)" },
            { "zwr", "\u0632\u0649\u0645\u0628\u0627\u0628\u06cb\u06d0 \u062f\u0648\u0644\u0644\u0649\u0631\u0649 (2008)" },
        };
        return data;
    }
}
