# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.tier_0s.locale_services.l2vpn_context.l2vpns.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class PeerConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier_0s.locale_services.l2vpn_context.l2vpns.peer_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PeerConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            tier0_id,
            locale_service_id,
            l2vpn_id,
            enforcement_point_path=None,
            ):
        """
        

        .. deprecated:: unknown

        :type  tier0_id: :class:`str`
        :param tier0_id: (required)
        :type  locale_service_id: :class:`str`
        :param locale_service_id: (required)
        :type  l2vpn_id: :class:`str`
        :param l2vpn_id: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateL2VpnPeerConfig`
        :return: com.vmware.nsx_policy.model.AggregateL2VpnPeerConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.tier_0s.locale_services.l2vpn_context.l2vpns.PeerConfig.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'tier0_id': tier0_id,
                            'locale_service_id': locale_service_id,
                            'l2vpn_id': l2vpn_id,
                            'enforcement_point_path': enforcement_point_path,
                            })
class Statistics(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier_0s.locale_services.l2vpn_context.l2vpns.statistics'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatisticsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            tier0_id,
            locale_service_id,
            l2vpn_id,
            container_cluster_path=None,
            enforcement_point_path=None,
            ):
        """
        Get statistics of an L2Vpn. - no enforcement point path specified:
        Stats will be evaluated on each enforcement point. -
        {enforcement_point_path}: Stats are evaluated only on the given
        enforcement point. This API is deprecated. Please use GET
        /infra/tier-0s/<tier-0-id>/locale-services/
        <locale-service-id>/l2vpn-services/default/sessions/L2VPN_<l2vpn-id>/statistics
        instead.

        .. deprecated:: unknown

        :type  tier0_id: :class:`str`
        :param tier0_id: (required)
        :type  locale_service_id: :class:`str`
        :param locale_service_id: (required)
        :type  l2vpn_id: :class:`str`
        :param l2vpn_id: (required)
        :type  container_cluster_path: :class:`str` or ``None``
        :param container_cluster_path: String Path of the Container Cluster entity (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateL2VpnStatistics`
        :return: com.vmware.nsx_policy.model.AggregateL2VpnStatistics
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx_policy.infra.tier_0s.locale_services.l2vpn_context.l2vpns.Statistics.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'tier0_id': tier0_id,
                            'locale_service_id': locale_service_id,
                            'l2vpn_id': l2vpn_id,
                            'container_cluster_path': container_cluster_path,
                            'enforcement_point_path': enforcement_point_path,
                            })
class _PeerConfigStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'tier0_id': type.StringType(),
            'locale_service_id': type.StringType(),
            'l2vpn_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/tier-0s/{tier-0-id}/locale-services/{locale-service-id}/l2vpn-context/l2vpns/{l2vpn-id}/peer-config',
            path_variables={
                'tier0_id': 'tier-0-id',
                'locale_service_id': 'locale-service-id',
                'l2vpn_id': 'l2vpn-id',
            },
             header_parameters={
                     },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateL2VpnPeerConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.tier_0s.locale_services.l2vpn_context.l2vpns.peer_config',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatisticsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'tier0_id': type.StringType(),
            'locale_service_id': type.StringType(),
            'l2vpn_id': type.StringType(),
            'container_cluster_path': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/tier-0s/{tier-0-id}/locale-services/{locale-service-id}/l2vpn-context/l2vpns/{l2vpn-id}/statistics',
            path_variables={
                'tier0_id': 'tier-0-id',
                'locale_service_id': 'locale-service-id',
                'l2vpn_id': 'l2vpn-id',
            },
             header_parameters={
                       },
            query_parameters={
                'container_cluster_path': 'container_cluster_path',
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregateL2VpnStatistics'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.tier_0s.locale_services.l2vpn_context.l2vpns.statistics',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'PeerConfig': PeerConfig,
        'Statistics': Statistics,
    }

