<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Configuración de cuenta',
    'sidebar_personalization' => 'Personalización',
    'sidebar_settings_storage' => 'Almacenamiento',
    'sidebar_settings_export' => 'Exportar datos',
    'sidebar_settings_users' => 'Usuarios',
    'sidebar_settings_subscriptions' => 'Subscripción',
    'sidebar_settings_import' => 'Importar datos',
    'sidebar_settings_tags' => 'Gestión de etiquetas',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'Recursos DAV',
    'sidebar_settings_security' => 'Seguridad',
    'sidebar_settings_auditlogs' => 'Registro de auditoría',

    'title_general' => 'Información general',
    'title_i18n' => 'Configuración internacional',
    'title_layout' => 'Diseño',

    'me_title' => 'Yo como contacto',
    'me_help' => 'Este es el contacto que te representa <em>a ti</em> en Monica',
    'me_select' => 'Selecciona un contacto',
    'me_no_contact' => 'Ningún contacto seleccionado.',
    'me_select_click' => 'Haz clic aquí para seleccionar un contacto.',
    'me_remove_contact' => 'Eliminar la asociación',
    'me_choose' => 'Selecciónate a ti mismo',
    'me_choose_placeholder' => 'Selecciónate a ti mismo',

    'export_title' => 'Exportar los datos de tu cuenta',
    'export_be_patient' => 'Haga clic en el botón para iniciar la exportación. Puede tardar varios minutos en procesar la exportación - por favor sea paciente y no haga spam en el botón.',
    'export_title_sql' => 'Exportar a SQL',
    'export_sql_explanation' => 'Exportar tus datos en formato SQL te permite coger tu información e importarla en tu propia instancia de Monica. Esto es útil sólo si tienes tu propio servidor.',
    'export_sql_cta' => 'Exportar a SQL',
    'export_sql_link_instructions' => 'Nota: <a href=":url">lee las instrucciones</a> para aprender más sobre como importar este archivo a tu propia instancia.',
    'export_title_json' => 'Exportar a Json',
    'export_submitted' => 'Su exportación ha sido enviada, estará disponible en un momento…',
    'export_json_explanation' => 'Exportando sus datos en formato Json para la copia de seguridad.',
    'export_json_beta' => 'La exportación de Json está en modo de vista previa. Dinos lo que piensas al respecto:',
    'export_json_cta' => 'Exportar a Json',
    'export_header_type' => 'Tipo',
    'export_header_timestamp' => 'Fecha de creación',
    'export_header_status' => 'Estado',
    'export_header_actions' => 'Acciones',
    'export_last_title' => 'Últimas exportaciones',
    'export_empty_title' => 'Aún no hay exportaciones',
    'export_type_json' => 'Exportación Json',
    'export_type_sql' => 'Exportación SQL',
    'export_status_todo' => 'Enviados',
    'export_status_doing' => 'En proceso',
    'export_status_done' => 'Hecho',
    'export_status_failed' => 'Fallido',
    'export_not_done' => 'Descarga imposible, esta exportación no ha terminado todavía.',

    'firstname' => 'Nombre',
    'lastname' => 'Apellidos',
    'name_order' => 'Orden de los nombres',
    'name_order_firstname_lastname' => '<Nombre> <Apellido> – Juan Pérez',
    'name_order_lastname_firstname' => '<Apellido> <Nombre> – Pérez Juan',
    'name_order_firstname_lastname_nickname' => '<Nombre> <Apellido> (<Apodo>) – Juan Pérez (el Nota)',
    'name_order_firstname_nickname_lastname' => '<Nombre> (<Apodo>) <Apellido> – Juan (el Nota) Pérez',
    'name_order_lastname_firstname_nickname' => '<Apellido> <Nombre> (<Apodo>) – Pérez Juan (el Nota)',
    'name_order_lastname_nickname_firstname' => '<Apellido> (<Apodo>) <Nombre> – Pérez (el Nota) Juan',
    'name_order_nickname_firstname_lastname' => '<Apodo> (<Nombre> <Apellido>) – El Nota (Juan Pérez)',
    'name_order_nickname_lastname_firstname' => '<Apodo> (<Apellido> <Nombre>) – El Nota (Pérez Juan)',
    'name_order_nickname' => '<Apodo> — el Nota',
    'currency' => 'Moneda',
    'name' => 'Tu nombre: :name',
    'email' => 'Correo electrónico',
    'email_placeholder' => 'Ingrese un email',
    'email_help' => 'Este es el correo electrónico usado para identificarte, y en el que recibirás tus recordatorios.',
    'timezone' => 'Zona horaria',
    'temperature_scale' => 'Escala de temperatura',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (˚C)',
    'layout' => 'Disposición',
    'layout_small' => 'Máximo 1200 pixels de ancho',
    'layout_big' => 'Usar ancho del navegador',
    'save' => 'Actualiza preferencias',
    'delete_title' => 'Eliminar tu cuenta',
    'delete_desc' => '¿Deseas eliminar tu cuenta? La eliminación es permanente, todos tus datos se perderán de manera permanente. Si tienes una suscripción, se cancelará inmediatamente.',
    'delete_other_desc' => 'Tus datos en la base de datos principal se borrarán inmediatamente. Tal y como explica nuestra política de privacidad, hacemos copias de seguridad diarias, cifradas de forma segura, que retenemos durante 30 días, tras los cuales se borran completamente. No podemos borrar información específica de las copias de seguridad antes de esto. Todos tus datos se borrarán completamente a los 31 días del borrado de tu cuenta.',
    'reset_desc' => '¿Deseas reiniciar tu cuenta? Esto borrará todos tus contactos, y todos los datos asociados con ellos. Tu cuenta no se eliminará.',
    'reset_title' => 'Resetear tu cuenta',
    'reset_cta' => 'Resetear tu cuenta',
    'reset_notice' => '¿Estás seguro de que quieres resetear tu cuenta? Esta acción es permanente e irreversible.',
    'reset_success' => 'Tu cuenta ha sido reseteada con éxito.',
    'delete_notice' => '¿Estás seguro de que deseas eliminar tu cuenta? Esto es permanente y no se puede deshacer. Todos tus datos serán eliminados y no se podrán recuperar.',
    'delete_cta' => 'Eliminar cuenta',
    'settings_success' => 'Preferencias actualizadas!',
    'locale' => 'Idiomas utilizados en la aplicación',
    'locale_help' => '¿Quieres ayudar a traducir Monica o añadir un nuevo idioma? Sigue <a href=":url" target="_blank" lang="en">este enlace para más información</a>.',
    'locale_ar' => 'Árabe',
    'locale_cs' => 'Checo',
    'locale_de' => 'Alemán',
    'locale_el' => 'Griego',
    'locale_en' => 'Ingles',
    'locale_en-GB' => 'Inglés (Reino Unido)',
    'locale_es' => 'Español',
    'locale_fr' => 'Frances',
    'locale_he' => 'Hebreo',
    'locale_hr' => 'Croata',
    'locale_id' => 'Indonesio',
    'locale_it' => 'Italiano',
    'locale_ja' => 'Japonés',
    'locale_nl' => 'Alemán',
    'locale_pt' => 'Portugues',
    'locale_pt-BR' => 'Portuguese, Brazil',
    'locale_ru' => 'Ruso',
    'locale_sv' => 'Sueco',
    'locale_vi' => 'Vietnamita',
    'locale_zh' => 'Chino simplificado',
    'locale_zh-TW' => 'Chino tradicional',
    'locale_tr' => 'Turco',

    'security_title' => 'Seguridad',
    'security_help' => 'Cambiar configuración de seguridad para tu cuenta.',
    'password_change' => 'Cambia tu contraseña',
    'password_current' => 'Contraseña actual',
    'password_current_placeholder' => 'Introduce tu contraseña actual',
    'password_new1' => 'Nueva contraseña',
    'password_new1_placeholder' => 'Introduzca su nueva contraseña',
    'password_new2' => 'Confirma tu nueva contraseña',
    'password_new2_placeholder' => 'Vuelve a escribir tu nueva contraseña',
    'password_btn' => 'Cambiar Contraseña',
    '2fa_title' => 'Autenticación en dos pasos',
    '2fa_otp_title' => 'Aplicación móvil de autenticación en dos pasos',
    '2fa_enable_title' => 'Activar autenticación de dos pasos',
    '2fa_enable_description' => 'Activar autenticación en dos pasos para aumentar la seguridad de tu cuenta.',
    '2fa_enable_otp' => 'Abre tu aplicación móvil de autenticación en dos pasos y escanea el siguente código QR:',
    '2fa_enable_otp_help' => 'Si tu aplicación móvil de Autenticación en dos pasos no soporta códigos QR, introduce el siguiente código:',
    '2fa_enable_otp_validate' => 'Por favor, valida el dispositivo que acabas de configurar:',
    '2fa_enable_success' => 'Autenticación en dos pasos activada',
    '2fa_enable_error' => 'Se ha producido al activar la Autenticación en dos pasos',
    '2fa_enable_error_already_set' => 'Autenticación en dos pasos ya está activada',
    '2fa_disable_title' => 'Desactivar Autenticación en dos pasos',
    '2fa_disable_description' => 'Desactivar la autenticación de dos factores para tu cuenta. ¡Ten cuidado, tu cuenta será mucho menos segura!',
    '2fa_disable_success' => 'Autenticación en dos pasos desactivada',
    '2fa_disable_error' => 'Se ha producido un error al desactivar la Autenticación en dos pasos',

    'webauthn_title' => 'Clave de seguridad — Protocolo WebAuthn',
    'webauthn_enable_description' => 'Agregar nueva clave de seguridad',
    'webauthn_key_name_help' => 'Dale un nombre a tu clave.',
    'webauthn_key_name' => 'Nombre de la clave:',
    'webauthn_success' => 'Su clave ha sido detectada y validada.',
    'webauthn_last_use' => 'Último uso: {timestamp}',
    'webauthn_delete_confirmation' => '¿Estás seguro de que quieres borrar esta clave?',
    'webauthn_delete_success' => 'Clave eliminada',
    'webauthn_insertKey' => 'Inserte su clave de seguridad.',
    'webauthn_buttonAdvise' => 'Si tu clave de seguridad tiene un botón, presiónalo.',
    'webauthn_noButtonAdvise' => 'Si no lo hace, quítalo e insertalo de nuevo.',
    'webauthn_not_supported' => 'Tu navegador no soporta actualmente WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn sólo soporta conexiones seguras. Por favor, cargue esta página con https.',
    'webauthn_error_already_used' => 'Esta clave ya está registrada. No es necesario registrarla de nuevo.',
    'webauthn_error_not_allowed' => 'La operación ha agotado el tiempo de espera o no ha sido permitida.',

    'recovery_title' => 'Códigos de recuperación',
    'recovery_show' => 'Obtener códigos de recuperación',
    'recovery_copy_help' => 'Copiar códigos al portapaples',
    'recovery_help_intro' => 'Estos son tus códigos de recuperación:',
    'recovery_help_information' => 'Puedes usar cada código de recuperación una vez.',
    'recovery_clipboard' => 'Códigos copiados al portapapeles.',
    'recovery_generate' => 'Generar nuevos códigos…',
    'recovery_generate_help' => 'Generar nuevos códigos invalidará los códigos previamente generados.',
    'recovery_already_used_help' => 'Este código ya ha sido utilizado.',

    'users_list_title' => 'Usuarios con acceso a tu cuenta',
    'users_list_add_user' => 'Invitar a un nuevo usuario',
    'users_list_you' => 'Ese/a eres tú',
    'users_list_invitations_title' => 'Invitaciones pendientes',
    'users_list_invitations_explanation' => 'Debajo están las personas que has invitado a unirse a Monica como colaboradores.',
    'users_list_invitations_invited_by' => 'invitado por :name',
    'users_list_invitations_sent_date' => 'enviada el :date',
    'users_blank_title' => 'Eres la única persona que tiene acceso a esta cuenta.',
    'users_blank_add_title' => '¿Te gustaría invitar a otra persona?',
    'users_blank_description' => 'Esta persona tendrá el mismo acceso que tú y podrá añadir, editar o eliminar la información de contactos.',
    'users_blank_cta' => 'Invitar a alguien',
    'users_add_title' => 'Invita a un nuevo usuario a tu cuenta por correo electrónico',
    'users_add_description' => 'Esta persona tendrá el mismo acceso que tú, incluyendo invitar o eliminar a otros usuarios, incluido tú. Asegúrate de confiar en esta persona antes de darle acceso.',
    'users_add_email_field' => 'Introduce el correo electrónico de la persona a la que quieres invitar',
    'users_add_confirmation' => 'Confirmo que quiero invitar a este usuario a mi cuenta. Entiendo que esta persona tendrá acceso a TODOS mis datos y verá exactamente lo mismo que yo veo.',
    'users_add_cta' => 'Invitar usuario por email',
    'users_accept_title' => 'Aceptar invitación y crear una nueva cuenta',
    'users_error_please_confirm' => 'Por favor, confirma que deseas invitar a este usuario antes de continuar con la invitación',
    'users_error_email_already_taken' => 'La dirección de correo ya ha sido utilizada. Utilice otra distinta',
    'users_error_already_invited' => 'Ya has invitado a este usuario. Por favor, elige otra dirección de correo electrónico.',
    'users_error_email_not_similar' => 'Este no es el correo electrónico de la persona que te ha invitado.',
    'users_invitation_deleted_confirmation_message' => 'La invitación se ha eliminado correctamente',
    'users_invitations_delete_confirmation' => '¿Estás seguro de que quieres borrar esta invitación?',
    'users_list_delete_confirmation' => '¿Estás seguro que deseas borar este usuario de tu cuenta?',
    'users_invitation_need_subscription' => 'Añadir más usuarios requiere una suscripción.',

    'subscriptions_account_current_plan' => 'Tu plan actual',
    'subscriptions_account_current_legacy' => 'Plan actual, ya no seleccionable:',
    'subscriptions_account_current_paid_plan' => 'Tú plan actual es :name. Muchas gracias por tu suscripción.',

    'subscriptions_account_next_billing_title' => 'Próxima factura',
    'subscriptions_account_next_billing' => 'Tu suscripción se renovará automáticamente el <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'Te facturaremos <strong>:price</strong> por otro <strong>mes</strong>.',
    'subscriptions_account_bill_annual' => 'Te facturaremos <strong>:price</strong> por otro <strong>año</strong>.',
    'subscriptions_account_change' => 'Cambiar Plan',

    'subscriptions_account_cancel_title' => 'Cancelar suscripción',
    'subscriptions_account_cancel_action' => 'Cancelar suscripción',
    'subscriptions_account_cancel' => 'You can <a href=":url">cancel subscription</a> anytime.',
    'subscriptions_account_free_plan' => 'Tienes el plan gratuito.',
    'subscriptions_account_free_plan_upgrade' => 'Puedes mejorar tu cuenta al plan :name, que cuesta $:price al mes. Estas son las ventajas:',
    'subscriptions_account_free_plan_benefits_users' => 'Número ilimitado de usuarios',
    'subscriptions_account_free_plan_benefits_reminders' => 'Recordatorios por correo electrónico',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Importar tus contactos con vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Respaldar el proyecto a largo plazo, para que podamos seguir añadiendo estupendas mejoras.',
    'subscriptions_account_upgrade' => 'Mejorar tu cuenta',
    'subscriptions_account_upgrade_title' => 'Mejora Mónica hoy y ten relaciones más significativas.',
    'subscriptions_account_upgrade_choice' => 'Escoja un plan a continuación y únase a :clientes que mejoraron su Monica.',
    'subscriptions_account_update_title' => 'Actualizar suscripción de Monica',
    'subscriptions_account_update_description' => 'Puedes cambiar la frecuencia de tu suscripción aquí.',
    'subscriptions_account_update_information' => 'Se te facturará inmediatamente por la nueva cantidad. Tu suscripción se ampliará al nuevo período, dependiendo de tu elección.',
    'subscriptions_account_invoices' => 'Recibos',
    'subscriptions_account_invoices_download' => 'Descargar',
    'subscriptions_account_invoices_subscription' => 'Suscripción de :startDate a :endDate',
    'subscriptions_account_payment' => '¿Qué opción de pago se ajusta mejor a ti?',
    'subscriptions_account_confirm_payment' => 'Tu pago está actualmente incompleto, por favor <a href=":url">confirma tu pago</a>.',
    'subscriptions_downgrade_title' => 'Reduzca su cuenta al plan gratuito',
    'subscriptions_downgrade_limitations' => 'El plan gratuito tiene limitaciones. Para poder degradar, tienes que pasar la siguiente lista de verificación:',
    'subscriptions_downgrade_rule_users' => 'Debes tener sólo 1 usuario en tu cuenta',
    'subscriptions_downgrade_rule_users_constraint' => 'Actualmente tienes <a href=":url">1 usuario</a> en tu cuenta.|Actualmente tienes <a href=":url">:count usuarios</a> en tu cuenta.',
    'subscriptions_downgrade_rule_invitations' => 'No debes tener ninguna invitación pendiente',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Actualmente tienes <a href=":url">1 invitación pendiente</a>. |Actualmente tienes <a href=":url">:count invitaciones pendientes</a>.',
    'subscriptions_downgrade_rule_contacts' => 'No debe tener más de :number contactos activos',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Actualmente tienes <a href=":url">1 contacto</a>.|Actualmente tienes <a href=":url">:count contactos</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'También podemos <a href=":url">archivar todos tus contactos para ti</a> – que borrarían esta regla y te permitirán continuar con el proceso de rebaja de tu cuenta.',
    'subscriptions_downgrade_cta' => 'Pasar a una suscripción inferior',
    'subscriptions_downgrade_success' => '¡Estás de vuelta al plan Gratis!',
    'subscriptions_downgrade_thanks' => 'Muchas gracias por probar el plan de pago. Seguimos añadiendo nuevas mejoras en Monica todo el tiempo, así que tal vez quieras volver en el futuro para ver si estás interesado en suscribirte de nuevo.',
    'subscriptions_back' => 'Volver a ajustes',
    'subscriptions_upgrade_title' => 'Mejorar tu cuenta',
    'subscriptions_upgrade_choose' => 'Has elegido el plan :plan.',
    'subscriptions_upgrade_infos' => 'No podemos estar más contentos. Introduce tu información de pago a continuación.',
    'subscriptions_upgrade_name' => 'Nombre en la tarjeta',
    'subscriptions_upgrade_zip' => 'ZIP / código postal',
    'subscriptions_upgrade_credit' => 'Tarjeta de crédito o débito',
    'subscriptions_upgrade_submit' => 'Pagar {amount}',
    'subscriptions_upgrade_charge' => 'Le cobraremos a tu tarjeta :price ahora. El siguiente cargo será el :date. Si alguna vez cambias de opinión, puedes cancelar en cualquier momento, sin preguntas formuladas.',
    'subscriptions_upgrade_charge_handled' => 'El pago es gestionado por <a href=":url">Stripe</a>. Ninguna información de la tarjeta toca nuestro servidor.',
    'subscriptions_upgrade_success' => '¡Gracias! Ahora estás suscrito.',
    'subscriptions_upgrade_thanks' => 'Bienvenidos a la comunidad de personas que intentan hacer del mundo un lugar mejor.',

    'subscriptions_payment_confirm_title' => 'Confirme su pago :amount',
    'subscriptions_payment_confirm_information' => 'Se necesita confirmación adicional para procesar tu pago. Por favor, confirma tu pago completando los detalles de tu pago a continuación.',
    'subscriptions_payment_succeeded_title' => 'Pago exitoso',
    'subscriptions_payment_succeeded' => 'Este pago ya fue confirmado con éxito.',
    'subscriptions_payment_cancelled_title' => 'Pago Cancelado',
    'subscriptions_payment_cancelled' => 'El pago ha sido cancelado.',
    'subscriptions_payment_error_name' => 'Por favor ingrese su nombre.',
    'subscriptions_payment_success' => 'Pago realizado con exito.',

    'subscriptions_pdf_title' => 'Tu suscripción mensual de :name',
    'subscriptions_plan_frequency_year' => ':amount / año',
    'subscriptions_plan_frequency_month' => ':amount / mes',
    'subscriptions_plan_choose' => 'Elegir este plan',
    'subscriptions_plan_year_title' => 'Pagar anualmente',
    'subscriptions_plan_year_bonus' => 'Paz mental durante todo un año',
    'subscriptions_plan_month_title' => 'Pagar mensualmente',
    'subscriptions_plan_month_bonus' => 'Cancelar en cualquier momento',
    'subscriptions_plan_include1' => 'Incluye con tu actualización:',
    'subscriptions_plan_include2' => 'Número ilimitado de contactos • Número ilimitado de usuarios • Recordatorios por correo electrónico • Importación con vCard • Personalización de la hoja de contacto',
    'subscriptions_plan_include3' => 'El 100% de los beneficios se destinan al desarrollo de este gran proyecto de código abierto.',
    'subscriptions_help_title' => 'Detalles adicionales sobre los que puedes tener curiosidad',
    'subscriptions_help_opensource_title' => '¿Qué es un proyecto de código abierto?',
    'subscriptions_help_opensource_desc' => 'Monica es un proyecto de código abierto. Esto significa que está construido por una comunidad que quiere construir una gran herramienta para el bien mayor. Ser de código abierto significa que el código está disponible públicamente en GitHub, y todos pueden inspeccionarlo, modificarlo o mejorarlo. Todo el dinero que recaudamos se dedica a construir mejores características, a pagar por servidores más poderosos y a pagar otros costes. Gracias por tu ayuda. No podríamos hacerlo sin ti.',
    'subscriptions_help_limits_title' => '¿Existe un límite en el número de contactos que podemos tener en el plan gratuito?',
    'subscriptions_help_limits_plan' => 'Sí. Los planes gratuitos te permiten administrar :number contacts.',
    'subscriptions_help_discounts_title' => '¿Tiene descuentos para educación y sin fines de lucro?',
    'subscriptions_help_discounts_desc' => '¡Los tenemos! Mónica es gratuita para los estudiantes, y gratuita para organizaciones benéficas y sin fines de lucro. Póngase en contacto con <a href=":support">el equipo de soporte</a> con una prueba de su estado y aplicaremos este estado especial en su cuenta.',
    'subscriptions_help_change_title' => '¿Qué pasa si cambio de opinión?',
    'subscriptions_help_change_desc' => 'Puedes cancelar en cualquier momento, sin preguntas y por ti mismo – sin necesidad de ponerte en contacto con soporte técnico. Sin embargo, no se le reembolsará durante el período actual.',

    'stripe_error_card' => 'Tu tarjeta fue rechazada. El mensaje es: :message',
    'stripe_error_api_connection' => 'La comunicación de red con Stripe falló. Inténtalo de nuevo más tarde.',
    'stripe_error_rate_limit' => 'Demasiadas solicitudes con Stripe ahora mismo. Inténtalo de nuevo más tarde.',
    'stripe_error_invalid_request' => 'Parámetros inválidos. Inténtalo de nuevo más tarde.',
    'stripe_error_authentication' => 'Autenticación incorrecta con Stripe',

    'import_title' => 'Importar contactos en tu cuenta',
    'import_cta' => 'Subir contactos',
    'import_stat' => 'Has importado :number archivos hasta ahora.',
    'import_result_stat' => 'Tarjeta vCard cargada con 1 contacto (:total_imported, :total_skipped saltado)|Tarjeta vs cargada con :total_contacts contactos (:total_imported, :total_skipped saltado)',
    'import_view_report' => 'Ver informe',
    'import_in_progress' => 'La importación está en progreso. Recarga la página en un minuto.',
    'import_upload_title' => 'Importa tus contactos con vCard',
    'import_upload_rules_desc' => 'Sin embargo, tenemos algunas normas:',
    'import_upload_rule_format' => 'Soportamos archivos <code>.vcard</code> y <code>.vcf</code>.',
    'import_upload_rule_vcard' => 'Soportamos el formato vCard 3.0, que es el formato predeterminado para Contacts.app (macOS) y Google Contacts.',
    'import_upload_rule_instructions' => 'Instrucciones de exportación para <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> y <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'Si sus contactos tienen varias direcciones de correo electrónico o números de teléfono, sólo se guardará la primera entrada.',
    'import_upload_rule_limit' => 'Los archivos están limitados a 10 MB.',
    'import_upload_rule_time' => 'Puede tardar hasta un minuto en subir los contactos y procesarlos. Por favor, sea paciente.',
    'import_upload_rule_cant_revert' => 'Por favor, asegúrese de que los datos son precisos antes de cargarlos, ya que no puede deshacer.',
    'import_upload_form_file' => 'Tu archivo <code>.vcf</code> o <code>.vCard</code>:',
    'import_upload_behaviour' => 'Comportamiento de importación:',
    'import_upload_behaviour_add' => 'Añadir nuevos contactos y omitir existentes',
    'import_upload_behaviour_replace' => 'Reemplazar contactos existentes',
    'import_upload_behaviour_help' => 'La sustitución reemplazará todos los datos encontrados en la vCard, pero mantendrá los campos de contacto existentes.',
    'import_report_title' => 'Importando reporte',
    'import_report_date' => 'Fecha de importación',
    'import_report_type' => 'Tipo de importación',
    'import_report_number_contacts' => 'Número de contactos en el archivo',
    'import_report_number_contacts_imported' => 'Número de contactos importados',
    'import_report_number_contacts_skipped' => 'Número de contactos omitidos',
    'import_report_status_imported' => 'Importados',
    'import_report_status_skipped' => 'Omitidos',
    'import_vcard_parse_error' => 'Error al analizar la entrada vCard',
    'import_vcard_contact_exist' => 'El contacto ya existe',
    'import_vcard_contact_no_firstname' => 'Sin nombre (obligatorio)',
    'import_vcard_file_not_found' => 'Archivo no encontrado',
    'import_vcard_unknown_entry' => 'Nombre de contacto desconocido',
    'import_vcard_file_no_entries' => 'El archivo no contiene entradas',
    'import_blank_title' => 'Aún no has importado ningún contacto.',
    'import_blank_question' => '¿Quieres importar contactos ahora?',
    'import_blank_description' => 'Podemos importar archivos vCard que puedes obtener de Google Contacts o de tu administrador de contactos.',
    'import_blank_cta' => 'Importar vCard',
    'import_need_subscription' => 'La importación de datos requiere una suscripción.',

    'tags_list_title' => 'Etiquetas',
    'tags_list_description' => 'Puede organizar sus contactos configurando etiquetas. Las etiquetas funcionan como carpetas, pero puede añadir más de una etiqueta a un contacto. Para añadir una nueva etiqueta, añádela en el contacto mismo.',
    'tags_list_contact_number' => '1 contacto|:count contactos',
    'tags_list_delete_success' => 'La etiqueta se ha eliminado correctamente',
    'tags_list_delete_confirmation' => '¿Está seguro que desea eliminar la etiqueta? Ningún contacto será eliminado, sólo la etiqueta.',
    'tags_blank_title' => 'Las etiquetas son una excelente forma de clasificar tus contactos.',
    'tags_blank_description' => 'Las etiquetas funcionan como carpetas, pero puede añadir más de una etiqueta a un contacto. Ir a un contacto y etiquetar a un amigo, justo debajo del nombre. Una vez que un contacto está etiquetado, vuelve aquí para gestionar todas las etiquetas de tu cuenta.',

    'api_title' => 'Acceso API',
    'api_description' => 'La API se puede utilizar para manipular los datos de Monica desde una aplicación externa, como una aplicación móvil por ejemplo.',
    'api_help' => 'Para utilizar la API, un token es obligatorio. Puede crear un token de acceso personal (autenticación de portador), o autorizar a un cliente de OAuth a crearlo para usted. Vea <a href=":url">documentación API</a>.',
    'api_endpoint' => 'El punto final de la API para esta instancia de Monica es:',

    'api_personal_access_tokens' => 'Tokens de acceso personal',
    'api_pao_description' => 'Asegúrese de dar este token a una fuente en la que confíe – ya que le permite acceder a todos sus datos.',
    'api_token_title' => 'Tokens de acceso personal',
    'api_token_create_new' => 'Crear nuevo token',
    'api_token_not_created' => 'No ha creado ningún token de acceso personal.',
    'api_token_name' => 'Nombre del token',
    'api_token_expire' => 'Expira el {date}',
    'api_token_delete' => 'Eliminar',
    'api_token_create' => 'Crear token',
    'api_token_scopes' => 'Alcances',
    'api_token_help' => 'Aquí está su nuevo token de acceso personal. Esta es la única vez que se mostrará así que no lo pierdas! Ahora puedes usar este token para hacer solicitudes de API.',

    'api_oauth_clients' => 'Sus clientes OAuth',
    'api_oauth_clients_desc' => 'Esta sección le permite registrar sus propios clientes de OAuth.',
    'api_oauth_clients_desc2' => 'Usa este id de cliente para solicitar un nuevo token y convertir códigos de autorización para los tokens de acceso. Consulta <a href="{url}">la documentación de Laravel Passport</a> para más información.',
    'api_oauth_title' => 'Clientes de OAuth',
    'api_oauth_create_new' => 'Crear un Nuevo Cliente',
    'api_oauth_edit' => 'Editar cliente',
    'api_oauth_not_created' => 'No ha creado ningún cliente OAuth.',
    'api_oauth_clientid' => 'ID de cliente',
    'api_oauth_name' => 'Nombre',
    'api_oauth_name_help' => 'Algo que sus usuarios reconocerán y en lo que confiarán.',
    'api_oauth_secret' => 'Secreto',
    'api_oauth_create' => 'Crear un nuevo cliente',
    'api_oauth_redirecturl' => 'URL de redirección',
    'api_oauth_redirecturl_help' => 'La URL de devolución de autorización de tu aplicación.',

    'api_authorized_clients' => 'Lista de clientes autorizados',
    'api_authorized_clients_desc' => 'Esta sección lista a todos los clientes que has autorizado para acceder a los datos de tu aplicación. Puedes revocar esta autorización en cualquier momento.',
    'api_authorized_clients_title' => 'Aplicaciones Autorizadas',
    'api_authorized_clients_none' => 'Todavía no hay clientes autorizados.',
    'api_authorized_clients_name' => 'Nombre',
    'api_authorized_clients_scopes' => 'Alcances',

    'personalization_tab_title' => 'Personaliza tu cuenta',

    'personalization_title' => 'Aquí encontrará diferentes ajustes para configurar su cuenta. Estas características están destinadas a “usuarios potenciales” que desean el máximo control sobre Mónica.',
    'personalization_contact_field_type_title' => 'Tipos de campos de contacto',
    'personalization_contact_field_type_add' => 'Añadir nuevo tipo de campo',
    'personalization_contact_field_type_description' => 'Puede configurar todos los diferentes tipos de campos de contacto que puede asociar a todos sus contactos. Por ejemplo, si aparece una nueva red social en el futuro, podrás añadir esta nueva forma de comunicarte con tus contactos aquí mismo.',
    'personalization_contact_field_type_table_name' => 'Nombre',
    'personalization_contact_field_type_table_protocol' => 'Protocolo',
    'personalization_contact_field_type_table_actions' => 'Acciones',
    'personalization_contact_field_type_modal_title' => 'Añadir un nuevo tipo de campo de contacto',
    'personalization_contact_field_type_modal_edit_title' => 'Editar un tipo de campo de contacto existente',
    'personalization_contact_field_type_modal_delete_title' => 'Eliminar un tipo de campo de contacto existente',
    'personalization_contact_field_type_modal_delete_description' => '¿Está seguro que desea eliminar este tipo de campo de contacto? Eliminar este tipo de campo de contacto eliminará TODOS los datos con este tipo para todos sus contactos.',
    'personalization_contact_field_type_modal_name' => 'Nombre',
    'personalization_contact_field_type_modal_protocol' => 'Protocolo (opcional)',
    'personalization_contact_field_type_modal_protocol_help' => 'Cada nuevo tipo de campo de contacto puede ser clicable. Si se establece un protocolo, lo usaremos para desencadenar la acción que se establece.',
    'personalization_contact_field_type_modal_icon' => 'Icono (Opcional)',
    'personalization_contact_field_type_modal_icon_help' => 'Puede asociar un icono con este tipo de campo de contacto. Necesita añadir una referencia a un icono de fuente impresionante.',
    'personalization_contact_field_type_delete_success' => 'El tipo de campo de contacto se ha eliminado correctamente.',
    'personalization_contact_field_type_add_success' => 'El tipo de campo de contacto se ha añadido correctamente.',
    'personalization_contact_field_type_edit_success' => 'El tipo de campo de contacto se ha actualizado correctamente.',

    'personalization_genders_title' => 'Tipos de género',
    'personalization_genders_add' => 'Añadir nuevo tipo de género',
    'personalization_genders_desc' => 'Puedes definir tantos géneros como necesites. Necesitas al menos un tipo de género en tu cuenta.',
    'personalization_genders_modal_add' => 'Añadir tipo de género',
    'personalization_genders_modal_edit' => 'Actualizar tipo de género',
    'personalization_genders_modal_name' => 'Nombre',
    'personalization_genders_modal_name_help' => 'El nombre utilizado para mostrar el género en una página de contacto.',
    'personalization_genders_modal_sex' => 'Sexo',
    'personalization_genders_modal_sex_help' => 'Utilizado para definir las relaciones, y durante el proceso de importación/exportación de VCard.',
    'personalization_genders_modal_default' => 'Seleccione el género por defecto para un nuevo contacto',
    'personalization_genders_modal_delete' => 'Eliminar tipo de género',
    'personalization_genders_modal_delete_desc' => '¿Está seguro de que desea eliminar el género “{name}”?',
    'personalization_genders_modal_delete_question' => 'Actualmente tienes {count} contacto con este género. Si eliminas este género, ¿qué género debe tener este contacto?|Actualmente tienes {count} contactos con este género. Si eliminas este género, ¿qué género deberían tener estos contactos?',
    'personalization_genders_modal_delete_question_default' => 'Este género es el predeterminado. Si eliminas este género, ¿cuál será el nuevo valor predeterminado?',
    'personalization_genders_modal_error' => 'Por favor, elija un género de la lista.',
    'personalization_genders_list_contact_number' => '{count} contacto|{count} contactos',
    'personalization_genders_table_name' => 'Nombre',
    'personalization_genders_table_sex' => 'Sexo',
    'personalization_genders_table_default' => 'Por defecto',
    'personalization_genders_default' => 'Género por defecto',
    'personalization_genders_make_default' => 'Cambiar género por defecto',
    'personalization_genders_select_default' => 'Seleccionar género por defecto',
    'personalization_genders_m' => 'Masculino',
    'personalization_genders_f' => 'Femenino',
    'personalization_genders_o' => 'Otro',
    'personalization_genders_u' => 'Desconocido',
    'personalization_genders_n' => 'Ninguno o no aplicable',

    'personalization_reminder_rule_save' => 'El cambio se ha guardado',
    'personalization_reminder_rule_title' => 'Reglas de recordatorio',
    'personalization_reminder_rule_line' => '{count} días antes|{count} días antes',
    'personalization_reminder_rule_desc' => 'Por cada recordatorio que haya establecido, Monica puede enviarle un correo electrónico varios días antes de que el evento suceda. Puedes ajustar estos ajustes de notificación aquí. Estas notificaciones solo se aplican a recordatorios mensuales y anuales.',

    'personalization_module_save' => 'El cambio se ha guardado',
    'personalization_module_title' => 'Características',
    'personalization_module_desc' => 'Puede que no necesite todas las características de Monica. Debajo puede cambiar características específicas que se utilizan en una hoja de contacto. Este cambio afectará a TODOS tus contactos. Desactivar una función no elimina ningún dato, simplemente oculta la función.',

    'personalisation_paid_upgrade' => 'Esta es una característica premium que requiere que esté activa una suscripción de pago. Actualice su cuenta visitando <a href=":url">Ajustes > Suscripción</a>.',
    'personalisation_paid_upgrade_vue' => 'Esta es una característica premium que requiere que esté activa una suscripción de pago. Actualice su cuenta visitando <a href="{url}">Ajustes > Suscripción</a>.',

    'reminder_time_to_send' => 'Hora del día a la que se enviarán los recordatorios',
    'reminder_time_to_send_help' => 'Su siguiente recordatorio está programado para ser enviado el <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Categorías de tipo de actividad',
    'personalization_activity_type_category_add' => 'Añadir una nueva categoría de tipo de actividad',
    'personalization_activity_type_category_table_name' => 'Nombre',
    'personalization_activity_type_category_description' => 'Una actividad con uno de tus contactos puede tener un tipo y un tipo de categoría. Su cuenta viene con un conjunto de tipos de categorías predefinidas por defecto, pero puede personalizar estos aquí.',
    'personalization_activity_type_category_table_actions' => 'Acciones',
    'personalization_activity_type_category_modal_add' => 'Añadir una nueva categoría de tipo de actividad',
    'personalization_activity_type_category_modal_edit' => 'Editar una categoría de tipo de actividad',
    'personalization_activity_type_category_modal_question' => '¿Qué debemos llamar a esta nueva categoría?',
    'personalization_activity_type_add_button' => 'Añadir un nuevo tipo de actividad',
    'personalization_activity_type_modal_add' => 'Añadir un nuevo tipo de actividad',
    'personalization_activity_type_modal_question' => '¿Qué debemos llamar a este nuevo tipo de actividad?',
    'personalization_activity_type_modal_edit' => 'Editar un tipo de actividad',
    'personalization_activity_type_category_modal_delete' => 'Eliminar una categoría de tipo de actividad',
    'personalization_activity_type_category_modal_delete_desc' => '¿Está seguro que desea eliminar esta categoría? Eliminarla eliminará todos los tipos de actividad asociados. Las actividades que pertenecen a esta categoría no se verán afectadas por esta eliminación.',
    'personalization_activity_type_modal_delete' => 'Eliminar un tipo de actividad',
    'personalization_activity_type_modal_delete_desc' => '¿Está seguro que desea eliminar este tipo de actividad? Las actividades que pertenecen a esta categoría no se verán afectadas por esta eliminación.',
    'personalization_activity_type_modal_delete_error' => 'No podemos encontrar este tipo de actividad.',
    'personalization_activity_type_category_modal_delete_error' => 'No podemos encontrar esta categoría de tipo de actividad.',

    'personalization_life_event_category_title' => 'Categorías de eventos vitales',
    'personalization_live_event_category_table_name' => 'Nombre',
    'personalization_life_event_category_description' => 'Un evento de vida puede tener un tipo y una categoría. Su cuenta viene con un conjunto de categorías y tipos predefinidos por defecto, pero puede personalizar los tipos de eventos de la vida aquí.',
    'personalization_live_event_category_table_actions' => 'Acciones',
    'personalization_life_event_type_add_button' => 'Añadir un nuevo tipo de evento de vida',
    'personalization_life_event_type_modal_add' => 'Añadir un nuevo tipo de evento de vida',
    'personalization_life_event_type_modal_question' => '¿Qué debemos llamar a este nuevo tipo de evento de vida?',
    'personalization_life_event_type_modal_edit' => 'Editar un tipo de evento de vida',
    'personalization_life_event_type_modal_delete' => 'Eliminar un tipo de evento de vida',
    'personalization_life_event_type_modal_delete_desc' => '¿Está seguro de que desea eliminar este tipo de evento vital? Los eventos de la vida que pertenecen a este tipo se eliminarán al realizar esta acción.',
    'personalization_life_event_type_modal_delete_error' => 'No podemos encontrar este tipo de evento de vida.',

    'personalization_life_event_category_work_education' => 'Trabajo y educación',
    'personalization_life_event_category_family_relationships' => 'Familia y relaciones',
    'personalization_life_event_category_home_living' => 'Hogar y estilo de vida',
    'personalization_life_event_category_travel_experiences' => 'Viajes y experiencias',
    'personalization_life_event_category_health_wellness' => 'Salud y bienestar',

    'personalization_life_event_type_new_job' => 'Nuevo trabajo',
    'personalization_life_event_type_retirement' => 'Jubilación',
    'personalization_life_event_type_new_school' => 'Nueva escuela',
    'personalization_life_event_type_study_abroad' => 'Estudiar en el extranjero',
    'personalization_life_event_type_volunteer_work' => 'Trabajo voluntario',
    'personalization_life_event_type_published_book_or_paper' => 'Publicó un libro o papel',
    'personalization_life_event_type_military_service' => 'Servicio militar',
    'personalization_life_event_type_first_met' => 'Primer encuentro',
    'personalization_life_event_type_new_relationship' => 'Nueva relación',
    'personalization_life_event_type_engagement' => 'Compromiso',
    'personalization_life_event_type_marriage' => 'Matrimonio',
    'personalization_life_event_type_anniversary' => 'Aniversario',
    'personalization_life_event_type_expecting_a_baby' => 'Esperando un bebé',
    'personalization_life_event_type_new_child' => 'Nuevo hijo',
    'personalization_life_event_type_new_family_member' => 'Nuevo miembro de la familia',
    'personalization_life_event_type_new_pet' => 'Nueva mascota',
    'personalization_life_event_type_end_of_relationship' => 'Fin de la relación',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Pérdida de un ser querido',
    'personalization_life_event_type_moved' => 'Mudanza',
    'personalization_life_event_type_bought_a_home' => 'Compró una casa',
    'personalization_life_event_type_home_improvement' => 'Mejoras en el hogar',
    'personalization_life_event_type_holidays' => 'Vacaciones',
    'personalization_life_event_type_new_vehicle' => 'Nuevo vehículo',
    'personalization_life_event_type_new_roommate' => 'Nuevo compañero de habitación',
    'personalization_life_event_type_overcame_an_illness' => 'Superó una enfermedad',
    'personalization_life_event_type_quit_a_habit' => 'Dejó un vicio',
    'personalization_life_event_type_new_eating_habits' => 'Nuevos hábitos alimenticios',
    'personalization_life_event_type_weight_loss' => 'Pérdida de peso',
    'personalization_life_event_type_wear_glass_or_contact' => 'Empezó a usar gafas o lentillas',
    'personalization_life_event_type_broken_bone' => 'Se rompió un hueso',
    'personalization_life_event_type_removed_braces' => 'Se quitó los brackets',
    'personalization_life_event_type_surgery' => 'Tuvo una operación',
    'personalization_life_event_type_dentist' => 'Tratamiento dental',
    'personalization_life_event_type_new_sport' => 'Comenzó a practicar un nuevo deporte',
    'personalization_life_event_type_new_hobby' => 'Comenzó un nuevo hobby',
    'personalization_life_event_type_new_instrument' => 'Comenzó a aprender un nuevo instrumento',
    'personalization_life_event_type_new_language' => 'Comenzó a aprender un nuevo idioma',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tatuaje o piercing',
    'personalization_life_event_type_new_license' => 'Nueva licencia',
    'personalization_life_event_type_travel' => 'Viaje',
    'personalization_life_event_type_achievement_or_award' => 'Logro o premio',
    'personalization_life_event_type_changed_beliefs' => 'Creencias cambiadas',
    'personalization_life_event_type_first_word' => 'Primera palabra',
    'personalization_life_event_type_first_kiss' => 'Primer beso',

    'storage_title' => 'Almacenamiento',
    'storage_account_info' => 'El límite de su cuenta es :accountLimit MB. Su uso actual es :currentAccountSize MB (alrededor de :percentUsage%).',
    'storage_upgrade_notice' => 'Actualiza tu cuenta para poder subir documentos y fotos.',
    'storage_description' => 'Aquí puedes ver todos los documentos y fotos subidos sobre tus contactos.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Aquí puede encontrar todos los ajustes para utilizar recursos WebDAV para las exportaciones de CardDAV y CalDAV.',
    'dav_copy_help' => 'Copiar al portapapeles',
    'dav_clipboard_copied' => 'Valor copiado al portapapeles',
    'dav_url_base' => 'Url base para todos los recursos CardDAV y CalDAV:',
    'dav_connect_help' => 'Puede conectar sus contactos y/o calendarios con esta url base en su teléfono u ordenador.',
    'dav_connect_help2' => 'Usa tu login (email) y crea un token API como la contraseña para autenticar.',
    'dav_url_carddav' => 'url de CardDAV para el recurso Contactos:',
    'dav_url_caldav_birthdays' => 'Url de CalDAV para recursos de cumpleaños:',
    'dav_url_caldav_tasks' => 'Url de CalDAV para los recursos de tareas:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Exportar todos los contactos en un archivo',
    'dav_caldav_birthdays_export' => 'Exportar todos los cumpleaños en un archivo',
    'dav_caldav_tasks_export' => 'Exportar todas las tareas en un archivo',

    'archive_title' => 'Archivar todos los contactos de tu cuenta',
    'archive_desc' => 'Esto archivará todos los contactos de su cuenta.',
    'archive_cta' => 'Archivar todos tus contactos',

    'logs_title' => 'Todo lo que ha pasado a esta cuenta',
    'logs_actor' => 'Actor',
    'logs_timestamp' => 'Fecha y Hora',
    'logs_description' => 'Descripción',
    'logs_subject' => 'Asunto',
    'logs_size' => 'Tamaño (kB)',
    'logs_object' => 'Objeto',
];
