/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.UnknownFormatException;
import liquibase.parser.SnapshotParser;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;

public class SnapshotParserFactory {
    private static SnapshotParserFactory instance;
    private List<SnapshotParser> parsers;
    private Comparator<SnapshotParser> snapshotParserComparator = new Comparator<SnapshotParser>(){

        @Override
        public int compare(SnapshotParser o1, SnapshotParser o2) {
            return Integer.valueOf(o2.getPriority()).compareTo(o1.getPriority());
        }
    };

    public static synchronized void reset() {
        instance = new SnapshotParserFactory();
    }

    public static synchronized SnapshotParserFactory getInstance() {
        if (instance == null) {
            instance = new SnapshotParserFactory();
        }
        return instance;
    }

    public static void setInstance(SnapshotParserFactory instance) {
        SnapshotParserFactory.instance = instance;
    }

    private SnapshotParserFactory() {
        this.parsers = new ArrayList<SnapshotParser>();
        try {
            Class<SnapshotParser>[] classes;
            for (Class<SnapshotParser> clazz : classes = ServiceLocator.getInstance().findClasses(SnapshotParser.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public List<SnapshotParser> getParsers() {
        return this.parsers;
    }

    public SnapshotParser getParser(String fileNameOrExtension, ResourceAccessor resourceAccessor) throws LiquibaseException {
        for (SnapshotParser parser : this.parsers) {
            if (!parser.supports(fileNameOrExtension, resourceAccessor)) continue;
            return parser;
        }
        throw new UnknownFormatException("Cannot find parser that supports " + fileNameOrExtension);
    }

    public void register(SnapshotParser snapshotParser) {
        this.parsers.add(snapshotParser);
        Collections.sort(this.parsers, this.snapshotParserComparator);
    }

    public void unregister(SnapshotParser snapshotParser) {
        this.parsers.remove(snapshotParser);
    }
}

