# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.orgs.projects.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Infra(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.infra'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _InfraStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            base_path=None,
            filter=None,
            type_filter=None,
            ):
        """
        Read infra. Returns only the infra related properties. Inner object are
        not populated.

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  base_path: :class:`str` or ``None``
        :param base_path: Base Path for retrieving hierarchical intent (optional)
        :type  filter: :class:`str` or ``None``
        :param filter: Filter string as java regex (optional)
        :type  type_filter: :class:`str` or ``None``
        :param type_filter: Filter string to retrieve hierarchy. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Infra`
        :return: com.vmware.nsx_policy.model.Infra
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'base_path': base_path,
                            'filter': filter,
                            'type_filter': type_filter,
                            })

    def patch(self,
              org_id,
              project_id,
              infra,
              enforce_revision_check=None,
              ):
        """
        Patch API at infra level can be used in two flavours 1. Like a regular
        API to update Infra object 2. Hierarchical API: To create/update/delete
        entire or part of intent hierarchy Hierarchical API: Provides users a
        way to create entire or part of intent in single API invocation. Input
        is expressed in a tree format. Each node in tree can have multiple
        children of different types. System will resolve the dependecies of
        nodes within the intent tree and will create the model. Children for
        any node can be specified using ChildResourceReference or
        ChildPolicyConfigResource. If a resource is specified using
        ChildResourceReference then it will not be updated only its children
        will be updated. If Object is specified using
        ChildPolicyConfigResource, object along with its children will be
        updated. Hierarchical API can also be used to delete any sub-branch of
        entire tree.

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  infra: :class:`com.vmware.nsx_policy.model_client.Infra`
        :param infra: (required)
        :type  enforce_revision_check: :class:`bool` or ``None``
        :param enforce_revision_check: Force revision check (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('patch',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'infra': infra,
                            'enforce_revision_check': enforce_revision_check,
                            })
class QuotaStats(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.quota_stats'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _QuotaStatsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            path_prefix,
            constraint_path=None,
            ):
        """
        Get quota details To create, update, list and delete the Quota, please
        refer to Constraint APIs with 'constraint_expressions' as
        'EntityInstanceCountConstraintExpression'.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  path_prefix: :class:`str`
        :param path_prefix: Path prefix for retriving the quota details. (required)
        :type  constraint_path: :class:`str` or ``None``
        :param constraint_path: Constraint path to retrive the quota details. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QuotaStatsListResult`
        :return: com.vmware.nsx_policy.model.QuotaStatsListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'path_prefix': path_prefix,
                            'constraint_path': constraint_path,
                            })
class SharedWithMe(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.shared_with_me'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SharedWithMeStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             org_id,
             project_id,
             resource_type=None,
             ):
        """
        Get the list of resource shared with a given project.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: resource type (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SharedResourceListResult`
        :return: com.vmware.nsx_policy.model.SharedResourceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'resource_type': resource_type,
                            })
class _InfraStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'base_path': type.OptionalType(type.StringType()),
            'filter': type.OptionalType(type.StringType()),
            'type_filter': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                       },
            query_parameters={
                'base_path': 'base_path',
                'filter': 'filter',
                'type_filter': 'type_filter',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'infra': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Infra'),
            'enforce_revision_check': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra',
            request_body_parameter='infra',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                     },
            query_parameters={
                'enforce_revision_check': 'enforce_revision_check',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Infra'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.infra',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _QuotaStatsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'path_prefix': type.StringType(),
            'constraint_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/quota-stats',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                     },
            query_parameters={
                'path_prefix': 'path_prefix',
                'constraint_path': 'constraint_path',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'QuotaStatsListResult'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.quota_stats',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _SharedWithMeStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'resource_type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/shared-with-me',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                   },
            query_parameters={
                'resource_type': 'resource_type',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'SharedResourceListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.shared_with_me',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Infra': Infra,
        'QuotaStats': QuotaStats,
        'SharedWithMe': SharedWithMe,
        'aaa': 'com.vmware.nsx_policy.orgs.projects.aaa_client.StubFactory',
        'infra': 'com.vmware.nsx_policy.orgs.projects.infra_client.StubFactory',
    }

