/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableexists;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableexists.Messages;
import org.pentaho.di.trans.steps.tableexists.TableExists;
import org.pentaho.di.trans.steps.tableexists.TableExistsData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableExistsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta database;
    private String tablenamefield;
    private String resultfieldname;
    private String schemaname;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getDynamicTablenameField() {
        return this.tablenamefield;
    }

    public void setDynamicTablenameField(String tablenamefield) {
        this.tablenamefield = tablenamefield;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        TableExistsMeta retval = (TableExistsMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.database = null;
        this.schemaname = null;
        this.resultfieldname = "result";
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!Const.isEmpty((String)this.resultfieldname)) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.resultfieldname), 4);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"tablenamefield", (String)this.tablenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.database = DatabaseMeta.findDatabase(databases, (String)con);
            this.tablenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"tablenamefield");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.schemaname = XMLHandler.getTagValue((Node)stepnode, (String)"schemaname");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("TableExistsMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.database = DatabaseMeta.findDatabase(databases, (long)id_connection);
            this.tablenamefield = rep.getStepAttributeString(id_step, "tablenamefield");
            this.schemaname = rep.getStepAttributeString(id_step, "schemaname");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("TableExistsMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.database == null ? -1.0 : (double)this.database.getID());
            rep.saveStepAttribute(id_transformation, id_step, "tablenamefield", this.tablenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "schemaname", this.schemaname);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getID());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("TableExistsMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (this.database == null) {
            error_message = Messages.getString("TableExistsMeta.CheckResult.InvalidConnection");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.resultfieldname)) {
            error_message = Messages.getString("TableExistsMeta.CheckResult.ResultFieldMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("TableExistsMeta.CheckResult.ResultFieldOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.tablenamefield)) {
            error_message = Messages.getString("TableExistsMeta.CheckResult.TableFieldMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("TableExistsMeta.CheckResult.TableFieldOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("TableExistsMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("TableExistsMeta.CheckResult.NoInpuReceived"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TableExists(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableExistsData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.database != null) {
            return new DatabaseMeta[]{this.database};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

