/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

final class RankedSequence<T>
extends AtomicReference<Content>
implements Iterable<T> {
    private static final long serialVersionUID = 1L;

    RankedSequence() {
    }

    RankedSequence(RankedSequence<T> sequence2) {
        if (sequence2 != null) {
            this.set((Content)sequence2.get());
        }
    }

    public void insert(T element2, int rank) {
        Content n;
        Content o;
        while (!this.compareAndSet(o, n = (o = (Content)this.get()) != null ? o.insert(element2, rank) : new Content(element2, rank))) {
        }
    }

    public T peek() {
        Content content2 = (Content)this.get();
        return (T)(content2 != null ? content2.objs[0] : null);
    }

    public boolean contains(Object element2) {
        Content content2 = (Content)this.get();
        return content2 != null && content2.indexOf(element2) >= 0;
    }

    public boolean containsThis(Object element2) {
        Content content2 = (Content)this.get();
        return content2 != null && content2.indexOfThis(element2) >= 0;
    }

    public T remove(Object element2) {
        int index2;
        Content n;
        Content o;
        do {
            if ((o = (Content)this.get()) != null && (index2 = o.indexOf(element2)) >= 0) continue;
            return null;
        } while (!this.compareAndSet(o, n = o.remove(index2)));
        return (T)o.objs[index2];
    }

    public boolean removeThis(T element2) {
        int index2;
        Content n;
        Content o;
        do {
            if ((o = (Content)this.get()) != null && (index2 = o.indexOfThis(element2)) >= 0) continue;
            return false;
        } while (!this.compareAndSet(o, n = o.remove(index2)));
        return true;
    }

    public Iterable<T> snapshot() {
        Content content2 = (Content)this.get();
        return content2 != null ? Arrays.asList(content2.objs) : Collections.EMPTY_SET;
    }

    public void clear() {
        this.set(null);
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    public int size() {
        Content content2 = (Content)this.get();
        return content2 != null ? content2.objs.length : 0;
    }

    public Itr iterator() {
        return new Itr();
    }

    static long rank2uid(int rank, int uniq) {
        return (long)(~rank) << 32 | 0xFFFFFFFFL & (long)uniq;
    }

    static int uid2rank(long uid) {
        return (int)((uid ^ 0xFFFFFFFFFFFFFFFFL) >>> 32);
    }

    static int safeBinarySearch(long[] uids, long uid) {
        if (uid < uids[0]) {
            return 0;
        }
        int min2 = 0;
        int max2 = uids.length - 1;
        while (min2 < max2) {
            int m = min2 + max2 >>> 1;
            if (uid <= uids[m]) {
                max2 = m;
                continue;
            }
            min2 = m + 1;
        }
        if (min2 == uids.length - 1 && uids[min2] < uid) {
            ++min2;
        }
        return min2;
    }

    static final class Content {
        final Object[] objs;
        final long[] uids;
        final int uniq;

        Content(Object element2, int rank) {
            this.objs = new Object[]{element2};
            this.uids = new long[]{RankedSequence.rank2uid(rank, 0)};
            this.uniq = 1;
        }

        Content(Object[] objs, long[] uids, int uniq) {
            this.objs = objs;
            this.uids = uids;
            this.uniq = uniq;
        }

        public int indexOf(Object element2) {
            if (element2 == null) {
                return this.indexOfThis(null);
            }
            int i = 0;
            while (i < this.objs.length) {
                if (element2.equals(this.objs[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int indexOfThis(Object element2) {
            int i = 0;
            while (i < this.objs.length) {
                if (element2 == this.objs[i]) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Content insert(Object element2, int rank) {
            int size = this.objs.length + 1;
            Object[] newObjs = new Object[size];
            long[] newUIDs = new long[size];
            long uid = RankedSequence.rank2uid(rank, this.uniq);
            int index2 = RankedSequence.safeBinarySearch(this.uids, uid);
            if (index2 > 0) {
                System.arraycopy(this.objs, 0, newObjs, 0, index2);
                System.arraycopy(this.uids, 0, newUIDs, 0, index2);
            }
            newObjs[index2] = element2;
            newUIDs[index2] = uid;
            int destPos = index2 + 1;
            int len = size - destPos;
            if (len > 0) {
                System.arraycopy(this.objs, index2, newObjs, destPos, len);
                System.arraycopy(this.uids, index2, newUIDs, destPos, len);
            }
            return new Content(newObjs, newUIDs, this.uniq + 1);
        }

        public Content remove(int index2) {
            if (this.objs.length == 1) {
                return null;
            }
            int size = this.objs.length - 1;
            Object[] newObjs = new Object[size];
            long[] newUIDs = new long[size];
            if (index2 > 0) {
                System.arraycopy(this.objs, 0, newObjs, 0, index2);
                System.arraycopy(this.uids, 0, newUIDs, 0, index2);
            }
            int srcPos = index2 + 1;
            int len = size - index2;
            if (len > 0) {
                System.arraycopy(this.objs, srcPos, newObjs, index2, len);
                System.arraycopy(this.uids, srcPos, newUIDs, index2, len);
            }
            return new Content(newObjs, newUIDs, this.uniq);
        }
    }

    final class Itr
    implements Iterator<T> {
        private Content content;
        private T nextObj;
        private long nextUID = Long.MIN_VALUE;
        private int index = -1;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextObj != null) {
                return true;
            }
            Content newContent = (Content)RankedSequence.this.get();
            if (this.content != newContent) {
                this.index = newContent != null ? RankedSequence.safeBinarySearch(newContent.uids, this.nextUID) : -1;
                this.content = newContent;
            }
            if (this.index >= 0 && this.index < this.content.objs.length) {
                this.nextObj = this.content.objs[this.index];
                this.nextUID = this.content.uids[this.index];
                return true;
            }
            return false;
        }

        public boolean hasNext(int rank) {
            if (this.nextObj != null) {
                return RankedSequence.uid2rank(this.nextUID) >= rank;
            }
            Content newContent = (Content)RankedSequence.this.get();
            if (this.content != newContent) {
                this.index = newContent != null ? RankedSequence.safeBinarySearch(newContent.uids, this.nextUID) : -1;
                this.content = newContent;
            }
            if (this.index >= 0 && this.index < this.content.uids.length) {
                return RankedSequence.uid2rank(this.content.uids[this.index]) >= rank;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                ++this.nextUID;
                ++this.index;
                Object element2 = this.nextObj;
                this.nextObj = null;
                return element2;
            }
            throw new NoSuchElementException();
        }

        public int rank() {
            return RankedSequence.uid2rank(this.nextUID);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

