/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.rtp.RtxPacket;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ModifierNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/RetransmissionSender;", "Lorg/jitsi/nlj/transform/node/ModifierNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "numRetransmissionsRequested", "", "numRetransmittedPlainPackets", "numRetransmittedRtxPackets", "origPtToRtxPayloadType", "", "Lorg/jitsi/nlj/format/RtxPayloadType;", "rtxStreamSeqNums", "", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "modify", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "retransmitPlain", "retransmitRtx", "rtxPt", "rtxSsrc", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class RetransmissionSender
extends ModifierNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Integer, RtxPayloadType> origPtToRtxPayloadType;
    @NotNull
    private final Map<Long, Integer> rtxStreamSeqNums;
    private int numRetransmissionsRequested;
    private int numRetransmittedRtxPackets;
    private int numRetransmittedPlainPackets;

    public RetransmissionSender(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("Retransmission sender");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.origPtToRtxPayloadType = new ConcurrentHashMap();
        this.rtxStreamSeqNums = new LinkedHashMap();
        this.streamInformationStore.onRtpPayloadTypesChanged((Function1<? super Map<Byte, ? extends PayloadType>, Unit>)new Function1<Map<Byte, ? extends PayloadType>, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull Map<Byte, ? extends PayloadType> currentRtpPayloadTypes) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter(currentRtpPayloadTypes, "currentRtpPayloadTypes");
                origPtToRtxPayloadType.clear();
                Iterable $this$filterIsInstance$iv = currentRtpPayloadTypes.values();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof RtxPayloadType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                RetransmissionSender retransmissionSender = this;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RtxPayloadType rtxPayloadType = (RtxPayloadType)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    retransmissionSender.origPtToRtxPayloadType.put(it.getAssociatedPayloadType(), it);
                    collection.add(Unit.INSTANCE);
                }
                List cfr_ignored_0 = (List)destination$iv$iv2;
            }
        });
    }

    @Override
    @NotNull
    protected PacketInfo modify(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        int n = this.numRetransmissionsRequested;
        this.numRetransmissionsRequested = n + 1;
        RtxPayloadType rtxPayloadType = this.origPtToRtxPayloadType.get(UnsignedKt.toPositiveInt(rtpPacket.getPayloadType()));
        if (rtxPayloadType == null) {
            return this.retransmitPlain(packetInfo);
        }
        RtxPayloadType rtxPt = rtxPayloadType;
        Long l = this.streamInformationStore.getRemoteSecondarySsrc(rtpPacket.getSsrc(), SsrcAssociationType.RTX);
        if (l == null) {
            return this.retransmitPlain(packetInfo);
        }
        long rtxSsrc = l;
        return this.retransmitRtx(packetInfo, UnsignedKt.toPositiveInt(rtxPt.getPt()), rtxSsrc);
    }

    private final PacketInfo retransmitRtx(PacketInfo packetInfo, int rtxPt, long rtxSsrc) {
        Integer n = this.rtxStreamSeqNums.merge(rtxSsrc, 1, Integer::sum);
        Intrinsics.checkNotNull(n);
        int rtxSeqNum = ((Number)n).intValue();
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug(this.hashCode() + " sending RTX packet with ssrc " + rtxSsrc + " with pt " + rtxPt + " and seqNum " + rtxSeqNum + " with original ssrc " + rtpPacket.getSsrc() + ", original sequence number " + rtpPacket.getSequenceNumber() + " and original payload type: " + rtpPacket.getPayloadType());
        }
        RtxPacket.Companion.addOriginalSequenceNumber(rtpPacket);
        rtpPacket.setSsrc(rtxSsrc);
        rtpPacket.setPayloadType(rtxPt);
        rtpPacket.setSequenceNumber(rtxSeqNum);
        packetInfo.resetPayloadVerification();
        int n2 = this.numRetransmittedRtxPackets;
        this.numRetransmittedRtxPackets = n2 + 1;
        return packetInfo;
    }

    private final PacketInfo retransmitPlain(PacketInfo packetInfo) {
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug(this.hashCode() + " plain retransmission packet with original ssrc " + rtpPacket.getSsrc() + ", original sequence number " + rtpPacket.getSequenceNumber() + " and original payload type: " + rtpPacket.getPayloadType());
        }
        int n = this.numRetransmittedPlainPackets;
        this.numRetransmittedPlainPackets = n + 1;
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d2 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d2.addNumber("num_retransmissions_requested", this.numRetransmissionsRequested);
        $this$getNodeStats_u24lambda_u2d2.addNumber("num_retransmissions_rtx_sent", this.numRetransmittedRtxPackets);
        $this$getNodeStats_u24lambda_u2d2.addNumber("num_retransmissions_plain_sent", this.numRetransmittedPlainPackets);
        $this$getNodeStats_u24lambda_u2d2.addString("rtx_payload_types(orig -> rtx)", this.origPtToRtxPayloadType.toString());
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

