/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class Socks5BytestreamManager
extends Manager
implements BytestreamManager {
    private static final String SESSION_ID_PREFIX = "js5_";
    private static final Map<XMPPConnection, Socks5BytestreamManager> managers;
    private final Map<Jid, BytestreamListener> userListeners = new ConcurrentHashMap<Jid, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private int targetResponseTimeout = 10000;
    private int proxyConnectionTimeout = 10000;
    private final Set<Jid> proxyBlacklist = Collections.synchronizedSet(new HashSet());
    private Jid lastWorkingProxy;
    private boolean proxyPrioritizationEnabled = true;
    private boolean annouceLocalStreamHost = true;
    private final List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized Socks5BytestreamManager getBytestreamManager(XMPPConnection connection) {
        if (connection == null) {
            return null;
        }
        Socks5BytestreamManager manager = managers.get(connection);
        if (manager == null) {
            manager = new Socks5BytestreamManager(connection);
            managers.put(connection, manager);
        }
        return manager;
    }

    private Socks5BytestreamManager(XMPPConnection connection) {
        super(connection);
        this.initiationListener = new InitiationListener(this);
        this.activate();
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.add(listener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.remove(listener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener, Jid initiatorJID) {
        this.userListeners.put(initiatorJID, listener);
    }

    @Override
    public void removeIncomingBytestreamListener(Jid initiatorJID) {
        this.userListeners.remove(initiatorJID);
    }

    public void ignoreBytestreamRequestOnce(String sessionID) {
        this.ignoredBytestreamRequests.add(sessionID);
    }

    public synchronized void disableService() {
        ServiceDiscoveryManager serviceDiscoveryManager;
        XMPPConnection connection = this.connection();
        connection.unregisterIQRequestHandler(this.initiationListener);
        this.initiationListener.shutdown();
        this.allRequestListeners.clear();
        this.userListeners.clear();
        this.lastWorkingProxy = null;
        this.proxyBlacklist.clear();
        this.ignoredBytestreamRequests.clear();
        managers.remove(connection);
        if (managers.size() == 0) {
            Socks5Proxy.getSocks5Proxy().stop();
        }
        if ((serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection)) != null) {
            serviceDiscoveryManager.removeFeature("http://jabber.org/protocol/bytestreams");
        }
    }

    public int getTargetResponseTimeout() {
        if (this.targetResponseTimeout <= 0) {
            this.targetResponseTimeout = 10000;
        }
        return this.targetResponseTimeout;
    }

    public void setTargetResponseTimeout(int targetResponseTimeout) {
        this.targetResponseTimeout = targetResponseTimeout;
    }

    public int getProxyConnectionTimeout() {
        if (this.proxyConnectionTimeout <= 0) {
            this.proxyConnectionTimeout = 10000;
        }
        return this.proxyConnectionTimeout;
    }

    public void setProxyConnectionTimeout(int proxyConnectionTimeout) {
        this.proxyConnectionTimeout = proxyConnectionTimeout;
    }

    public boolean isProxyPrioritizationEnabled() {
        return this.proxyPrioritizationEnabled;
    }

    public void setProxyPrioritizationEnabled(boolean proxyPrioritizationEnabled) {
        this.proxyPrioritizationEnabled = proxyPrioritizationEnabled;
    }

    public boolean isAnnouncingLocalStreamHostEnabled() {
        return this.annouceLocalStreamHost;
    }

    public void setAnnounceLocalStreamHost(boolean announceLocalStreamHost) {
        this.annouceLocalStreamHost = announceLocalStreamHost;
    }

    @Override
    public Socks5BytestreamSession establishSession(Jid targetJID) throws XMPPException, IOException, InterruptedException, SmackException {
        String sessionID = Socks5BytestreamManager.getNextSessionID();
        return this.establishSession(targetJID, sessionID);
    }

    @Override
    public Socks5BytestreamSession establishSession(Jid targetJID, String sessionID) throws IOException, InterruptedException, XMPPException, SmackException.NoResponseException, SmackException.NotConnectedException, SmackException.SmackMessageException, SmackException.FeatureNotSupportedException {
        XMPPConnection connection = this.connection();
        XMPPException.XMPPErrorException discoveryException = null;
        if (!this.supportsSocks5(targetJID)) {
            throw new SmackException.FeatureNotSupportedException("SOCKS5 Bytestream", targetJID);
        }
        ArrayList<Jid> proxies = new ArrayList<Jid>();
        try {
            proxies.addAll(this.determineProxies());
        }
        catch (XMPPException.XMPPErrorException e) {
            discoveryException = e;
        }
        List<Bytestream.StreamHost> streamHosts = this.determineStreamHostInfos(proxies);
        if (streamHosts.isEmpty()) {
            if (discoveryException != null) {
                throw discoveryException;
            }
            throw new SmackException.SmackMessageException("no SOCKS5 proxies available");
        }
        String digest = Socks5Utils.createDigest(sessionID, connection.getUser(), targetJID);
        if (this.proxyPrioritizationEnabled && this.lastWorkingProxy != null) {
            Bytestream.StreamHost selectedStreamHost = null;
            for (Bytestream.StreamHost streamHost : streamHosts) {
                if (!streamHost.getJID().equals(this.lastWorkingProxy)) continue;
                selectedStreamHost = streamHost;
                break;
            }
            if (selectedStreamHost != null) {
                streamHosts.remove(selectedStreamHost);
                streamHosts.add(0, selectedStreamHost);
            }
        }
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        try {
            socks5Proxy.addTransfer(digest);
            Bytestream initiation = Socks5BytestreamManager.createBytestreamInitiation(sessionID, targetJID, streamHosts);
            Object response2 = connection.createStanzaCollectorAndSend(initiation).nextResultOrThrow(this.getTargetResponseTimeout());
            Bytestream.StreamHostUsed streamHostUsed = ((Bytestream)response2).getUsedHost();
            Bytestream.StreamHost usedStreamHost = initiation.getStreamHost(streamHostUsed.getJID());
            if (usedStreamHost == null) {
                throw new SmackException.SmackMessageException("Remote user responded with unknown host");
            }
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(usedStreamHost, digest, connection, sessionID, targetJID);
            Socket socket = ((Socks5Client)socks5Client).getSocket(this.getProxyConnectionTimeout());
            this.lastWorkingProxy = usedStreamHost.getJID();
            Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(socket, usedStreamHost.getJID().equals(connection.getUser()));
            return socks5BytestreamSession;
        }
        catch (TimeoutException e) {
            throw new IOException("Timeout while connecting to SOCKS5 proxy", e);
        }
        finally {
            socks5Proxy.removeTransfer(digest);
        }
    }

    private boolean supportsSocks5(Jid targetJID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(targetJID, "http://jabber.org/protocol/bytestreams");
    }

    public List<Jid> determineProxies() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<Jid> proxies = new ArrayList<Jid>();
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(connection.getXMPPServiceDomain());
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            DiscoverInfo proxyInfo;
            if (this.proxyBlacklist.contains(item.getEntityID())) continue;
            try {
                proxyInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                this.proxyBlacklist.add(item.getEntityID());
                continue;
            }
            if (proxyInfo.hasIdentity("proxy", "bytestreams")) {
                proxies.add(item.getEntityID());
                continue;
            }
            this.proxyBlacklist.add(item.getEntityID());
        }
        return proxies;
    }

    private List<Bytestream.StreamHost> determineStreamHostInfos(List<Jid> proxies) {
        XMPPConnection connection = this.connection();
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        if (this.annouceLocalStreamHost) {
            List<Bytestream.StreamHost> localProxies = this.getLocalStreamHost();
            streamHosts.addAll(localProxies);
        }
        for (Jid proxy : proxies) {
            Bytestream streamHostRequest = Socks5BytestreamManager.createStreamHostRequest(proxy);
            try {
                Bytestream response2 = (Bytestream)connection.createStanzaCollectorAndSend(streamHostRequest).nextResultOrThrow();
                streamHosts.addAll(response2.getStreamHosts());
            }
            catch (Exception e) {
                this.proxyBlacklist.add(proxy);
            }
        }
        return streamHosts;
    }

    private static Bytestream createStreamHostRequest(Jid proxy) {
        Bytestream request = new Bytestream();
        request.setType(IQ.Type.get);
        request.setTo(proxy);
        return request;
    }

    public List<Bytestream.StreamHost> getLocalStreamHost() {
        Socks5Proxy.getSocks5Proxy();
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        XMPPConnection connection = this.connection();
        EntityFullJid myJid = connection.getUser();
        for (Socks5Proxy socks5Server : Socks5Proxy.getRunningProxies()) {
            List<InetAddress> addresses = socks5Server.getLocalAddresses();
            if (addresses.isEmpty()) continue;
            int port2 = socks5Server.getPort();
            for (InetAddress address : addresses) {
                if (address.isLoopbackAddress()) continue;
                streamHosts.add(new Bytestream.StreamHost((Jid)myJid, address, port2));
            }
        }
        return streamHosts;
    }

    private static Bytestream createBytestreamInitiation(String sessionID, Jid targetJID, List<Bytestream.StreamHost> streamHosts) {
        Bytestream initiation = new Bytestream(sessionID);
        for (Bytestream.StreamHost streamHost : streamHosts) {
            initiation.addStreamHost(streamHost);
        }
        initiation.setType(IQ.Type.set);
        initiation.setTo(targetJID);
        return initiation;
    }

    protected void replyRejectPacket(IQ packet) throws SmackException.NotConnectedException, InterruptedException {
        StanzaError xmppError = StanzaError.getBuilder(StanzaError.Condition.not_acceptable).build();
        ErrorIQ errorIQ = IQ.createErrorResponse(packet, xmppError);
        this.connection().sendStanza(errorIQ);
    }

    private void activate() {
        this.connection().registerIQRequestHandler(this.initiationListener);
        this.enableService();
    }

    private void enableService() {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        manager.addFeature("http://jabber.org/protocol/bytestreams");
    }

    private static String getNextSessionID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SESSION_ID_PREFIX);
        buffer.append(StringUtils.secureOnlineAttackSafeRandomString());
        return buffer.toString();
    }

    protected XMPPConnection getConnection() {
        return this.connection();
    }

    protected BytestreamListener getUserListener(Jid initiator) {
        return this.userListeners.get(initiator);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                Socks5BytestreamManager.getBytestreamManager(connection);
            }
        });
        managers = new WeakHashMap<XMPPConnection, Socks5BytestreamManager>();
    }
}

