/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer;

import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;

public final class AnnotationUtil {
    public static final String ANY = "jakarta.enterprise.inject.Any";
    public static final String VALUE = "value";
    public static final String INJECT = "Inject";
    public static final String INJECT_FQN = "jakarta.inject.Inject";
    public static final String DECORATOR = "jakarta.decorator.Decorator";
    public static final String PRODUCES = "Produces";
    public static final String PRODUCES_FQN = "jakarta.enterprise.inject.Produces";
    public static final String INTERCEPTOR_BINDING = "InterceptorBinding";
    public static final String INTERCEPTOR_BINDING_FQN = "jakarta.interceptor.InterceptorBinding";
    public static final String INTERCEPTOR = "jakarta.interceptor.Interceptor";
    public static final String NORMAL_SCOPE = "NormalScope";
    public static final String NORMAL_SCOPE_FQN = "jakarta.enterprise.context.NormalScope";
    public static final String SCOPE = "Scope";
    public static final String SCOPE_FQN = "jakarta.inject.Scope";
    public static final String REQUEST_SCOPE_FQN = "jakarta.enterprise.context.RequestScoped";
    public static final String SESSION_SCOPE_FQN = "jakarta.enterprise.context.SessionScoped";
    public static final String APPLICATION_SCOPE_FQN = "jakarta.enterprise.context.ApplicationScoped";
    public static final String CONVERSATION_SCOPE_FQN = "jakarta.enterprise.context.ConversationScoped";
    public static final String DEPENDENT_SCOPE_FQN = "jakarta.enterprise.context.Dependent";
    public static final String DISPOSES = "Disposes";
    public static final String DISPOSES_FQN = "jakarta.enterprise.inject.Disposes";
    public static final String OBSERVES = "Observes";
    public static final String OBSERVES_FQN = "jakarta.enterprise.event.Observes";
    public static final String STATELESS = "jakarta.ejb.Stateless";
    public static final String STATEFUL = "jakarta.ejb.Stateful";
    public static final String SINGLETON = "jakarta.ejb.Singleton";
    public static final String CDISINGLETON = "jakarta.inject.Singleton";
    public static final String APPLICATION_SCOPED = "jakarta.enterprise.context.ApplicationScoped";
    public static final String DEPENDENT = "jakarta.enterprise.context.Dependent";
    public static final String STEREOTYPE = "Stereotype";
    public static final String STEREOTYPE_FQN = "jakarta.enterprise.inject.Stereotype";
    public static final String NAMED = "jakarta.inject.Named";
    public static final String QUALIFIER = "Qualifier";
    public static final String QUALIFIER_FQN = "jakarta.inject.Qualifier";
    public static final String DELEGATE_FQN = "jakarta.decorator.Delegate";
    public static final String SPECIALIZES = "jakarta.enterprise.inject.Specializes";
    public static final String INJECTION_POINT = "jakarta.enterprise.inject.spi.InjectionPoint";
    public static final String DEFAULT_FQN = "jakarta.enterprise.inject.Default";
    public static final String POST_CONSTRUCT = "jakarta.annotation.PostConstruct";
    public static final String PRE_DESTROY = "jakarta.annotation.PreDestroy";
    public static final String POST_ACTIVATE = "jakarta.ejb.PostActivate";
    public static final String PRE_PASSIVATE = "jakarta.ejb.PrePassivate";
    public static final String CONTEXT = "jakarta.enterprise.context.spi.Context";
    public static final String CONVERSATION = "jakarta.enterprise.context.Conversation";
    public static final String ALTERNATVE = "jakarta.enterprise.inject.Alternative";
    public static final String TYPED = "jakarta.enterprise.inject.Typed";
    public static final String NON_BINDING = "jakarta.enterprise.util.Nonbinding";
    public static final String PASSIVATING = "passivating";
    public static final String PROVIDER = "jakarta.inject.Provider";

    private AnnotationUtil() {
    }

    public static boolean hasAnnotation(Element element, String annotation, CompilationInfo info) {
        return AnnotationUtil.getAnnotationMirror(element, annotation, info) != null;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String annotation, CompilationInfo info) {
        return AnnotationUtil.getAnnotationMirror(element, info, annotation);
    }

    /*
     * WARNING - void declaration
     */
    public static AnnotationMirror getAnnotationMirror(Element element, CompilationInfo info, String ... annotationFqns) {
        void var7_9;
        HashSet<TypeElement> set = new HashSet<TypeElement>();
        Elements els = info.getElements();
        String[] stringArray = annotationFqns;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String annotation = stringArray[var7_9];
            TypeElement annotationElement = els.getTypeElement(annotation);
            if (annotationElement != null) {
                set.add(annotationElement);
            }
            ++var7_9;
        }
        List<? extends AnnotationMirror> annotations = els.getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotations) {
            Element declaredAnnotation = info.getTypes().asElement(annotationMirror.getAnnotationType());
            if (!set.contains(declaredAnnotation)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isSessionBean(Element element, CompilationInfo compInfo) {
        return AnnotationUtil.getAnnotationMirror(element, compInfo, STATEFUL, STATELESS, SINGLETON) != null;
    }

    public static boolean isDelegate(Element element, TypeElement parent, WebBeansModel model) {
        return AnnotationUtil.hasAnnotation(element, DELEGATE_FQN, (CompilationInfo)model.getCompilationController()) && AnnotationUtil.hasAnnotation(parent, DECORATOR, (CompilationInfo)model.getCompilationController());
    }

    public static boolean isLifecycleCallback(ExecutableElement element, CompilationInfo info) {
        AnnotationMirror annotationMirror = AnnotationUtil.getAnnotationMirror((Element)element, info, POST_ACTIVATE, POST_CONSTRUCT, PRE_DESTROY, PRE_PASSIVATE);
        return annotationMirror != null;
    }
}

