/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.method;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiEditorAnalysisFactory;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AbstractDecoratorAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.MethodModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.field.InjectionPointAnalyzer;
import org.netbeans.modules.jakarta.web.beans.api.model.CdiException;
import org.netbeans.modules.jakarta.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.jakarta.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.hints.EditorAnnotationsHelper;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class InjectionPointParameterAnalyzer
extends AbstractDecoratorAnalyzer<ExecutableElement>
implements MethodModelAnalyzer.MethodAnalyzer {
    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        for (VariableElement variableElement : element.getParameters()) {
            if (cancel.get()) {
                return;
            }
            try {
                if (!model.isInjectionPoint(variableElement)) continue;
                boolean isDelegate = false;
                result.requireCdiEnabled(element, model);
                if (cancel.get()) {
                    return;
                }
                if (!model.isDynamicInjectionPoint(variableElement)) {
                    isDelegate = AnnotationUtil.isDelegate(variableElement, parent, model);
                    if (!this.checkBuiltInBeans(variableElement, this.getParameterType(variableElement, element, parent, model.getCompilationController()), model, cancel)) {
                        DependencyInjectionResult res = model.lookupInjectables(variableElement, (DeclaredType)parent.asType(), cancel);
                        this.checkResult(res, element, variableElement, model, result);
                        if (isDelegate) {
                            this.analyzeDecoratedBeans(res, variableElement, element, parent, model, result);
                        }
                    }
                }
                if (cancel.get()) {
                    return;
                }
                this.checkName(element, variableElement, model, result);
                if (cancel.get()) {
                    return;
                }
                this.checkInjectionPointMetadata(variableElement, element, parent, model, cancel, result);
                if (isDelegate || AnnotationUtil.hasAnnotation(element, "jakarta.decorator.Delegate", (CompilationInfo)model.getCompilationController())) {
                    return;
                }
                VariableElement param = CdiEditorAnalysisFactory.resolveParameter(variableElement, element, result.getInfo());
                EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(result);
                if (helper == null) continue;
                helper.addInjectionPoint(result, param);
            }
            catch (InjectionPointDefinitionError e) {
                result.requireCdiEnabled(element, model);
                this.informInjectionPointDefError(e, element, model, result);
            }
        }
    }

    @Override
    protected void addClassError(VariableElement element, ExecutableElement method, TypeElement decoratedBean, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError(element, method, model, NbBundle.getMessage(InjectionPointParameterAnalyzer.class, (String)"ERR_FinalDecoratedBean", (Object)decoratedBean.getQualifiedName().toString()));
    }

    @Override
    protected void addMethodError(VariableElement element, ExecutableElement method, TypeElement decoratedBean, Element decoratedMethod, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError(element, method, model, NbBundle.getMessage(InjectionPointParameterAnalyzer.class, (String)"ERR_FinalMethodDecoratedBean", (Object)decoratedBean.getQualifiedName().toString(), (Object)decoratedMethod.getSimpleName().toString()));
    }

    private TypeMirror getParameterType(VariableElement var, ExecutableElement element, TypeElement parent, CompilationController controller) {
        ExecutableType method = (ExecutableType)controller.getTypes().asMemberOf((DeclaredType)parent.asType(), element);
        List<? extends TypeMirror> parameterTypes = method.getParameterTypes();
        List<? extends VariableElement> parameters = element.getParameters();
        int paramIndex = parameters.indexOf(var);
        return parameterTypes.get(paramIndex);
    }

    private void checkInjectionPointMetadata(VariableElement var, ExecutableElement method, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        TypeElement injectionPointType = model.getCompilationController().getElements().getTypeElement("jakarta.enterprise.inject.spi.InjectionPoint");
        if (injectionPointType == null) {
            return;
        }
        Element varElement = model.getCompilationController().getTypes().asElement(var.asType());
        if (!injectionPointType.equals(varElement)) {
            return;
        }
        if (cancel.get()) {
            return;
        }
        List<AnnotationMirror> qualifiers = model.getQualifiers(varElement, true);
        AnnotationHelper helper = new AnnotationHelper((CompilationInfo)model.getCompilationController());
        Map qualifiersFqns = helper.getAnnotationsByType(qualifiers);
        boolean hasDefault = model.hasImplicitDefaultQualifier(varElement);
        if (!hasDefault && qualifiersFqns.containsKey("jakarta.enterprise.inject.Default")) {
            hasDefault = true;
        }
        if (!hasDefault || cancel.get()) {
            return;
        }
        try {
            String scope = model.getScope(parent);
            if (scope != null && !"jakarta.enterprise.context.Dependent".equals(scope)) {
                result.addError(var, method, model, NbBundle.getMessage(InjectionPointParameterAnalyzer.class, (String)"ERR_WrongQualifierInjectionPointMeta"));
            }
        }
        catch (CdiException e) {
            return;
        }
    }

    private void checkName(ExecutableElement element, VariableElement var, WebBeansModel model, ModelAnalyzer.Result result) {
        AnnotationMirror annotation = AnnotationUtil.getAnnotationMirror((Element)var, "jakarta.inject.Named", (CompilationInfo)model.getCompilationController());
        if (annotation != null) {
            result.addNotification(Severity.WARNING, var, element, model, NbBundle.getMessage(InjectionPointAnalyzer.class, (String)"WARN_NamedInjectionPoint"));
            if (annotation.getElementValues().size() == 0) {
                result.addError(var, element, model, NbBundle.getMessage(InjectionPointParameterAnalyzer.class, (String)"ERR_ParameterNamedInjectionPoint"));
            }
        }
    }

    private void checkResult(DependencyInjectionResult res, ExecutableElement method, VariableElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        if (res instanceof DependencyInjectionResult.Error) {
            DependencyInjectionResult.ResultKind kind = res.getKind();
            Severity severity = Severity.WARNING;
            if (kind == DependencyInjectionResult.ResultKind.DEFINITION_ERROR) {
                severity = Severity.ERROR;
            }
            String message = ((DependencyInjectionResult.Error)res).getMessage();
            result.addNotification(severity, element, method, model, message);
        }
    }

    private void informInjectionPointDefError(InjectionPointDefinitionError exception, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError(element, model, exception.getMessage());
    }
}

