/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.TextItemEditorModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.EntityOverviewForm;
import org.netbeans.modules.xml.multiview.ItemCheckBoxHelper;
import org.netbeans.modules.xml.multiview.ItemComboBoxHelper;
import org.netbeans.modules.xml.multiview.ItemEditorHelper;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;

public class EntityOverviewPanel
extends EntityOverviewForm {
    private XmlMultiViewDataSynchronizer synchronizer;
    private Entity entity;
    private static final String PK_COMPOUND = Utils.getBundleMessage("LBL_Compound_PK");
    private EntityHelper entityHelper;

    public EntityOverviewPanel(SectionNodeView sectionNodeView, final Entity entity, final EntityHelper entityHelper) {
        super(sectionNodeView);
        this.entityHelper = entityHelper;
        this.synchronizer = ((EjbJarMultiViewDataObject)sectionNodeView.getDataObject()).getModelSynchronizer();
        JTextField ejbNameTextField = this.getEjbNameTextField();
        JTextField persistenceTypeTextField = this.getPersistenceTypeTextField();
        JTextField abstractSchemaNameTextField = this.getAbstractSchemaNameTextField();
        JLabel primaryKeyFieldLabel = this.getPrimaryKeyFieldLabel();
        final JComboBox primaryKeyFieldComboBox = this.getPrimaryKeyFieldComboBox();
        final JComboBox primaryKeyClassComboBox = this.getPrimaryKeyClassComboBox();
        JTextField primaryKeyClassTextField = this.getPrimaryKeyClassTextField();
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)ejbNameTextField, (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this.synchronizer, false){

            @Override
            protected String getValue() {
                return entity.getEjbName();
            }

            @Override
            protected void setValue(String value) {
                entity.setEjbName(value);
            }
        }));
        ejbNameTextField.setEditable(false);
        persistenceTypeTextField.setEditable(false);
        this.entity = entity;
        String persistenceType = this.entity.getPersistenceType();
        boolean isCmp = "Container".equals(persistenceType);
        persistenceTypeTextField.setText(persistenceType + (isCmp ? " (CMP)" : " (BMP)"));
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)abstractSchemaNameTextField, (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this.synchronizer, true){

            @Override
            protected String getValue() {
                return entity.getAbstractSchemaName();
            }

            @Override
            protected void setValue(String value) {
                entity.setAbstractSchemaName(value);
            }
        }));
        abstractSchemaNameTextField.setEditable(false);
        if (isCmp) {
            primaryKeyFieldLabel.setVisible(true);
            primaryKeyFieldComboBox.setVisible(true);
            primaryKeyClassComboBox.setVisible(true);
            primaryKeyClassTextField.setVisible(false);
            this.initPrimaryKeyFieldComboBox();
            final ItemComboBoxHelper primaryKeyComboBoxHelper = new ItemComboBoxHelper(this.synchronizer, primaryKeyFieldComboBox){

                public String getItemValue() {
                    String value = entity.getPrimkeyField();
                    return value == null ? PK_COMPOUND : value;
                }

                public void setItemValue(String value) {
                    try {
                        entityHelper.setPrimkeyField(value == PK_COMPOUND ? null : value);
                    }
                    catch (ClassNotFoundException e) {
                        Utils.notifyError(e);
                    }
                }
            };
            this.addRefreshable((Refreshable)primaryKeyComboBoxHelper);
            primaryKeyFieldComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = primaryKeyFieldComboBox.getSelectedIndex();
                    if (selectedIndex == 0) {
                        primaryKeyClassComboBox.setEnabled(true);
                        primaryKeyClassComboBox.setSelectedItem(entity.getPrimKeyClass());
                    } else {
                        primaryKeyClassComboBox.setEnabled(false);
                    }
                    primaryKeyClassComboBox.setSelectedItem(entity.getPrimKeyClass());
                }
            });
            primaryKeyClassComboBox.setEnabled(primaryKeyFieldComboBox.getSelectedIndex() == 0);
            primaryKeyClassComboBox.addItem("boolean");
            primaryKeyClassComboBox.addItem("byte");
            primaryKeyClassComboBox.addItem("char");
            primaryKeyClassComboBox.addItem("double");
            primaryKeyClassComboBox.addItem("float");
            primaryKeyClassComboBox.addItem("int");
            primaryKeyClassComboBox.addItem("long");
            primaryKeyClassComboBox.addItem("java.lang.Boolean");
            primaryKeyClassComboBox.addItem("java.lang.Byte");
            primaryKeyClassComboBox.addItem("java.lang.Character");
            primaryKeyClassComboBox.addItem("java.lang.Double");
            primaryKeyClassComboBox.addItem("java.lang.Float");
            primaryKeyClassComboBox.addItem("java.lang.Integer");
            primaryKeyClassComboBox.addItem("java.lang.Long");
            primaryKeyClassComboBox.addItem("java.lang.Object");
            primaryKeyClassComboBox.addItem("java.lang.String");
            primaryKeyClassComboBox.addItem("java.math.BigDecimal");
            this.addRefreshable((Refreshable)new ItemComboBoxHelper(this.synchronizer, primaryKeyClassComboBox){

                public String getItemValue() {
                    return entity.getPrimKeyClass();
                }

                public void setItemValue(String value) {
                    if (!Utils.isValidPackageName(value)) {
                        primaryKeyComboBoxHelper.refresh();
                    }
                }
            });
        } else {
            primaryKeyFieldLabel.setVisible(false);
            primaryKeyFieldComboBox.setVisible(false);
            primaryKeyClassComboBox.setVisible(false);
            primaryKeyClassTextField.setVisible(true);
            this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)primaryKeyClassTextField, (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this.synchronizer, false){

                @Override
                protected String getValue() {
                    return entity.getPrimKeyClass();
                }

                @Override
                protected void setValue(String value) {
                    entity.setPrimKeyClass(value);
                }
            }));
        }
        this.addRefreshable((Refreshable)new ItemCheckBoxHelper(this.synchronizer, this.getReentrantCheckBox()){

            public boolean getItemValue() {
                return entity.isReentrant();
            }

            public void setItemValue(boolean value) {
                entity.setReentrant(value);
            }
        });
    }

    private void initPrimaryKeyFieldComboBox() {
        JComboBox primaryKeyFieldComboBox = this.getPrimaryKeyFieldComboBox();
        CmpField[] cmpFields = this.entityHelper.cmpFields.getCmpFields();
        String[] items = new String[cmpFields.length + 1];
        items[0] = PK_COMPOUND;
        for (int i = 0; i < cmpFields.length; ++i) {
            items[i + 1] = cmpFields[i].getFieldName();
        }
        primaryKeyFieldComboBox.setModel(new DefaultComboBoxModel<String>(items));
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        super.dataModelPropertyChange(source, propertyName, oldValue, newValue);
    }

    public void refreshView() {
        this.initPrimaryKeyFieldComboBox();
        super.refreshView();
        this.getReentrantCheckBox().setSelected(this.entity.isReentrant());
    }
}

