/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.websvc.saas.model.CustomSaas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.ui.nodes.CustomSaasNode;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasGroupNode;
import org.netbeans.modules.websvc.saas.ui.nodes.WadlSaasNode;
import org.netbeans.modules.websvc.saas.ui.nodes.WsdlSaasNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class SaasGroupNodeChildren
extends Children.Keys<Object>
implements PropertyChangeListener {
    private SaasGroup group;

    public SaasGroupNodeChildren(SaasGroup group) {
        this.group = group;
        SaasServicesModel model = SaasServicesModel.getInstance();
        model.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)model));
    }

    protected void setGroup(SaasGroup g) {
        this.group = g;
    }

    protected void addNotify() {
        this.updateKeys();
        super.addNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.group) {
            this.updateKeys();
            if (evt.getNewValue() != null) {
                this.refreshKey(evt.getNewValue());
            } else if (evt.getOldValue() != null) {
                this.refreshKey(evt.getOldValue());
            }
        }
    }

    protected void updateKeys() {
        ArrayList keys = new ArrayList();
        List groups = this.group.getChildrenGroups();
        Collections.sort(groups);
        keys.addAll(groups);
        List services = this.group.getServices();
        Collections.sort(services);
        keys.addAll(services);
        this.setKeys(keys);
    }

    protected void removeNotify() {
        List emptyList = Collections.emptyList();
        this.setKeys(emptyList);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof SaasGroup) {
            SaasGroup g = (SaasGroup)key;
            SaasGroupNode node = new SaasGroupNode(g);
            return new Node[]{node};
        }
        if (key instanceof WadlSaas) {
            return new Node[]{new WadlSaasNode((WadlSaas)key)};
        }
        if (key instanceof WsdlSaas) {
            return new Node[]{new WsdlSaasNode((WsdlSaas)key)};
        }
        if (key instanceof CustomSaas) {
            return new Node[]{new CustomSaasNode((CustomSaas)key)};
        }
        return new Node[0];
    }
}

