/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver.preferences;

import java.io.File;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.jstestdriver.preferences.Bundle;
import org.netbeans.modules.javascript.jstestdriver.preferences.JsTestDriverPreferences;
import org.netbeans.modules.web.common.api.ValidationResult;

public final class JsTestDriverPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public JsTestDriverPreferencesValidator validate(Project project) {
        this.validateConfig(JsTestDriverPreferences.getConfig(project));
        return this;
    }

    public JsTestDriverPreferencesValidator validateConfig(String config) {
        String warning = this.validateFile(Bundle.JsTestDriverPreferencesValidator_config_name(), config, false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"config", warning));
        }
        return this;
    }

    @CheckForNull
    private String validateFile(String source, String filePath, boolean writable) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return Bundle.JsTestDriverPreferencesValidator_validateFile_missing(source);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            return Bundle.JsTestDriverPreferencesValidator_validateFile_notAbsolute(source);
        }
        if (!file.isFile()) {
            return Bundle.JsTestDriverPreferencesValidator_validateFile_notFile(source);
        }
        if (!file.canRead()) {
            return Bundle.JsTestDriverPreferencesValidator_validateFile_notReadable(source);
        }
        if (writable && !file.canWrite()) {
            return Bundle.JsTestDriverPreferencesValidator_validateFile_notWritable(source);
        }
        return null;
    }
}

