/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.LazyArrayList;
import org.netbeans.api.debugger.PathLookup;
import org.netbeans.api.debugger.PositionedList;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;

abstract class Lookup
implements ContextProvider {
    public static final String NOTIFY_LOAD_FIRST = "load first";
    public static final String NOTIFY_LOAD_LAST = "load last";
    public static final String NOTIFY_UNLOAD_FIRST = "unload first";
    public static final String NOTIFY_UNLOAD_LAST = "unload last";
    private static final Logger logger = Logger.getLogger(Lookup.class.getName());
    private static boolean verbose = System.getProperty("netbeans.debugger.registration") != null;

    Lookup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lookupFirst(String folder, Class<T> service) {
        List<T> l;
        List<T> list = l = this.lookup(folder, service);
        synchronized (list) {
            if (l.isEmpty()) {
                return null;
            }
            return l.get(0);
        }
    }

    @Override
    public abstract <T> List<? extends T> lookup(String var1, Class<T> var2);

    private static class LookupList<T>
    extends LazyArrayList<T> {
        protected Set<String> hiddenClassNames;
        private LinkedHashMap<Object, String> instanceClassNames = new LinkedHashMap();

        public LookupList(Set<String> hiddenClassNames) {
            this.hiddenClassNames = hiddenClassNames;
        }

        void add(T instance, String className) {
            super.add(instance);
            this.instanceClassNames.put(instance, className);
        }

        void add(LazyArrayList.LazyEntry instance, String className) {
            super.add(instance);
            this.instanceClassNames.put(instance, className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> c) {
            if (c instanceof LookupList) {
                LookupList ll;
                LookupList lookupList = ll = (LookupList)c;
                synchronized (lookupList) {
                    LookupList lookupList2 = this;
                    synchronized (lookupList2) {
                        Set<String> newHiddenClassNames = ll.hiddenClassNames;
                        if (newHiddenClassNames != null) {
                            block6: for (String className : newHiddenClassNames) {
                                String className2 = null;
                                if (className.endsWith("()")) {
                                    className2 = className.substring(0, className.length() - 2);
                                }
                                if (!this.instanceClassNames.containsValue(className) && (className2 == null || !this.instanceClassNames.containsValue(className2))) continue;
                                for (Object instance : this.instanceClassNames.keySet()) {
                                    String icn = this.instanceClassNames.get(instance);
                                    if (!className.equals(icn) && (className2 == null || !className2.equals(icn))) continue;
                                    this.remove(instance);
                                    this.instanceClassNames.remove(instance);
                                    continue block6;
                                }
                            }
                            if (this.hiddenClassNames != null) {
                                this.hiddenClassNames.addAll(newHiddenClassNames);
                            } else {
                                this.hiddenClassNames = newHiddenClassNames;
                            }
                        }
                        this.ensureCapacity(this.size() + ll.size());
                        boolean addedAnything = false;
                        for (int i = 0; i < ll.size(); ++i) {
                            Object entry = ll.getEntry(i);
                            String className = ll.instanceClassNames.get(entry);
                            if (this.hiddenClassNames != null && this.hiddenClassNames.contains(className)) continue;
                            if (entry instanceof LazyArrayList.LazyEntry) {
                                this.add((LazyArrayList.LazyEntry)entry, className);
                            } else {
                                this.add(entry, className);
                            }
                            addedAnything = true;
                        }
                        return addedAnything;
                    }
                }
            }
            return super.addAll(c);
        }

        @Override
        public void clear() {
            super.clear();
            this.instanceClassNames.clear();
        }

        protected abstract class LookupLazyEntry<T>
        extends LazyArrayList.LazyEntry<T> {
            protected LookupLazyEntry() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected final T get() {
                T e = this.getEntry();
                LookupList lookupList = LookupList.this;
                synchronized (lookupList) {
                    String className = (String)LookupList.this.instanceClassNames.remove(this);
                    if (className != null) {
                        LookupList.this.instanceClassNames.put(e, className);
                    }
                }
                return e;
            }

            protected abstract T getEntry();
        }
    }

    private static final class FutureInstance
    implements Future<Object> {
        private static final Object NONE = new Object();
        private Object instance = NONE;

        private FutureInstance() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isCancelled() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public synchronized boolean isDone() {
            return this.instance != NONE;
        }

        @Override
        public synchronized Object get() throws InterruptedException {
            while (this.instance == NONE) {
                this.wait();
            }
            return this.instance;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("Not supported.");
        }

        synchronized void setInstance(Object instance) {
            this.instance = instance;
            this.notifyAll();
        }
    }

    static class MetaInf
    extends Lookup {
        private static final String HIDDEN = "-hidden";
        private static final RequestProcessor RP = new RequestProcessor("Debugger Services Refresh", 1, false, false);
        private String rootFolder;
        private final Map<String, List<String>> registrationCache = new HashMap<String, List<String>>();
        private final HashMap<String, Object> instanceCache = new HashMap();
        private final HashMap<String, FutureInstance> instanceFutureCache = new HashMap();
        private final HashMap<String, Object> origInstanceCache = new HashMap();
        private final HashMap<String, Lookup.Item> lookupItemsCache = new HashMap();
        private Lookup context;
        private Lookup.Result<ModuleInfo> moduleLookupResult;
        private ModuleChangeListener modulesChangeListener;
        private final Map<ClassLoader, ModuleChangeListener> moduleChangeListeners = new HashMap<ClassLoader, ModuleChangeListener>();
        private final Map<ModuleInfo, ModuleChangeListener> disabledModuleChangeListeners = new HashMap<ModuleInfo, ModuleChangeListener>();
        private final Set<MetaInfLookupList> lookupLists = new WeakSet();
        private RequestProcessor.Task refreshListEnabled;
        private RequestProcessor.Task refreshListDisabled;
        private final RequestProcessor.Task listenOnDisabledModulesTask;
        private final Map<String, org.openide.util.Lookup> pathLookups = new HashMap<String, org.openide.util.Lookup>();

        MetaInf(String rootFolder) {
            if (rootFolder != null && rootFolder.length() == 0) {
                rootFolder = null;
            }
            this.rootFolder = rootFolder;
            this.moduleLookupResult = org.openide.util.Lookup.getDefault().lookupResult(ModuleInfo.class);
            this.modulesChangeListener = new ModuleChangeListener(null);
            this.moduleLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.modulesChangeListener, this.moduleLookupResult));
            this.listenOnDisabledModulesTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    this.listenOnDisabledModules();
                }
            });
        }

        void setContext(Lookup context) {
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> List<? extends T> lookup(String folder, Class<T> service) {
            MetaInfLookupList<T> mll = new MetaInfLookupList<T>(folder, service);
            Set<MetaInfLookupList> set = this.lookupLists;
            synchronized (set) {
                this.lookupLists.add(mll);
            }
            return mll;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> list(String folder, Class<?> service) {
            String name = service.getName();
            String pathResourceName = "debugger/" + (this.rootFolder == null ? "" : this.rootFolder + "/") + (folder == null ? "" : folder + "/");
            String resourceName = "META-INF/" + pathResourceName + name;
            Map<String, List<String>> map = this.registrationCache;
            synchronized (map) {
                List<String> l = this.registrationCache.get(resourceName);
                if (l == null) {
                    l = this.loadMetaInf(resourceName);
                    this.registrationCache.put(resourceName, l);
                }
                return l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private org.openide.util.Lookup lookupForPath(String folder) {
            org.openide.util.Lookup l;
            String pathResourceName = "Debugger/" + (this.rootFolder == null ? "" : this.rootFolder + "/") + (folder == null ? "" : folder + "/");
            Map<String, org.openide.util.Lookup> map = this.pathLookups;
            synchronized (map) {
                l = this.pathLookups.get(pathResourceName);
                if (l == null) {
                    l = new PathLookup(pathResourceName);
                }
                this.pathLookups.put(pathResourceName, l);
            }
            return l;
        }

        private <T> Lookup.Result<T> listLookup(String folder, Class<T> service) {
            return this.lookupForPath(folder).lookupResult(service);
        }

        private static Set<String> getHiddenClassNames(List l) {
            HashSet<String> s = null;
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                String className = (String)l.get(i);
                if (!className.endsWith(HIDDEN)) continue;
                if (s == null) {
                    s = new HashSet<String>();
                }
                s.add(className.substring(0, className.length() - HIDDEN.length()));
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> loadMetaInf(String resourceName) {
            ArrayList<String> l = new ArrayList<String>();
            try {
                ClassLoader cl = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(ClassLoader.class);
                StringBuilder v = new StringBuilder("\nR lookup ").append(resourceName);
                Enumeration<URL> e = cl.getResources(resourceName);
                HashSet<URL> urls = new HashSet<URL>();
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    if (urls.contains(url)) continue;
                    urls.add(url);
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        String s = br.readLine();
                        while (s != null) {
                            if (!s.startsWith("#") && s.length() != 0) {
                                if (verbose) {
                                    v.append("\nR  service ").append(s).append(" found");
                                }
                                l.add(s);
                            }
                            s = br.readLine();
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                if (verbose) {
                    System.out.println(v.toString());
                }
                return l;
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                throw new InternalError("Can not read from Meta-inf!");
            }
        }

        private void postponedListenOn(final ClassLoader cl) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    this.listenOn(cl);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listenOn(ClassLoader cl) {
            boolean doesNotContainCl = false;
            Map<ClassLoader, ModuleChangeListener> map = this.moduleChangeListeners;
            synchronized (map) {
                if (!this.moduleChangeListeners.containsKey(cl)) {
                    doesNotContainCl = true;
                }
            }
            if (doesNotContainCl) {
                Collection allInstances = this.moduleLookupResult.allInstances();
                Map<ClassLoader, ModuleChangeListener> map2 = this.moduleChangeListeners;
                synchronized (map2) {
                    if (!this.moduleChangeListeners.containsKey(cl)) {
                        for (ModuleInfo mi : allInstances) {
                            if (!mi.isEnabled() || mi.getClassLoader() != cl) continue;
                            ModuleChangeListener l = new ModuleChangeListener(cl);
                            mi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)l, (Object)mi));
                            this.moduleChangeListeners.put(cl, l);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listenOnDisabledModules() {
            Collection allInstances = this.moduleLookupResult.allInstances();
            Map<ClassLoader, ModuleChangeListener> map = this.moduleChangeListeners;
            synchronized (map) {
                for (ModuleInfo mi : allInstances) {
                    if (mi.isEnabled() || this.disabledModuleChangeListeners.containsKey(mi)) continue;
                    ModuleChangeListener l = new ModuleChangeListener(null);
                    mi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)l, (Object)mi));
                    this.disabledModuleChangeListeners.put(mi, l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearCaches() {
            Map<String, List<String>> map = this.registrationCache;
            synchronized (map) {
                this.registrationCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearCaches(ClassLoader cl) {
            this.clearCaches();
            if (cl != null) {
                HashMap<String, Object> hashMap = this.instanceCache;
                synchronized (hashMap) {
                    ArrayList<String> classes = new ArrayList<String>(this.instanceCache.size());
                    classes.addAll(this.instanceCache.keySet());
                    for (String clazz : classes) {
                        Object instance = this.instanceCache.get(clazz);
                        if (instance.getClass().getClassLoader() == cl) {
                            this.instanceCache.remove(clazz);
                            this.origInstanceCache.remove(clazz);
                            this.lookupItemsCache.remove(clazz);
                            continue;
                        }
                        instance = this.origInstanceCache.get(clazz);
                        if (instance == null || instance.getClass().getClassLoader() != cl) continue;
                        this.instanceCache.remove(clazz);
                        this.origInstanceCache.remove(clazz);
                        this.lookupItemsCache.remove(clazz);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshLists(boolean load) {
            ArrayList<MetaInfLookupList> ll;
            Set<MetaInfLookupList> set = this.lookupLists;
            synchronized (set) {
                ll = new ArrayList<MetaInfLookupList>(this.lookupLists.size());
                ll.addAll(this.lookupLists);
            }
            Collections.sort(ll, MetaInf.getMetaInfLookupListComparator(load));
            for (MetaInfLookupList mll : ll) {
                mll.refreshContent();
            }
        }

        private static Comparator<MetaInfLookupList> getMetaInfLookupListComparator(final boolean load) {
            return new Comparator<MetaInfLookupList>(){

                @Override
                public int compare(MetaInfLookupList l1, MetaInfLookupList l2) {
                    if (load) {
                        return l1.notifyLoadOrder - l2.notifyLoadOrder;
                    }
                    return l1.notifyUnloadOrder - l2.notifyUnloadOrder;
                }
            };
        }

        public String toString() {
            return "Lookup.MetaInf@" + Integer.toHexString(this.hashCode()) + "[rootFolder=" + this.rootFolder + "]";
        }

        private final class MetaInfLookupList<T>
        extends LookupList<T>
        implements PositionedList<T>,
        Customizer {
            private String folder;
            private final Class<T> service;
            private List<PropertyChangeListener> propertyChangeListeners;
            public int notifyLoadOrder;
            public int notifyUnloadOrder;
            public List<Integer> elementPositions;

            public MetaInfLookupList(String folder, Class<T> service) {
                this(metaInf.list(folder, service), metaInf.listLookup(folder, service), service);
                this.folder = folder;
            }

            private MetaInfLookupList(List<String> l, Lookup.Result<T> lr, Class<T> service) {
                this(l, lr, MetaInf.getHiddenClassNames(l), service);
            }

            private MetaInfLookupList(List<String> l, Lookup.Result<T> lr, Set<String> s, Class<T> service) {
                super(s);
                this.notifyLoadOrder = 0;
                this.notifyUnloadOrder = 0;
                this.elementPositions = new ArrayList<Integer>();
                assert (service != null);
                this.service = service;
                this.fillInstances(l, lr, s);
                MetaInf.this.listenOnDisabledModulesTask.schedule(100);
            }

            private void fillInstances(List<String> l, Lookup.Result<T> lr, Set<String> s) {
                for (String className : l) {
                    if (className.endsWith(MetaInf.HIDDEN) || s != null && s.contains(className)) continue;
                    this.fillClassInstance(className);
                }
                for (Lookup.Item li : lr.allItems()) {
                    String serviceName = this.getServiceName(li.getId());
                    if (s != null && (s.contains(serviceName) || s.contains(serviceName + "()"))) continue;
                    this.fillServiceInstance(li);
                }
            }

            private String getServiceName(String itemId) {
                int i = itemId.lastIndexOf(47);
                i = i < 0 ? 0 : ++i;
                String serviceName = itemId.substring(i);
                boolean isMethodCall = serviceName.indexOf(46) > 0;
                serviceName = serviceName.replace('-', '.');
                if (isMethodCall) {
                    serviceName = serviceName + "()";
                }
                return serviceName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fillClassInstance(String className) {
                Object instance;
                HashMap hashMap = MetaInf.this.instanceCache;
                synchronized (hashMap) {
                    instance = MetaInf.this.instanceCache.get(className);
                }
                if (instance != null) {
                    try {
                        this.add(this.service.cast(instance), className);
                    }
                    catch (ClassCastException cce) {
                        logger.log(Level.WARNING, null, cce);
                    }
                    MetaInf.this.listenOn(instance.getClass().getClassLoader());
                } else if (this.checkClassName(className)) {
                    this.add(new LazyInstance<T>(this.service, className), className);
                }
            }

            private String getClassName(Lookup.Item li) {
                String id = li.getId();
                int i = id.lastIndexOf("/");
                if (i >= 0) {
                    id = id.substring(i + 1);
                }
                return id.replace('-', '.');
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fillServiceInstance(Lookup.Item<T> li) {
                String className = this.getClassName(li);
                Object instance = null;
                HashMap hashMap = MetaInf.this.instanceCache;
                synchronized (hashMap) {
                    instance = MetaInf.this.instanceCache.get(className);
                    Object origInstance = MetaInf.this.origInstanceCache.get(className);
                    Lookup.Item lastItem = (Lookup.Item)MetaInf.this.lookupItemsCache.get(className);
                    if (origInstance != null && li instanceof AbstractLookup.Pair && lastItem != null && lastItem.getId().equals(li.getId())) {
                        try {
                            Method creatorOfMethod = AbstractLookup.Pair.class.getDeclaredMethod("creatorOf", Object.class);
                            creatorOfMethod.setAccessible(true);
                            Object isCreator = creatorOfMethod.invoke(li, origInstance);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("fillServiceInstance(" + li + " [HASH = " + System.identityHashCode(li) + "]):");
                                logger.fine("  className = \"" + className + "\", orig instance = " + origInstance + ", instance = " + instance + ", is creator of = " + isCreator);
                                if (lastItem != null) {
                                    logger.fine("  last item was " + lastItem + " [HASH = " + System.identityHashCode(lastItem) + "])");
                                }
                                if (!Boolean.TRUE.equals(isCreator)) {
                                    logger.fine("\n!!!\n" + li + " is not a creator of " + origInstance + " !\nCreating a new instance...");
                                }
                            }
                            if (!Boolean.TRUE.equals(isCreator)) {
                                instance = null;
                                MetaInf.this.instanceCache.remove(className);
                                MetaInf.this.origInstanceCache.remove(className);
                                MetaInf.this.lookupItemsCache.remove(className);
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                int position = this.getPosition(li);
                while (this.elementPositions.size() < this.size()) {
                    this.elementPositions.add(Integer.MAX_VALUE);
                }
                this.elementPositions.add(position);
                if (instance != null) {
                    try {
                        this.add(this.service.cast(instance), className);
                    }
                    catch (ClassCastException cce) {
                        logger.log(Level.WARNING, null, cce);
                    }
                    MetaInf.this.listenOn(instance.getClass().getClassLoader());
                } else {
                    this.add(new LazyInstance<T>(this.service, li));
                }
            }

            private int getPosition(Lookup.Item<T> li) {
                int position = Integer.MAX_VALUE;
                try {
                    Object positionObj;
                    Field foField = li.getClass().getDeclaredField("fo");
                    foField.setAccessible(true);
                    FileObject fo = (FileObject)foField.get(li);
                    if (fo != null && (positionObj = fo.getAttribute("position")) instanceof Integer) {
                        position = (Integer)positionObj;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Not able to retieve position from item " + li, ex);
                }
                return position;
            }

            @Override
            public int getPosition(int elementIndex) {
                if (this.elementPositions.size() <= elementIndex) {
                    return Integer.MAX_VALUE;
                }
                return this.elementPositions.get(elementIndex);
            }

            @Override
            public boolean hasPositions() {
                return !this.elementPositions.isEmpty();
            }

            @Override
            public void clear() {
                super.clear();
                this.elementPositions.clear();
            }

            @Override
            public T remove(int index) {
                Object o = super.remove(index);
                this.elementPositions.remove(index);
                return o;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof LazyArrayList.LazyEntry) {
                    return super.remove(o);
                }
                int size = this.size();
                if (o == null) {
                    for (int index = 0; index < size; ++index) {
                        if (this.getRaw(index) != null) continue;
                        this.remove(index);
                        return true;
                    }
                } else {
                    for (int index = 0; index < size; ++index) {
                        if (!o.equals(this.getRaw(index))) continue;
                        this.remove(index);
                        return true;
                    }
                }
                return false;
            }

            private boolean checkClassName(String service) {
                ClassLoader cl;
                URL resource;
                if (service.endsWith("()")) {
                    int lastdot = service.lastIndexOf(46);
                    if (lastdot < 0) {
                        Exceptions.printStackTrace((Throwable)new IllegalStateException("Bad service - dot before method name is missing: '" + service + "'."));
                        return false;
                    }
                    service = service.substring(0, lastdot);
                }
                if ((resource = (cl = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(ClassLoader.class)).getResource(service.replace('.', '/') + ".class")) == null) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("The service " + service + " not found."));
                    return false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void refreshContent() {
                MetaInfLookupList metaInfLookupList = this;
                synchronized (metaInfLookupList) {
                    Set s;
                    this.clear();
                    List l = MetaInf.this.list(this.folder, this.service);
                    Lookup.Result lr = MetaInf.this.listLookup(this.folder, this.service);
                    this.hiddenClassNames = s = MetaInf.getHiddenClassNames(l);
                    this.fillInstances(l, lr, s);
                }
                this.firePropertyChange();
            }

            @Override
            public void setObject(Object bean) {
                if (Lookup.NOTIFY_LOAD_FIRST == bean) {
                    this.notifyLoadOrder = -1;
                } else if (Lookup.NOTIFY_LOAD_LAST == bean) {
                    this.notifyLoadOrder = 1;
                } else if (Lookup.NOTIFY_UNLOAD_FIRST == bean) {
                    this.notifyUnloadOrder = -1;
                } else if (Lookup.NOTIFY_UNLOAD_LAST == bean) {
                    this.notifyUnloadOrder = 1;
                } else {
                    throw new IllegalArgumentException(bean.toString());
                }
            }

            @Override
            public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
                if (this.propertyChangeListeners == null) {
                    this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
                }
                this.propertyChangeListeners.add(listener);
            }

            @Override
            public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
                this.propertyChangeListeners.remove(listener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void firePropertyChange() {
                ArrayList<PropertyChangeListener> listeners;
                MetaInfLookupList metaInfLookupList = this;
                synchronized (metaInfLookupList) {
                    if (this.propertyChangeListeners == null) {
                        return;
                    }
                    listeners = new ArrayList<PropertyChangeListener>(this.propertyChangeListeners);
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this, "content", null, null);
                for (PropertyChangeListener l : listeners) {
                    l.propertyChange(evt);
                }
            }

            private class LazyInstance<T>
            extends LookupList.LookupLazyEntry<T> {
                private String className;
                private Class<T> service;
                Lookup.Item<T> lookupItem;
                private final Object instanceCreationLock = new Object();

                public LazyInstance(Class<T> service, String className) {
                    this.service = service;
                    this.className = className;
                }

                public LazyInstance(Class<T> service, Lookup.Item<T> lookupItem) {
                    this.service = service;
                    this.lookupItem = lookupItem;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected T getEntry() {
                    Object fiex;
                    Object object;
                    Object cn;
                    Object instance = null;
                    if (this.lookupItem != null) {
                        cn = MetaInfLookupList.this.getClassName(this.lookupItem);
                        object = this.instanceCreationLock;
                        synchronized (object) {
                            FutureInstance fi = null;
                            fiex = null;
                            HashMap hashMap = MetaInf.this.instanceCache;
                            synchronized (hashMap) {
                                instance = MetaInf.this.instanceCache.get(cn);
                                if (instance == null && (fiex = (FutureInstance)MetaInf.this.instanceFutureCache.get(cn)) == null) {
                                    fi = new FutureInstance();
                                    MetaInf.this.instanceFutureCache.put(cn, fi);
                                }
                            }
                            if (instance == null) {
                                if (fiex != null) {
                                    try {
                                        instance = ((FutureInstance)fiex).get();
                                    }
                                    catch (InterruptedException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.fine("WAITED for instance " + instance + " to be created by a parallel thread.");
                                    }
                                } else {
                                    Object origInstance = instance = this.lookupItem.getInstance();
                                    Lookup.Item<T> lookupItemToCache = this.lookupItem;
                                    if (instance instanceof ContextAwareService) {
                                        ContextAwareService cas = (ContextAwareService)instance;
                                        instance = cas.forContext(MetaInf.this.context);
                                        this.lookupItem = null;
                                    }
                                    fi.setInstance(instance);
                                    HashMap hashMap2 = MetaInf.this.instanceCache;
                                    synchronized (hashMap2) {
                                        if (instance != null) {
                                            MetaInf.this.instanceCache.put(cn, instance);
                                        } else {
                                            MetaInf.this.instanceCache.remove(cn);
                                        }
                                        MetaInf.this.origInstanceCache.put(cn, origInstance);
                                        MetaInf.this.lookupItemsCache.put(cn, lookupItemToCache);
                                        MetaInf.this.instanceFutureCache.remove(cn);
                                    }
                                }
                            }
                        }
                    }
                    if (instance == null && this.className != null) {
                        cn = this.instanceCreationLock;
                        synchronized (cn) {
                            FutureInstance fi = null;
                            FutureInstance fiex2 = null;
                            fiex = MetaInf.this.instanceCache;
                            synchronized (fiex) {
                                instance = MetaInf.this.instanceCache.get(this.className);
                                if (instance == null && (fiex2 = (FutureInstance)MetaInf.this.instanceFutureCache.get(this.className)) == null) {
                                    fi = new FutureInstance();
                                    MetaInf.this.instanceFutureCache.put(this.className, fi);
                                }
                            }
                            if (instance == null) {
                                if (fiex2 != null) {
                                    try {
                                        instance = fiex2.get();
                                    }
                                    catch (InterruptedException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.fine("WAITED for instance " + instance + " to be created by a parallel thread.");
                                    }
                                } else {
                                    instance = ContextAwareSupport.createInstance(this.className, MetaInf.this.context);
                                    fi.setInstance(instance);
                                    HashMap hashMap = MetaInf.this.instanceCache;
                                    synchronized (hashMap) {
                                        if (instance != null) {
                                            MetaInf.this.instanceCache.put(this.className, instance);
                                        }
                                        MetaInf.this.instanceFutureCache.remove(this.className);
                                    }
                                }
                            }
                        }
                    }
                    if (instance != null) {
                        try {
                            cn = this.service.cast(instance);
                            return (T)cn;
                        }
                        catch (ClassCastException cce) {
                            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)cce, (String)("Can not cast instance " + instance + " registered in '" + MetaInfLookupList.this.folder + "' folder to " + this.service + ". className = " + this.className + ", lookupItem = " + this.lookupItem)));
                            object = null;
                            return (T)object;
                        }
                        finally {
                            if (Thread.holdsLock(MetaInfLookupList.this)) {
                                MetaInf.this.postponedListenOn(instance.getClass().getClassLoader());
                            } else {
                                MetaInf.this.listenOn(instance.getClass().getClassLoader());
                            }
                        }
                    }
                    logger.log(Level.INFO, "Returning null instance from LazyInstance.getEntry(). className = {0}, service = {1}, lookupItem = {2}", new Object[]{this.className, this.service, this.lookupItem});
                    return null;
                }
            }
        }

        private final class ModuleChangeListener
        implements PropertyChangeListener,
        LookupListener {
            private ClassLoader cl;

            public ModuleChangeListener(ClassLoader cl) {
                this.cl = cl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object object;
                if (!"enabled".equals(evt.getPropertyName())) {
                    return;
                }
                MetaInf.this.clearCaches(this.cl);
                ModuleInfo mi = (ModuleInfo)evt.getSource();
                if (!mi.isEnabled() && this.cl != null) {
                    object = MetaInf.this.moduleChangeListeners;
                    synchronized (object) {
                        MetaInf.this.moduleChangeListeners.remove(this.cl);
                        MetaInf.this.disabledModuleChangeListeners.put(mi, this);
                    }
                    this.cl = null;
                } else if (mi.isEnabled()) {
                    this.cl = mi.getClassLoader();
                    object = MetaInf.this.moduleChangeListeners;
                    synchronized (object) {
                        MetaInf.this.disabledModuleChangeListeners.remove(mi);
                        MetaInf.this.moduleChangeListeners.put(this.cl, this);
                    }
                }
                object = MetaInf.this;
                synchronized (object) {
                    if (mi.isEnabled()) {
                        if (MetaInf.this.refreshListEnabled == null) {
                            MetaInf.this.refreshListEnabled = RP.create(new Runnable(){

                                @Override
                                public void run() {
                                    MetaInf.this.refreshLists(true);
                                }
                            });
                        }
                        MetaInf.this.refreshListEnabled.schedule(100);
                    } else {
                        if (MetaInf.this.refreshListDisabled == null) {
                            MetaInf.this.refreshListDisabled = RP.create(new Runnable(){

                                @Override
                                public void run() {
                                    MetaInf.this.refreshLists(false);
                                }
                            });
                        }
                        MetaInf.this.refreshListDisabled.schedule(100);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                MetaInf.this.clearCaches(null);
                Map map = MetaInf.this.moduleChangeListeners;
                synchronized (map) {
                    MetaInf.this.moduleChangeListeners.clear();
                    MetaInf.this.disabledModuleChangeListeners.clear();
                }
                MetaInf.this.refreshLists(true);
                MetaInf.this.listenOnDisabledModules();
            }
        }
    }

    static class Compound
    extends Lookup {
        ContextProvider l1;
        ContextProvider l2;

        Compound(ContextProvider l1, ContextProvider l2) {
            this.l1 = l1;
            this.l2 = l2;
            this.setContext(this);
        }

        @Override
        public <T> List<? extends T> lookup(String folder, Class<T> service) {
            return new CompoundLookupList<T>(folder, service);
        }

        void setContext(Lookup context) {
            if (this.l1 instanceof Compound) {
                ((Compound)this.l1).setContext(context);
            }
            if (this.l1 instanceof MetaInf) {
                ((MetaInf)this.l1).setContext(context);
            }
            if (this.l2 instanceof Compound) {
                ((Compound)this.l2).setContext(context);
            }
            if (this.l2 instanceof MetaInf) {
                ((MetaInf)this.l2).setContext(context);
            }
        }

        public String toString() {
            return "Lookup.Compound@" + Integer.toHexString(this.hashCode()) + "[l1=" + this.l1 + ", l2=" + this.l2 + "]";
        }

        private static class PositionedElement<T>
        implements Comparable {
            T element;
            int position;

            private PositionedElement() {
            }

            public int compareTo(Object o) {
                if (o instanceof PositionedElement) {
                    return this.position - ((PositionedElement)o).position;
                }
                return 1;
            }
        }

        private class CompoundLookupList<T>
        extends LookupList<T>
        implements PositionedList<T>,
        Customizer,
        PropertyChangeListener {
            private String folder;
            private Class<T> service;
            private List<PropertyChangeListener> propertyChangeListeners;
            private Customizer sublist1;
            private Customizer sublist2;
            private List<PositionedElement> positionedElements;

            public CompoundLookupList(String folder, Class<T> service) {
                super((Set<String>)null);
                this.folder = folder;
                this.service = service;
                this.setUp();
            }

            private synchronized void setUp() {
                this.clear();
                List<T> list1 = Compound.this.l1.lookup(this.folder, this.service);
                List<T> list2 = Compound.this.l2.lookup(this.folder, this.service);
                if (list1 instanceof PositionedList || list2 instanceof PositionedList) {
                    PositionedList ml2;
                    PositionedList ml1;
                    ArrayList<PositionedElement> positioned = new ArrayList<PositionedElement>();
                    ArrayList<T> others = new ArrayList<T>();
                    boolean hp1 = false;
                    if (list1 instanceof PositionedList && (ml1 = (PositionedList)list1).hasPositions()) {
                        this.fillElements(ml1, positioned, others);
                        hp1 = true;
                    }
                    boolean hp2 = false;
                    if (list2 instanceof PositionedList && (ml2 = (PositionedList)list2).hasPositions()) {
                        this.fillElements(ml2, positioned, others);
                        hp2 = true;
                    }
                    if (hp1 && hp2) {
                        if (!positioned.isEmpty()) {
                            Collections.sort(positioned);
                            HashSet<String> hiddenClassNames = new HashSet<String>();
                            this.addHiddenClassNames(list1, hiddenClassNames);
                            this.addHiddenClassNames(list2, hiddenClassNames);
                            LookupList sorted = new LookupList((Set<String>)hiddenClassNames);
                            for (PositionedElement pe : positioned) {
                                sorted.add(pe.element);
                            }
                            this.positionedElements = positioned;
                            list1 = sorted;
                        } else {
                            list1 = Collections.emptyList();
                        }
                        list2 = others;
                    } else if (hp1) {
                        this.positionedElements = positioned;
                    } else if (hp2) {
                        this.positionedElements = positioned;
                        List<T> switchList = list1;
                        list1 = list2;
                        list2 = switchList;
                    }
                }
                this.addAll(list1);
                this.addAll(list2);
                this.sublist1 = list1 instanceof Customizer ? (Customizer)((Object)list1) : null;
                this.sublist2 = list2 instanceof Customizer ? (Customizer)((Object)list2) : null;
            }

            private void addHiddenClassNames(List list, Set<String> hiddenClassNames) {
                Set<String> hcn;
                if (list instanceof LookupList && (hcn = ((LookupList)list).hiddenClassNames) != null) {
                    hiddenClassNames.addAll(hcn);
                }
            }

            private void fillElements(PositionedList<? extends T> ml, List<PositionedElement> positioned, List<T> others) {
                int s1 = ml.size();
                for (int i = 0; i < s1; ++i) {
                    Object obj = ml.get(i);
                    int pos = ml.getPosition(i);
                    if (pos == 0 || pos == Integer.MAX_VALUE) {
                        others.add(obj);
                        continue;
                    }
                    PositionedElement p = new PositionedElement();
                    p.element = obj;
                    p.position = pos;
                    positioned.add(p);
                }
            }

            @Override
            public boolean hasPositions() {
                return this.positionedElements != null && !this.positionedElements.isEmpty();
            }

            @Override
            public int getPosition(int elementIndex) {
                if (elementIndex < this.positionedElements.size()) {
                    return this.positionedElements.get((int)elementIndex).position;
                }
                return Integer.MAX_VALUE;
            }

            @Override
            public synchronized void setObject(Object bean) {
                if (this.sublist1 != null) {
                    this.sublist1.setObject(bean);
                }
                if (this.sublist2 != null) {
                    this.sublist2.setObject(bean);
                }
            }

            @Override
            public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
                if (this.propertyChangeListeners == null) {
                    this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
                    if (this.sublist1 != null) {
                        this.sublist1.addPropertyChangeListener(this);
                    }
                    if (this.sublist2 != null) {
                        this.sublist2.addPropertyChangeListener(this);
                    }
                }
                this.propertyChangeListeners.add(listener);
            }

            @Override
            public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
                this.propertyChangeListeners.remove(listener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ArrayList<PropertyChangeListener> listeners;
                this.setUp();
                CompoundLookupList compoundLookupList = this;
                synchronized (compoundLookupList) {
                    if (this.propertyChangeListeners == null) {
                        return;
                    }
                    listeners = new ArrayList<PropertyChangeListener>(this.propertyChangeListeners);
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this, "content", null, null);
                for (PropertyChangeListener l : listeners) {
                    l.propertyChange(evt);
                }
            }
        }
    }

    static class Instance
    extends Lookup {
        private Object[] services;

        Instance(Object[] services) {
            this.services = services;
        }

        @Override
        public <T> List<? extends T> lookup(String folder, Class<T> service) {
            ArrayList<T> l = new ArrayList<T>();
            for (Object s : this.services) {
                if (!service.isInstance(s)) continue;
                l.add(service.cast(s));
                if (!verbose) continue;
                System.out.println("\nR  instance " + s + " found");
            }
            return l;
        }
    }
}

