/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DrScanDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="scanListenerPortTcp")
    private final Integer scanListenerPortTcp;
    @JsonProperty(value="ips")
    private final List<String> ips;

    @Deprecated
    @ConstructorProperties(value={"hostname", "scanListenerPortTcp", "ips"})
    public DrScanDetails(String hostname, Integer scanListenerPortTcp, List<String> ips) {
        this.hostname = hostname;
        this.scanListenerPortTcp = scanListenerPortTcp;
        this.ips = ips;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getScanListenerPortTcp() {
        return this.scanListenerPortTcp;
    }

    public List<String> getIps() {
        return this.ips;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrScanDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hostname=").append(String.valueOf(this.hostname));
        sb.append(", scanListenerPortTcp=").append(String.valueOf(this.scanListenerPortTcp));
        sb.append(", ips=").append(String.valueOf(this.ips));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrScanDetails)) {
            return false;
        }
        DrScanDetails other = (DrScanDetails)((Object)o);
        return Objects.equals(this.hostname, other.hostname) && Objects.equals(this.scanListenerPortTcp, other.scanListenerPortTcp) && Objects.equals(this.ips, other.ips) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.scanListenerPortTcp == null ? 43 : this.scanListenerPortTcp.hashCode());
        result = result * 59 + (this.ips == null ? 43 : this.ips.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="scanListenerPortTcp")
        private Integer scanListenerPortTcp;
        @JsonProperty(value="ips")
        private List<String> ips;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            this.__explicitlySet__.add("scanListenerPortTcp");
            return this;
        }

        public Builder ips(List<String> ips) {
            this.ips = ips;
            this.__explicitlySet__.add("ips");
            return this;
        }

        public DrScanDetails build() {
            DrScanDetails model = new DrScanDetails(this.hostname, this.scanListenerPortTcp, this.ips);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrScanDetails model) {
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcp")) {
                this.scanListenerPortTcp(model.getScanListenerPortTcp());
            }
            if (model.wasPropertyExplicitlySet("ips")) {
                this.ips(model.getIps());
            }
            return this;
        }
    }
}

