/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.element;

public enum ElementKind {
    PACKAGE,
    ENUM,
    CLASS,
    ANNOTATION_TYPE,
    INTERFACE,
    ENUM_CONSTANT,
    FIELD,
    PARAMETER,
    LOCAL_VARIABLE,
    EXCEPTION_PARAMETER,
    METHOD,
    CONSTRUCTOR,
    STATIC_INIT,
    INSTANCE_INIT,
    TYPE_PARAMETER,
    OTHER,
    RESOURCE_VARIABLE,
    MODULE,
    RECORD,
    RECORD_COMPONENT,
    BINDING_VARIABLE;


    public boolean isClass() {
        return this == CLASS || this == ENUM || this == RECORD;
    }

    public boolean isInterface() {
        return this == INTERFACE || this == ANNOTATION_TYPE;
    }

    public boolean isDeclaredType() {
        return this.isClass() || this.isInterface();
    }

    public boolean isField() {
        return this == FIELD || this == ENUM_CONSTANT;
    }

    public boolean isExecutable() {
        boolean bl;
        switch (this) {
            case METHOD: 
            case CONSTRUCTOR: 
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isInitializer() {
        boolean bl;
        switch (this) {
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isVariable() {
        boolean bl;
        switch (this) {
            case ENUM_CONSTANT: 
            case FIELD: 
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: 
            case BINDING_VARIABLE: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

