/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.navigation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.navigation.SnippetNodes;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class SnippetPanelUI
extends JPanel
implements Lookup.Provider,
ExplorerManager.Provider,
PropertyChangeListener {
    private BeanTreeView treeView;
    private ExplorerManager manager = new ExplorerManager();
    private JShellEnvironment env;
    private SnippetNodes nodesFactory;
    private final InstanceContent selectedObjects = new InstanceContent();
    private final Lookup lkp = new AbstractLookup((AbstractLookup.Content)this.selectedObjects);
    private JScrollPane treeScrollPane;

    public SnippetPanelUI() {
        this.treeView = new BeanTreeView();
        this.initComponents();
        this.treeView.setRootVisible(false);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"selectedNodes".equals(evt.getPropertyName())) {
            return;
        }
        for (Node n : (Node[])evt.getOldValue()) {
            this.selectedObjects.remove((Object)n);
        }
        for (Node n : (Node[])evt.getNewValue()) {
            this.selectedObjects.add((Object)n);
        }
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    void unselectAll() {
        for (Node n : this.manager.getSelectedNodes()) {
            this.selectedObjects.remove((Object)n);
        }
    }

    private void initComponents() {
        this.treeScrollPane = this.treeView;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.treeScrollPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.treeScrollPane, -1, 300, Short.MAX_VALUE));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void navigateToHandle(SnippetHandle handle) {
        Node n = this.nodesFactory.getNodeFor(handle);
        if (n != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{n});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void navigate(JShellEnvironment env) {
        if (this.env == env) {
            return;
        }
        if (this.env != null) {
            this.selectedObjects.remove((Object)this.env);
        }
        this.selectedObjects.add((Object)env);
        this.env = env;
        this.nodesFactory = new SnippetNodes(env);
        this.manager.setRootContext((Node)new AbstractNode((Children)this.nodesFactory));
        try {
            this.manager.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

