/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.deploy;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.tomcat5.deploy.TomcatTarget;

public final class TomcatModule
implements TargetModuleID {
    private static final Logger LOGGER = Logger.getLogger(TomcatModule.class.getName());
    private TomcatTarget target;
    private final String path;
    private final String docRoot;

    public TomcatModule(Target target, String path) {
        this(target, path, null);
    }

    public TomcatModule(Target target, String path, String docRoot) {
        if (!path.isEmpty() && !path.startsWith("/")) {
            LOGGER.log(Level.INFO, "Non empty module path must start with '/'; was {0}", path);
        }
        this.target = (TomcatTarget)target;
        this.path = "".equals(path) ? "/" : path;
        this.docRoot = docRoot;
    }

    public String getDocRoot() {
        return this.docRoot;
    }

    public TargetModuleID[] getChildTargetModuleID() {
        return null;
    }

    public String getModuleID() {
        return this.getWebURL();
    }

    public TargetModuleID getParentTargetModuleID() {
        return null;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getPath() {
        return this.path;
    }

    public String getWebURL() {
        return this.target.getServerUri() + this.path.replace(" ", "%20");
    }

    public String toString() {
        return this.getModuleID();
    }
}

