/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class OptionsPanelColorProvider {
    private static final String colorNamePrefix = "annotationFormat.";
    private final HashMap<String, AnnotationFormat> colors = new HashMap();

    protected OptionsPanelColorProvider() {
    }

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Color[]> getColors() {
        HashMap<String, AnnotationFormat> hashMap = this.colors;
        synchronized (hashMap) {
            HashMap<String, Color[]> outputColors = new HashMap<String, Color[]>(this.colors.size());
            for (Map.Entry<String, AnnotationFormat> e : this.colors.entrySet()) {
                AnnotationFormat af = e.getValue();
                outputColors.put(af.getDisplayName(), new Color[]{af.getActualColor(), af.getDefaultColor()});
            }
            return outputColors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void colorsChanged(Map<String, Color> newColors) {
        HashMap<String, AnnotationFormat> hashMap = this.colors;
        synchronized (hashMap) {
            for (Map.Entry<String, Color> e : newColors.entrySet()) {
                AnnotationFormat af = this.colors.get(e.getKey());
                if (af == null) continue;
                af.setActualColor(e.getValue());
            }
            this.saveColors(this.colors.values());
        }
    }

    protected static final String to2Hex(int val) {
        String hexStr = Integer.toHexString(val & 0xFF);
        if (hexStr.length() == 1) {
            hexStr = "0" + hexStr;
        }
        return hexStr;
    }

    protected static String getColorKey(String annotationKey) {
        return colorNamePrefix + annotationKey;
    }

    protected final AnnotationFormat createAnnotationFormat(String formatKey, String displayName, Color defaultColor, boolean isTooltip) {
        return new AnnotationFormat(formatKey, displayName, defaultColor, defaultColor == null ? null : this.getSavedColor(OptionsPanelColorProvider.getColorKey(formatKey), defaultColor), isTooltip);
    }

    protected void putColor(AnnotationFormat af) {
        this.colors.put(af.getDisplayName(), af);
    }

    protected abstract Color getSavedColor(String var1, Color var2);

    protected abstract MessageFormat createFormat(Color var1, boolean var2);

    protected abstract void saveColors(Collection<AnnotationFormat> var1);

    public class AnnotationFormat {
        private final String displayName;
        private final boolean tooltip;
        private final String key;
        private final Color defaultColor;
        private Color actualColor;
        private MessageFormat format;

        private AnnotationFormat(String key, String displayName, Color defaultColor, Color actualColor, boolean tooltip) {
            this.key = key;
            this.displayName = displayName;
            this.defaultColor = defaultColor;
            this.tooltip = tooltip;
            this.setActualColor(actualColor);
        }

        public boolean isTooltip() {
            return this.tooltip;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Color getDefaultColor() {
            return this.defaultColor;
        }

        public String getKey() {
            return this.key;
        }

        public synchronized MessageFormat getFormat() {
            if (this.format == null) {
                Color color = this.getActualColor();
                this.format = OptionsPanelColorProvider.this.createFormat(color, this.isTooltip());
            }
            return this.format;
        }

        public Color getActualColor() {
            return this.actualColor;
        }

        private synchronized void setActualColor(Color color) {
            this.actualColor = color == null ? this.defaultColor : color;
            this.format = null;
        }
    }
}

