/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.Objects;
import javax.swing.JTable;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.versioning.util.TableSorter;

public class SortedTable
extends JTable {
    private final TableSorter sorter;

    public SortedTable(TableSorter sorter) {
        super(sorter);
        this.sorter = sorter;
        this.updateSorterTableHeader();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new TableHeader(this.columnModel);
    }

    @Override
    public void setTableHeader(JTableHeader tableHeader) {
        if (tableHeader != this.tableHeader) {
            super.setTableHeader(tableHeader);
            this.updateSorterTableHeader();
        }
    }

    private void updateSorterTableHeader() {
        if (this.sorter != null) {
            this.sorter.setTableHeader(this.tableHeader);
        }
    }

    private final class TableHeader
    extends JTableHeader {
        private TableHeader(TableColumnModel columnModel) {
            super(columnModel);
            this.setSortingRenderer();
        }

        @Override
        public void setUI(TableHeaderUI ui) {
            if (ui != this.ui) {
                this.unsetSortingRenderer();
                super.setUI(ui);
                this.setSortingRenderer();
                this.repaint();
            }
        }

        private void unsetSortingRenderer() {
            TableCellRenderer defaultRenderer = this.getDefaultRenderer();
            if (defaultRenderer instanceof TableSorter.SortableHeaderRenderer) {
                this.setDefaultRenderer(((TableSorter.SortableHeaderRenderer)defaultRenderer).getRendererDelegate());
            }
        }

        private void setSortingRenderer() {
            TableCellRenderer defaultRenderer;
            if (SortedTable.this.sorter != null && !((defaultRenderer = this.getDefaultRenderer()) instanceof TableSorter.SortableHeaderRenderer)) {
                TableSorter tableSorter = SortedTable.this.sorter;
                Objects.requireNonNull(tableSorter);
                this.setDefaultRenderer(new TableSorter.SortableHeaderRenderer(tableSorter, defaultRenderer));
            }
        }
    }
}

