/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.items;

import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.openide.util.ChangeSupport;

public abstract class OCIItem {
    final OCID id;
    final String name;
    String description;
    ChangeSupport changeSupport;

    public OCIItem(OCID id, String name) {
        this.id = id;
        this.name = name;
        this.changeSupport = new ChangeSupport((Object)this);
    }

    public OCIItem() {
        this(null, null);
    }

    public OCID getKey() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void refresh() {
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public int maxInProject() {
        return 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.id);
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + Objects.hashCode(this.description);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OCIItem other = (OCIItem)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }
}

