/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagement;
import com.oracle.bmc.adm.model.KnowledgeBase;
import com.oracle.bmc.adm.model.VulnerabilityAudit;
import com.oracle.bmc.adm.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.GetVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetWorkRequestRequest;
import com.oracle.bmc.adm.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.GetVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ApplicationDependencyManagementWaiters {
    private final ExecutorService executorService;
    private final ApplicationDependencyManagement client;

    public ApplicationDependencyManagementWaiters(ExecutorService executorService, ApplicationDependencyManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(GetKnowledgeBaseRequest request, KnowledgeBase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forKnowledgeBase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(GetKnowledgeBaseRequest request, KnowledgeBase.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forKnowledgeBase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(GetKnowledgeBaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, KnowledgeBase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forKnowledgeBase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse> forKnowledgeBase(BmcGenericWaiter waiter, GetKnowledgeBaseRequest request, KnowledgeBase.LifecycleState ... targetStates) {
        final HashSet<KnowledgeBase.LifecycleState> targetStatesSet = new HashSet<KnowledgeBase.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetKnowledgeBaseRequest, GetKnowledgeBaseResponse>(){

            @Override
            public GetKnowledgeBaseResponse apply(GetKnowledgeBaseRequest request) {
                return ApplicationDependencyManagementWaiters.this.client.getKnowledgeBase(request);
            }
        }, (Predicate)new Predicate<GetKnowledgeBaseResponse>(){

            @Override
            public boolean test(GetKnowledgeBaseResponse response) {
                return targetStatesSet.contains((Object)response.getKnowledgeBase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)KnowledgeBase.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse> forVulnerabilityAudit(GetVulnerabilityAuditRequest request, VulnerabilityAudit.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVulnerabilityAudit(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse> forVulnerabilityAudit(GetVulnerabilityAuditRequest request, VulnerabilityAudit.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVulnerabilityAudit(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse> forVulnerabilityAudit(GetVulnerabilityAuditRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VulnerabilityAudit.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVulnerabilityAudit(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse> forVulnerabilityAudit(BmcGenericWaiter waiter, GetVulnerabilityAuditRequest request, VulnerabilityAudit.LifecycleState ... targetStates) {
        final HashSet<VulnerabilityAudit.LifecycleState> targetStatesSet = new HashSet<VulnerabilityAudit.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVulnerabilityAuditRequest, GetVulnerabilityAuditResponse>(){

            @Override
            public GetVulnerabilityAuditResponse apply(GetVulnerabilityAuditRequest request) {
                return ApplicationDependencyManagementWaiters.this.client.getVulnerabilityAudit(request);
            }
        }, (Predicate)new Predicate<GetVulnerabilityAuditResponse>(){

            @Override
            public boolean test(GetVulnerabilityAuditResponse response) {
                return targetStatesSet.contains((Object)response.getVulnerabilityAudit().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VulnerabilityAudit.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ApplicationDependencyManagementWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

