/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.netbeans.modules.gradle.tooling.NbProjectInfoBuilder;
import org.netbeans.modules.gradle.tooling.NbProjectInfoModel;
import org.netbeans.modules.gradle.tooling.NeedOnlineModeException;
import org.netbeans.modules.gradle.tooling.internal.NbProjectInfo;

public class NetBeansToolingPlugin
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry registry;

    @Inject
    public NetBeansToolingPlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project t) {
        this.registry.register((ToolingModelBuilder)new NetBeansToolingModelBuilder());
    }

    private static class NetBeansToolingModelBuilder
    implements ToolingModelBuilder {
        private NetBeansToolingModelBuilder() {
        }

        public boolean canBuild(String modelName) {
            return NbProjectInfo.class.getName().equals(modelName);
        }

        public Object buildAll(String modelName, Project prj) {
            try {
                NbProjectInfo model = new NbProjectInfoBuilder(prj).buildAll();
                Map<String, Object> info = model.getInfo();
                if (prj.hasProperty("nbSerializeCheck")) {
                    LinkedList<String> serializeProblems = new LinkedList<String>();
                    try (ObjectOutputStream os2 = new ObjectOutputStream(new ByteArrayOutputStream());){
                        for (String key : info.keySet()) {
                            try {
                                os2.writeObject(info.get(key));
                            }
                            catch (NotSerializableException ex) {
                                serializeProblems.add(key);
                                System.err.println("Field '" + key + "' is not serializable: " + ex.getMessage());
                            }
                        }
                    }
                    catch (IOException os2) {
                        // empty catch block
                    }
                    if (!serializeProblems.isEmpty()) {
                        NbProjectInfoModel ret = new NbProjectInfoModel();
                        ret.setGradleException(new NotSerializableException(((Object)serializeProblems).toString()).toString());
                        return ret;
                    }
                }
                return model;
            }
            catch (NeedOnlineModeException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println(ex.toString());
                ex.printStackTrace(pw);
                NbProjectInfoModel ret = new NbProjectInfoModel();
                ret.setGradleException(sw.toString());
                for (Throwable cause = ex; cause != null && cause.getCause() != cause; cause = cause.getCause()) {
                    if (!(cause instanceof GradleException)) continue;
                    ret.noteProblem((Throwable)((GradleException)cause));
                    break;
                }
                return ret;
            }
        }
    }
}

