/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.openide.awt.GraphicsUtils;

public final class ResultBar
extends JComponent
implements ActionListener {
    private static final Color NOT_COVERED_LIGHT = new Color(255, 160, 160);
    private static final Color NOT_COVERED_DARK = new Color(180, 50, 50);
    private static final Color COVERED_LIGHT = new Color(160, 255, 160);
    private static final Color COVERED_DARK = new Color(30, 180, 30);
    private static final Color NO_TESTS_LIGHT = new Color(200, 200, 200);
    private static final Color NO_TESTS_DARK = new Color(110, 110, 110);
    private static final Color ABORTED_TESTS_LIGHT = new Color(246, 232, 206);
    private static final Color ABORTED_TESTS_DARK = new Color(214, 157, 41);
    private boolean emphasize;
    private boolean selected;
    private float passedPercentage = 0.0f;
    private float skippedPercentage = 0.0f;
    private float abortedPercentage = 0.0f;
    private Timer timer = new Timer(100, this);
    private int phase = 1;
    private boolean passedReported = false;
    private boolean skippedReported = false;
    private boolean abortedReported = false;

    public ResultBar() {
        this.updateUI();
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.phase = this.phase < this.getHeight() - 1 ? this.phase + 1 : 1;
        this.repaint();
    }

    public float getPassedPercentage() {
        return this.passedPercentage;
    }

    public void setPassedPercentage(float passedPercentage) {
        if (Float.isNaN(passedPercentage)) {
            passedPercentage = 0.0f;
        }
        this.passedPercentage = passedPercentage;
        this.passedReported = true;
        this.repaint();
    }

    public void setSkippedPercentage(float skippedPercentage) {
        if (Float.isNaN(skippedPercentage)) {
            skippedPercentage = 0.0f;
        }
        this.skippedPercentage = skippedPercentage;
        this.skippedReported = true;
        this.repaint();
    }

    public void setAbortedPercentage(float abortedPercentage) {
        if (Float.isNaN(abortedPercentage)) {
            abortedPercentage = 0.0f;
        }
        this.abortedPercentage = abortedPercentage;
        this.abortedReported = true;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isEmphasize() {
        return this.emphasize;
    }

    public void setEmphasize(boolean emphasize) {
        this.emphasize = emphasize;
    }

    private String getString() {
        return "Tests passed: ".concat(String.format("%.2f %%", Float.valueOf(this.passedPercentage)));
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void updateUI() {
        Font f = new JLabel().getFont();
        f = new Font(f.getName(), 1, f.getSize());
        this.setFont(f);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height;
        int width;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        int barRectWidth = width = this.getWidth();
        int barRectHeight = height = this.getHeight();
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = (int)((float)barRectWidth * this.passedPercentage / 100.0f);
        int amountSkip = (int)((float)barRectWidth * this.skippedPercentage / 100.0f);
        int amountAbort = (int)((float)barRectWidth * this.abortedPercentage / 100.0f);
        int amountFail = Math.abs(barRectWidth - amountFull - amountSkip - amountAbort);
        if (amountFail <= 1) {
            amountFail = 0;
        }
        Color notCoveredLight = NOT_COVERED_LIGHT;
        Color notCoveredDark = NOT_COVERED_DARK;
        Color coveredLight = COVERED_LIGHT;
        Color coveredDark = COVERED_DARK;
        Color noTestsLight = NO_TESTS_LIGHT;
        Color noTestsDark = NO_TESTS_DARK;
        Color abortedTestsLight = ABORTED_TESTS_LIGHT;
        Color abortedTestsDark = ABORTED_TESTS_DARK;
        if (this.emphasize) {
            coveredDark = coveredDark.darker();
            notCoveredDark = notCoveredDark.darker();
            noTestsDark = noTestsDark.darker();
            abortedTestsDark = abortedTestsDark.darker();
        } else if (this.selected) {
            coveredLight = coveredLight.brighter();
            coveredDark = coveredDark.darker();
            notCoveredLight = notCoveredLight.brighter();
            notCoveredDark = notCoveredDark.darker();
            noTestsLight = noTestsLight.brighter();
            noTestsDark = noTestsDark.darker();
            abortedTestsLight = abortedTestsLight.brighter();
            abortedTestsDark = abortedTestsDark.darker();
        }
        Graphics2D g2 = (Graphics2D)g;
        Color light = noTestsLight;
        Color dark = noTestsDark;
        if (this.abortedReported || this.skippedReported || this.passedReported) {
            if ((double)this.passedPercentage == 100.0) {
                light = coveredLight;
                dark = coveredDark;
            } else if ((double)this.abortedPercentage > 0.0) {
                light = abortedTestsLight;
                dark = abortedTestsDark;
            } else if ((double)(100.0f - this.passedPercentage - this.abortedPercentage - this.skippedPercentage) > 1.0E-4) {
                light = notCoveredLight;
                dark = notCoveredDark;
            } else if ((double)this.skippedPercentage > 0.0) {
                light = noTestsLight;
                dark = noTestsDark;
            }
        }
        g2.setPaint(new GradientPaint(0.0f, this.phase, light, 0.0f, this.phase + height / 2, dark, true));
        g2.fillRect(0, 0, barRectWidth, height);
        this.paintText(g2, barRectWidth, barRectHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        int stringHeight;
        Insets border = this.getInsets();
        FontMetrics fontSizer = this.getFontMetrics(this.getFont());
        Container parent = this.getParent();
        Insets insets = parent.getInsets();
        Dimension size = new Dimension(parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
        String string = this.getString();
        int stringWidth = fontSizer.stringWidth(string);
        if (stringWidth > size.width) {
            size.width = stringWidth;
        }
        if ((stringHeight = fontSizer.getHeight() + fontSizer.getDescent()) > size.height) {
            size.height = stringHeight;
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = 40;
        return pref;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension pref = this.getPreferredSize();
        pref.width = Short.MAX_VALUE;
        return pref;
    }

    @Override
    public int getBaseline(int w, int h) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return h - fm.getDescent() - (h - fm.getHeight()) / 2;
    }

    private void paintText(Graphics2D g, int w, int h) {
        Font font = this.getFont();
        String text = this.getString();
        GlyphVector gv = font.createGlyphVector(g.getFontRenderContext(), text);
        FontMetrics fm = g.getFontMetrics(font);
        Shape outline = gv.getOutline();
        Rectangle2D bounds = outline.getBounds2D();
        double x = Math.max(0.0, ((double)w - bounds.getWidth()) / 2.0);
        double y = (double)h / 2.0 + (double)fm.getAscent() / 2.0 - 1.0;
        AffineTransform oldTransform = g.getTransform();
        g.translate(x, y);
        g.setColor(new Color(0, 0, 0, 100));
        g.setStroke(new BasicStroke(2.0f, 1, 1));
        g.draw(outline);
        g.setColor(Color.WHITE);
        g.fill(outline);
        g.setTransform(oldTransform);
    }
}

