/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.queries.Bundle;
import org.netbeans.modules.gradle.java.queries.GradleDependencyResult;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.ProjectSpec;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.spi.ProjectDependenciesImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GradleDependenciesImplementation
implements ProjectDependenciesImplementation {
    private static final int DEPENDENCIES_MAX_COUNT = 100000;
    private static final Logger LOG = Logger.getLogger(GradleDependenciesImplementation.class.getName());
    private final Project project;
    private final NbGradleProject nbgp;
    private static final Set<Scope> SCOPES = new HashSet<Scope>();
    static final Map<Scope, String> SCOPE_TO_CONFIURATION;

    public GradleDependenciesImplementation(Project project) {
        this.project = project;
        this.nbgp = NbGradleProject.get((Project)project);
    }

    public DependencyResult findDependencies(ProjectDependencies.DependencyQuery query) throws ProjectOperationException {
        CompletableFuture result = new CompletableFuture();
        this.nbgp.toQuality(Bundle.DESC_ObtainDependencies(), query.isOffline() ? NbGradleProject.Quality.FULL : NbGradleProject.Quality.FULL_ONLINE, query.isFlushChaches()).thenApply(p -> {
            DependencyResult dr = new Collector(query).processDependencies(this.nbgp);
            result.complete(dr);
            return null;
        });
        try {
            return (DependencyResult)result.get();
        }
        catch (InterruptedException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.OK, Bundle.ERR_DependenciesCancelled(), (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable t = ex.getCause();
            if (t instanceof ProjectOperationException) {
                throw (ProjectOperationException)t;
            }
            throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_Unexpected(ex.getLocalizedMessage()), t);
        }
    }

    public static String[] gavSplit(String gav) {
        int versionEnd;
        int firstColon = gav.indexOf(58);
        int versionColon = gav.indexOf(58, firstColon + 1);
        int n = versionEnd = versionColon > firstColon ? gav.indexOf(58, versionColon + 1) : -1;
        if (firstColon == -1 || versionColon == -1 || firstColon == versionColon) {
            throw new IllegalArgumentException("Invalid GAV format: '" + gav + "'");
        }
        int end = versionEnd == -1 ? gav.length() : versionEnd;
        return new String[]{gav.substring(0, firstColon), gav.substring(firstColon + 1, versionColon), gav.substring(versionColon + 1, end)};
    }

    static {
        SCOPES.add(Scopes.PROCESS);
        SCOPES.add(Scopes.COMPILE);
        SCOPES.add(Scopes.RUNTIME);
        SCOPES.add(Scopes.EXTERNAL);
        SCOPES.add(Scopes.TEST);
        SCOPES.add(Scopes.TEST_COMPILE);
        SCOPES.add(Scopes.TEST_RUNTIME);
        SCOPE_TO_CONFIURATION = new HashMap<Scope, String>();
        SCOPE_TO_CONFIURATION.put(Scopes.PROCESS, "annotationProcessor");
        SCOPE_TO_CONFIURATION.put(Scopes.COMPILE, "compileClasspath");
        SCOPE_TO_CONFIURATION.put(Scopes.RUNTIME, "runtimeClasspath");
        SCOPE_TO_CONFIURATION.put(Scopes.TEST_COMPILE, "testCompileClasspath");
        SCOPE_TO_CONFIURATION.put(Scopes.TEST_RUNTIME, "testRuntimeClasspath");
    }

    class Collector {
        final ProjectDependencies.DependencyQuery query;
        final GradleBaseProject base;
        GradleConfiguration cfg;
        Scope scope;
        List<Dependency> problems = new ArrayList<Dependency>();
        int counter = 0;
        final FileObject marker = FileUtil.getConfigRoot();
        final Map<File, FileObject> file2FileObject = new HashMap<File, FileObject>();

        public Collector(ProjectDependencies.DependencyQuery query) {
            this.query = query;
            this.base = GradleBaseProject.get((Project)GradleDependenciesImplementation.this.project);
        }

        DependencyResult processDependencies(NbGradleProject nbgp) {
            FileObject pf;
            GradleBaseProject base = GradleBaseProject.get((Project)GradleDependenciesImplementation.this.project);
            Set scopes = this.query.getScopes();
            ArrayDeque processScopes = new ArrayDeque(scopes);
            HashSet allScopes = new HashSet(scopes);
            allScopes.retainAll(SCOPE_TO_CONFIURATION.keySet());
            processScopes.removeAll(allScopes);
            while (!processScopes.isEmpty()) {
                Scope s = (Scope)processScopes.poll();
                HashSet newScopes = new HashSet();
                newScopes.add(s);
                for (Scope t : SCOPES) {
                    if (s.includes(t)) {
                        newScopes.add(t);
                        continue;
                    }
                    if (!t.implies(s)) continue;
                    newScopes.add(t);
                }
                newScopes.removeAll(allScopes);
                allScopes.addAll(newScopes);
                processScopes.addAll(newScopes);
            }
            ArrayList<Dependency> rootDeps = new ArrayList<Dependency>();
            for (Scope s : allScopes) {
                GradleConfiguration cfg;
                String cfgName = SCOPE_TO_CONFIURATION.get(s);
                if (cfgName == null || (cfg = (GradleConfiguration)base.getConfigurations().get(cfgName)) == null) continue;
                this.scope = s;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Dependencies for configuration {0}: {1}", new Object[]{cfg, cfg.getDependencies()});
                }
                for (GradleDependency dep : cfg.getDependencies()) {
                    this.cfg = cfg.getDependencyOrigin(dep);
                    if (this.cfg == null) {
                        this.cfg = cfg;
                    }
                    List<Dependency> ch = this.processLevel(cfg, dep, new LinkedHashSet<GradleDependency>());
                    Dependency n = this.createDependency(dep, ch);
                    rootDeps.add(n);
                }
            }
            File f = nbgp.getGradleFiles().getProjectDir();
            FileObject fileObject = pf = f == null ? null : FileUtil.toFileObject((File)f);
            if (pf == null) {
                throw new ProjectOperationException(GradleDependenciesImplementation.this.project, ProjectOperationException.State.ERROR, Bundle.ERR_NoProjectDirectory(f));
            }
            ArtifactSpec part = this.createProjectArtifact(null, base.getPath(), rootDeps);
            ProjectSpec pspec = ProjectSpec.create((String)base.getPath(), (FileObject)pf);
            Dependency root = Dependency.create((ProjectSpec)pspec, (ArtifactSpec)part, null, rootDeps, (Object)GradleDependenciesImplementation.this.project);
            return new GradleDependencyResult(GradleDependenciesImplementation.this.project, root);
        }

        ArtifactSpec createProjectArtifact(GradleDependencyResult.Info info, String projectId, List<Dependency> children) {
            String[] split;
            ArtifactSpec spec = null;
            String gav = this.base.findProjectGav(projectId);
            if (gav != null && (split = GradleDependenciesImplementation.gavSplit(gav)) != null) {
                String v = split.length > 2 ? split[2] : null;
                boolean snap = v == null || v.toLowerCase().contains("snapshot-");
                ArtifactSpec artifactSpec = spec = snap ? ArtifactSpec.createSnapshotSpec((String)split[0], (String)split[1], null, null, (String)split[2], (boolean)false, null, (Object)info) : ArtifactSpec.createVersionSpec((String)split[0], (String)split[1], null, null, (String)split[2], (boolean)false, null, (Object)info);
            }
            if (spec == null && children != null && !children.isEmpty()) {
                spec = ArtifactSpec.createVersionSpec(null, (String)projectId, null, null, null, (boolean)false, null, (Object)info);
                Dependency ret = Dependency.create((ArtifactSpec)spec, (Scope)this.scope, children, (Object)info);
                if (info != null && info.gradleDependency != null) {
                    this.problems.add(ret);
                }
            }
            return spec;
        }

        Dependency createDependency(GradleDependency dep, List<Dependency> children) {
            FileObject file;
            GradleDependencyResult.Info info = new GradleDependencyResult.Info(this.cfg, dep);
            if (dep instanceof GradleDependency.UnresolvedDependency) {
                return null;
            }
            if (dep instanceof GradleDependency.ProjectDependency) {
                GradleDependency.ProjectDependency pd = (GradleDependency.ProjectDependency)dep;
                String projectId = pd.getId();
                File f = pd.getPath();
                FileObject fo = FileUtil.toFileObject((File)f);
                ArtifactSpec spec = null;
                if (fo != null && ProjectManager.getDefault().isProject(fo)) {
                    ProjectSpec pspec = ProjectSpec.create((String)projectId, (FileObject)fo);
                    return Dependency.create((ProjectSpec)pspec, spec, (Scope)this.scope, children, (Object)info);
                }
            }
            if (!(dep instanceof GradleDependency.ModuleDependency)) {
                if (children != null && !children.isEmpty()) {
                    ArtifactSpec spec = ArtifactSpec.createVersionSpec(null, (String)dep.getId(), null, null, null, (boolean)false, null, (Object)info);
                    Dependency ret = Dependency.create((ArtifactSpec)spec, (Scope)this.scope, children, (Object)info);
                    this.problems.add(ret);
                    return ret;
                }
                return null;
            }
            GradleDependency.ModuleDependency md = (GradleDependency.ModuleDependency)dep;
            boolean snap = md.getVersion().toLowerCase().contains("snapshot-");
            if (md.getArtifacts().size() == 1) {
                File f = (File)md.getArtifacts().iterator().next();
                FileObject cached = this.file2FileObject.get(f);
                if (cached == null) {
                    cached = FileUtil.toFileObject((File)f);
                    this.file2FileObject.put(f, cached != null ? cached : this.marker);
                }
                if (cached == this.marker) {
                    cached = null;
                }
                file = cached;
            } else {
                file = null;
            }
            ArtifactSpec spec = snap ? ArtifactSpec.createSnapshotSpec((String)md.getGroup(), (String)md.getName(), null, null, (String)md.getVersion(), (boolean)false, file, (Object)dep) : ArtifactSpec.createVersionSpec((String)md.getGroup(), (String)md.getName(), null, null, (String)md.getVersion(), (boolean)false, file, (Object)dep);
            Dependency ret = Dependency.create((ArtifactSpec)spec, (Scope)this.scope, children, (Object)info);
            return ret;
        }

        List<Dependency> processLevel(GradleConfiguration c, GradleDependency d, Set<GradleDependency> allParents) {
            if (this.counter > 100000) {
                LOG.log(Level.WARNING, "Potential dependency cycle for {0} (parents: {1}), abort!", new Object[]{d, allParents});
                return Collections.emptyList();
            }
            ++this.counter;
            Collection deps = c.getDependenciesOf(new GradleDependency[]{d});
            if (deps == null) {
                return Collections.emptyList();
            }
            ArrayList<Dependency> res = new ArrayList<Dependency>();
            if (!allParents.add(d)) {
                return res;
            }
            for (GradleDependency child : deps) {
                List<Dependency> grandChildren;
                Dependency n = this.createDependency(child, grandChildren = this.processLevel(c, child, allParents));
                if (n == null) continue;
                res.add(n);
            }
            allParents.remove(d);
            return res;
        }
    }
}

