/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class JavaSourceHelper {
    static final String CLASS_TEMPLATE = "Templates/Classes/Class.java";
    static final String INTERFACE_TEMPLATE = "Templates/Classes/Interface.java";
    static final String JAVA_EXT = "java";

    public static List<JavaSource> getJavaSources(Project project) {
        SourceGroup[] groups;
        ArrayList<JavaSource> result = new ArrayList<JavaSource>();
        for (SourceGroup group : groups = SourceGroupSupport.getJavaSourceGroups(project)) {
            FileObject root = group.getRootFolder();
            Enumeration files = root.getData(true);
            while (files.hasMoreElements()) {
                FileObject fobj = (FileObject)files.nextElement();
                if (!fobj.getExt().equals(JAVA_EXT)) continue;
                JavaSource source = JavaSource.forFileObject((FileObject)fobj);
                result.add(source);
            }
        }
        return result;
    }

    public static List<JavaSource> getEntityClasses(Project project) {
        List<JavaSource> sources = JavaSourceHelper.getJavaSources(project);
        ArrayList<JavaSource> entityClasses = new ArrayList<JavaSource>();
        for (JavaSource source : sources) {
            if (!JavaSourceHelper.isEntity(source)) continue;
            entityClasses.add(source);
        }
        return entityClasses;
    }

    public static boolean isEntity(JavaSource source) {
        final boolean[] isBoolean = new boolean[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    List<? extends AnnotationMirror> annotations = controller.getElements().getAllAnnotationMirrors(classElement);
                    for (AnnotationMirror annotationMirror : annotations) {
                        if (!annotationMirror.toString().equals("@javax.persistence.Entity")) continue;
                        isBoolean[0] = true;
                        break;
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return isBoolean[0];
    }

    public static String getClassNameQuietly(JavaSource source) {
        try {
            return JavaSourceHelper.getClassName(source);
        }
        catch (IOException ioe) {
            Logger.getLogger(JavaSourceHelper.class.getName()).log(Level.WARNING, ioe.getLocalizedMessage());
            return null;
        }
    }

    public static String getClassName(JavaSource source) throws IOException {
        TypeElement te = JavaSourceHelper.getTypeElement(source);
        if (te != null) {
            return te.getSimpleName().toString();
        }
        return null;
    }

    public static String getClassType(JavaSource source) throws IOException {
        return JavaSourceHelper.getTypeElement(source).getQualifiedName().toString();
    }

    public static String getPackageName(JavaSource source) {
        final String[] packageName = new String[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ExpressionTree packageTree = controller.getCompilationUnit().getPackageName();
                    packageName[0] = packageTree.toString();
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return packageName[0];
    }

    public static String getIdFieldName(JavaSource source) {
        final String[] fieldName = new String[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    List<VariableElement> fields = ElementFilter.fieldsIn(classElement.getEnclosedElements());
                    for (VariableElement field : fields) {
                        List<? extends AnnotationMirror> annotations = field.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : annotations) {
                            if (!annotationMirror.toString().equals("@javax.persistence.Id")) continue;
                            fieldName[0] = field.getSimpleName().toString();
                            return;
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return fieldName[0];
    }

    public static ClassTree getTopLevelClassTree(CompilationController controller) {
        String className = controller.getFileObject().getName();
        CompilationUnitTree cu = controller.getCompilationUnit();
        if (cu != null) {
            List<? extends Tree> decls = cu.getTypeDecls();
            for (Tree tree : decls) {
                ClassTree classTree;
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(className) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                return classTree;
            }
        }
        return null;
    }

    public static TypeElement getTopLevelClassElement(CompilationController controller) {
        ClassTree classTree = JavaSourceHelper.getTopLevelClassTree(controller);
        if (classTree == null) {
            return null;
        }
        Trees trees = controller.getTrees();
        TreePath path = trees.getPath(controller.getCompilationUnit(), classTree);
        return (TypeElement)trees.getElement(path);
    }

    public static Collection<String> getImports(CompilationController controller) {
        HashSet<String> imports = new HashSet<String>();
        CompilationUnitTree cu = controller.getCompilationUnit();
        if (cu != null) {
            List<? extends ImportTree> importTrees = cu.getImports();
            for (ImportTree importTree : importTrees) {
                imports.add(importTree.getQualifiedIdentifier().toString());
            }
        }
        return imports;
    }

    public static MethodTree getDefaultConstructor(CompilationController controller) {
        TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
        if (classElement == null) {
            return null;
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(classElement.getEnclosedElements());
        for (ExecutableElement constructor : constructors) {
            if (constructor.getParameters().size() != 0) continue;
            return controller.getTrees().getTree(constructor);
        }
        return null;
    }

    public static MethodTree getMethodByName(CompilationController controller, String methodName) {
        TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
        if (classElement == null) {
            return null;
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ArrayList<MethodTree> found = new ArrayList<MethodTree>();
        for (ExecutableElement method : methods) {
            if (!method.getSimpleName().toString().equals(methodName)) continue;
            found.add(controller.getTrees().getTree(method));
        }
        if (found.size() > 1) {
            throw new IllegalArgumentException("Unexpected overloading methods of '" + methodName + "' found.");
        }
        if (found.size() == 1) {
            return (MethodTree)found.get(0);
        }
        return null;
    }

    public static VariableTree getField(CompilationController controller, String fieldName) {
        TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
        if (classElement == null) {
            return null;
        }
        List<VariableElement> fields = ElementFilter.fieldsIn(classElement.getEnclosedElements());
        for (VariableElement field : fields) {
            if (!field.getSimpleName().toString().equals(fieldName)) continue;
            return (VariableTree)controller.getTrees().getTree(field);
        }
        return null;
    }

    public static JavaSource createJavaSource(FileObject targetFolder, String packageName, String className) {
        return JavaSourceHelper.createJavaSource(CLASS_TEMPLATE, targetFolder, packageName, className);
    }

    public static JavaSource createJavaSource(String template, FileObject targetFolder, String packageName, String className) {
        try {
            FileObject fobj = targetFolder.getFileObject(className, JAVA_EXT);
            if (fobj == null) {
                fobj = JavaSourceHelper.createDataObjectFromTemplate(template, targetFolder, packageName, className, null).getPrimaryFile();
            }
            return JavaSource.forFileObject((FileObject)fobj);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static JavaSource createJavaSource(String template, Map<String, String> params, FileObject targetFolder, String packageName, String className) {
        try {
            FileObject fobj = targetFolder.getFileObject(className, JAVA_EXT);
            if (fobj == null) {
                fobj = JavaSourceHelper.createDataObjectFromTemplate(template, targetFolder, packageName, className, params).getPrimaryFile();
            }
            return JavaSource.forFileObject((FileObject)fobj);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String packageName, String targetName, Map<String, String> params) throws IOException {
        assert (template != null);
        assert (targetFolder != null);
        assert (targetName != null && targetName.trim().length() > 0);
        FileObject templateFO = FileUtil.getConfigFile((String)template);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("package", packageName);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                parameters.put(entry.getKey(), entry.getValue());
            }
        }
        return templateDO.createFromTemplate(dataFolder, targetName, params);
    }

    public static void addClassAnnotation(WorkingCopy copy, String[] annotations, Object[] annotationAttrs) {
        TreeMaker maker = copy.getTreeMaker();
        ClassTree tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
        if (tree == null) {
            return;
        }
        ModifiersTree modifiers = tree.getModifiers();
        for (int i = 0; i < annotations.length; ++i) {
            List attrTrees = null;
            Object attr = annotationAttrs[i];
            if (attr != null) {
                attrTrees = new ArrayList();
                if (attr instanceof ExpressionTree) {
                    attrTrees.add((ExpressionTree)attr);
                } else {
                    attrTrees.add(maker.Literal(attr));
                }
            } else {
                attrTrees = Collections.emptyList();
            }
            AnnotationTree newAnnotation = maker.Annotation((Tree)maker.Identifier((CharSequence)annotations[i]), attrTrees);
            if (modifiers == null) continue;
            modifiers = maker.addModifiersAnnotation(modifiers, newAnnotation);
        }
        copy.rewrite((Tree)tree.getModifiers(), (Tree)modifiers);
    }

    public static void addImports(WorkingCopy copy, String[] imports) {
        CompilationUnitTree tree;
        Collection<String> existingImports = JavaSourceHelper.getImports((CompilationController)copy);
        TreeMaker maker = copy.getTreeMaker();
        CompilationUnitTree modifiedTree = tree = copy.getCompilationUnit();
        for (String imp : imports) {
            if (existingImports.contains(imp)) continue;
            modifiedTree = maker.addCompUnitImport(modifiedTree, maker.Import((Tree)maker.Identifier((CharSequence)imp), false));
        }
        copy.rewrite((Tree)tree, (Tree)modifiedTree);
    }

    public static ClassTree addField(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs, String name, Object type) {
        return JavaSourceHelper.addField(copy, tree, modifiers, annotations, annotationAttrs, name, type, null);
    }

    public static ClassTree addField(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs, String name, Object type, Object initialValue) {
        TreeMaker maker = copy.getTreeMaker();
        ClassTree modifiedTree = tree;
        ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, type);
        ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, annotations, annotationAttrs);
        LiteralTree init = initialValue == null ? null : maker.Literal(initialValue);
        VariableTree variableTree = maker.Variable(modifiersTree, (CharSequence)name, (Tree)typeTree, (ExpressionTree)init);
        return maker.insertClassMember(modifiedTree, 0, (Tree)variableTree);
    }

    public static void addFields(WorkingCopy copy, String[] names, Object[] types) {
        Object[] initValues = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Object type = types[i];
            initValues[i] = String.class.equals(type) || String.class.getName().equals(type) ? "" : (type instanceof Class && Number.class.isAssignableFrom((Class)type) ? Integer.valueOf(0) : null);
        }
        JavaSourceHelper.addFields(copy, names, types, initValues);
    }

    public static void addFields(WorkingCopy copy, String[] names, Object[] types, Object[] initialValues) {
        JavaSourceHelper.addFields(copy, names, types, initialValues, Constants.PRIVATE);
    }

    public static void addConstants(WorkingCopy copy, String[] names, Object[] types, Object[] initialValues) {
        JavaSourceHelper.addFields(copy, names, types, initialValues, Constants.PUBLIC_STATIC_FINAL);
    }

    public static void addFields(WorkingCopy copy, String[] names, Object[] types, Object[] initialValues, Modifier[] modifiers) {
        ClassTree classTree;
        TreeMaker maker = copy.getTreeMaker();
        ClassTree modifiedTree = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
        String[] annotations = new String[]{};
        Object[] annotationAttrs = new Object[]{};
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Object type = types[i];
            Object initialValue = initialValues[i];
            if (initialValue instanceof Enum) continue;
            ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, type);
            ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, annotations, annotationAttrs);
            LiteralTree init = initialValue == null ? null : maker.Literal(initialValue);
            VariableTree variableTree = maker.Variable(modifiersTree, (CharSequence)name, (Tree)typeTree, (ExpressionTree)init);
            modifiedTree = maker.insertClassMember(modifiedTree, 0, (Tree)variableTree);
        }
        copy.rewrite((Tree)classTree, (Tree)modifiedTree);
    }

    public static ClassTree addConstructor(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] parameters, Object[] paramTypes, String bodyText, String comment) {
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, null, null);
        ModifiersTree paramModTree = maker.Modifiers(Collections.emptySet());
        ArrayList<VariableTree> paramTrees = new ArrayList<VariableTree>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                paramTrees.add(maker.Variable(paramModTree, (CharSequence)parameters[i], (Tree)JavaSourceHelper.createTypeTree(copy, paramTypes[i]), null));
            }
        }
        MethodTree methodTree = maker.Constructor(modifiersTree, Collections.emptyList(), paramTrees, Collections.emptyList(), bodyText);
        if (comment != null) {
            maker.addComment((Tree)methodTree, JavaSourceHelper.createJavaDocComment(comment), true);
        }
        return maker.addClassMember(tree, (Tree)methodTree);
    }

    public static void replaceFieldValue(WorkingCopy copy, VariableTree tree, String value) {
        TreeMaker maker = copy.getTreeMaker();
        VariableTree modifiedTree = maker.Variable(tree.getModifiers(), (CharSequence)tree.getName(), tree.getType(), (ExpressionTree)maker.Literal((Object)value));
        copy.rewrite((Tree)tree, (Tree)modifiedTree);
    }

    public static void replaceMethodBody(WorkingCopy copy, MethodTree tree, String body) {
        TreeMaker maker = copy.getTreeMaker();
        MethodTree modifiedTree = maker.Method(tree.getModifiers(), (CharSequence)tree.getName(), tree.getReturnType(), tree.getTypeParameters(), tree.getParameters(), tree.getThrows(), body, null);
        copy.rewrite((Tree)tree, (Tree)modifiedTree);
    }

    public static ClassTree addMethod(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs, String name, Object returnType, String[] parameters, Object[] paramTypes, Object[] paramAnnotationsArray, Object[] paramAnnotationAttrsArray, String bodyText, String comment) {
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, annotations, annotationAttrs);
        ExpressionTree returnTypeTree = JavaSourceHelper.createTypeTree(copy, returnType);
        ArrayList<VariableTree> paramTrees = new ArrayList<VariableTree>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                ModifiersTree paramModTree = maker.Modifiers(Collections.emptySet());
                String[] paramAnnotations = null;
                Object[] paramAnnotationAttrs = null;
                if (paramAnnotationsArray != null && paramAnnotationsArray.length > 0) {
                    if (paramAnnotationsArray[i] instanceof String) {
                        paramAnnotations = new String[]{(String)paramAnnotationsArray[i]};
                        paramAnnotationAttrs = new Object[]{paramAnnotationAttrsArray[i]};
                    } else {
                        paramAnnotations = (String[])paramAnnotationsArray[i];
                        paramAnnotationAttrs = (Object[])paramAnnotationAttrsArray[i];
                    }
                    if (paramAnnotations != null) {
                        paramModTree = JavaSourceHelper.createModifiersTree(copy, new Modifier[0], paramAnnotations, paramAnnotationAttrs);
                    }
                }
                paramTrees.add(maker.Variable(paramModTree, (CharSequence)parameters[i], (Tree)JavaSourceHelper.createTypeTree(copy, paramTypes[i]), null));
            }
        }
        MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)name, (Tree)returnTypeTree, Collections.emptyList(), paramTrees, Collections.emptyList(), bodyText, null);
        if (comment != null) {
            maker.addComment((Tree)methodTree, JavaSourceHelper.createJavaDocComment(comment), true);
        }
        return maker.addClassMember(tree, (Tree)methodTree);
    }

    public static ClassTree createInnerClass(WorkingCopy copy, Modifier[] modifiers, String className, String classToExtend, String[] annotations, Object[] annotationAttributes) {
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, annotations, annotationAttributes);
        return maker.Class(modifiersTree, (CharSequence)className, Collections.emptyList(), JavaSourceHelper.createIdentifierTree(copy, classToExtend), Collections.emptyList(), Collections.emptyList());
    }

    public static ClassTree createInnerClass(WorkingCopy copy, Modifier[] modifiers, String className, String classToExtend) {
        return JavaSourceHelper.createInnerClass(copy, modifiers, className, classToExtend, null, null);
    }

    public static AssignmentTree createAssignmentTree(WorkingCopy copy, String variable, Object value) {
        TreeMaker maker = copy.getTreeMaker();
        return maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)variable), (ExpressionTree)maker.Literal(value));
    }

    public static ExpressionTree createTypeTree(WorkingCopy copy, Object type) {
        if (type instanceof String) {
            TypeElement element = copy.getElements().getTypeElement((String)type);
            if (element != null) {
                return copy.getTreeMaker().QualIdent((Element)element);
            }
            return copy.getTreeMaker().Identifier((CharSequence)((String)type));
        }
        return (ExpressionTree)type;
    }

    public static Tree createIdentifierTree(WorkingCopy copy, String value) {
        return copy.getTreeMaker().Identifier((CharSequence)value);
    }

    public static Tree createParameterizedTypeTree(WorkingCopy copy, String type, String[] typeArgs) {
        TreeMaker maker = copy.getTreeMaker();
        ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, type);
        ArrayList<ExpressionTree> typeArgTrees = new ArrayList<ExpressionTree>();
        for (String arg : typeArgs) {
            typeArgTrees.add(JavaSourceHelper.createTypeTree(copy, arg));
        }
        return maker.ParameterizedType((Tree)typeTree, typeArgTrees);
    }

    public static ModifiersTree createModifiersTree(WorkingCopy copy, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs) {
        TreeMaker maker = copy.getTreeMaker();
        EnumSet<Modifier> modifierSet = EnumSet.noneOf(Modifier.class);
        modifierSet.addAll(Arrays.asList(modifiers));
        List<AnnotationTree> annotationTrees = JavaSourceHelper.createAnnotationTrees(copy, annotations, annotationAttrs);
        return maker.Modifiers(modifierSet, annotationTrees);
    }

    private static List<AnnotationTree> createAnnotationTrees(WorkingCopy copy, String[] annotations, Object[] annotationAttrs) {
        TreeMaker maker = copy.getTreeMaker();
        List<AnnotationTree> annotationTrees = null;
        if (annotations != null) {
            annotationTrees = new ArrayList();
            for (int i = 0; i < annotations.length; ++i) {
                Object attr;
                String annotation = annotations[i];
                List expressionTrees = Collections.emptyList();
                if (annotationAttrs != null && (attr = annotationAttrs[i]) != null) {
                    expressionTrees = new ArrayList();
                    if (attr instanceof ExpressionTree) {
                        expressionTrees.add((ExpressionTree)attr);
                    } else {
                        expressionTrees.add(maker.Literal(attr));
                    }
                }
                annotationTrees.add(maker.Annotation((Tree)maker.Identifier((CharSequence)annotation), expressionTrees));
            }
        } else {
            annotationTrees = Collections.emptyList();
        }
        return annotationTrees;
    }

    private static Comment createJavaDocComment(String text) {
        return Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)text);
    }

    public static ClassTree findPublicTopLevelClass(CompilationController controller) throws IOException {
        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        String mainElementName = controller.getFileObject().getName();
        for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
            ClassTree classTree;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(mainElementName) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
            return classTree;
        }
        return null;
    }

    public static boolean isInjectionTarget(CompilationController controller) throws IOException {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        ClassTree classTree = JavaSourceHelper.findPublicTopLevelClass(controller);
        if (classTree == null) {
            throw new IllegalArgumentException();
        }
        return JavaSourceHelper.isInjectionTarget(controller, JavaSourceHelper.getTypeElement(controller, classTree));
    }

    public static boolean isInjectionTarget(CompilationController controller, TypeElement typeElement) {
        if (ElementKind.INTERFACE != typeElement.getKind()) {
            List<? extends AnnotationMirror> annotations = typeElement.getAnnotationMirrors();
            boolean found = false;
            for (AnnotationMirror annotationMirror : annotations) {
                Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                if (qualifiedName.contentEquals("javax.jws.WebService")) {
                    found = true;
                    break;
                }
                if (!qualifiedName.contentEquals("javax.jws.WebServiceProvider")) continue;
                found = true;
                break;
            }
            if (found) {
                return true;
            }
        }
        return false;
    }

    public static TypeElement getTypeElement(CompilationController controller, ClassTree classTree) {
        TreePath classTreePath = controller.getTrees().getPath(controller.getCompilationUnit(), classTree);
        return (TypeElement)controller.getTrees().getElement(classTreePath);
    }

    public static TypeElement getTypeElement(CompilationController controller, TreePath treePath) {
        return (TypeElement)controller.getTrees().getElement(treePath);
    }

    public static ClassTree getClassTree(CompilationController controller, TypeElement typeElement) {
        return controller.getTrees().getTree(typeElement);
    }

    public static void saveSource(FileObject[] files) throws IOException {
        for (FileObject f : files) {
            try {
                DataObject dobj = DataObject.find((FileObject)f);
                SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                if (sc == null) continue;
                sc.save();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static boolean isOfAnnotationType(AnnotationMirror am, String annotationType) {
        return annotationType.equals(am.toString().substring(1));
    }

    public static AnnotationMirror findAnnotation(List<? extends AnnotationMirror> anmirs, String annotationString) {
        for (AnnotationMirror annotationMirror : anmirs) {
            if (!JavaSourceHelper.isOfAnnotationType(annotationMirror, annotationString)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean annotationHasAttributeValue(AnnotationMirror am, String attr, String value) {
        return value.equals(am.getElementValues().get(attr).getValue());
    }

    public static boolean annotationHasAttributeValue(AnnotationMirror am, String value) {
        if (am != null) {
            for (AnnotationValue annotationValue : am.getElementValues().values()) {
                if (!value.equals(annotationValue.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeElement getXmlRepresentationClass(TypeElement typeElement, String defaultSuffix) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement method : methods) {
            TypeElement returnType;
            TypeMirror tm;
            List<? extends AnnotationMirror> anmirs = method.getAnnotationMirrors();
            AnnotationMirror mirrorHttpMethod = JavaSourceHelper.findAnnotation(anmirs, "javax.ws.rs.GET");
            if (mirrorHttpMethod == null || (tm = method.getReturnType()) == null || tm.getKind() != TypeKind.DECLARED || !(returnType = (TypeElement)((DeclaredType)tm).asElement()).getSimpleName().toString().endsWith(defaultSuffix)) continue;
            return returnType;
        }
        return null;
    }

    public static TypeElement getTypeElement(JavaSource source) throws IOException {
        final TypeElement[] results = new TypeElement[1];
        source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                results[0] = JavaSourceHelper.getTopLevelClassElement(controller);
            }
        }, true);
        return results[0];
    }

    public static JavaSource forTypeElement(TypeElement typeElement, Project project) throws IOException {
        for (JavaSource js : JavaSourceHelper.getJavaSources(project)) {
            String className = JavaSourceHelper.getClassType(js);
            if (!typeElement.getQualifiedName().contentEquals(className)) continue;
            return js;
        }
        return null;
    }

    public static List<? extends AnnotationMirror> getClassAnnotations(JavaSource source) {
        final List[] classAnons = new List[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    classAnons[0] = controller.getElements().getAllAnnotationMirrors(classElement);
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return classAnons[0];
    }

    public static List<? extends Tree> getAllTree(JavaSource source) {
        final List[] allTree = new List[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    CompilationUnitTree cu = controller.getCompilationUnit();
                    if (cu != null) {
                        allTree[0] = cu.getTypeDecls();
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return allTree[0];
    }

    public static List<MethodTree> getAllMethods(JavaSource source) {
        final ArrayList<MethodTree> allMethods = new ArrayList<MethodTree>();
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                    for (ExecutableElement method : methods) {
                        allMethods.add(controller.getTrees().getTree(method));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return allMethods;
    }

    public static Collection<String> getAnnotationValuesForAllMethods(JavaSource source, final String annotation) {
        final HashSet<String> results = new HashSet<String>();
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                    for (ExecutableElement method : methods) {
                        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotation)) continue;
                            for (AnnotationValue annotationValue : annotationMirror.getElementValues().values()) {
                                results.add(annotationValue.getValue().toString());
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return results;
    }

    public static long[] getPosition(JavaSource source, final String methodName) {
        final long[] position = new long[]{0L, 0L};
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    CompilationUnitTree tree = controller.getCompilationUnit();
                    Trees trees = controller.getTrees();
                    Parameterizable element = null;
                    if (methodName == null) {
                        element = classElement;
                    } else {
                        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                        for (ExecutableElement method : methods) {
                            if (!method.getSimpleName().toString().equals(methodName)) continue;
                            element = method;
                            break;
                        }
                    }
                    if (element != null) {
                        Tree elementTree = trees.getTree(element);
                        long pos = trees.getSourcePositions().getStartPosition(tree, elementTree);
                        position[0] = tree.getLineMap().getLineNumber(pos) - 1L;
                        position[1] = tree.getLineMap().getColumnNumber(pos) - 1L;
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return position;
    }

    public static ExecutableElement getLongestContructor(JavaSource source) throws IOException {
        return JavaSourceHelper.getLongestContructor(JavaSourceHelper.getTypeElement(source));
    }

    public static ExecutableElement getLongestContructor(TypeElement typeElement) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        int max = -1;
        ExecutableElement current = null;
        for (ExecutableElement constructor : constructors) {
            if (constructor.getParameters().size() <= max) continue;
            max = constructor.getParameters().size();
            current = constructor;
        }
        return current;
    }
}

