/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api.ant.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.javaee.project.api.ant.ui.wizard.J2eeVersionWarningPanel;
import org.netbeans.modules.javaee.project.api.ant.ui.wizard.ProjectImportLocationPanel;
import org.netbeans.modules.javaee.project.api.ant.ui.wizard.ProjectLocationPanel;
import org.netbeans.modules.javaee.project.api.ant.ui.wizard.ProjectServerWizardPanel;
import org.netbeans.modules.javaee.project.api.ui.UserProjectSettings;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ProjectServerPanel
extends JPanel
implements DocumentListener {
    private ProjectServerWizardPanel wizard;
    private boolean contextModified = false;
    private final DefaultComboBoxModel<ServerInstanceWrapper> serversModel = new DefaultComboBoxModel();
    private J2eeVersionWarningPanel warningPanel;
    private boolean sharableProject;
    private List<Project> earProjects;
    private final J2eeModule.Type j2eeModuleType;
    private File projectLocation;
    private boolean importScenario;
    private BigDecimal xmlVersion;
    private boolean firstTimeOnly = true;
    private JButton addServerButton;
    private JCheckBox cdiCheckbox;
    private JCheckBox createCarCheckBox;
    private JCheckBox createEjbCheckBox;
    private JCheckBox createWARCheckBox;
    private JComboBox j2eeSpecComboBox;
    private JLabel j2eeSpecLabel;
    private JComboBox jComboBoxEnterprise;
    private JLabel jLabelContextPath;
    private JLabel jLabelEnterprise;
    private JTextField jTextFieldCarName;
    protected JTextField jTextFieldContextPath;
    private JTextField jTextFieldEjbModuleName;
    private JTextField jTextFieldWebAppName;
    private JLabel mainClassLabel;
    private JLabel mainClassLabel1;
    private JTextField mainClassTextField;
    private JTextField mainClassTextFieldWithinEar;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;
    private JCheckBox serverLibraryCheckbox;
    private JPanel warningPlaceHolderPanel;

    @Deprecated
    public ProjectServerPanel(Object j2eeModuleType, String name, String title, ProjectServerWizardPanel wizard, boolean showAddToEar, boolean mainAppClientClass, boolean showContextPath, boolean createProjects, boolean importScenario) {
        this(J2eeModule.Type.fromJsrType((Object)j2eeModuleType), name, title, wizard, showAddToEar, mainAppClientClass, showContextPath, createProjects, importScenario);
    }

    public ProjectServerPanel(J2eeModule.Type j2eeModuleType, String name, String title, ProjectServerWizardPanel wizard, boolean showAddToEar, boolean mainAppClientClass, boolean showContextPath, boolean createProjects, boolean importScenario) {
        this.importScenario = importScenario;
        this.initComponents();
        this.setJ2eeVersionWarningPanel();
        this.wizard = wizard;
        this.j2eeModuleType = j2eeModuleType;
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
        this.initEnterpriseApplications();
        this.setName(name);
        this.putClientProperty("NewProjectWizard_Title", title);
        this.jLabelEnterprise.setVisible(showAddToEar);
        this.jComboBoxEnterprise.setVisible(showAddToEar);
        this.jLabelContextPath.setVisible(showContextPath);
        this.jTextFieldContextPath.setVisible(showContextPath);
        this.mainClassLabel.setVisible(mainAppClientClass);
        this.mainClassTextField.setVisible(mainAppClientClass);
        this.createCarCheckBox.setVisible(false);
        this.createEjbCheckBox.setVisible(createProjects);
        this.createWARCheckBox.setVisible(createProjects);
        this.jTextFieldCarName.setVisible(false);
        this.jTextFieldEjbModuleName.setVisible(createProjects);
        this.jTextFieldWebAppName.setVisible(createProjects);
        this.mainClassLabel1.setVisible(false);
        this.mainClassTextFieldWithinEar.setVisible(false);
        this.jTextFieldCarName.getDocument().addDocumentListener(this);
        this.jTextFieldEjbModuleName.getDocument().addDocumentListener(this);
        this.jTextFieldWebAppName.getDocument().addDocumentListener(this);
        this.mainClassTextFieldWithinEar.getDocument().addDocumentListener(this);
        this.mainClassTextField.getDocument().addDocumentListener(this);
        this.jTextFieldContextPath.getDocument().addDocumentListener(this);
        this.serverLibraryCheckbox.setVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.firstTimeOnly) {
            this.firstTimeOnly = false;
            this.initServers(UserProjectSettings.getDefault().getLastUsedServer());
        }
    }

    private void initComponents() {
        this.jLabelEnterprise = new JLabel();
        this.jComboBoxEnterprise = new JComboBox();
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.addServerButton = new JButton();
        this.j2eeSpecLabel = new JLabel();
        this.j2eeSpecComboBox = new JComboBox();
        this.jLabelContextPath = new JLabel();
        this.warningPlaceHolderPanel = new JPanel();
        this.jTextFieldContextPath = new JTextField();
        this.mainClassLabel = new JLabel();
        this.mainClassTextField = new JTextField();
        this.createEjbCheckBox = new JCheckBox();
        this.jTextFieldEjbModuleName = new JTextField();
        this.createWARCheckBox = new JCheckBox();
        this.jTextFieldWebAppName = new JTextField();
        this.createCarCheckBox = new JCheckBox();
        this.jTextFieldCarName = new JTextField();
        this.mainClassLabel1 = new JLabel();
        this.mainClassTextFieldWithinEar = new JTextField();
        this.serverLibraryCheckbox = new JCheckBox();
        this.cdiCheckbox = new JCheckBox();
        this.jLabelEnterprise.setLabelFor(this.jComboBoxEnterprise);
        Mnemonics.setLocalizedText((JLabel)this.jLabelEnterprise, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_AddToEnterprise_Label"));
        this.serverInstanceLabel.setLabelFor(this.serverInstanceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverInstanceLabel, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_Server"));
        this.serverInstanceComboBox.setModel(this.serversModel);
        this.serverInstanceComboBox.setPrototypeDisplayValue("The Gr8est Marvelous Nr. 1 Server");
        this.serverInstanceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectServerPanel.this.serverInstanceComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addServerButton, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_AddServer"));
        this.addServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectServerPanel.this.addServerButtonActionPerformed(evt);
            }
        });
        this.j2eeSpecLabel.setLabelFor(this.j2eeSpecComboBox);
        Mnemonics.setLocalizedText((JLabel)this.j2eeSpecLabel, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_J2EESpecLevel_Label"));
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectServerPanel.this.j2eeSpecComboBoxActionPerformed(evt);
            }
        });
        this.jLabelContextPath.setLabelFor(this.jTextFieldContextPath);
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPath, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_ContextPath_Label"));
        this.warningPlaceHolderPanel.setBackground(new Color(0, 153, 102));
        this.warningPlaceHolderPanel.setLayout(new BorderLayout());
        this.jTextFieldContextPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProjectServerPanel.this.jTextFieldContextPathKeyReleased(evt);
            }
        });
        this.mainClassLabel.setLabelFor(this.mainClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.mainClassLabel, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NWP1_MainClass_Label"));
        this.mainClassLabel.setAlignmentX(0.5f);
        this.mainClassTextField.setText("com.myapp.Main");
        this.createEjbCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createEjbCheckBox, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NEAP_CreateEjbModule"));
        this.createEjbCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectServerPanel.this.createEjbCheckBox_action(evt);
            }
        });
        this.createWARCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createWARCheckBox, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NEAP_CreatWebAppModule"));
        this.createWARCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectServerPanel.this.createWARCheckBoxcreateWebAppCheckBox_action(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.createCarCheckBox, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NEAP_CreateCarModule"));
        this.createCarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectServerPanel.this.createCarCheckBox_action(evt);
            }
        });
        this.jTextFieldCarName.setEnabled(false);
        this.mainClassLabel1.setLabelFor(this.mainClassTextFieldWithinEar);
        Mnemonics.setLocalizedText((JLabel)this.mainClassLabel1, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NWP1_MainClass_Label"));
        this.mainClassTextFieldWithinEar.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.serverLibraryCheckbox, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"PanelSharabilityVisual.serverLibraryCheckbox.text"));
        this.serverLibraryCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.serverLibraryCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectServerPanel.this.serverLibraryCheckboxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cdiCheckbox, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"PanelSharabilityVisual.cdiCheckbox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mainClassLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createCarCheckBox).addComponent(this.createEjbCheckBox).addComponent(this.createWARCheckBox)).addComponent(this.mainClassLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldEjbModuleName).addComponent(this.jTextFieldWebAppName).addComponent(this.jTextFieldCarName).addComponent(this.mainClassTextFieldWithinEar)).addGap(74, 74, 74)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelEnterprise).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxEnterprise, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelContextPath).addComponent(this.serverInstanceLabel).addComponent(this.j2eeSpecLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.warningPlaceHolderPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.serverInstanceComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addServerButton)).addGroup(layout.createSequentialGroup().addComponent(this.j2eeSpecComboBox, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.serverLibraryCheckbox, -2, 377, Short.MAX_VALUE).addComponent(this.cdiCheckbox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainClassTextField).addComponent(this.jTextFieldContextPath)).addGap(74, 74, 74)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelEnterprise).addComponent(this.jComboBoxEnterprise, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverInstanceLabel).addComponent(this.addServerButton).addComponent(this.serverInstanceComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverLibraryCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.j2eeSpecLabel).addComponent(this.j2eeSpecComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cdiCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningPlaceHolderPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelContextPath).addComponent(this.jTextFieldContextPath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainClassLabel).addComponent(this.mainClassTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldEjbModuleName, -2, -1, -2).addComponent(this.createEjbCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldWebAppName, -2, -1, -2).addComponent(this.createWARCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createCarCheckBox).addComponent(this.jTextFieldCarName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainClassLabel1).addComponent(this.mainClassTextFieldWithinEar, -2, -1, -2))));
        this.jLabelEnterprise.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jComboBoxEnterprise.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.serverInstanceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.addServerButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"ASCN_AddServer"));
        this.addServerButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.j2eeSpecLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jLabelContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.warningPlaceHolderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.warningPlaceHolderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.createEjbCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldEjbModuleName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NEAP_CreateEjbModule"));
        this.jTextFieldEjbModuleName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.createWARCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldWebAppName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NEAP_CreatWebAppModule"));
        this.jTextFieldWebAppName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.createCarCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldCarName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NEAP_CreateCarModule"));
        this.jTextFieldCarName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassTextFieldWithinEar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.serverLibraryCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.cdiCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
    }

    private void addServerButtonActionPerformed(ActionEvent evt) {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        String selectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            selectedServerInstanceID = serverInstanceWrapper.getServerInstanceID();
        }
        ProfileItem lastSelectedJ2eeProfile = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("suggested-name", (String)this.wizard.wizardDescriptor.getProperty("name"));
        String newServerInstanceID = ServerManager.showAddServerInstanceWizard(props);
        if (newServerInstanceID != null) {
            selectedServerInstanceID = newServerInstanceID;
            lastSelectedJ2eeProfile = null;
            this.j2eeSpecComboBox.setSelectedItem(null);
        }
        this.initServers(selectedServerInstanceID);
        if (lastSelectedJ2eeProfile != null) {
            this.j2eeSpecComboBox.setSelectedItem(lastSelectedJ2eeProfile);
        }
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent evt) {
        this.setJ2eeVersionWarningPanel();
    }

    private void serverInstanceComboBoxActionPerformed(ActionEvent evt) {
        ProfileItem prevSelectedItem = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        this.j2eeSpecComboBox.removeAllItems();
        if (serverInstanceWrapper != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceWrapper.getServerInstanceID()).getJ2eePlatform();
                TreeSet profiles = new TreeSet(Profile.UI_COMPARATOR);
                profiles.addAll(j2eePlatform.getSupportedProfiles(this.j2eeModuleType));
                for (Profile profile : profiles) {
                    if (Profile.J2EE_13.equals((Object)profile) || Profile.J2EE_14.equals((Object)profile) || (this.j2eeModuleType == J2eeModule.Type.WAR ? Profile.JAVA_EE_6_FULL.equals((Object)profile) || Profile.JAVA_EE_7_FULL.equals((Object)profile) || Profile.JAVA_EE_8_FULL.equals((Object)profile) || Profile.JAKARTA_EE_8_FULL.equals((Object)profile) || Profile.JAKARTA_EE_9_FULL.equals((Object)profile) || Profile.JAKARTA_EE_9_1_FULL.equals((Object)profile) || Profile.JAKARTA_EE_10_FULL.equals((Object)profile) : Profile.JAVA_EE_6_WEB.equals((Object)profile) || Profile.JAVA_EE_7_WEB.equals((Object)profile) || Profile.JAVA_EE_8_WEB.equals((Object)profile) || Profile.JAKARTA_EE_8_WEB.equals((Object)profile) || Profile.JAKARTA_EE_9_WEB.equals((Object)profile) || Profile.JAKARTA_EE_9_1_WEB.equals((Object)profile) || Profile.JAKARTA_EE_10_WEB.equals((Object)profile))) continue;
                    this.j2eeSpecComboBox.addItem(new ProfileItem(profile));
                }
                if (prevSelectedItem != null) {
                    this.j2eeSpecComboBox.setSelectedItem(prevSelectedItem);
                }
            }
            catch (InstanceRemovedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.wizard.fireChangeEvent();
    }

    private void jTextFieldContextPathKeyReleased(KeyEvent evt) {
        this.contextModified = true;
    }

    private void createEjbCheckBox_action(ActionEvent evt) {
        this.jTextFieldEjbModuleName.setEnabled(this.createEjbCheckBox.isSelected());
        this.wizard.fireChangeEvent();
    }

    private void createWARCheckBoxcreateWebAppCheckBox_action(ActionEvent evt) {
        this.jTextFieldWebAppName.setEnabled(this.createWARCheckBox.isSelected());
        this.wizard.fireChangeEvent();
    }

    private void createCarCheckBox_action(ActionEvent evt) {
        this.jTextFieldCarName.setEnabled(this.createCarCheckBox.isSelected());
        this.mainClassTextFieldWithinEar.setEnabled(this.createCarCheckBox.isSelected());
        this.wizard.fireChangeEvent();
    }

    private void serverLibraryCheckboxActionPerformed(ActionEvent evt) {
        this.wizard.fireChangeEvent();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        Profile selectedProfile;
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        if (this.getSelectedServer() == null) {
            String errMsg = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_NoServer");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errMsg);
            return false;
        }
        if (this.isSharableProject() && this.serverLibraryCheckbox.isEnabled() && this.serverLibraryCheckbox.isSelected()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectServerPanel.class, (String)"PanelSharability.licenseWarning.text")));
        }
        if ((selectedProfile = this.getSelectedJ2eeProfile()) == null) {
            ProjectServerPanel.setErrorMessage("ERROR_EnterpriseLevelOfYourServerIsNotSupported", wizardDescriptor);
            return false;
        }
        if (J2eeModule.Type.EJB.equals(this.j2eeModuleType)) {
            this.setJ2eeVersionWarning(wizardDescriptor);
        }
        if (J2eeModule.Type.CAR.equals(this.j2eeModuleType) && !this.isMainClassValid(this.mainClassTextField.getText())) {
            ProjectServerPanel.setErrorMessage("ERROR_IllegalMainClassName", wizardDescriptor);
            return false;
        }
        if (J2eeModule.Type.EAR.equals(this.j2eeModuleType)) {
            String jarName;
            if (this.createWARCheckBox.isSelected()) {
                String warName = this.jTextFieldWebAppName.getText();
                if (warName.length() < 1) {
                    ProjectServerPanel.setErrorMessage("MSG_NoWARName", wizardDescriptor);
                    return false;
                }
                if (!warName.endsWith("-war")) {
                    ProjectServerPanel.setErrorMessage("MSG_WARNameNotBlueprints", wizardDescriptor);
                }
            }
            if (this.createEjbCheckBox.isSelected()) {
                jarName = this.jTextFieldEjbModuleName.getText();
                if (jarName.length() < 1) {
                    ProjectServerPanel.setErrorMessage("MSG_NoJARName", wizardDescriptor);
                    return false;
                }
                if (!jarName.endsWith("-ejb")) {
                    ProjectServerPanel.setErrorMessage("MSG_JARNameNotBlueprints", wizardDescriptor);
                }
            }
            if (this.createCarCheckBox.isSelected()) {
                jarName = this.jTextFieldCarName.getText();
                if (jarName.length() < 1) {
                    ProjectServerPanel.setErrorMessage("MSG_NoCARName", wizardDescriptor);
                    return false;
                }
                if (!this.isMainClassValid(this.mainClassTextFieldWithinEar.getText())) {
                    ProjectServerPanel.setErrorMessage("ERROR_IllegalMainClassName", wizardDescriptor);
                    return false;
                }
                if (!jarName.endsWith("-app-client")) {
                    ProjectServerPanel.setErrorMessage("MSG_CARNameNotBlueprints", wizardDescriptor);
                }
            }
        }
        return true;
    }

    private boolean isMainClassValid(String mainClassName) {
        boolean valid;
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean bl = valid = tk.countTokens() > 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    private static void setErrorMessage(String errMsgKey, WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectServerPanel.class, (String)errMsgKey));
    }

    private boolean isSharableProject() {
        return this.sharableProject;
    }

    void store(WizardDescriptor d) {
        String serverInstanceId = this.getSelectedServer();
        d.putProperty("serverInstanceID", (Object)serverInstanceId);
        Profile j2ee = this.getSelectedJ2eeProfile();
        d.putProperty("j2eeLevel", (Object)j2ee);
        d.putProperty("contextPath", (Object)this.jTextFieldContextPath.getText().trim());
        d.putProperty("earApplication", (Object)this.getSelectedEarApplication());
        d.putProperty("warName", (Object)this.jTextFieldWebAppName.getText());
        d.putProperty("jarName", (Object)this.jTextFieldEjbModuleName.getText());
        d.putProperty("carName", (Object)this.jTextFieldCarName.getText());
        d.putProperty("mainClass", (Object)(J2eeModule.Type.CAR.equals(this.j2eeModuleType) ? this.mainClassTextField.getText().trim() : this.mainClassTextFieldWithinEar.getText().trim()));
        d.putProperty("createWAR", (Object)(this.createWARCheckBox.isVisible() ? this.createWARCheckBox.isSelected() : false));
        d.putProperty("createJAR", (Object)(this.createEjbCheckBox.isVisible() ? this.createEjbCheckBox.isSelected() : false));
        d.putProperty("createCAR", (Object)(this.createCarCheckBox.isVisible() ? this.createCarCheckBox.isSelected() : false));
        d.putProperty("cdi", (Object)(this.cdiCheckbox.isVisible() && this.cdiCheckbox.isSelected() ? 1 : 0));
        d.putProperty("setSourceLevel", (Object)this.getSourceLevel(d, serverInstanceId, j2ee));
    }

    private String getSourceLevel(WizardDescriptor d, String serverInstanceId, Profile j2ee) {
        Specification spec;
        String sourceLevel = JavaPlatform.getDefault().getSpecification().getVersion().toString();
        if (this.warningPanel != null && this.warningPlaceHolderPanel.isVisible() && (spec = this.warningPanel.getSuggestedJavaPlatformSpecification()) != null) {
            sourceLevel = spec.getVersion().toString();
        }
        if (serverInstanceId != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceId).getJ2eePlatform();
                Set jdks = j2eePlatform.getSupportedJavaPlatformVersions();
                if (jdks != null && !jdks.contains(sourceLevel)) {
                    if ("11".equals(sourceLevel) && jdks.contains("1.8")) {
                        sourceLevel = "1.8";
                    } else if ("1.8".equals(sourceLevel) && jdks.contains("1.7")) {
                        sourceLevel = "1.7";
                    } else if ("1.7".equals(sourceLevel) && jdks.contains("1.6")) {
                        sourceLevel = "1.6";
                    } else if ("1.6".equals(sourceLevel) && jdks.contains("1.5")) {
                        sourceLevel = "1.5";
                    }
                }
            }
            catch (InstanceRemovedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.warningPanel != null && this.warningPlaceHolderPanel.isVisible()) {
            String warningType;
            d.putProperty("setJavaPlatform", (Object)this.warningPanel.getSuggestedJavaPlatformName());
            if (j2ee != null && (warningType = this.warningPanel.getWarningType()) != null) {
                switch (warningType) {
                    case "warnSetSourceLevel11": {
                        sourceLevel = "11";
                        break;
                    }
                    case "warnSetSourceLevel8": {
                        sourceLevel = "1.8";
                        break;
                    }
                    case "warnSetSourceLevel7": {
                        sourceLevel = "1.7";
                        break;
                    }
                    case "warnSetSourceLevel6": {
                        sourceLevel = "1.6";
                        break;
                    }
                    case "warnSetSourceLevel15": {
                        sourceLevel = "1.5";
                        break;
                    }
                }
            }
        } else {
            d.putProperty("setJavaPlatform", (Object)JavaPlatform.getDefault().getDisplayName());
        }
        return sourceLevel;
    }

    private String getServerLibraryName() {
        if (!this.serverLibraryCheckbox.isSelected() || !this.serverLibraryCheckbox.isEnabled()) {
            return null;
        }
        Deployment deployment = Deployment.getDefault();
        String name = deployment.getServerDisplayName(deployment.getServerID(this.getSelectedServer()));
        return name == null ? "" : PropertyUtils.getUsablePropertyName((String)name);
    }

    void read(WizardDescriptor d) {
        if (!this.isContextModified()) {
            this.jTextFieldContextPath.setText(ProjectServerPanel.createDefaultContext((String)d.getProperty("name")));
        }
        this.sharableProject = d.getProperty("sharedLibraries") != null;
        this.serverLibraryCheckbox.setEnabled(this.isSharableProject());
        if (!this.serverLibraryCheckbox.isEnabled()) {
            this.serverLibraryCheckbox.setSelected(false);
        }
        this.projectLocation = (File)d.getProperty("projdir");
        if (J2eeModule.Type.EJB.equals(this.j2eeModuleType)) {
            this.updateJ2EEVersion("ejb-jar.xml");
        }
        if (J2eeModule.Type.CAR.equals(this.j2eeModuleType)) {
            this.initClientAppMainClass((String)d.getProperty("name"));
            this.updateJ2EEVersion("application-client.xml");
        }
        if (J2eeModule.Type.EAR.equals(this.j2eeModuleType)) {
            String newProjectName = (String)d.getProperty("name");
            this.initClientAppMainClass(newProjectName);
            this.jTextFieldEjbModuleName.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_EJBProjectName"), newProjectName));
            this.jTextFieldWebAppName.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_WebAppProjectName"), newProjectName));
            this.jTextFieldCarName.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_AppClientProjectName"), newProjectName));
        }
    }

    private static String createDefaultContext(String projectName) {
        return "/" + (projectName != null ? PropertyUtils.getUsablePropertyName((String)projectName) : "");
    }

    private void initServers(String selectedServerInstanceID) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> servers = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper selectedItem = null;
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            try {
                ServerInstance si = Deployment.getDefault().getServerInstance(serverInstanceID);
                String displayName = si.getDisplayName();
                J2eePlatform j2eePlatform = si.getJ2eePlatform();
                if (displayName == null || j2eePlatform == null || !j2eePlatform.getSupportedTypes().contains(this.j2eeModuleType)) continue;
                ServerInstanceWrapper serverWrapper = new ServerInstanceWrapper(serverInstanceID, displayName);
                if (selectedItem == null && selectedServerInstanceID != null && selectedServerInstanceID.equals(serverInstanceID)) {
                    selectedItem = serverWrapper;
                }
                servers.add(serverWrapper);
            }
            catch (InstanceRemovedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        for (ServerInstanceWrapper item : servers) {
            this.serversModel.addElement(item);
        }
        if (selectedItem != null) {
            this.serversModel.setSelectedItem(selectedItem);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
    }

    private Profile getSelectedJ2eeProfile() {
        ProfileItem item = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        return item == null ? null : item.getProfile();
    }

    private String getSelectedServer() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    protected boolean isContextModified() {
        return this.contextModified;
    }

    private Project getSelectedEarApplication() {
        int idx = this.jComboBoxEnterprise.getSelectedIndex();
        return idx <= 0 ? null : this.earProjects.get(idx - 1);
    }

    private void initEnterpriseApplications() {
        this.jComboBoxEnterprise.addItem(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_AddToEnterprise_None"));
        this.jComboBoxEnterprise.setSelectedIndex(0);
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        this.earProjects = new ArrayList<Project>();
        for (int i = 0; i < allProjects.length; ++i) {
            J2eeApplicationProvider j2eeAppProvider = (J2eeApplicationProvider)allProjects[i].getLookup().lookup(J2eeApplicationProvider.class);
            if (j2eeAppProvider == null || AntArtifactQuery.findArtifactsByType((Project)allProjects[i], (String)"ear").length == 0) continue;
            J2eeApplication j2eeApplication = (J2eeApplication)j2eeAppProvider.getJ2eeModule();
            ProjectInformation projectInfo = ProjectUtils.getInformation((Project)allProjects[i]);
            if (j2eeApplication == null) continue;
            this.earProjects.add(projectInfo.getProject());
            this.jComboBoxEnterprise.addItem(projectInfo.getDisplayName());
        }
        if (this.earProjects.size() <= 0) {
            this.jComboBoxEnterprise.setEnabled(false);
        }
    }

    private void setJ2eeVersionWarningPanel() {
        Profile j2ee = this.getSelectedJ2eeProfile();
        if (j2ee == null) {
            this.warningPlaceHolderPanel.setVisible(false);
            this.cdiCheckbox.setVisible(false);
            return;
        }
        Set jdks = Collections.emptySet();
        String serverInstanceId = this.getSelectedServer();
        if (serverInstanceId != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceId).getJ2eePlatform();
                if (j2eePlatform != null) {
                    jdks = j2eePlatform.getSupportedJavaPlatformVersions();
                }
            }
            catch (InstanceRemovedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.cdiCheckbox.setVisible(!this.importScenario && (j2ee.equals((Object)Profile.JAVA_EE_6_FULL) || j2ee.equals((Object)Profile.JAVA_EE_6_WEB)));
        String warningType = J2eeVersionWarningPanel.findWarningType(j2ee, jdks);
        if (warningType == null && this.warningPanel == null) {
            this.warningPlaceHolderPanel.setVisible(false);
            return;
        }
        if (this.warningPanel == null) {
            this.warningPanel = new J2eeVersionWarningPanel(warningType);
            this.warningPlaceHolderPanel.add((Component)this.warningPanel, "Center");
            this.warningPanel.setWarningType(warningType);
            this.warningPlaceHolderPanel.setVisible(true);
        } else if (warningType == null) {
            this.warningPlaceHolderPanel.setVisible(false);
        } else {
            this.warningPanel.setWarningType(warningType);
            this.warningPlaceHolderPanel.setVisible(true);
        }
        this.revalidate();
    }

    private void updateJ2EEVersion(String configFileName) {
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.projectLocation));
        if (fo != null) {
            FileObject configFilesPath = FileSearchUtility.guessConfigFilesPath((FileObject)fo, (String)configFileName);
            if (configFilesPath != null) {
                FileObject configFile = configFilesPath.getFileObject(configFileName);
                if (J2eeModule.Type.EJB.equals(this.j2eeModuleType)) {
                    this.checkEjbJarXmlJ2eeVersion(configFile);
                } else if (J2eeModule.Type.CAR.equals(this.j2eeModuleType)) {
                    this.checkACXmlJ2eeVersion(configFile);
                }
            } else {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_8_FULL));
            }
        }
    }

    private BigDecimal getEjbJarXmlVersion(FileObject ejbJarXml) throws IOException {
        EjbJar ejbJar;
        if (ejbJarXml != null && (ejbJar = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getDDRoot(ejbJarXml)) != null) {
            return ejbJar.getVersion();
        }
        return null;
    }

    private void checkEjbJarXmlJ2eeVersion(FileObject ejbJarXml) {
        try {
            BigDecimal version;
            this.xmlVersion = version = this.getEjbJarXmlVersion(ejbJarXml);
            if (version == null) {
                return;
            }
            if (new BigDecimal("2.1").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.J2EE_14));
            } else if (new BigDecimal("3.0").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_5));
            } else if (new BigDecimal("3.1").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_6_FULL));
            } else if (new BigDecimal("3.2").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_7_FULL));
            } else if (new BigDecimal("4.0").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAKARTA_EE_9_FULL));
            }
        }
        catch (IOException e) {
            String message = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_EjbJarXmlCorrupted");
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)e, (String)message));
        }
    }

    private BigDecimal getACXmlVersion(FileObject appClientXML) throws IOException {
        if (appClientXML != null) {
            return DDProvider.getDefault().getDDRoot(appClientXML).getVersion();
        }
        return null;
    }

    private void checkACXmlJ2eeVersion(FileObject appClientXML) {
        try {
            BigDecimal version = this.getACXmlVersion(appClientXML);
            if (version == null) {
                return;
            }
            if (new BigDecimal("1.4").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.J2EE_14));
            } else if (new BigDecimal("5").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_5));
            } else if (new BigDecimal("6").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_6_FULL));
            } else if (new BigDecimal("7").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_7_FULL));
            } else if (new BigDecimal("8").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_8_FULL));
            } else if (new BigDecimal("9").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAKARTA_EE_9_FULL));
            } else if (new BigDecimal("10").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAKARTA_EE_10_FULL));
            }
        }
        catch (IOException e) {
            String message = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_AppClientXmlCorrupted");
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)e, (String)message));
        }
    }

    private void setJ2eeVersionWarning(WizardDescriptor d) {
        boolean oldXml;
        String errorMessage = null;
        ProfileItem selectedItem = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        boolean bl = this.xmlVersion == null ? true : (oldXml = new BigDecimal("2.1").compareTo(this.xmlVersion) > 0);
        if (selectedItem != null && Profile.J2EE_14 == selectedItem.getProfile() && oldXml) {
            errorMessage = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_EjbJarXMLNotSupported");
        }
        if (d != null) {
            d.putProperty("WizardPanel_errorMessage", errorMessage);
        }
        this.setJ2eeVersionWarningPanel();
    }

    private void initClientAppMainClass(String newProjectName) {
        if (!Utilities.isJavaIdentifier((String)(newProjectName = this.getPackageName(newProjectName)))) {
            newProjectName = NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_PackageNameSuffix", (Object)newProjectName);
        }
        if (J2eeModule.Type.CAR.equals(this.j2eeModuleType)) {
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_ClassName"), newProjectName));
        } else {
            this.mainClassTextFieldWithinEar.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_ClassName"), newProjectName));
        }
    }

    private String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.wizard.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.wizard.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.wizard.fireChangeEvent();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectImportLocationPanel.generateHelpID(ProjectServerPanel.class, this.j2eeModuleType));
    }

    private static class ProfileItem {
        private final Profile profile;

        public ProfileItem(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public String toString() {
            return this.profile.getDisplayName();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProfileItem other = (ProfileItem)obj;
            return this.profile == other.profile || this.profile != null && this.profile.equals((Object)other.profile);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.profile != null ? this.profile.hashCode() : 0);
            return hash;
        }
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String serverInstanceID, String displayName) {
            this.serverInstanceID = serverInstanceID;
            this.displayName = displayName;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

