/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.VMDisconnectedException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.RequestProcessor;

abstract class JPDADebuggerAction
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;
    private boolean canApplyLazyEnabled = false;

    JPDADebuggerAction(JPDADebugger debugger) {
        this.debugger = debugger;
        debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            this.checkEnabled(this.debugger.getState());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    protected abstract void checkEnabled(int var1);

    protected final void checkEnabledLazySingleAction(final int debuggerState, RequestProcessor rp) {
        this.canApplyLazyEnabled = true;
        rp.post(new Runnable(){

            @Override
            public void run() {
                final boolean enabled = JPDADebuggerAction.this.checkEnabledLazyImpl(debuggerState);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JPDADebuggerAction.this.canApplyLazyEnabled) {
                            JPDADebuggerAction.this.setEnabledSingleAction(enabled);
                            JPDADebuggerAction.this.canApplyLazyEnabled = true;
                        }
                    }
                });
            }
        });
    }

    protected boolean checkEnabledLazyImpl(int debuggerState) {
        return false;
    }

    protected final void setEnabledSingleAction(boolean enabled) {
        this.canApplyLazyEnabled = false;
        this.setEnabled(this.getActions().iterator().next(), enabled);
    }

    JPDADebugger getDebuggerImpl() {
        return this.debugger;
    }
}

