/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.tools.JAXRConceptsManager;
import com.sun.xml.registry.common.util.MarshallerUtil;
import com.sun.xml.registry.common.util.XMLUtil;
import com.sun.xml.registry.uddi.ConnectionImpl;
import com.sun.xml.registry.uddi.JAXRConstants;
import com.sun.xml.registry.uddi.MapperHelpers;
import com.sun.xml.registry.uddi.Processor;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIObjectCache;
import com.sun.xml.registry.uddi.bindings_v2_2.AccessPoint;
import com.sun.xml.registry.uddi.bindings_v2_2.AddPublisherAssertions;
import com.sun.xml.registry.uddi.bindings_v2_2.Address;
import com.sun.xml.registry.uddi.bindings_v2_2.AddressLine;
import com.sun.xml.registry.uddi.bindings_v2_2.AssertionStatusItem;
import com.sun.xml.registry.uddi.bindings_v2_2.BindingTemplate;
import com.sun.xml.registry.uddi.bindings_v2_2.BindingTemplates;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessEntity;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessService;
import com.sun.xml.registry.uddi.bindings_v2_2.BusinessServices;
import com.sun.xml.registry.uddi.bindings_v2_2.CategoryBag;
import com.sun.xml.registry.uddi.bindings_v2_2.Contact;
import com.sun.xml.registry.uddi.bindings_v2_2.Contacts;
import com.sun.xml.registry.uddi.bindings_v2_2.DeleteBinding;
import com.sun.xml.registry.uddi.bindings_v2_2.DeleteBusiness;
import com.sun.xml.registry.uddi.bindings_v2_2.DeletePublisherAssertions;
import com.sun.xml.registry.uddi.bindings_v2_2.DeleteService;
import com.sun.xml.registry.uddi.bindings_v2_2.DeleteTModel;
import com.sun.xml.registry.uddi.bindings_v2_2.Description;
import com.sun.xml.registry.uddi.bindings_v2_2.Direction;
import com.sun.xml.registry.uddi.bindings_v2_2.DiscoveryURL;
import com.sun.xml.registry.uddi.bindings_v2_2.DiscoveryURLs;
import com.sun.xml.registry.uddi.bindings_v2_2.Email;
import com.sun.xml.registry.uddi.bindings_v2_2.ErrInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.FindBinding;
import com.sun.xml.registry.uddi.bindings_v2_2.FindBusiness;
import com.sun.xml.registry.uddi.bindings_v2_2.FindQualifiers;
import com.sun.xml.registry.uddi.bindings_v2_2.FindRelatedBusinesses;
import com.sun.xml.registry.uddi.bindings_v2_2.FindService;
import com.sun.xml.registry.uddi.bindings_v2_2.FindTModel;
import com.sun.xml.registry.uddi.bindings_v2_2.GetAssertionStatusReport;
import com.sun.xml.registry.uddi.bindings_v2_2.GetAuthToken;
import com.sun.xml.registry.uddi.bindings_v2_2.GetBindingDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.GetBusinessDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.GetPublisherAssertions;
import com.sun.xml.registry.uddi.bindings_v2_2.GetRegisteredInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.GetServiceDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.GetTModelDetail;
import com.sun.xml.registry.uddi.bindings_v2_2.HostingRedirector;
import com.sun.xml.registry.uddi.bindings_v2_2.IdentifierBag;
import com.sun.xml.registry.uddi.bindings_v2_2.InstanceDetails;
import com.sun.xml.registry.uddi.bindings_v2_2.KeyType;
import com.sun.xml.registry.uddi.bindings_v2_2.KeyedReference;
import com.sun.xml.registry.uddi.bindings_v2_2.KeysOwned;
import com.sun.xml.registry.uddi.bindings_v2_2.Name;
import com.sun.xml.registry.uddi.bindings_v2_2.ObjectFactory;
import com.sun.xml.registry.uddi.bindings_v2_2.OverviewDoc;
import com.sun.xml.registry.uddi.bindings_v2_2.Phone;
import com.sun.xml.registry.uddi.bindings_v2_2.PublisherAssertion;
import com.sun.xml.registry.uddi.bindings_v2_2.RelatedBusinessInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.Result;
import com.sun.xml.registry.uddi.bindings_v2_2.SaveBinding;
import com.sun.xml.registry.uddi.bindings_v2_2.SaveBusiness;
import com.sun.xml.registry.uddi.bindings_v2_2.SaveService;
import com.sun.xml.registry.uddi.bindings_v2_2.SaveTModel;
import com.sun.xml.registry.uddi.bindings_v2_2.ServiceInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.ServiceInfos;
import com.sun.xml.registry.uddi.bindings_v2_2.SetPublisherAssertions;
import com.sun.xml.registry.uddi.bindings_v2_2.SharedRelationships;
import com.sun.xml.registry.uddi.bindings_v2_2.TModel;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelBag;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelInstanceDetails;
import com.sun.xml.registry.uddi.bindings_v2_2.TModelInstanceInfo;
import com.sun.xml.registry.uddi.bindings_v2_2.URLType;
import com.sun.xml.registry.uddi.infomodel.AssociationImpl;
import com.sun.xml.registry.uddi.infomodel.ClassificationImpl;
import com.sun.xml.registry.uddi.infomodel.ClassificationSchemeImpl;
import com.sun.xml.registry.uddi.infomodel.ConceptImpl;
import com.sun.xml.registry.uddi.infomodel.EmailAddressImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.LocalizedStringImpl;
import com.sun.xml.registry.uddi.infomodel.OrganizationImpl;
import com.sun.xml.registry.uddi.infomodel.PersonNameImpl;
import com.sun.xml.registry.uddi.infomodel.PostalAddressImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceBindingImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceImpl;
import com.sun.xml.registry.uddi.infomodel.SlotImpl;
import com.sun.xml.registry.uddi.infomodel.SpecificationLinkImpl;
import com.sun.xml.registry.uddi.infomodel.TelephoneNumberImpl;
import com.sun.xml.registry.uddi.infomodel.UserImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.DeleteException;
import javax.xml.registry.FindException;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.SaveException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UDDIMapper
extends JAXRConstants {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    private static XMLUtil xmlUtil;
    private static MarshallerUtil marshallerUtil;
    private UDDIObjectCache objectManager = null;
    private RegistryServiceImpl service = null;
    private ConnectionImpl connection = null;
    private static JAXRConceptsManager manager;
    private Collection fromKeysOwned;
    private Collection toKeysOwned;
    private ClassificationScheme defaultPostalScheme;
    private ClassificationScheme jaxrPostalAddressScheme;
    private HashMap postalAddressMap;
    private HashMap equivalentConcepts;
    private HashMap semanticEquivalences;
    private long tokenTime;
    private Processor processor;
    private MapperHelpers helper;
    private JAXBContext jc;
    private ObjectFactory objFactory;

    public UDDIMapper(RegistryService service) {
        this.service = (RegistryServiceImpl)service;
        this.objectManager = new UDDIObjectCache((RegistryServiceImpl)service);
        xmlUtil = XMLUtil.getInstance();
        try {
            marshallerUtil = marshallerUtil.getInstance();
        }
        catch (JAXBException jbe) {
            System.out.println("Failure to initialize mapper");
        }
        this.helper = new MapperHelpers();
        this.initJAXBObjectFactory();
    }

    public UDDIObjectCache getObjectManager() {
        return this.objectManager;
    }

    private void initJAXBObjectFactory() {
        try {
            if (this.jc == null) {
                this.jc = JAXBContext.newInstance("com.sun.xml.registry.uddi.bindings_v2_2");
            }
        }
        catch (JAXBException jbe) {
            this.logger.log(Level.SEVERE, "Exiting unable to initial JAXB context", jbe);
            System.exit(1);
        }
        if (this.objFactory == null) {
            this.objFactory = new ObjectFactory();
        }
    }

    private Processor getProcessor() {
        if (this.processor == null) {
            this.processor = new Processor(this.service, this);
        }
        return this.processor;
    }

    private JAXRConceptsManager getConceptsManager() throws JAXRException {
        if (manager == null) {
            manager = JAXRConceptsManager.getInstance(this.service.getConnection());
        }
        return manager;
    }

    private ConnectionImpl getConnection() {
        if (this.service != null && this.connection == null) {
            this.connection = this.service.getConnection();
        }
        return this.connection;
    }

    private void setConnection() {
        if (this.service != null && this.connection == null) {
            this.connection = this.service.getConnection();
        }
    }

    BulkResponse findOrganizations(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection identifiers, Collection externalLinks) throws JAXRException {
        FindQualifiers fQualifiers;
        FindBusiness findBusiness = null;
        boolean parameterSet = false;
        findBusiness = this.objFactory.createFindBusiness();
        findBusiness.setGeneric("2.0");
        String maxrows = this.getConnection().getMaxRows();
        if (maxrows != null) {
            int mrows = Integer.parseInt(maxrows);
            findBusiness.setMaxRows(mrows);
        }
        if ((fQualifiers = this.strings2FindQualifiers(findQualifiers)) != null) {
            findBusiness.setFindQualifiers(fQualifiers);
        }
        Collection names = this.namePatterns2Names(namePatterns, false);
        IdentifierBag ibag = this.externalIdentifiers2IdentifierBag(identifiers);
        CategoryBag cbag = this.classifications2CategoryBag(classifications);
        TModelBag tbag = this.concepts2TModelBag(specifications);
        DiscoveryURLs urls = this.externalLinks2DiscoveryURLs(externalLinks);
        if (names != null && !names.isEmpty()) {
            findBusiness.getName().addAll(names);
            parameterSet = true;
        }
        if (ibag != null) {
            findBusiness.setIdentifierBag(ibag);
            parameterSet = true;
        }
        if (cbag != null) {
            findBusiness.setCategoryBag(cbag);
            parameterSet = true;
        }
        if (tbag != null) {
            findBusiness.setTModelBag(tbag);
            parameterSet = true;
        }
        if (urls != null) {
            findBusiness.setDiscoveryURLs(urls);
            parameterSet = true;
        }
        if (!parameterSet) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Find_Criteria_Set_for_FindOrganization"));
        }
        return this.getProcessor().processRequestJAXB(findBusiness, false, null, "find");
    }

    BulkResponse saveOrganizations(Collection organizations) throws JAXRException {
        SaveBusiness saveBusiness = null;
        saveBusiness = this.objFactory.createSaveBusiness();
        saveBusiness.setGeneric("2.0");
        String authInfo = null;
        Collection businessEntities = this.organizations2BusinessEntities(organizations, true);
        if (businessEntities.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Organization_information_to_save"));
        }
        saveBusiness.getBusinessEntity().addAll(businessEntities);
        authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_present"));
        }
        saveBusiness.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(saveBusiness, true, null, "save");
    }

    private String getAuthInfo() throws JAXRException {
        String authInfo = this.getConnection().getAuthToken();
        if (authInfo == null || this.tokenExpired()) {
            String result = this.getAuthorizationToken(this.getConnection().getAuthCreds());
            if (result == null) {
                result = "";
            }
            this.getConnection().setAuthToken(result.toCharArray());
            this.getConnection().setAuthTokenTimestamp(this.timeStamp());
            return result;
        }
        return authInfo;
    }

    private long timeStamp() {
        return System.currentTimeMillis();
    }

    private boolean tokenExpired() {
        this.logger.finest("Last Token time " + this.tokenTime);
        long diffTime = this.timeStamp() - this.getConnection().getAuthTokenTimestamp();
        this.logger.finest("Elapsed time between authTokens " + diffTime);
        long defaultTimeout = this.getConnection().getTokenTimeout();
        this.logger.finest("DefaultTimeout " + defaultTimeout);
        return diffTime > defaultTimeout;
    }

    BulkResponse saveServices(Collection services) throws JAXRException {
        SaveService saveService = null;
        saveService = this.objFactory.createSaveService();
        saveService.setGeneric("2.0");
        String authInfo = null;
        Collection businessServices = this.services2BusinessServicesCollection(services, true);
        if (businessServices == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Service_Information_to_Save_or_Update"));
        }
        saveService.getBusinessService().addAll(businessServices);
        authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credential_Infomation"));
        }
        saveService.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(saveService, true, null, "save");
    }

    BulkResponse saveServiceBindings(Collection serviceBindings) throws JAXRException {
        boolean publish = true;
        SaveBinding saveBindings = null;
        saveBindings = this.objFactory.createSaveBinding();
        saveBindings.setGeneric("2.0");
        String authInfo = null;
        Collection bindingTemplates = this.serviceBindings2BindingTemplatesCollection(serviceBindings, publish);
        if (bindingTemplates == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Binding_Information_to_be_saved_or_updated"));
        }
        saveBindings.getBindingTemplate().addAll(bindingTemplates);
        authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credential_or_Invalid_Credential_Information"));
        }
        saveBindings.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(saveBindings, true, null, "save");
    }

    BulkResponse saveConcepts(Collection concepts) throws JAXRException {
        boolean publish = true;
        SaveTModel saveTModel = null;
        saveTModel = this.objFactory.createSaveTModel();
        saveTModel.setGeneric("2.0");
        Collection tModels = this.concepts2TModels(concepts, publish);
        if (tModels == null || tModels.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Concept_Information_or_Invalid_Concept_Information"));
        }
        saveTModel.getTModel().addAll(tModels);
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_or_Invalid_Credentials"));
        }
        saveTModel.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(saveTModel, true, null, "save");
    }

    BulkResponse saveClassificationSchemes(Collection schemes) throws JAXRException {
        boolean publish = true;
        SaveTModel saveTModel = null;
        saveTModel = this.objFactory.createSaveTModel();
        saveTModel.setGeneric("2.0");
        Collection tModels = this.classificationSchemes2TModels(schemes, publish);
        if (tModels == null || tModels.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Concept_Information_or_Invalid_Concept_Information"));
        }
        saveTModel.getTModel().addAll(tModels);
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_or_Invalid_Credentials"));
        }
        saveTModel.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(saveTModel, true, null, "save");
    }

    BulkResponse deleteOrganizations(Collection organizationKeys) throws JAXRException {
        DeleteBusiness deleteBusiness = null;
        deleteBusiness = this.objFactory.createDeleteBusiness();
        deleteBusiness.setGeneric("2.0");
        Collection keys = this.keys2Keys(organizationKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Business_Identified_to_Delete"));
        }
        deleteBusiness.getBusinessKey().addAll(keys);
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_or_Invalid_Credentials"));
        }
        deleteBusiness.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(deleteBusiness, true, organizationKeys, "delete");
    }

    BulkResponse deleteServices(Collection serviceKeys) throws JAXRException {
        DeleteService deleteService = null;
        deleteService = this.objFactory.createDeleteService();
        deleteService.setGeneric("2.0");
        Collection keys = this.keys2Keys(serviceKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Service_Keys_supplied_for_deletion"));
        }
        deleteService.getServiceKey().addAll(keys);
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Invalid_Credential_Information"));
        }
        deleteService.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(deleteService, true, serviceKeys, "delete");
    }

    BulkResponse deleteServiceBindings(Collection bindingKeys) throws JAXRException {
        DeleteBinding deleteBinding = null;
        deleteBinding = this.objFactory.createDeleteBinding();
        deleteBinding.setGeneric("2.0");
        Collection keys = this.keys2Keys(bindingKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Service_Binding_Keys_supplied_for_deletion"));
        }
        deleteBinding.getBindingKey().addAll(keys);
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Invalid_Credential_Information"));
        }
        deleteBinding.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(deleteBinding, true, bindingKeys, "delete");
    }

    BulkResponse deleteConcepts(Collection conceptKeys) throws JAXRException {
        DeleteTModel deleteTModel = null;
        deleteTModel = this.objFactory.createDeleteTModel();
        deleteTModel.setGeneric("2.0");
        Collection keys = this.keys2Keys(conceptKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Service_Binding_Keys_supplied_for_deletion"));
        }
        deleteTModel.getTModelKey().addAll(keys);
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Invalid_Credential_Information"));
        }
        deleteTModel.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(deleteTModel, true, conceptKeys, "delete");
    }

    BulkResponse deleteAssociations(Collection associationKeys) throws JAXRException {
        DeletePublisherAssertions publisherAssertions = null;
        publisherAssertions = this.objFactory.createDeletePublisherAssertions();
        publisherAssertions.setGeneric("2.0");
        Collection assertions = this.associationKeys2PublisherAssertions(associationKeys);
        publisherAssertions.getPublisherAssertion().addAll(assertions);
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Invalid_Credential_Information"));
        }
        publisherAssertions.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(publisherAssertions, true, associationKeys, "delete");
    }

    BulkResponse findServices(Key orgKey, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications) throws JAXRException {
        FindService findService = null;
        boolean parameterSet = false;
        findService = this.objFactory.createFindService();
        findService.setGeneric("2.0");
        FindQualifiers fQualifiers = this.strings2FindQualifiers(findQualifiers);
        if (fQualifiers != null) {
            findService.setFindQualifiers(fQualifiers);
        }
        String key = this.key2Key(orgKey);
        findService.setBusinessKey(key);
        Collection names = this.namePatterns2Names(namePatterns, false);
        CategoryBag cbag = this.classifications2CategoryBag(classifications);
        TModelBag tbag = this.concepts2TModelBag(specifications);
        if (names != null && !names.isEmpty()) {
            findService.getName().addAll(names);
            parameterSet = true;
        }
        if (cbag != null) {
            findService.setCategoryBag(cbag);
            parameterSet = true;
        }
        if (tbag != null) {
            findService.setTModelBag(tbag);
            parameterSet = true;
        }
        if (!parameterSet) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Find_Criteria_Specified"));
        }
        return this.getProcessor().processRequestJAXB(findService, false, null, "find");
    }

    BulkResponse findServiceBindings(Key serviceKey, Collection findQualifiers, Collection classifications, Collection specifications) throws JAXRException {
        String key;
        FindQualifiers fQualifiers;
        FindBinding findBinding = null;
        boolean parameterSet = false;
        findBinding = this.objFactory.createFindBinding();
        findBinding.setGeneric("2.0");
        String maxrows = this.getConnection().getMaxRows();
        if (maxrows != null) {
            int rows = Integer.parseInt(maxrows);
            findBinding.setMaxRows(rows);
        }
        if ((fQualifiers = this.strings2FindQualifiers(findQualifiers)) != null) {
            findBinding.setFindQualifiers(fQualifiers);
        }
        if ((key = this.key2Key(serviceKey)) == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Service_Key_must_be_specified"));
        }
        findBinding.setServiceKey(key);
        TModelBag tbag = this.concepts2TModelBag(specifications);
        if (tbag != null) {
            findBinding.setTModelBag(tbag);
            parameterSet = true;
        }
        if (!parameterSet) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Find_Criteria_Specified"));
        }
        return this.getProcessor().processRequestJAXB(findBinding, false, null, "find");
    }

    BulkResponse findConcepts(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        FindQualifiers fQualifiers;
        FindTModel findTModel = null;
        boolean parameterSet = false;
        findTModel = this.objFactory.createFindTModel();
        findTModel.setGeneric("2.0");
        String maxrows = this.getConnection().getMaxRows();
        if (maxrows != null) {
            int rows = Integer.parseInt(maxrows);
            findTModel.setMaxRows(rows);
        }
        if ((fQualifiers = this.strings2FindQualifiers(findQualifiers)) != null) {
            findTModel.setFindQualifiers(fQualifiers);
        }
        Collection names = this.namePatterns2Names(namePatterns, false);
        CategoryBag cbag = this.classifications2CategoryBag(classifications);
        IdentifierBag ibag = this.externalIdentifiers2IdentifierBag(externalIdentifiers);
        if (cbag != null) {
            findTModel.setCategoryBag(cbag);
            parameterSet = true;
        }
        if (ibag != null) {
            findTModel.setIdentifierBag(ibag);
            parameterSet = true;
        }
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>();
        int len = names.size();
        if (names != null && len > 0) {
            for (int i = 0; i < len; ++i) {
                findTModel.setName((Name)((ArrayList)names).get(i));
                BulkResponse br = this.getProcessor().processRequestJAXB(findTModel, false, null, "find");
                Collection al = br.getCollection();
                Iterator it1 = al.iterator();
                responses.add(br);
            }
            try {
                int size = responses.size();
                for (int iterator = 0; iterator < size; iterator += 2) {
                    BulkResponse bulkresponse1 = (BulkResponse)responses.get(iterator);
                    BulkResponse bulkresponse2 = null;
                    if (iterator + 1 < size) {
                        bulkresponse2 = (BulkResponse)responses.get(iterator + 1);
                    }
                    if (bulkresponse1 == null || bulkresponse2 == null) continue;
                    Iterator it1 = bulkresponse1.getCollection().iterator();
                    Iterator it2 = bulkresponse2.getCollection().iterator();
                    boolean found = true;
                    while (it1.hasNext() && it2.hasNext()) {
                        if (((KeyImpl)((ConceptImpl)it1.next()).getKey()).getId().equals(((KeyImpl)((ConceptImpl)it2.next()).getKey()).getId())) {
                            found = true;
                            continue;
                        }
                        found = false;
                    }
                    if (!found) continue;
                    if (!it1.hasNext()) {
                        responses.remove(iterator);
                        continue;
                    }
                    if (it2.hasNext()) continue;
                    responses.remove(iterator + 1);
                }
            }
            catch (ClassCastException size) {
                // empty catch block
            }
            BulkResponse bResponse = BulkResponseImpl.combineBulkResponses(responses);
            return this.helper.extractRegistryObjectByClass(bResponse, "Concept");
        }
        if (!parameterSet) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Find_Criteria_Specified_specified"));
        }
        BulkResponse response = this.getProcessor().processRequestJAXB(findTModel, false, null, "find");
        return this.helper.extractRegistryObjectByClass(response, "Concept");
    }

    BulkResponse findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        return this.findClassificationSchemes(findQualifiers, namePatterns, classifications, externalLinks, true);
    }

    BulkResponse findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks, boolean cull) throws JAXRException {
        FindQualifiers fQualifiers;
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>();
        Collection schemes = null;
        BulkResponseImpl response = new BulkResponseImpl();
        if (classifications == null && externalLinks == null && namePatterns != null && (schemes = this.getConceptsManager().findClassificationSchemes(findQualifiers, namePatterns, classifications, externalLinks)).size() > 0) {
            Iterator siter = schemes.iterator();
            while (siter.hasNext()) {
                try {
                    ClassificationScheme scheme = (ClassificationScheme)siter.next();
                    if (scheme != null) {
                        this.objectManager.addObjectToCache((RegistryObjectImpl)scheme, this.service.getServiceId());
                    }
                }
                catch (ClassCastException cce) {
                    this.logger.log(Level.SEVERE, cce.getMessage(), cce);
                }
                response.setCollection(schemes);
            }
            responses.add(response);
        }
        Object br = null;
        FindTModel findTModel = null;
        boolean parameterSet = false;
        Object doc = null;
        findTModel = this.objFactory.createFindTModel();
        findTModel.setGeneric("2.0");
        String maxrows = this.getConnection().getMaxRows();
        if (maxrows != null) {
            int rows = Integer.parseInt(maxrows);
            findTModel.setMaxRows(rows);
        }
        if ((fQualifiers = this.strings2FindQualifiers(findQualifiers)) != null) {
            findTModel.setFindQualifiers(fQualifiers);
        }
        Collection names = this.namePatterns2Names(namePatterns, false);
        CategoryBag cbag = this.classifications2CategoryBag(classifications);
        if (cbag != null) {
            findTModel.setCategoryBag(cbag);
            parameterSet = true;
        }
        int len = names.size();
        if (names != null && len > 0) {
            for (int i = 0; i < len; ++i) {
                findTModel.setName((Name)((ArrayList)names).get(i));
                BulkResponse brr = this.getProcessor().processRequestJAXB(findTModel, false, null, "find");
                responses.add(brr);
            }
            BulkResponse bResponse = BulkResponseImpl.combineBulkResponses(responses);
            if (cull) {
                return this.helper.cullDuplicates(this.helper.extractRegistryObjectByClass(bResponse, "ClassificationScheme"));
            }
            return this.helper.extractRegistryObjectByClass(bResponse, "ClassificationScheme");
        }
        if (!parameterSet) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Find_Criteria_Specified_specified"));
        }
        BulkResponse cresponse = this.getProcessor().processRequestJAXB(findTModel, false, null, "find");
        responses.add(cresponse);
        BulkResponse fresponse = BulkResponseImpl.combineBulkResponses(responses);
        return this.helper.cullDuplicates(this.helper.extractRegistryObjectByClass(fresponse, "ClassificationScheme"));
    }

    ClassificationScheme findClassificationSchemeByName(Collection findQualifiers, String namePattern) throws JAXRException {
        ArrayList<String> namePatterns = new ArrayList<String>();
        namePatterns.add(namePattern);
        BulkResponse br = this.findClassificationSchemes(null, namePatterns, null, null, true);
        if (br != null && br.getExceptions() == null) {
            Collection schemes = br.getCollection();
            int size = schemes.size();
            this.logger.finest("Found schemes " + size);
            if (size > 1) {
                throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("Multiple_Schemes_matching_name_pattern"));
            }
            Iterator iter = schemes.iterator();
            if (iter.hasNext()) {
                try {
                    ClassificationScheme cScheme = (ClassificationScheme)iter.next();
                    return cScheme;
                }
                catch (ClassCastException cce) {
                    this.logger.log(Level.SEVERE, cce.getMessage(), cce);
                    throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("Expected_ClassificationScheme"), (Throwable)cce);
                }
            }
        }
        return null;
    }

    Concept findConceptByPath(String path) throws JAXRException {
        if (path != null) {
            return this.getConceptsManager().findConceptByPath(path);
        }
        return null;
    }

    public Collection getChildConcepts(ClassificationScheme scheme) throws JAXRException {
        Collection concepts = null;
        if (((ClassificationSchemeImpl)scheme).isPredefined()) {
            concepts = this.getConceptsManager().getChildConcepts(scheme);
        }
        return concepts;
    }

    KeyedReference associationType2KeyedReference(Object associationType) throws JAXRException {
        if (associationType == null) {
            return null;
        }
        String typeName = null;
        String typeValue = null;
        if (associationType instanceof Concept) {
            typeName = ((Concept)associationType).getName().getValue();
            typeValue = ((Concept)associationType).getValue();
        } else if (associationType instanceof String) {
            typeName = (String)associationType;
            typeValue = (String)associationType;
        }
        String keyName = null;
        String keyValue = null;
        if (typeValue.equalsIgnoreCase("EquivalentTo")) {
            keyName = "identity";
            keyValue = "identity";
        } else if (typeValue.equalsIgnoreCase("RelatedTo")) {
            keyName = "peer-peer";
            keyValue = "peer-peer";
        } else if (typeValue.equalsIgnoreCase("HasChild")) {
            keyName = "parent-child";
            keyValue = "parent-child";
        } else {
            keyName = typeName;
            keyValue = typeValue;
        }
        KeyedReference keyedReference = null;
        keyedReference = this.objFactory.createKeyedReference();
        keyedReference.setTModelKey("uuid:807a2c6a-ee22-470d-adc7-e0424a337c03");
        if (keyName == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Association_Type_required_to_save_Association_to_Registry"));
        }
        keyedReference.setKeyName(keyName);
        if (keyValue == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Association_Type_required_to_save_Association_to_Registry"));
        }
        keyedReference.setKeyValue(keyValue);
        return keyedReference;
    }

    Collection associationTypes2KeyedReferences(Collection associationTypes) throws JAXRException {
        ArrayList<KeyedReference> keyedReferences = new ArrayList<KeyedReference>();
        if (associationTypes != null) {
            Iterator iter = associationTypes.iterator();
            while (iter.hasNext()) {
                KeyedReference ref = this.associationType2KeyedReference(iter.next());
                if (ref == null) continue;
                keyedReferences.add(ref);
            }
        }
        return keyedReferences;
    }

    BulkResponse getOrganizations(Collection orgKeys) throws JAXRException {
        GetBusinessDetail detail = null;
        detail = this.objFactory.createGetBusinessDetail();
        detail.setGeneric("2.0");
        Collection keys = this.keys2Keys(orgKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Organization_Keys_supplied"));
        }
        detail.getBusinessKey().addAll(keys);
        return this.getProcessor().processRequestJAXB(detail, false, orgKeys, "find");
    }

    BulkResponse getServices(Collection orgKeys) throws JAXRException {
        GetServiceDetail detail = null;
        detail = this.objFactory.createGetServiceDetail();
        detail.setGeneric("2.0");
        Collection keys = this.keys2Keys(orgKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_service_Keys_Supplied"));
        }
        detail.getServiceKey().addAll(keys);
        return this.getProcessor().processRequestJAXB(detail, false, null, "find");
    }

    BulkResponse getServiceBindings(Collection bindingKeys) throws JAXRException {
        GetBindingDetail detail = null;
        detail = this.objFactory.createGetBindingDetail();
        detail.setGeneric("2.0");
        Collection keys = this.keys2Keys(bindingKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_ServiceBinding_Keys_supplied"));
        }
        detail.getBindingKey().addAll(keys);
        return this.getProcessor().processRequestJAXB(detail, false, null, "find");
    }

    BulkResponse getConcepts(Collection conceptKeys) throws JAXRException {
        GetTModelDetail detail = null;
        detail = this.objFactory.createGetTModelDetail();
        detail.setGeneric("2.0");
        Collection keys = this.keys2Keys(conceptKeys);
        if (keys == null || keys.isEmpty()) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Concept_keys_supplied"));
        }
        detail.getTModelKey().addAll(keys);
        return this.getProcessor().processRequestJAXB(detail, false, null, "find");
    }

    IdentifierBag externalIdentifiers2IdentifierBag(Collection identifiers) throws UnexpectedObjectException, JAXRException {
        IdentifierBag ibag = null;
        if (identifiers != null && !identifiers.isEmpty()) {
            ibag = this.objFactory.createIdentifierBag();
            try {
                ArrayList<KeyedReference> keyedRefs = new ArrayList<KeyedReference>();
                Iterator iter = identifiers.iterator();
                while (iter.hasNext()) {
                    KeyedReference kref = this.externalIdentifier2KeyedReference((ExternalIdentifier)iter.next());
                    if (kref == null) continue;
                    keyedRefs.add(kref);
                }
                ibag.getKeyedReference().addAll(keyedRefs);
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_ExternalIdentifier"), (Throwable)cce);
            }
        }
        return ibag;
    }

    Collection organizations2BusinessEntities(Collection orgs, boolean publish) throws JAXRException {
        ArrayList<BusinessEntity> entities = new ArrayList<BusinessEntity>();
        if (orgs != null && !orgs.isEmpty()) {
            Iterator iter = orgs.iterator();
            try {
                while (iter.hasNext()) {
                    BusinessEntity businessEntity = this.organization2BusinessEntity((OrganizationImpl)iter.next(), publish);
                    if (businessEntity == null) continue;
                    entities.add(businessEntity);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Organization"), (Throwable)cce);
            }
        }
        return entities;
    }

    BusinessEntity organization2BusinessEntity(OrganizationImpl org, boolean publish) throws JAXRException {
        BusinessEntity entity = null;
        if (org != null) {
            Contacts contacts;
            BusinessServices bServices;
            DiscoveryURLs dUrl;
            CategoryBag cbag;
            IdentifierBag ibag;
            String operatorString;
            String authNameString;
            Collection values;
            entity = this.objFactory.createBusinessEntity();
            Key key = org.getKey();
            Slot authName = org.getSlot("authorizedName");
            Slot operator = org.getSlot("operator");
            Collection names = this.getNames(org, publish);
            Collection descriptions = this.getDescriptions(org, publish);
            Collection users = org.getUsers();
            User primaryContact = org.getPrimaryContact();
            Collection services = org.getServices();
            Collection externalIdentifiers = org.getExternalIdentifiers();
            Collection classifications = org.getClassifications();
            Collection externalLinks = org.getExternalLinks();
            if (key != null) {
                String id = key.getId();
                if (id != null) {
                    entity.setBusinessKey(id);
                }
            } else {
                entity.setBusinessKey("");
            }
            if (names == null) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:The_Organization_name_must_be_specified_to_save_an_Organization"));
            }
            entity.getName().addAll(names);
            if (descriptions != null) {
                entity.getDescription().addAll(descriptions);
            }
            if (authName != null && (values = authName.getValues()) != null && !values.isEmpty() && (authNameString = (String)values.toArray()[0]) != null) {
                entity.setAuthorizedName(authNameString);
            }
            if (operator != null && (values = operator.getValues()) != null && !values.isEmpty() && (operatorString = (String)values.toArray()[0]) != null) {
                entity.setOperator(operatorString);
            }
            if (externalIdentifiers != null && !externalIdentifiers.isEmpty() && (ibag = this.externalIdentifiers2IdentifierBag(externalIdentifiers)) != null) {
                entity.setIdentifierBag(ibag);
            }
            if (classifications != null && !classifications.isEmpty() && (cbag = this.classifications2CategoryBag(classifications)) != null) {
                entity.setCategoryBag(cbag);
            }
            if (externalLinks != null && !externalLinks.isEmpty() && (dUrl = this.externalLinks2DiscoveryURLs(externalLinks)) != null) {
                entity.setDiscoveryURLs(dUrl);
            }
            if (services != null && !services.isEmpty() && (bServices = this.services2BusinessServices(services, publish)) != null) {
                entity.setBusinessServices(bServices);
            }
            if (users != null && !users.isEmpty() && (contacts = this.users2Contacts(users, publish)) != null) {
                entity.setContacts(contacts);
            }
        }
        return entity;
    }

    Collection identifierBag2ExternalIdentifiers(IdentifierBag ibag) throws JAXRException {
        ArrayList<ExternalIdentifier> identifiers = null;
        if (ibag != null) {
            identifiers = new ArrayList<ExternalIdentifier>();
            List<KeyedReference> keyedReference = ibag.getKeyedReference();
            Iterator iter = keyedReference.iterator();
            while (iter.hasNext()) {
                ExternalIdentifier identifier = this.keyedReference2ExternalIdentifier((KeyedReference)iter.next());
                if (identifier == null) continue;
                identifiers.add(identifier);
            }
        }
        return identifiers;
    }

    BusinessServices services2BusinessServices(Collection services, boolean publish) throws JAXRException {
        BusinessServices businessServices = null;
        if (services != null) {
            businessServices = this.objFactory.createBusinessServices();
            try {
                Iterator iter = services.iterator();
                while (iter.hasNext()) {
                    BusinessService businessService = this.service2BusinessService((Service)iter.next(), publish);
                    if (businessService == null) continue;
                    businessServices.getBusinessService().add(businessService);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Service"), (Throwable)cce);
            }
        }
        return businessServices;
    }

    Collection services2BusinessServicesCollection(Collection services, boolean publish) throws JAXRException {
        ArrayList<BusinessService> businessServices = null;
        if (services != null) {
            businessServices = new ArrayList<BusinessService>();
            try {
                Iterator iter = services.iterator();
                while (iter.hasNext()) {
                    BusinessService businessService = this.service2BusinessService((Service)iter.next(), publish);
                    if (businessService == null) continue;
                    businessServices.add(businessService);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Service"), (Throwable)cce);
            }
        }
        return businessServices;
    }

    BusinessService service2BusinessService(Service service, boolean publish) throws JAXRException {
        BusinessService businessService = null;
        if (service != null) {
            BindingTemplates bindingTemplates;
            CategoryBag cbag;
            businessService = this.objFactory.createBusinessService();
            Organization org = service.getProvidingOrganization();
            if (org != null) {
                Key key = org.getKey();
                if (key != null) {
                    String id = key.getId();
                    if (id != null) {
                        businessService.setBusinessKey(id);
                        this.logger.finest("Setting business key");
                        this.logger.finest("key" + key);
                    }
                } else {
                    this.logger.finest("Organization key is null");
                }
            } else {
                this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Org_is_null"));
            }
            Key sKey = service.getKey();
            String sKeyString = null;
            if (sKey != null) {
                sKeyString = sKey.getId();
            }
            Collection name = this.getNames((RegistryObject)service, publish);
            Collection description = this.getDescriptions((RegistryObject)service, publish);
            Collection sbindings = service.getServiceBindings();
            Collection classifications = service.getClassifications();
            if (sKeyString != null) {
                businessService.setServiceKey(sKeyString);
            } else {
                businessService.setServiceKey("");
            }
            if (name != null) {
                businessService.getName().addAll(name);
            }
            if (description != null) {
                businessService.getDescription().addAll(description);
            }
            if ((cbag = this.classifications2CategoryBag(classifications)) != null) {
                businessService.setCategoryBag(cbag);
            }
            if ((bindingTemplates = this.serviceBindings2BindingTemplates(sbindings, publish)) != null) {
                businessService.setBindingTemplates(bindingTemplates);
            }
        }
        return businessService;
    }

    BindingTemplates serviceBindings2BindingTemplates(Collection sbindings, boolean publish) throws JAXRException {
        BindingTemplates templates = null;
        if (sbindings != null) {
            templates = this.objFactory.createBindingTemplates();
            Iterator iter = sbindings.iterator();
            try {
                while (iter.hasNext()) {
                    BindingTemplate bTemplate = this.serviceBinding2BindingTemplate((ServiceBinding)iter.next(), publish);
                    if (bTemplate == null) continue;
                    templates.getBindingTemplate().add(bTemplate);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_ServiceBinding"), (Throwable)cce);
            }
        }
        return templates;
    }

    Collection serviceBindings2BindingTemplatesCollection(Collection sbindings, boolean publish) throws JAXRException {
        ArrayList<BindingTemplate> templates = null;
        if (sbindings != null) {
            templates = new ArrayList<BindingTemplate>();
            Iterator iter = sbindings.iterator();
            try {
                while (iter.hasNext()) {
                    BindingTemplate bTemplate = this.serviceBinding2BindingTemplate((ServiceBinding)iter.next(), publish);
                    if (bTemplate == null) continue;
                    templates.add(bTemplate);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_ServiceBinding"), (Throwable)cce);
            }
        }
        return templates;
    }

    BindingTemplate serviceBinding2BindingTemplate(ServiceBinding sbinding, boolean publish) throws JAXRException {
        BindingTemplate template = null;
        if (sbinding != null) {
            HostingRedirector redirector;
            Service service;
            String bKeyString = null;
            template = this.objFactory.createBindingTemplate();
            Key bindingKey = sbinding.getKey();
            if (bindingKey != null) {
                bKeyString = bindingKey.getId();
            }
            if ((service = sbinding.getService()) != null) {
                Key key = service.getKey();
                if (key != null) {
                    String id = key.getId();
                    if (id != null) {
                        template.setServiceKey(id);
                    } else {
                        template.setServiceKey("");
                    }
                }
            } else {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:A_ServiceBinding_must_be_associated_with_a_service."));
            }
            Description description = this.getDescription((RegistryObject)sbinding);
            String accessURI = sbinding.getAccessURI();
            if (bKeyString != null) {
                template.setBindingKey(bKeyString);
            } else {
                template.setBindingKey("");
            }
            if (description != null) {
                template.getDescription().add(description);
            }
            ServiceBinding targetBinding = sbinding.getTargetBinding();
            if (accessURI == null && targetBinding == null) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:AccessURI_or_targetBinding_needs_to_be_set_on_the_ServiceBinding_-_neither_is_set"));
            }
            AccessPoint accessPoint = null;
            if (accessURI != null) {
                accessPoint = this.objFactory.createAccessPoint();
                accessPoint.setValue(accessURI);
                Collection classifications = sbinding.getClassifications();
                URLType urlType = null;
                Iterator citer = classifications.iterator();
                boolean urlTypeSetByUser = false;
                while (citer.hasNext()) {
                    Classification classification = (Classification)citer.next();
                    Concept concept = classification.getConcept();
                    if (concept == null) continue;
                    ClassificationScheme cScheme = concept.getClassificationScheme();
                    InternationalString name = cScheme.getName();
                    String nameValue = null;
                    if (name != null) {
                        nameValue = name.getValue();
                    }
                    if (cScheme == null || !nameValue.equalsIgnoreCase("URLType")) continue;
                    String conceptValue = concept.getValue();
                    urlType = conceptValue.indexOf("https") != -1 ? URLType.HTTPS : (conceptValue.indexOf("http") != -1 ? URLType.HTTP : (conceptValue.indexOf("ftp") != -1 ? URLType.FTP : (conceptValue.indexOf("phone") != -1 ? URLType.PHONE : (conceptValue.indexOf("mailto") != -1 ? URLType.MAILTO : URLType.OTHER))));
                    urlTypeSetByUser = true;
                    break;
                }
                if (!urlTypeSetByUser) {
                    urlType = this.helper.parseUrlForUrlType(accessURI);
                }
                if (urlType != null) {
                    accessPoint.setURLType(urlType);
                } else {
                    accessPoint.setURLType(URLType.OTHER);
                }
                template.setAccessPoint(accessPoint);
            } else if (targetBinding != null && (redirector = this.targetBinding2HostingRedirector(targetBinding)) != null) {
                template.setHostingRedirector(redirector);
            }
            Collection specificationLinks = sbinding.getSpecificationLinks();
            TModelInstanceDetails tModelInstanceDetails = null;
            if (specificationLinks != null) {
                Collection tInstanceInfos = this.specificationLinks2TModelInstanceInfos(specificationLinks, publish);
                tModelInstanceDetails = null;
                tModelInstanceDetails = this.objFactory.createTModelInstanceDetails();
                if (tInstanceInfos != null) {
                    tModelInstanceDetails.getTModelInstanceInfo().addAll(tInstanceInfos);
                }
                template.setTModelInstanceDetails(tModelInstanceDetails);
            }
        }
        return template;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Collection specificationLinks2TModelInstanceInfos(Collection specificationLinks, boolean publish) throws JAXRException {
        ArrayList<TModelInstanceInfo> tModelInstanceInfos = null;
        if (specificationLinks == null) return tModelInstanceInfos;
        tModelInstanceInfos = new ArrayList<TModelInstanceInfo>();
        Iterator iter = specificationLinks.iterator();
        while (iter.hasNext()) {
            SpecificationLink specLink = null;
            try {
                specLink = (SpecificationLink)iter.next();
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_SpecificationLink"), (Throwable)cce);
            }
            RegistryObject ro = specLink.getSpecificationObject();
            InternationalString usageDescription = specLink.getUsageDescription();
            Collection usageParms = specLink.getUsageParameters();
            Collection externalLinks = specLink.getExternalLinks();
            TModelInstanceInfo tMInstance = null;
            tMInstance = this.objFactory.createTModelInstanceInfo();
            if (ro == null) throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:The_Concept_defining_the_Technical_interface_of_this_Service_Binding_must_be_supplied."));
            Key key = ro.getKey();
            if (key == null) throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:The_Concept_Key_defining_the_Technical_interface_of_this_Service_Binding_must_be_supplied."));
            String id = key.getId();
            if (id != null) {
                tMInstance.setTModelKey(id);
            }
            InstanceDetails details = null;
            if (usageDescription != null || usageParms != null || externalLinks != null) {
                OverviewDoc doc;
                Iterator iterc;
                Iterator iterb;
                details = null;
                details = this.objFactory.createInstanceDetails();
                Collection desc = this.internationalString2Descriptions(usageDescription, publish);
                if (usageDescription != null) {
                    details.getDescription().addAll(desc);
                }
                if (usageParms != null && (iterb = usageParms.iterator()).hasNext()) {
                    details.setInstanceParms((String)iterb.next());
                }
                if (externalLinks != null && (iterc = externalLinks.iterator()).hasNext() && (doc = this.externalLink2OverviewDoc((ExternalLink)iterc.next(), publish)) != null) {
                    details.setOverviewDoc(doc);
                }
            }
            if (details == null) continue;
            tMInstance.setInstanceDetails(details);
            tModelInstanceInfos.add(tMInstance);
        }
        return tModelInstanceInfos;
    }

    HostingRedirector targetBinding2HostingRedirector(ServiceBinding tBinding) throws JAXRException {
        HostingRedirector redirector = null;
        if (tBinding != null) {
            redirector = null;
            redirector = this.objFactory.createHostingRedirector();
            Key key = tBinding.getKey();
            if (key != null) {
                String keyString = key.getId();
                redirector.setBindingKey(keyString);
            } else {
                redirector = null;
            }
        }
        return redirector;
    }

    ServiceBinding hostingRedirector2TargetBinding(HostingRedirector redirector) throws JAXRException {
        ServiceBinding targetBinding = null;
        String key = redirector.getBindingKey();
        if (key != null) {
            targetBinding = (ServiceBinding)this.objectManager.fetchObjectFromCache(key);
            if (targetBinding == null) {
                Iterator bindingIterator;
                Collection bindings;
                KeyImpl bindingKey = new KeyImpl(key);
                ArrayList<KeyImpl> bindingKeys = new ArrayList<KeyImpl>();
                bindingKeys.add(bindingKey);
                BulkResponse bulkResponse = this.getServiceBindings(bindingKeys);
                if (bulkResponse.getExceptions() == null && (bindings = bulkResponse.getCollection()) != null && (bindingIterator = bindings.iterator()).hasNext()) {
                    targetBinding = (ServiceBinding)bindingIterator.next();
                    return targetBinding;
                }
            }
            return targetBinding;
        }
        return null;
    }

    Concept urlType2Concept(URLType urlType) throws JAXRException {
        Collection childConcepts;
        String typeString = urlType.value();
        Collection schemes = this.getConceptsManager().findClassificationSchemeByName(null, "URLType");
        ClassificationScheme scheme = (ClassificationScheme)schemes.iterator().next();
        if (scheme != null && (childConcepts = scheme.getChildrenConcepts()) != null) {
            for (Concept concept : childConcepts) {
                InternationalString name = concept.getName();
                String nameValue = name.getValue();
                String conceptValue = concept.getValue();
                if (typeString == null || conceptValue == null || nameValue == null || typeString.indexOf(nameValue) == -1 && typeString.indexOf(conceptValue) == -1) continue;
                return concept;
            }
        }
        return null;
    }

    Contacts users2Contacts(Collection users, boolean publish) throws JAXRException {
        Contacts contacts = null;
        contacts = this.objFactory.createContacts();
        if (users != null) {
            Iterator iter = users.iterator();
            try {
                while (iter.hasNext()) {
                    Contact contact = this.user2Contact((User)iter.next(), publish);
                    if (contact == null) continue;
                    contacts.getContact().add(contact);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_User"), (Throwable)cce);
            }
        }
        return contacts;
    }

    Contact user2Contact(User user, boolean publish) throws JAXRException {
        Contact contact = null;
        if (user != null) {
            Iterator iter;
            Collection telephoneNumbers = user.getTelephoneNumbers(null);
            PersonNameImpl personName = (PersonNameImpl)user.getPersonName();
            Collection postalAddresses = user.getPostalAddresses();
            Collection emailAddresses = user.getEmailAddresses();
            Collection descriptions = this.getDescriptions((RegistryObject)user, publish);
            String useType = user.getType();
            contact = null;
            contact = this.objFactory.createContact();
            if (personName != null) {
                String contactName = personName.getFullName();
                if (contactName != null) {
                    contact.setPersonName(contactName);
                }
            } else {
                return null;
            }
            if (descriptions != null) {
                contact.getDescription().addAll(descriptions);
            }
            if (useType != null) {
                contact.setUseType(useType);
            }
            if (telephoneNumbers != null && !telephoneNumbers.isEmpty()) {
                iter = telephoneNumbers.iterator();
                try {
                    while (iter.hasNext()) {
                        Phone phone = this.telephoneNumber2Phone((TelephoneNumber)iter.next());
                        if (phone != null) {
                            // empty if block
                        }
                        contact.getPhone().add(phone);
                    }
                }
                catch (ClassCastException cce) {
                    this.logger.log(Level.WARNING, cce.getMessage(), cce);
                    throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_TelephoneNumber"), (Throwable)cce);
                }
            }
            if (emailAddresses != null && !emailAddresses.isEmpty()) {
                iter = emailAddresses.iterator();
                ArrayList<Email> emails = new ArrayList<Email>();
                try {
                    while (iter.hasNext()) {
                        EmailAddress emailAddress = (EmailAddress)iter.next();
                        String address = emailAddress.getAddress();
                        String type = emailAddress.getType();
                        Email email = null;
                        email = this.objFactory.createEmail();
                        if (address != null) {
                            email.setValue(address);
                        }
                        if (type != null) {
                            email.setUseType(type);
                        }
                        emails.add(email);
                    }
                    contact.getEmail().addAll(emails);
                }
                catch (ClassCastException cce) {
                    this.logger.log(Level.WARNING, cce.getMessage(), cce);
                    throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_EmailAddress"), (Throwable)cce);
                }
            }
            if (postalAddresses != null) {
                for (PostalAddress postalAddress : postalAddresses) {
                    Address address = this.postalAddress2Address(postalAddress);
                    contact.getAddress().add(address);
                }
            }
        }
        return contact;
    }

    Phone telephoneNumber2Phone(TelephoneNumber telephoneNumber) throws JAXRException {
        Phone phone = null;
        phone = this.objFactory.createPhone();
        if (telephoneNumber != null) {
            String number;
            String type = telephoneNumber.getType();
            if (type != null) {
                phone.setUseType(type);
            }
            if ((number = telephoneNumber.getNumber()) != null) {
                phone.setValue(number);
            }
        }
        return phone;
    }

    Collection postalAddresses2Addresses(Collection postalAddresses) {
        return null;
    }

    Address postalAddress2Address(PostalAddress postalAddress) throws JAXRException {
        if (postalAddress == null) {
            return null;
        }
        this.initPostalSchemes();
        String type = postalAddress.getType();
        this.logger.finest("Got type");
        Slot sortCode = postalAddress.getSlot("sortCode");
        this.logger.finest("SortCode");
        Address address = null;
        ClassificationScheme defaultScheme = this.defaultPostalScheme;
        address = this.postalAddressEquivalence2Address(defaultScheme, postalAddress);
        if (address == null) {
            try {
                Slot addressLines = postalAddress.getSlot("addressLines");
                this.logger.finest("addressLines");
                address = this.objFactory.createAddress();
                Collection aLines = null;
                aLines = this.postalAddressLines2AddressLines(addressLines);
                this.logger.finest("alines");
                if (aLines != null) {
                    address.getAddressLine().addAll(aLines);
                }
            }
            catch (ClassCastException cce) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_PostalAddress"), (Throwable)cce);
            }
        }
        if (address != null) {
            if (type != null) {
                address.setUseType(type);
            }
            if (sortCode != null) {
                String value;
                Collection values = sortCode.getValues();
                if (values != null && !values.isEmpty() && (value = (String)values.toArray()[0]) != null) {
                    address.setSortCode(value);
                }
            } else {
                address.setSortCode("");
            }
        }
        return address;
    }

    private Address postalAddressEquivalence2Address(ClassificationScheme defaultScheme, PostalAddress postalAddress) throws JAXRException {
        String country;
        String postalCode;
        String state;
        String city;
        String streetNumber;
        boolean unformated = false;
        if (defaultScheme == null) {
            unformated = true;
        }
        ClassificationScheme postalScheme = null;
        if (postalAddress != null) {
            postalScheme = postalAddress.getPostalScheme();
        }
        Object paId = null;
        Address address = null;
        address = this.objFactory.createAddress();
        if (this.postalAddressMap == null) {
            this.mapPostalAddressAttributes(postalScheme);
            if (this.postalAddressMap == null) {
                this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_PostalAddressMapping"));
            }
        }
        ArrayList<String> unformatedLines = new ArrayList<String>();
        ArrayList<AddressLine> addressLines = new ArrayList<AddressLine>();
        String street = postalAddress.getStreet();
        if (street != null) {
            unformatedLines.add(street);
        }
        if ((streetNumber = postalAddress.getStreetNumber()) != null) {
            unformatedLines.add(streetNumber);
        }
        if ((city = postalAddress.getCity()) != null) {
            unformatedLines.add(city);
        }
        if ((state = postalAddress.getStateOrProvince()) != null) {
            unformatedLines.add(state);
        }
        if ((postalCode = postalAddress.getPostalCode()) != null) {
            unformatedLines.add(postalCode);
        }
        if ((country = postalAddress.getCountry()) != null) {
            unformatedLines.add(country);
        }
        AddressLine line = null;
        if (streetNumber != null) {
            line = this.postalAddressAttribute2AddressLine(this.postalAddressMap, streetNumber, "StreetNumber");
            if (line != null) {
                addressLines.add(line);
            }
            line = null;
        }
        if (street != null) {
            line = this.postalAddressAttribute2AddressLine(this.postalAddressMap, street, "Street");
            if (line != null) {
                addressLines.add(line);
            }
            line = null;
        }
        if (city != null) {
            line = this.postalAddressAttribute2AddressLine(this.postalAddressMap, city, "City");
            if (line != null) {
                addressLines.add(line);
            }
            line = null;
        }
        if (state != null) {
            line = this.postalAddressAttribute2AddressLine(this.postalAddressMap, state, "State");
            if (line != null) {
                addressLines.add(line);
            }
            line = null;
        }
        if (postalCode != null) {
            line = this.postalAddressAttribute2AddressLine(this.postalAddressMap, postalCode, "PostalCode");
            if (line != null) {
                addressLines.add(line);
            }
            line = null;
        }
        if (country != null) {
            line = this.postalAddressAttribute2AddressLine(this.postalAddressMap, country, "Country");
            if (line != null) {
                addressLines.add(line);
            }
            line = null;
        }
        if (addressLines != null && !addressLines.isEmpty()) {
            String defaultSchemeId;
            address = null;
            address = this.objFactory.createAddress();
            if (defaultScheme != null && (defaultSchemeId = defaultScheme.getKey().getId()) != null) {
                address.setTModelKey(defaultSchemeId);
            }
            address.getAddressLine().addAll(addressLines);
            return address;
        }
        return null;
    }

    AddressLine postalAddressAttribute2AddressLine(HashMap postalAddressMap, String attribute, String jaxrName) throws JAXRException {
        Object streetLine = null;
        String keyName = null;
        String keyValue = null;
        AddressLine line = null;
        line = this.objFactory.createAddressLine();
        if (attribute == null || attribute.equals("")) {
            return null;
        }
        Concept equivalentConcept = null;
        if (postalAddressMap != null) {
            equivalentConcept = (Concept)postalAddressMap.get(jaxrName);
        }
        if (equivalentConcept != null) {
            keyName = equivalentConcept.getName().getValue();
            keyValue = equivalentConcept.getValue();
        } else {
            keyName = jaxrName;
            keyValue = jaxrName;
        }
        if (attribute != null) {
            if (keyName != null) {
                line.setKeyName(keyName);
            }
            if (keyValue != null) {
                line.setKeyValue(keyValue);
            }
            line.setValue(attribute);
            return line;
        }
        return null;
    }

    Collection postalAddressLines2AddressLines(Slot addressLines) throws JAXRException {
        ArrayList<AddressLine> aLines = null;
        if (addressLines != null) {
            aLines = new ArrayList<AddressLine>();
            Collection values = addressLines.getValues();
            if (values != null) {
                for (String line : values) {
                    AddressLine aline = null;
                    aline = this.objFactory.createAddressLine();
                    if (aline == null) continue;
                    aline.setValue(line);
                    aLines.add(aline);
                }
            }
        }
        return aLines;
    }

    CategoryBag classifications2CategoryBag(Collection classifications) throws JAXRException {
        CategoryBag cbag = null;
        if (classifications != null && !classifications.isEmpty()) {
            cbag = null;
            cbag = this.objFactory.createCategoryBag();
            Classification classification = null;
            Iterator iter = classifications.iterator();
            try {
                while (iter.hasNext()) {
                    classification = (Classification)iter.next();
                    Concept concept = classification.getConcept();
                    if (concept != null) {
                        KeyedReference kref = this.concept2KeyedReference(concept);
                        if (kref == null) continue;
                        cbag.getKeyedReference().add(kref);
                        continue;
                    }
                    ClassificationScheme cScheme = classification.getClassificationScheme();
                    String value = classification.getValue();
                    Name name = this.getName((RegistryObject)classification);
                    String nvalue = null;
                    if (name != null) {
                        nvalue = name.getValue();
                    }
                    if (cScheme != null) {
                        if (value != null && !value.equalsIgnoreCase("")) {
                            KeyedReference kref = this.classification2KeyedReference(cScheme, nvalue, value);
                            if (kref == null) continue;
                            cbag.getKeyedReference().add(kref);
                            continue;
                        }
                        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Concept_specified_for_this_Classification"));
                    }
                    throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Concept_specified_for_this_Classification"));
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Classification"), (Throwable)cce);
            }
        }
        return cbag;
    }

    Collection categoryBag2Classifications(CategoryBag cbag) throws JAXRException {
        ArrayList<Classification> classifications = null;
        if (cbag != null) {
            classifications = new ArrayList<Classification>();
            List<KeyedReference> keyedReference = cbag.getKeyedReference();
            Iterator iter = keyedReference.iterator();
            while (iter.hasNext()) {
                Classification classification = this.keyedReference2Classification((KeyedReference)iter.next());
                if (classification == null) continue;
                classifications.add(classification);
            }
        }
        return classifications;
    }

    CategoryBag concepts2CategoryBag(Collection concepts) throws JAXRException {
        CategoryBag cbag = null;
        if (concepts != null && !concepts.isEmpty()) {
            cbag = null;
            cbag = this.objFactory.createCategoryBag();
            Iterator iter = concepts.iterator();
            try {
                while (iter.hasNext()) {
                    KeyedReference kref = this.concept2KeyedReference((Concept)iter.next());
                    if (kref == null) continue;
                    cbag.getKeyedReference().add(kref);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Concept"), (Throwable)cce);
            }
        }
        return cbag;
    }

    Collection categoryBag2Concepts(CategoryBag cbag) throws JAXRException {
        ArrayList<Concept> concepts = null;
        if (cbag != null) {
            concepts = new ArrayList<Concept>();
            List<KeyedReference> keyedReference = cbag.getKeyedReference();
            Iterator iter = keyedReference.iterator();
            while (iter.hasNext()) {
                Concept concept = this.keyedReference2Concept((KeyedReference)iter.next());
                if (concept == null) continue;
                concepts.add(concept);
            }
        }
        return concepts;
    }

    TModelBag concepts2TModelBag(Collection concepts) throws JAXRException {
        TModelBag tbag = null;
        if (concepts != null && !concepts.isEmpty()) {
            tbag = null;
            tbag = this.objFactory.createTModelBag();
            Concept concept = null;
            Iterator iter = concepts.iterator();
            try {
                while (iter.hasNext()) {
                    concept = (Concept)iter.next();
                    ClassificationScheme scheme = concept.getClassificationScheme();
                    Concept parent = concept.getParentConcept();
                    if (scheme == null && parent == null) {
                        Key key = concept.getKey();
                        tbag.getTModelKey().add(key.getId());
                        continue;
                    }
                    throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:ClassificationScheme_and_Parent_must_be_non-existent_for_specifications"));
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Concept"), (Throwable)cce);
            }
        }
        return tbag;
    }

    String[] strings2Names(Collection namePatterns) throws JAXRException {
        String[] names = null;
        if (namePatterns != null) {
            try {
                names = namePatterns.toArray(new String[0]);
            }
            catch (ArrayStoreException ase) {
                throw new JAXRException((Throwable)ase);
            }
        }
        return names;
    }

    Collection namePatterns2Names(Collection namePatterns, boolean publish) throws JAXRException {
        ArrayList<Name> names = new ArrayList<Name>();
        if (namePatterns != null) {
            for (Object pattern : namePatterns) {
                Collection iname;
                if (pattern instanceof String) {
                    String country;
                    Name name = null;
                    Name dupName = null;
                    name = this.objFactory.createName();
                    dupName = this.objFactory.createName();
                    name.setValue((String)pattern);
                    dupName.setValue((String)pattern);
                    Locale defaultLocale = Locale.getDefault();
                    String lang = defaultLocale.getLanguage();
                    if (!publish) {
                        dupName.setLang(lang);
                        names.add(dupName);
                    }
                    if ((country = defaultLocale.getCountry()) != null && !country.equals("")) {
                        lang = lang + "-" + country;
                    }
                    name.setLang(lang);
                    names.add(name);
                    continue;
                }
                if (!(pattern instanceof InternationalString) || (iname = this.internationalString2Names((InternationalString)pattern, publish)) == null) continue;
                names.addAll(iname);
            }
        }
        return names;
    }

    String key2Key(Key jaxKey) throws JAXRException {
        String key = null;
        if (jaxKey != null) {
            key = jaxKey.getId();
        }
        return key;
    }

    Collection keys2Keys(Collection jaxKeys) throws JAXRException {
        ArrayList<String> keys = new ArrayList<String>();
        if (jaxKeys != null) {
            Iterator iter = jaxKeys.iterator();
            try {
                while (iter.hasNext()) {
                    keys.add(((Key)iter.next()).getId());
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Keys"), (Throwable)cce);
            }
        }
        return keys;
    }

    FindQualifiers strings2FindQualifiers(Collection findQualifiers) throws JAXRException {
        try {
            FindQualifiers fq = null;
            if (findQualifiers != null && !findQualifiers.isEmpty()) {
                fq = null;
                fq = this.objFactory.createFindQualifiers();
                Iterator iter = findQualifiers.iterator();
                while (iter.hasNext()) {
                    fq.getFindQualifier().add((String)iter.next());
                }
            }
            return fq;
        }
        catch (ClassCastException cce) {
            this.logger.log(Level.WARNING, cce.getMessage(), cce);
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_String"), (Throwable)cce);
        }
    }

    DiscoveryURLs externalLinks2DiscoveryURLs(Collection links) throws JAXRException {
        DiscoveryURLs URLs = null;
        if (links != null && !links.isEmpty()) {
            URLs = null;
            URLs = this.objFactory.createDiscoveryURLs();
            ExternalLink link = null;
            Iterator linksiter = links.iterator();
            try {
                while (linksiter.hasNext()) {
                    DiscoveryURL dURL = null;
                    dURL = this.objFactory.createDiscoveryURL();
                    link = (ExternalLink)linksiter.next();
                    String uri = link.getExternalURI();
                    Name name = this.getName((RegistryObject)link);
                    if (uri != null) {
                        dURL.setValue(uri);
                    }
                    if (name == null || name.equals("")) {
                        name.setValue("Unknown Name");
                        name.setLang("");
                    }
                    dURL.setUseType(name.getValue());
                    URLs.getDiscoveryURL().add(dURL);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_ExternalLink"), (Throwable)cce);
            }
        }
        return URLs;
    }

    Collection concepts2TModels(Collection concepts, boolean publish) throws JAXRException {
        ArrayList<TModel> tmodels = null;
        if (concepts != null && !concepts.isEmpty()) {
            tmodels = new ArrayList<TModel>();
            Iterator iter = concepts.iterator();
            try {
                while (iter.hasNext()) {
                    TModel tModel = this.concept2TModel((Concept)iter.next(), publish);
                    if (tModel == null) continue;
                    tmodels.add(tModel);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Concept"), (Throwable)cce);
            }
        }
        return tmodels;
    }

    Collection classificationSchemes2TModels(Collection schemes, boolean publish) throws JAXRException {
        ArrayList<TModel> tmodels = null;
        if (schemes != null && !schemes.isEmpty()) {
            tmodels = new ArrayList<TModel>();
            Iterator iter = schemes.iterator();
            try {
                while (iter.hasNext()) {
                    TModel tModel = this.classificationScheme2TModel((ClassificationScheme)iter.next(), publish);
                    if (tModel == null) continue;
                    tmodels.add(tModel);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_ClassificationScheme"), (Throwable)cce);
            }
        }
        return tmodels;
    }

    TModel concept2TModel(Concept concept, boolean publish) throws JAXRException {
        Collection links;
        IdentifierBag identifierBag;
        Collection identifiers;
        TModel model = null;
        model = this.objFactory.createTModel();
        ConceptImpl aConcept = (ConceptImpl)concept;
        Key key = aConcept.getKey();
        if (key != null) {
            model.setTModelKey(key.getId());
        } else {
            model.setTModelKey("");
        }
        Name name = this.getName((RegistryObject)concept);
        model.setName(name);
        Collection description = this.getDescriptions(aConcept, publish);
        model.getDescription().addAll(description);
        Collection slots = aConcept.getSlots();
        if (slots != null) {
            try {
                for (Slot slot : slots) {
                    String operator;
                    Object[] vals;
                    String authName;
                    Collection values;
                    if (slot.getName().equals("authorizedName") && (values = slot.getValues()) != null && !values.isEmpty() && (authName = (String)(vals = values.toArray())[0]) != null) {
                        model.setAuthorizedName(authName);
                    }
                    if (!slot.getName().equals("operator") || (values = slot.getValues()) == null || values.isEmpty() || (operator = (String)(vals = values.toArray())[0]) == null) continue;
                    model.setOperator(operator);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Slot"), (Throwable)cce);
            }
        }
        if ((identifiers = aConcept.getExternalIdentifiers()) != null && (identifierBag = this.externalIdentifiers2IdentifierBag(identifiers)) != null) {
            model.setIdentifierBag(identifierBag);
        }
        Collection concepts = aConcept.getClassifications();
        CategoryBag categoryBag = null;
        if (concepts != null) {
            categoryBag = this.classifications2CategoryBag(concepts);
        }
        if ((categoryBag = this.addCategorization(categoryBag, "Concept")) != null) {
            model.setCategoryBag(categoryBag);
        }
        if ((links = concept.getExternalLinks()) != null && !links.isEmpty()) {
            OverviewDoc overviewDoc = this.externalLink2OverviewDoc((ExternalLink)links.toArray()[0], publish);
            model.setOverviewDoc(overviewDoc);
        }
        return model;
    }

    TModel classificationScheme2TModel(ClassificationScheme scheme, boolean publish) throws JAXRException {
        Collection links;
        IdentifierBag identifierBag;
        Collection identifiers;
        TModel model = null;
        model = this.objFactory.createTModel();
        Key key = scheme.getKey();
        if (key != null) {
            model.setTModelKey(key.getId());
        } else {
            model.setTModelKey("");
        }
        Name name = this.getName((RegistryObject)scheme);
        model.setName(name);
        Collection description = this.getDescriptions((RegistryObject)scheme, publish);
        model.getDescription().addAll(description);
        Collection slots = scheme.getSlots();
        if (slots != null) {
            try {
                for (Slot slot : slots) {
                    String operator;
                    Object[] vals;
                    String authName;
                    Collection values;
                    if (slot.getName().equals("authorizedName") && (values = slot.getValues()) != null && !values.isEmpty() && (authName = (String)(vals = values.toArray())[0]) != null) {
                        model.setAuthorizedName(authName);
                    }
                    if (!slot.getName().equals("operator") || (values = slot.getValues()) == null || values.isEmpty() || (operator = (String)(vals = values.toArray())[0]) == null) continue;
                    model.setOperator(operator);
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.WARNING, cce.getMessage(), cce);
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Slot"), (Throwable)cce);
            }
        }
        if ((identifiers = scheme.getExternalIdentifiers()) != null && (identifierBag = this.externalIdentifiers2IdentifierBag(identifiers)) != null) {
            model.setIdentifierBag(identifierBag);
        }
        Collection concepts = scheme.getClassifications();
        CategoryBag categoryBag = null;
        if (concepts != null) {
            categoryBag = this.classifications2CategoryBag(concepts);
        }
        if ((categoryBag = this.addCategorization(categoryBag, "ClassificationScheme")) != null) {
            model.setCategoryBag(categoryBag);
        }
        if ((links = scheme.getExternalLinks()) != null && !links.isEmpty()) {
            OverviewDoc overviewDoc = this.externalLink2OverviewDoc((ExternalLink)links.toArray()[0], publish);
            model.setOverviewDoc(overviewDoc);
        }
        return model;
    }

    CategoryBag addCategorization(CategoryBag categoryBag, String objectType) throws JAXRException {
        boolean present = false;
        List<KeyedReference> keyedReferences = null;
        if (categoryBag == null) {
            categoryBag = this.objFactory.createCategoryBag();
        } else {
            keyedReferences = categoryBag.getKeyedReference();
            if (keyedReferences != null) {
                for (KeyedReference ref : keyedReferences) {
                    if (!ref.getTModelKey().equalsIgnoreCase("uuid:c1acf26d-9672-4404-9d70-39b756e62ab4")) continue;
                    present = true;
                    break;
                }
            }
        }
        if (!present) {
            KeyedReference keyedRef = null;
            keyedRef = this.objFactory.createKeyedReference();
            if (objectType.equalsIgnoreCase("ClassificationScheme")) {
                keyedRef.setTModelKey("uuid:c1acf26d-9672-4404-9d70-39b756e62ab4");
                keyedRef.setKeyName("uddi-org:types");
                keyedRef.setKeyValue("categorization");
            } else if (objectType.equalsIgnoreCase("Concept")) {
                keyedRef.setTModelKey("uuid:c1acf26d-9672-4404-9d70-39b756e62ab4");
                keyedRef.setKeyName("uddi-org:types");
                keyedRef.setKeyValue("specification");
            } else {
                keyedRef = null;
            }
            if (keyedRef != null) {
                categoryBag.getKeyedReference().add(keyedRef);
            }
        }
        return categoryBag;
    }

    Concept tModel2Concept(TModelInfo info) throws JAXRException {
        ConceptImpl concept = null;
        String tkey = info.getTModelKey();
        Name name = info.getName();
        if (this.getConnection().useCache()) {
            try {
                concept = (ConceptImpl)this.objectManager.fetchObjectFromCache(tkey);
            }
            catch (ClassCastException cce) {
                this.logger.finest("ClassCastException in tModelInfo2Concept on fetch, continuing");
            }
        }
        if (concept == null) {
            concept = new ConceptImpl();
            concept.setServiceId(this.service.getServiceId());
            concept.setRegistryService(this.service);
        }
        InternationalString iname = this.name2InternationalString(name);
        concept.setName(iname);
        concept.setKey(new KeyImpl(tkey));
        concept.setStatusFlags(true, false, false);
        this.objectManager.addObjectToCache(concept, this.service.getServiceId());
        return concept;
    }

    Concept tModel2Concept(TModel model) throws JAXRException {
        RegistryObjectImpl concept = null;
        String tModelKey = model.getTModelKey();
        if (this.getConnection().useCache()) {
            try {
                concept = (ConceptImpl)this.objectManager.fetchObjectFromCache(tModelKey);
            }
            catch (ClassCastException cce) {
                this.logger.finest("ClassCastException in tModel2Concept, continuing");
                concept = null;
            }
        }
        if (concept == null) {
            concept = new ConceptImpl(new KeyImpl(tModelKey));
            concept.setServiceId(this.service.getServiceId());
            concept.setRegistryService(this.service);
        }
        concept.setIsLoaded(true);
        concept.setIsRetrieved(true);
        concept.setIsNew(false);
        Name name = model.getName();
        String authorizedName = model.getAuthorizedName();
        SlotImpl authSlot = new SlotImpl("authorizedName", "authorizedName", authorizedName);
        concept.addSlot(authSlot);
        String operator = model.getOperator();
        SlotImpl operSlot = new SlotImpl("operator", "operator", operator);
        concept.addSlot(operSlot);
        ExternalLink link = null;
        OverviewDoc odoc = model.getOverviewDoc();
        if (odoc != null && (link = this.overviewDoc2ExternalLink(odoc)) != null) {
            ArrayList<ExternalLink> links = new ArrayList<ExternalLink>();
            links.add(link);
            ((ConceptImpl)concept).setExternalLinks(links);
        }
        Collection externalIds = null;
        IdentifierBag ibag = model.getIdentifierBag();
        if (ibag != null && (externalIds = this.identifierBag2ExternalIdentifiers(ibag)) != null && !externalIds.isEmpty()) {
            concept.setExternalIdentifiers(externalIds);
        }
        Collection classifications = null;
        CategoryBag cbag = model.getCategoryBag();
        if (cbag != null && (classifications = this.categoryBag2Classifications(cbag)) != null && !classifications.isEmpty()) {
            concept.setClassifications(classifications);
        }
        KeyImpl key = new KeyImpl(tModelKey);
        InternationalString iname = this.name2InternationalString(name);
        concept.setName(iname);
        List<Description> description = model.getDescription();
        InternationalString idesc = this.descriptions2InternationalString(description);
        if (idesc != null) {
            concept.setDescription(idesc);
        }
        if (this.getConnection().useCache()) {
            this.objectManager.addObjectToCache(concept, this.service.getServiceId());
        } else {
            this.objectManager.removeObjectFromCache(concept.getKey().getId());
        }
        return concept;
    }

    RegistryObject tModel2ConceptOrClassificationScheme(TModel model) throws JAXRException {
        RegistryObjectImpl ro = null;
        String tModelKey = model.getTModelKey();
        ro = (RegistryObjectImpl)this.objectManager.fetchObjectFromCache(tModelKey);
        if (ro != null) {
            ro.setRegistryService(this.service);
            ro.setIsLoaded(true);
        }
        Collection classifications = null;
        CategoryBag cbag = model.getCategoryBag();
        boolean scheme = false;
        if (cbag != null && (classifications = this.categoryBag2Classifications(cbag)) != null && !classifications.isEmpty()) {
            try {
                Iterator iter = classifications.iterator();
                while (iter.hasNext() && !(scheme = this.isClassificationScheme((Classification)iter.next()))) {
                }
            }
            catch (ClassCastException cce) {
                this.logger.log(Level.SEVERE, cce.getMessage(), cce);
            }
        }
        RegistryObjectImpl registryObject = null;
        if (ro != null) {
            if (scheme) {
                if (ro instanceof Concept) {
                    registryObject = new ClassificationSchemeImpl((ConceptImpl)ro);
                }
            } else {
                registryObject = ro;
            }
        }
        if (registryObject == null) {
            registryObject = scheme ? new ClassificationSchemeImpl(new KeyImpl(tModelKey)) : new ConceptImpl(new KeyImpl(tModelKey));
            registryObject.setServiceId(this.service.getServiceId());
            registryObject.setRegistryService(this.service);
        }
        registryObject.setIsRetrieved(true);
        registryObject.setIsNew(false);
        registryObject.setIsLoaded(true);
        String authorizedName = model.getAuthorizedName();
        SlotImpl authSlot = new SlotImpl("authorizedName", authorizedName, "authorizedName");
        registryObject.addSlot(authSlot);
        String operator = model.getOperator();
        SlotImpl operSlot = new SlotImpl("operator", "operator", operator);
        registryObject.addSlot(operSlot);
        if (classifications != null) {
            registryObject.setClassifications(classifications);
        }
        ExternalLink link = null;
        OverviewDoc odoc = model.getOverviewDoc();
        if (odoc != null && (link = this.overviewDoc2ExternalLink(odoc)) != null) {
            ArrayList<ExternalLink> links = new ArrayList<ExternalLink>();
            links.add(link);
            registryObject.setExternalLinks(links);
        }
        Collection externalIds = null;
        IdentifierBag ibag = model.getIdentifierBag();
        if (ibag != null && (externalIds = this.identifierBag2ExternalIdentifiers(ibag)) != null && !externalIds.isEmpty()) {
            registryObject.setExternalIdentifiers(externalIds);
        }
        Name name = model.getName();
        InternationalString iname = this.name2InternationalString(name);
        registryObject.setName(iname);
        List<Description> description = model.getDescription();
        InternationalString idesc = this.descriptions2InternationalString(description);
        registryObject.setDescription(idesc);
        this.objectManager.addObjectToCache(registryObject, this.service.getServiceId());
        return registryObject;
    }

    boolean isClassificationScheme(Classification classification) throws JAXRException {
        boolean isScheme = false;
        String value = classification.getValue();
        if (value == null) {
            return isScheme;
        }
        if (value.equalsIgnoreCase("identifier")) {
            isScheme = true;
        } else if (value.equalsIgnoreCase("namespace")) {
            isScheme = true;
        } else if (value.equalsIgnoreCase("categorization")) {
            isScheme = true;
        } else if (value.equalsIgnoreCase("postalAddress")) {
            isScheme = true;
        }
        return isScheme;
    }

    KeyedReference externalIdentifier2KeyedReference(ExternalIdentifier identifier) throws JAXRException {
        KeyedReference keyedRef = null;
        keyedRef = this.objFactory.createKeyedReference();
        ClassificationScheme identScheme = identifier.getIdentificationScheme();
        if (identScheme == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:IdentificationScheme_missing_-_this_must_be_supplied"));
        }
        Key ikey = identScheme.getKey();
        String id = null;
        if (ikey != null) {
            id = ikey.getId();
        }
        if (ikey == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_IdentificationScheme_Key_-_this_must_be_supplied"));
        }
        keyedRef.setTModelKey(id);
        String name = null;
        try {
            name = identifier.getName().getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (name != null) {
            keyedRef.setKeyName(name);
        } else {
            keyedRef.setKeyName("");
        }
        String value = identifier.getValue();
        if (value == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_ExternialIdentifier_Value_supplied_-_this_must_be_supplied"));
        }
        keyedRef.setKeyValue(value);
        return keyedRef;
    }

    ExternalIdentifier keyedReference2ExternalIdentifier(KeyedReference keyedRef) throws JAXRException {
        ExternalIdentifierImpl identifier = null;
        if (keyedRef != null) {
            String tModelKey = keyedRef.getTModelKey();
            String keyName = keyedRef.getKeyName();
            String value = keyedRef.getKeyValue();
            ClassificationSchemeImpl scheme = new ClassificationSchemeImpl();
            scheme.setKey(new KeyImpl(tModelKey));
            scheme.setName(new InternationalStringImpl(keyName));
            identifier = new ExternalIdentifierImpl(scheme, keyName, value);
            identifier.setRegistryService(this.service);
        }
        return identifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    KeyedReference concept2KeyedReference(Concept concept) throws JAXRException {
        ConceptImpl aConcept = (ConceptImpl)concept;
        KeyedReference keyedRef = null;
        keyedRef = this.objFactory.createKeyedReference();
        if (concept == null) return keyedRef;
        ClassificationScheme parent = concept.getClassificationScheme();
        if (parent == null) throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Root_Concept_for_this_concept__") + concept.getName());
        Key key = parent.getKey();
        if (key == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Root_ClassificationScheme_key_supplied"));
        }
        String pvalue = key.getId();
        String name = null;
        if (aConcept.getName() != null) {
            name = aConcept.getName().getValue();
        }
        String value = aConcept.getValue();
        if (name != null) {
            keyedRef.setKeyName(name);
        } else {
            keyedRef.setKeyName("Unknown");
        }
        if (value == null) {
            return null;
        }
        keyedRef.setKeyValue(value);
        if (pvalue == null) return null;
        keyedRef.setTModelKey(pvalue);
        return keyedRef;
    }

    KeyedReference classification2KeyedReference(ClassificationScheme scheme, String vname, String value) throws JAXRException {
        KeyedReference keyedRef = null;
        if (scheme != null) {
            keyedRef = null;
            keyedRef = this.objFactory.createKeyedReference();
            Key key = scheme.getKey();
            String pvalue = null;
            if (key != null) {
                pvalue = key.getId();
            }
            if (vname != null) {
                keyedRef.setKeyName(vname);
            } else {
                keyedRef.setKeyName("");
            }
            if (value == null) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Classification_must_have_a_value_"));
            }
            keyedRef.setKeyValue(value);
            if (pvalue != null) {
                keyedRef.setTModelKey(pvalue);
            } else {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Parent_ClassificationScheme_key_must_have_a_value_"));
            }
        }
        return keyedRef;
    }

    Concept keyedReference2Concept(KeyedReference keyedRef) throws JAXRException {
        ConceptImpl concept = null;
        String tModelKey = keyedRef.getTModelKey();
        String keyName = keyedRef.getKeyName();
        String value = keyedRef.getKeyValue();
        concept = new ConceptImpl(new KeyImpl(tModelKey), keyName, value);
        concept.setName(new InternationalStringImpl(keyName));
        concept.setIsRetrieved(true);
        concept.setIsLoaded(false);
        concept.setIsNew(false);
        this.objectManager.addObjectToCache(concept, this.service.getServiceId());
        return concept;
    }

    Classification keyedReference2Classification(KeyedReference keyedRef) throws JAXRException {
        String tModelKey = keyedRef.getTModelKey();
        String keyName = keyedRef.getKeyName();
        String value = keyedRef.getKeyValue();
        ClassificationSchemeImpl scheme = (ClassificationSchemeImpl)this.getConceptsManager().getClassificationSchemeById(tModelKey);
        if (scheme == null) {
            try {
                scheme = (ClassificationSchemeImpl)this.objectManager.fetchObjectFromCache(tModelKey);
            }
            catch (ClassCastException cce) {
                this.logger.finest("ClassCastException in keyedRef2Classification feting classificationScheme");
                scheme = null;
            }
        }
        if (scheme == null) {
            scheme = new ClassificationSchemeImpl();
            scheme.setKey(new KeyImpl(tModelKey));
            scheme.setIsLoaded(false);
            scheme.setIsNew(false);
            scheme.setIsRetrieved(true);
            this.objectManager.addObjectToCache(scheme, this.service.getServiceId());
        }
        ClassificationImpl classification = new ClassificationImpl();
        classification.setClassificationScheme(scheme);
        classification.setName(new InternationalStringImpl(keyName));
        classification.setValue(value);
        classification.setRegistryService(this.service);
        return classification;
    }

    KeyedReference key2KeyedReference(Key key) throws JAXRException {
        KeyedReference keyedRef = null;
        keyedRef = this.objFactory.createKeyedReference();
        if (key != null) {
            String pvalue = key.getId();
            keyedRef.setTModelKey(pvalue);
        }
        return keyedRef;
    }

    OverviewDoc externalLink2OverviewDoc(ExternalLink link, boolean publish) throws JAXRException {
        ExternalLinkImpl linx = (ExternalLinkImpl)link;
        OverviewDoc doc = null;
        doc = this.objFactory.createOverviewDoc();
        if (link != null) {
            String url = linx.getExternalURI();
            doc.setOverviewURL(url);
            Collection description = this.getDescriptions(linx, publish);
            doc.getDescription().addAll(description);
        }
        return doc;
    }

    ExternalLink overviewDoc2ExternalLink(OverviewDoc doc) throws JAXRException {
        ExternalLinkImpl link = null;
        if (doc != null) {
            String urlString = doc.getOverviewURL();
            List<Description> description = doc.getDescription();
            InternationalString idesc = this.descriptions2InternationalString(description);
            link = new ExternalLinkImpl();
            link.setValidateURI(false);
            link.setExternalURI(urlString);
            if (idesc != null) {
                link.setDescription(idesc);
            }
        }
        return link;
    }

    Collection tModelInstanceInfos2SpecificationLinks(Collection instanceInfo) throws JAXRException {
        ArrayList<SpecificationLinkImpl> specificationLinks = new ArrayList<SpecificationLinkImpl>();
        Iterator iter = instanceInfo.iterator();
        if (instanceInfo != null) {
            while (iter.hasNext()) {
                SpecificationLinkImpl specLink = new SpecificationLinkImpl();
                specLink.setRegistryService(this.service);
                TModelInstanceInfo info = (TModelInstanceInfo)iter.next();
                String tModelKey = info.getTModelKey();
                List<Description> descript = info.getDescription();
                InstanceDetails instanceDetails = info.getInstanceDetails();
                ConceptImpl classConcept = null;
                if (tModelKey != null) {
                    try {
                        classConcept = (ConceptImpl)this.objectManager.fetchObjectFromCache(tModelKey);
                    }
                    catch (ClassCastException cce) {
                        this.logger.finest("ClassCastException in tModelInstanceInfos2SpecificationLinks fetch concept, continuing");
                        classConcept = null;
                    }
                    if (classConcept == null) {
                        classConcept = new ConceptImpl();
                        classConcept.setRegistryService(this.service);
                        classConcept.setKey(new KeyImpl(tModelKey));
                        classConcept.setStatusFlags(true, false, false);
                        classConcept.setRegistryService(this.service);
                        this.objectManager.addObjectToCache(classConcept, this.service.getServiceId());
                    }
                    if (classConcept != null) {
                        specLink.setSpecificationObject(classConcept);
                        this.logger.finest("setting specification concept");
                    }
                }
                if (instanceDetails != null) {
                    this.logger.finest("have instance Details");
                    OverviewDoc oDoc = instanceDetails.getOverviewDoc();
                    String params = instanceDetails.getInstanceParms();
                    List<Description> instanceDescription = instanceDetails.getDescription();
                    InternationalString idesc = this.descriptions2InternationalString(instanceDescription);
                    if (idesc != null) {
                        specLink.setUsageDescription(idesc);
                    }
                    if (params != null) {
                        ArrayList<String> up = new ArrayList<String>();
                        up.add(params);
                        specLink.setUsageParameters(up);
                    }
                    RegistryObjectImpl exLink = null;
                    if (oDoc != null) {
                        this.logger.finest("oDoc is found");
                        exLink = (ExternalLinkImpl)this.overviewDoc2ExternalLink(oDoc);
                        if (exLink == null) {
                            this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Exlink_is_null"));
                        }
                    }
                    if (exLink != null) {
                        exLink.setRegistryService(this.service);
                        specLink.addExternalLink((ExternalLink)exLink);
                    }
                }
                if (specLink == null) continue;
                this.logger.finest("Adding specificationLink");
                specificationLinks.add(specLink);
            }
            return specificationLinks;
        }
        return null;
    }

    Organization businessInfo2Organization(BusinessInfo info) throws JAXRException {
        ServiceInfos serviceInfos;
        List<Description> description;
        InternationalString idesc;
        OrganizationImpl org = null;
        String businessKey = info.getBusinessKey();
        if (this.getConnection().useCache()) {
            try {
                org = (OrganizationImpl)this.objectManager.fetchObjectFromCache(businessKey);
            }
            catch (ClassCastException cce) {
                this.logger.finest("CLassCastException businessInfo2Org on fetch from cache, continuing");
                org = null;
            }
        }
        if (org == null) {
            org = new OrganizationImpl();
            org.setServiceId(this.service.getServiceId());
        }
        org.setRegistryService(this.service);
        org.setIsRetrieved(false);
        List<Name> name = info.getName();
        InternationalString iname = this.names2InternationalString(name);
        if (iname != null) {
            org.setName(iname);
        }
        if (businessKey != null) {
            org.setKey(new KeyImpl(businessKey));
        }
        if ((idesc = this.descriptions2InternationalString(description = info.getDescription())) != null) {
            org.setDescription(idesc);
        }
        if ((serviceInfos = info.getServiceInfos()) != null) {
            ArrayList<ServiceImpl> serviceCollection = new ArrayList<ServiceImpl>();
            List<ServiceInfo> sInfo = serviceInfos.getServiceInfo();
            Iterator iter = sInfo.iterator();
            while (iter.hasNext()) {
                ServiceImpl service = (ServiceImpl)this.serviceInfo2Service((ServiceInfo)iter.next());
                if (service == null) continue;
                service.setServiceId(this.service.getServiceId());
                service.setRegistryService(this.service);
                serviceCollection.add(service);
            }
            if (serviceCollection != null) {
                org.setServices(serviceCollection);
            }
        }
        org.setIsRetrieved(true);
        org.setIsNew(false);
        if (!this.getConnection().useCache()) {
            org.setIsLoaded(false);
        }
        this.objectManager.addObjectToCache(org, this.service.getServiceId());
        return org;
    }

    Collection relatedBusinessInfo2Associations(RelatedBusinessInfo info, Collection keys) throws JAXRException {
        List<SharedRelationships> sharedRelationships;
        Collection associations;
        List<Description> description;
        InternationalString idesc;
        List<Name> name;
        InternationalString iname;
        Iterator keysIter;
        KeyImpl key;
        String originalOrgKeyId;
        OrganizationImpl relatedOrg = null;
        OrganizationImpl originalOrg = null;
        if (keys == null) {
            this.logger.finest("Keys are null");
        }
        if (keys != null && !keys.isEmpty() && (originalOrg = (OrganizationImpl)this.objectManager.fetchObjectFromCache(originalOrgKeyId = (key = (KeyImpl)(keysIter = keys.iterator()).next()).getId())) == null) {
            originalOrg = (OrganizationImpl)this.getRegistryObject(originalOrgKeyId, "Organization");
        }
        String businessKey = info.getBusinessKey();
        this.logger.finest("Related Business Key " + businessKey);
        relatedOrg = (OrganizationImpl)this.objectManager.fetchObjectFromCache(businessKey);
        if (relatedOrg == null) {
            relatedOrg = new OrganizationImpl();
            relatedOrg.setServiceId(this.service.getServiceId());
            relatedOrg.setRegistryService(this.service);
        }
        relatedOrg.setIsRetrieved(true);
        relatedOrg.setIsNew(false);
        if (businessKey != null) {
            relatedOrg.setKey(new KeyImpl(businessKey));
        }
        if ((iname = this.names2InternationalString(name = info.getName())) != null) {
            relatedOrg.setName(iname);
        }
        if (businessKey != null) {
            relatedOrg.setKey(new KeyImpl(businessKey));
        }
        if ((idesc = this.descriptions2InternationalString(description = info.getDescription())) != null) {
            relatedOrg.setDescription(idesc);
        }
        if ((associations = this.sharedRelationships2Associations(relatedOrg, originalOrg, sharedRelationships = info.getSharedRelationships())) != null) {
            this.logger.finest("RelatedBusinessInfo2Associations : associations = " + associations.size());
        }
        this.objectManager.addObjectToCache(relatedOrg, this.service.getServiceId());
        return associations;
    }

    Collection sharedRelationships2Associations(Organization relatedOrg, Organization originalOrg, Collection sharedRelationships) throws JAXRException {
        ArrayList<AssociationImpl> associations = new ArrayList<AssociationImpl>();
        for (SharedRelationships sharedRelationship : sharedRelationships) {
            Direction direction = sharedRelationship.getDirection();
            String directionType = direction.value();
            Organization sourceObject = null;
            Organization targetObject = null;
            String sourceKeyId = null;
            String targetKeyId = null;
            if (directionType.equalsIgnoreCase("fromKey")) {
                sourceObject = relatedOrg;
                sourceKeyId = relatedOrg.getKey().getId();
                targetObject = originalOrg;
                targetKeyId = originalOrg.getKey().getId();
            } else if (directionType.equalsIgnoreCase("toKey")) {
                sourceObject = originalOrg;
                sourceKeyId = originalOrg.getKey().getId();
                targetObject = relatedOrg;
                targetKeyId = relatedOrg.getKey().getId();
            }
            List<KeyedReference> keyedReferences = sharedRelationship.getKeyedReference();
            Collection associationTypes = this.keyedReferences2AssociationTypes(keyedReferences);
            for (Concept type : associationTypes) {
                AssociationImpl association = new AssociationImpl();
                association.setAssociationType(type);
                association.setSourceObject((RegistryObject)sourceObject);
                association.setTargetObject((RegistryObject)targetObject);
                association.setRegistryService(this.service);
                if (!sourceKeyId.equals(targetKeyId)) {
                    association.setIsExtramural(true);
                }
                KeyImpl associationKey = this.buildAssociationKey(sourceKeyId, targetKeyId, type.getValue());
                association.setKey(associationKey);
                association.setIsConfirmedBySourceOwner(true);
                association.setIsConfirmedByTargetOwner(true);
                associations.add(association);
            }
        }
        return associations;
    }

    Collection keyedReferences2AssociationTypes(Collection keyedReferences) throws JAXRException {
        ArrayList<ConceptImpl> associationTypes = null;
        if (keyedReferences != null) {
            Iterator iter = keyedReferences.iterator();
            associationTypes = new ArrayList<ConceptImpl>();
            while (iter.hasNext()) {
                KeyedReference keyedRef = (KeyedReference)iter.next();
                String key = keyedRef.getTModelKey();
                String name = keyedRef.getKeyName();
                String value = keyedRef.getKeyValue();
                String newName = null;
                String newValue = null;
                if (value.equals("peer-peer")) {
                    newName = "RelatedTo";
                    newValue = "RelatedTo";
                } else if (value.equals("identity")) {
                    newName = "EquivalentTo";
                    newValue = "EquivalentTo";
                } else if (value.equals("parent-child")) {
                    newName = "HasChild";
                    newValue = "HasChild";
                } else {
                    newName = name;
                    newValue = value;
                }
                ConceptImpl concept = new ConceptImpl();
                if (name != null) {
                    concept.setName(new InternationalStringImpl(newName));
                }
                if (value != null) {
                    concept.setValue(newValue);
                }
                if (key != null) {
                    concept.setKey(new KeyImpl(key));
                }
                associationTypes.add(concept);
            }
        }
        return associationTypes;
    }

    Organization businessEntity2Organization(BusinessEntity entity) throws JAXRException {
        List<Contact> users;
        InternationalString idesc;
        InternationalString iname;
        if (entity == null) {
            return null;
        }
        OrganizationImpl org = null;
        String businessKey = entity.getBusinessKey();
        try {
            org = (OrganizationImpl)this.objectManager.fetchObjectFromCache(businessKey);
        }
        catch (ClassCastException cce) {
            this.logger.finest("ClassCastException fetching org in businessEntity2Org, continuing");
        }
        if (org == null) {
            org = new OrganizationImpl();
            org.setServiceId(this.service.getServiceId());
            org.setRegistryService(this.service);
        }
        org.setIsRetrieved(true);
        org.setIsNew(false);
        org.setIsLoaded(true);
        String operator = entity.getOperator();
        SlotImpl operatorSlot = null;
        if (operator != null && (operatorSlot = new SlotImpl("operator", operator, null)) != null) {
            org.addSlot(operatorSlot);
        }
        String authorizedName = entity.getAuthorizedName();
        SlotImpl authorizedNameSlot = null;
        if (authorizedName != null && (authorizedNameSlot = new SlotImpl("authorizedName", authorizedName, null)) != null) {
            org.addSlot(authorizedNameSlot);
        }
        List<Name> businessName = entity.getName();
        List<Description> description = entity.getDescription();
        Contacts contacts = entity.getContacts();
        BusinessServices businessServices = entity.getBusinessServices();
        Collection identifiers = null;
        IdentifierBag ibag = entity.getIdentifierBag();
        if (ibag != null && (identifiers = this.identifierBag2ExternalIdentifiers(ibag)) != null) {
            org.setExternalIdentifiers(identifiers);
        }
        Collection classifications = null;
        CategoryBag cbag = entity.getCategoryBag();
        if (cbag != null && (classifications = this.categoryBag2Classifications(cbag)) != null) {
            org.setClassifications(classifications);
        }
        Collection externalLinks = null;
        DiscoveryURLs urls = entity.getDiscoveryURLs();
        if (urls != null && (externalLinks = this.discoveryURLs2ExternalLinks(urls)) != null) {
            org.setExternalLinks(externalLinks);
        }
        if (businessKey != null) {
            org.setKey(new KeyImpl(businessKey));
        }
        if (businessName != null && (iname = this.names2InternationalString(businessName)) != null) {
            org.setName(iname);
        }
        if (description != null && (idesc = this.descriptions2InternationalString(description)) != null) {
            org.setDescription(idesc);
        }
        if (businessServices != null) {
            List<BusinessService> businessService = businessServices.getBusinessService();
            ArrayList<Service> serviceCollection = new ArrayList<Service>();
            if (businessService != null) {
                Iterator iter = businessService.iterator();
                while (iter.hasNext()) {
                    Service service = this.businessService2Service((BusinessService)iter.next());
                    if (service == null) continue;
                    serviceCollection.add(service);
                }
                if (serviceCollection != null) {
                    org.setServices(serviceCollection);
                }
            }
        }
        if (contacts != null && (users = contacts.getContact()) != null) {
            Iterator iter = users.iterator();
            Collection ousers = org.getUsers();
            org.removeUsers(ousers);
            int i = 0;
            while (iter.hasNext()) {
                UserImpl user = (UserImpl)this.contact2User((Contact)iter.next());
                user.setIsLoaded(true);
                user.setRegistryService(this.service);
                if (user != null) {
                    user.setSubmittingOrganization(org);
                    user.setOrganization(org);
                }
                if (i == 0) {
                    org.setPrimaryContact(user);
                    ++i;
                    continue;
                }
                org.addUser(user);
            }
        }
        this.objectManager.addObjectToCache(org, this.service.getServiceId());
        return org;
    }

    Collection discoveryURLs2ExternalLinks(DiscoveryURLs urls) throws JAXRException {
        ArrayList<ExternalLinkImpl> externalLinks = null;
        List<DiscoveryURL> dUrls = urls.getDiscoveryURL();
        if (dUrls != null) {
            externalLinks = new ArrayList<ExternalLinkImpl>();
            for (DiscoveryURL url : dUrls) {
                String uri = url.getValue();
                String type = url.getUseType();
                ExternalLinkImpl link = new ExternalLinkImpl();
                link.setRegistryService(this.service);
                link.setValidateURI(false);
                if (uri != null) {
                    link.setExternalURI(uri);
                }
                if (type != null) {
                    link.setName(new InternationalStringImpl(type));
                } else {
                    link.setName(new InternationalStringImpl("ExternalLink"));
                }
                externalLinks.add(link);
            }
        }
        return externalLinks;
    }

    User contact2User(Contact user) throws JAXRException {
        if (user != null) {
            Collection postalAddresses;
            Collection emails;
            InternationalString description;
            String useType = user.getUseType();
            List<Description> descriptions = user.getDescription();
            String name = user.getPersonName();
            List<Phone> phone = user.getPhone();
            List<Email> email = user.getEmail();
            List<Address> address = user.getAddress();
            UserImpl theUser = new UserImpl();
            if (name != null) {
                theUser.setPersonName(new PersonNameImpl(name));
            }
            if (useType != null) {
                theUser.setType(useType);
            }
            if (descriptions != null && (description = this.descriptions2InternationalString(descriptions)) != null) {
                theUser.setDescription(description);
            }
            if (phone != null) {
                Collection telephoneNumbers = this.phones2TelephoneNumbers(phone);
                theUser.setTelephoneNumbers(telephoneNumbers);
            }
            if (email != null && (emails = this.emails2EmailAddresses(email)).size() > 0) {
                theUser.setEmailAddresses(emails);
            }
            if (address != null && (postalAddresses = this.addresses2PostalAddresses(address)).size() > 0) {
                theUser.setPostalAddresses(postalAddresses);
            }
            return theUser;
        }
        return null;
    }

    private PostalAddress address2PostalAddress(Address address) throws JAXRException {
        PostalAddressImpl postalAddress = null;
        if (address != null) {
            String sortCode;
            String useType;
            ClassificationScheme defaultScheme;
            this.initPostalSchemes();
            List<AddressLine> addressLines = address.getAddressLine();
            String postalSchemeId = address.getTModelKey();
            this.logger.finest("PostalSchemeId retrieved = " + postalSchemeId);
            if (postalSchemeId != null && (defaultScheme = this.service.getDefaultPostalScheme()) != null && defaultScheme.getKey().getId().equalsIgnoreCase(postalSchemeId)) {
                if (this.postalAddressMap == null) {
                    this.mapPostalAddressAttributes(defaultScheme);
                }
                if (this.postalAddressMap == null) {
                    this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_PostalAddressMapping"));
                } else {
                    postalAddress = this.addressLines2PostalAddressEquivalence(defaultScheme, addressLines);
                }
            }
            if (postalAddress == null && addressLines != null) {
                postalAddress = new PostalAddressImpl();
                SlotImpl addressSlot = new SlotImpl();
                addressSlot.setName("addressLines");
                ArrayList<String> values = new ArrayList<String>();
                Iterator liter = addressLines.iterator();
                while (liter.hasNext()) {
                    values.add(((AddressLine)liter.next()).getValue());
                }
                addressSlot.setValues(values);
                postalAddress.addSlot(addressSlot);
            }
            if ((useType = address.getUseType()) != null) {
                postalAddress.setType(useType);
            }
            if ((sortCode = address.getSortCode()) != null) {
                SlotImpl sortCodeSlot = new SlotImpl();
                sortCodeSlot.setName("sortCode");
                ArrayList<String> values = new ArrayList<String>();
                values.add(sortCode);
                sortCodeSlot.setValues(values);
                postalAddress.addSlot(sortCodeSlot);
            }
        }
        return postalAddress;
    }

    PostalAddress addressLines2PostalAddressEquivalence(ClassificationScheme defaultScheme, Collection addressLines) throws JAXRException {
        SlotImpl addressSlot = null;
        ArrayList<String> values = null;
        PostalAddressImpl postalAddress = null;
        if (this.postalAddressMap == null) {
            return null;
        }
        if (defaultScheme != null && addressLines != null) {
            Collection defaultChildren = defaultScheme.getChildrenConcepts();
            for (AddressLine line : addressLines) {
                String keyValue = line.getKeyValue();
                String keyName = line.getKeyName();
                if (keyValue != null) {
                    block1: for (Concept child : defaultChildren) {
                        if (!this.postalAddressMap.containsValue(child)) continue;
                        Set keys = this.postalAddressMap.keySet();
                        Iterator kiter = keys.iterator();
                        String childValue = child.getValue();
                        while (kiter.hasNext()) {
                            String jaxrName = (String)kiter.next();
                            Concept value = (Concept)this.postalAddressMap.get(jaxrName);
                            if (!value.getValue().equalsIgnoreCase(keyValue)) continue;
                            if (postalAddress == null) {
                                postalAddress = new PostalAddressImpl();
                            }
                            postalAddress = this.mapEquivalentLine2PostalAttribute(jaxrName, line, postalAddress);
                            continue block1;
                        }
                    }
                    continue;
                }
                if (keyName != null) {
                    ClassificationScheme jaxrPostalScheme = this.findClassificationSchemeByName(null, "PostalAddressAttributes");
                    if (jaxrPostalScheme == null) continue;
                    Collection children = jaxrPostalScheme.getChildrenConcepts();
                    for (Concept child : children) {
                        String childName = child.getName().getValue();
                        if (!childName.equalsIgnoreCase(keyName) || postalAddress != null) continue;
                        postalAddress = new PostalAddressImpl();
                        postalAddress = this.mapEquivalentLine2PostalAttribute(keyName, line, postalAddress);
                    }
                    continue;
                }
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(line.getValue());
            }
            if (values != null && values.size() > 0) {
                if (postalAddress == null) {
                    postalAddress = new PostalAddressImpl();
                }
                addressSlot = new SlotImpl();
                addressSlot.setName("addressLines");
                addressSlot.setValues(values);
                postalAddress.addSlot(addressSlot);
            }
            return postalAddress;
        }
        return null;
    }

    PostalAddress mapEquivalentLine2PostalAttribute(String jaxrName, AddressLine line, PostalAddress postalAddress) throws JAXRException {
        String content = line.getValue();
        if (content != null) {
            if (jaxrName.equalsIgnoreCase("StreetNumber")) {
                postalAddress.setStreetNumber(content);
            } else if (jaxrName.equalsIgnoreCase("Street")) {
                postalAddress.setStreet(content);
            } else if (jaxrName.equalsIgnoreCase("City")) {
                postalAddress.setCity(content);
            } else if (jaxrName.equalsIgnoreCase("State")) {
                postalAddress.setStateOrProvince(content);
            } else if (jaxrName.equalsIgnoreCase("PostalCode")) {
                postalAddress.setPostalCode(content);
            } else if (jaxrName.equalsIgnoreCase("Country")) {
                postalAddress.setCountry(content);
            } else {
                this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_matching_postal_Address_Attribute"));
            }
        }
        return postalAddress;
    }

    Collection addresses2PostalAddresses(Collection addresses) throws JAXRException {
        ArrayList<PostalAddress> postalAddresses = null;
        if (addresses != null) {
            postalAddresses = new ArrayList<PostalAddress>();
            Iterator iter = addresses.iterator();
            while (iter.hasNext()) {
                PostalAddress postalAddress = this.address2PostalAddress((Address)iter.next());
                if (postalAddress == null) continue;
                postalAddresses.add(postalAddress);
            }
            return postalAddresses;
        }
        return null;
    }

    Collection emails2EmailAddresses(Collection emails) throws JAXRException {
        ArrayList<EmailAddressImpl> emailAddresses = null;
        if (emails != null) {
            emailAddresses = new ArrayList<EmailAddressImpl>();
            for (Email email : emails) {
                String emailAddress = email.getValue();
                String useType = email.getUseType();
                EmailAddressImpl address = new EmailAddressImpl();
                if (emailAddress != null) {
                    address.setAddress(emailAddress);
                }
                if (useType != null) {
                    address.setType(useType);
                }
                emailAddresses.add(address);
            }
        }
        return emailAddresses;
    }

    Collection phones2TelephoneNumbers(Collection phones) throws JAXRException {
        ArrayList<TelephoneNumberImpl> numbers = null;
        if (phones != null) {
            numbers = new ArrayList<TelephoneNumberImpl>(phones.size());
            Iterator iter = phones.iterator();
            while (iter.hasNext()) {
                String useType;
                TelephoneNumberImpl telephone = new TelephoneNumberImpl();
                Phone phone = (Phone)iter.next();
                String number = phone.getValue();
                if (number != null) {
                    telephone.setNumber(number);
                }
                if ((useType = phone.getUseType()) != null) {
                    telephone.setType(useType);
                }
                numbers.add(telephone);
            }
            return numbers;
        }
        return null;
    }

    ServiceBinding bindingTemplate2ServiceBinding(BindingTemplate template) throws JAXRException {
        List<TModelInstanceInfo> instanceInfo;
        TModelInstanceDetails tModelInstanceDetails;
        ServiceBinding redirectorBinding;
        ServiceBindingImpl sBinding = null;
        ServiceImpl sService = null;
        String tkey = template.getBindingKey();
        String skey = template.getServiceKey();
        try {
            sService = (ServiceImpl)this.objectManager.fetchObjectFromCache(skey);
        }
        catch (ClassCastException cce) {
            this.logger.finest("ClassCastException in bindingTemplate2ServiceBinding fetch service, continuing");
            sService = null;
        }
        try {
            sBinding = (ServiceBindingImpl)this.objectManager.fetchObjectFromCache(tkey);
        }
        catch (ClassCastException cce) {
            this.logger.finest("ClassCastException in bindingTemplate2ServicBinding fetchin serviceBinding, continuing");
            sBinding = null;
        }
        if (sBinding == null) {
            sBinding = new ServiceBindingImpl();
            sBinding.setServiceId(this.service.getServiceId());
        }
        sBinding.setRegistryService(this.service);
        sBinding.setIsLoaded(true);
        sBinding.setIsRetrieved(false);
        sBinding.setIsNew(false);
        if (sService != null) {
            sService.setIsRetrieved(true);
            sBinding.setService(sService);
        }
        sBinding.setKey(new KeyImpl(tkey));
        List<Description> description = template.getDescription();
        InternationalString idesc = this.descriptions2InternationalString(description);
        sBinding.setDescription(idesc);
        AccessPoint accessPoint = null;
        HostingRedirector redirector = null;
        if (template != null) {
            accessPoint = template.getAccessPoint();
            redirector = template.getHostingRedirector();
        }
        if (accessPoint != null) {
            String uri;
            URLType type = accessPoint.getURLType();
            if (type != null) {
                Concept urlTypeConcept = this.urlType2Concept(type);
                ClassificationImpl classification = new ClassificationImpl(urlTypeConcept);
                classification.setRegistryService(this.service);
                sBinding.addClassification(classification);
            }
            if ((uri = accessPoint.getValue()) != null) {
                sBinding.setValidateURI(false);
                sBinding.setAccessURI(uri);
            }
        }
        if (redirector != null && (redirectorBinding = this.hostingRedirector2TargetBinding(redirector)) != null) {
            ((ServiceBindingImpl)redirectorBinding).setRegistryService(this.service);
            sBinding.setTargetBinding(redirectorBinding);
        }
        if ((tModelInstanceDetails = template.getTModelInstanceDetails()) != null && (instanceInfo = tModelInstanceDetails.getTModelInstanceInfo()) != null) {
            this.logger.finest("Got InstanceInfo");
            Collection specLinks = this.tModelInstanceInfos2SpecificationLinks(instanceInfo);
            if (specLinks != null && specLinks.size() > 0) {
                sBinding.setSpecificationLinks(specLinks);
            }
        }
        if (this.getConnection().useCache()) {
            this.objectManager.addObjectToCache(sBinding, this.service.getServiceId());
        } else {
            this.objectManager.removeObjectFromCache(sBinding.getKey().getId());
        }
        return sBinding;
    }

    Service serviceInfo2Service(ServiceInfo sInfo) throws JAXRException {
        ServiceImpl rservice = null;
        String serviceKey = sInfo.getServiceKey();
        String businessKey = sInfo.getBusinessKey();
        Object sOrg = null;
        if (this.getConnection().useCache()) {
            try {
                rservice = (ServiceImpl)this.objectManager.fetchObjectFromCache(serviceKey);
            }
            catch (ClassCastException cce) {
                this.logger.finest("ClassCastException on fetch of service, serviceInfo2Service, continuing");
                rservice = null;
            }
        }
        if (rservice == null) {
            rservice = new ServiceImpl();
            rservice.setServiceId(this.service.getServiceId());
        }
        rservice.setRegistryService(this.service);
        rservice.setIsRetrieved(false);
        rservice.setKey(new KeyImpl(serviceKey));
        OrganizationImpl registryObject = null;
        if (businessKey != null) {
            try {
                registryObject = (OrganizationImpl)this.objectManager.fetchObjectFromCache(businessKey);
            }
            catch (ClassCastException cce) {
                this.logger.finest("ClassCastException fetching providing Org, serviceInfo2Service, continuing");
                registryObject = null;
            }
            if (registryObject == null) {
                registryObject = new OrganizationImpl();
                registryObject.setKey(new KeyImpl(businessKey));
                registryObject.setIsRetrieved(true);
                registryObject.setRegistryService(this.service);
                registryObject.setIsNew(false);
                this.objectManager.addObjectToCache(registryObject, this.service.getServiceId());
            }
            if (registryObject != null) {
                rservice.setProvidingOrganization(registryObject);
            }
        }
        List<Name> name = sInfo.getName();
        InternationalString iname = this.names2InternationalString(name);
        rservice.setName(iname);
        rservice.setIsRetrieved(true);
        rservice.setIsNew(false);
        if (!this.getConnection().useCache()) {
            rservice.setIsLoaded(false);
        }
        this.objectManager.addObjectToCache(rservice, this.service.getServiceId());
        return rservice;
    }

    Service businessService2Service(BusinessService bService) throws JAXRException {
        BindingTemplates bTemplates;
        CategoryBag cbag;
        Collection classifications;
        List<Name> bName;
        InternationalString iname;
        ServiceImpl service = null;
        String bServiceKey = bService.getServiceKey();
        String businessKey = bService.getBusinessKey();
        try {
            service = (ServiceImpl)this.objectManager.fetchObjectFromCache(bServiceKey);
        }
        catch (ClassCastException cce) {
            this.logger.finest("ClassCastException in serviceDetail2Service fetching service, continuing");
            service = null;
        }
        if (service == null) {
            service = new ServiceImpl();
            service.setServiceId(this.service.getServiceId());
            service.setRegistryService(this.service);
        }
        service.setIsRetrieved(true);
        service.setIsNew(false);
        service.setIsLoaded(true);
        OrganizationImpl registryObject = null;
        try {
            registryObject = (OrganizationImpl)this.objectManager.fetchObjectFromCache(businessKey);
        }
        catch (ClassCastException cce) {
            this.logger.finest("ClassCastException fething org in serviceDetail2Service, continuing");
            registryObject = null;
        }
        if (registryObject == null) {
            registryObject = new OrganizationImpl();
            registryObject.setKey(new KeyImpl(businessKey));
            registryObject.setRegistryService(this.service);
            registryObject.setIsRetrieved(true);
            registryObject.setIsNew(false);
            registryObject.setIsLoaded(false);
            this.objectManager.addObjectToCache(registryObject, this.service.getServiceId());
        }
        service.setProvidingOrganization(registryObject);
        KeyImpl serviceKey = new KeyImpl(bServiceKey);
        service.setKey(serviceKey);
        List<Description> description = bService.getDescription();
        InternationalString idesc = this.descriptions2InternationalString(description);
        if (idesc != null) {
            service.setDescription(idesc);
        }
        if ((iname = this.names2InternationalString(bName = bService.getName())) != null) {
            service.setName(iname);
        }
        if ((classifications = this.categoryBag2Classifications(cbag = bService.getCategoryBag())) != null && classifications.size() > 0) {
            service.setClassifications(classifications);
        }
        if ((bTemplates = bService.getBindingTemplates()) != null) {
            List<BindingTemplate> template = bTemplates.getBindingTemplate();
            ArrayList<ServiceBindingImpl> bindings = new ArrayList<ServiceBindingImpl>();
            if (template != null) {
                Iterator iter = template.iterator();
                while (iter.hasNext()) {
                    ServiceBindingImpl sBinding = (ServiceBindingImpl)this.bindingTemplate2ServiceBinding((BindingTemplate)iter.next());
                    if (sBinding == null) continue;
                    this.objectManager.addObjectToCache(sBinding, this.service.getServiceId());
                    sBinding.setServiceId(this.service.getServiceId());
                    sBinding.setRegistryService(this.service);
                    sBinding.setStatusFlags(true, true, false);
                    bindings.add(sBinding);
                }
                Collection currentBindings = service.getServiceBindings();
                service.removeServiceBindings(currentBindings);
                service.addServiceBindings(bindings);
            }
        }
        if (this.getConnection().useCache()) {
            this.objectManager.addObjectToCache(service, this.service.getServiceId());
        } else {
            this.objectManager.removeObjectFromCache(service.getKey().getId());
        }
        return service;
    }

    BulkResponse results2BulkResponse(Collection results, Collection keys, String type) throws JAXRException {
        BulkResponseImpl br = new BulkResponseImpl();
        ArrayList exceptions = new ArrayList();
        if (keys != null) {
            br.setCollection(keys);
        }
        if (results != null && !results.isEmpty()) {
            for (Result result : results) {
                KeyType keyType = result.getKeyType();
                int errNo = result.getErrno();
                ErrInfo errInfo = result.getErrInfo();
                String errCode = "";
                String content = "";
                if (errInfo != null) {
                    errCode = errInfo.getErrCode();
                    content = errInfo.getValue();
                    if (errCode.equalsIgnoreCase("E_success")) {
                        if (type.equals("delete")) {
                            this.getObjectManager().removeObjectsFromCache(keys);
                        }
                        return br;
                    }
                } else if (errNo == 0) {
                    if (type.equals("delete")) {
                        this.getObjectManager().removeObjectsFromCache(keys);
                    }
                    return br;
                }
                String message = ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:UDDI_DispositionReport:_Error_Code_=_") + errCode + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:;_Error_Message_=_") + content + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:;_Error_Number_=_") + errNo;
                FindException ne = null;
                if (type.equals("find")) {
                    ne = new FindException(message);
                } else if (type.equals("save")) {
                    ne = new SaveException(message);
                } else if (type.equals("delete")) {
                    ne = new DeleteException(message);
                }
                br.addException((JAXRException)ne);
            }
        }
        return br;
    }

    BulkResponse getRegistryObjects(Collection objectKeys) throws JAXRException {
        HashMap sortedKeys = this.sortObjectType(objectKeys);
        Collection unknownKeys = (Collection)sortedKeys.get("unknown");
        Collection tempKeys = null;
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>();
        tempKeys = (Collection)sortedKeys.get("orgs");
        if (tempKeys != null) {
            tempKeys.addAll(unknownKeys);
            if (tempKeys != null && !tempKeys.isEmpty()) {
                responses.add(this.getOrganizations(tempKeys));
            }
        }
        if (tempKeys != null) {
            tempKeys = (Collection)sortedKeys.get("services");
            tempKeys.addAll(unknownKeys);
            if (tempKeys != null && !tempKeys.isEmpty()) {
                responses.add(this.getServices(tempKeys));
            }
        }
        if (tempKeys != null) {
            tempKeys = (Collection)sortedKeys.get("bindings");
            tempKeys.addAll(unknownKeys);
            if (tempKeys != null && !tempKeys.isEmpty()) {
                responses.add(this.getServiceBindings(tempKeys));
            }
        }
        if (tempKeys != null) {
            tempKeys = (Collection)sortedKeys.get("concepts");
            tempKeys.addAll(unknownKeys);
            if (tempKeys != null && !tempKeys.isEmpty()) {
                responses.add(this.getConcepts(tempKeys));
            }
        }
        if (tempKeys != null) {
            tempKeys = (Collection)sortedKeys.get("schemes");
            tempKeys.addAll(unknownKeys);
            if (tempKeys != null && !tempKeys.isEmpty()) {
                responses.add(this.getConcepts(tempKeys));
            }
        }
        return BulkResponseImpl.combineBulkResponses(responses);
    }

    BulkResponse getRegistryObjects(Collection objectKeys, String objectType) throws JAXRException {
        BulkResponse bulkResponse = null;
        if (objectType.equals("Organization")) {
            bulkResponse = this.getOrganizations(objectKeys);
        } else if (objectType.equals("Service")) {
            bulkResponse = this.getServices(objectKeys);
        } else if (objectType.equals("ServiceBinding")) {
            bulkResponse = this.getServiceBindings(objectKeys);
        } else if (objectType.equals("Concept") || objectType.equals("ClassificationScheme")) {
            bulkResponse = this.getConcepts(objectKeys);
        } else {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Unknown_Object_Type_") + objectType + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:_cannot_retrieve"));
        }
        return bulkResponse;
    }

    BulkResponse getRegistryObjects() throws JAXRException {
        GetRegisteredInfo info = null;
        info = this.objFactory.createGetRegisteredInfo();
        info.setGeneric("2.0");
        String authInfo = null;
        authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_present"));
        }
        info.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(info, true, null, "find");
    }

    RegistryObject getRegistryObject(RegistryObjectImpl ro) throws JAXRException {
        Collection objs;
        Iterator iter;
        BulkResponse bulkResponse = null;
        Object associationBulkResponse = null;
        if (ro == null) {
            return null;
        }
        Key objectKey = ro.getKey();
        ArrayList<Key> tempKeys = new ArrayList<Key>();
        tempKeys.add(objectKey);
        if (ro instanceof OrganizationImpl) {
            bulkResponse = this.getOrganizations(tempKeys);
        } else if (ro instanceof ServiceImpl) {
            bulkResponse = this.getServices(tempKeys);
        } else if (ro instanceof ServiceBindingImpl) {
            bulkResponse = this.getServiceBindings(tempKeys);
        } else if (ro instanceof ConceptImpl) {
            bulkResponse = this.getConcepts(tempKeys);
        } else {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Unknown_Object_Type"));
        }
        if (bulkResponse.getExceptions() == null && (iter = (objs = bulkResponse.getCollection()).iterator()).hasNext()) {
            RegistryObject registryObj = (RegistryObject)iter.next();
            return registryObj;
        }
        return null;
    }

    RegistryObject getRegistryObject(String id, String objectType) throws JAXRException {
        if (id == null) {
            return null;
        }
        Object bulkResponse = null;
        RegistryObject ro = this.objectManager.fetchObjectFromCache(id);
        if (ro != null) {
            return ro;
        }
        KeyImpl objectKey = new KeyImpl(id);
        ArrayList<KeyImpl> keys = new ArrayList<KeyImpl>();
        keys.add(objectKey);
        BulkResponse br = this.getRegistryObjects(keys, objectType);
        if (br.getExceptions() == null) {
            Collection registryObjects = br.getCollection();
            RegistryObject registryObject = null;
            if (registryObjects.size() == 1) {
                registryObject = (RegistryObject)((ArrayList)registryObjects).get(0);
                return registryObject;
            }
        } else {
            Collection exceptions = br.getExceptions();
            Iterator eiter = exceptions.iterator();
            if (eiter.hasNext()) {
                throw (JAXRException)((Object)eiter.next());
            }
        }
        return null;
    }

    String getAuthorizationToken(Set credentials) throws JAXRException {
        String userName = null;
        String password = null;
        char[] passwd = null;
        if (credentials != null && credentials.size() > 0) {
            for (Object obj : credentials) {
                if (!(obj instanceof PasswordAuthentication)) continue;
                userName = ((PasswordAuthentication)obj).getUserName();
                passwd = ((PasswordAuthentication)obj).getPassword();
                password = new String(passwd);
            }
        }
        if (userName == null || passwd == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:User_Name_and/or_Password_not_set."));
        }
        GetAuthToken getAuthToken = null;
        getAuthToken = this.objFactory.createGetAuthToken();
        getAuthToken.setGeneric("2.0");
        getAuthToken.setUserID(userName);
        getAuthToken.setCred(password);
        password = null;
        BulkResponse br = null;
        br = this.getProcessor().processRequestJAXB(getAuthToken, true, null, "save");
        if (br.getExceptions() == null) {
            Collection tokens = br.getCollection();
            if (tokens.size() > 0) {
                return (String)((ArrayList)tokens).get(0);
            }
        } else {
            Collection exceptions = br.getExceptions();
            Iterator eiter = exceptions.iterator();
            if (eiter.hasNext()) {
                JAXRException exception = (JAXRException)((Object)eiter.next());
                throw exception;
            }
        }
        return null;
    }

    HashMap sortObjectType(Collection objectKeys) throws UnexpectedObjectException, JAXRException {
        ArrayList<KeyImpl> orgs = new ArrayList<KeyImpl>();
        ArrayList<KeyImpl> services = new ArrayList<KeyImpl>();
        ArrayList<KeyImpl> bindings = new ArrayList<KeyImpl>();
        ArrayList<KeyImpl> concepts = new ArrayList<KeyImpl>();
        ArrayList<KeyImpl> classificationSchemes = new ArrayList<KeyImpl>();
        ArrayList<KeyImpl> unknown = new ArrayList<KeyImpl>();
        HashMap<String, ArrayList<KeyImpl>> sortedKeys = new HashMap<String, ArrayList<KeyImpl>>();
        for (KeyImpl key : objectKeys) {
            RegistryObject ro = this.objectManager.fetchObjectFromCache(key.getId());
            if (ro != null) {
                if (ro instanceof Organization) {
                    orgs.add(key);
                    continue;
                }
                if (ro instanceof Service) {
                    services.add(key);
                    continue;
                }
                if (ro instanceof ServiceBinding) {
                    bindings.add(key);
                    continue;
                }
                if (ro instanceof Concept) {
                    concepts.add(key);
                    continue;
                }
                if (ro instanceof ClassificationScheme) {
                    classificationSchemes.add(key);
                    continue;
                }
                throw new UnexpectedObjectException();
            }
            if (key.getId().indexOf("uuid") != -1 || key.getId().indexOf("UUID") != -1) {
                concepts.add(key);
                continue;
            }
            unknown.add(key);
        }
        sortedKeys.put("orgs", orgs);
        sortedKeys.put("services", services);
        sortedKeys.put("bindings", bindings);
        sortedKeys.put("concepts", concepts);
        sortedKeys.put("schemes", classificationSchemes);
        sortedKeys.put("unknown", unknown);
        return sortedKeys;
    }

    BulkResponse saveObjects(Collection registryObjects) throws JAXRException {
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>();
        ArrayList organizations = new ArrayList();
        ArrayList services = new ArrayList();
        ArrayList serviceBindings = new ArrayList();
        ArrayList concepts = new ArrayList();
        ArrayList classificationSchemes = new ArrayList();
        for (Object cObject : registryObjects) {
            if (cObject instanceof Organization) {
                organizations.add(cObject);
                continue;
            }
            if (cObject instanceof Service) {
                services.add(cObject);
                continue;
            }
            if (cObject instanceof ServiceBinding) {
                serviceBindings.add(cObject);
                continue;
            }
            if (cObject instanceof Concept) {
                concepts.add(cObject);
                continue;
            }
            if (cObject instanceof ClassificationScheme) {
                classificationSchemes.add(cObject);
                continue;
            }
            throw new UnexpectedObjectException();
        }
        if (organizations.size() != 0) {
            responses.add(this.saveOrganizations(organizations));
        }
        if (services.size() != 0) {
            responses.add(this.saveServices(services));
        }
        if (serviceBindings.size() != 0) {
            responses.add(this.saveServiceBindings(serviceBindings));
        }
        if (concepts.size() != 0) {
            responses.add(this.saveConcepts(concepts));
        }
        if (classificationSchemes.size() != 0) {
            responses.add(this.saveClassificationSchemes(classificationSchemes));
        }
        return BulkResponseImpl.combineBulkResponses(responses);
    }

    BulkResponse deleteObjects(Collection keys) throws JAXRException {
        HashMap sortedKeys = this.sortObjectType(keys);
        Collection tempKeys = null;
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>();
        tempKeys = (Collection)sortedKeys.get("orgs");
        if (tempKeys != null && !tempKeys.isEmpty()) {
            responses.add(this.deleteOrganizations(tempKeys));
        }
        if ((tempKeys = (Collection)sortedKeys.get("services")) != null && !tempKeys.isEmpty()) {
            responses.add(this.deleteServices(tempKeys));
        }
        if ((tempKeys = (Collection)sortedKeys.get("bindings")) != null && !tempKeys.isEmpty()) {
            responses.add(this.deleteServiceBindings(tempKeys));
        }
        if ((tempKeys = (Collection)sortedKeys.get("concepts")) != null && !tempKeys.isEmpty()) {
            responses.add(this.deleteConcepts(tempKeys));
        }
        if ((tempKeys = (Collection)sortedKeys.get("schemes")) != null && !tempKeys.isEmpty()) {
            responses.add(this.deleteConcepts(tempKeys));
        }
        return BulkResponseImpl.combineBulkResponses(responses);
    }

    BulkResponse deleteObjects(Collection keys, String objectType) throws JAXRException {
        BulkResponse bulkResponse = null;
        if (objectType.equals("Organization")) {
            bulkResponse = this.deleteOrganizations(keys);
        }
        if (objectType.equals("Service")) {
            bulkResponse = this.deleteServices(keys);
        }
        if (objectType.equals("ServiceBinding")) {
            bulkResponse = this.deleteServiceBindings(keys);
        }
        if (objectType.equals("Concept") || objectType.equals("ClassificationScheme")) {
            bulkResponse = this.deleteConcepts(keys);
        }
        return bulkResponse;
    }

    public BulkResponse saveAssociations(Collection associations, boolean replace) throws JAXRException {
        if (associations.size() == 0) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:UDDIMapper:No_Associations_found_to_save"));
        }
        if (replace) {
            return this.saveAllAssociations(associations, replace);
        }
        AddPublisherAssertions publisherAssertions = null;
        publisherAssertions = this.objFactory.createAddPublisherAssertions();
        publisherAssertions.setGeneric("2.0");
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_or_Invalid_Credential_Information"));
        }
        publisherAssertions.setAuthInfo(authInfo);
        Collection assertions = this.associations2PublisherAssertions(associations);
        if (assertions != null) {
            publisherAssertions.getPublisherAssertion().addAll(assertions);
        }
        ArrayList<KeyImpl> associationKeys = new ArrayList<KeyImpl>();
        Iterator associationIterator = associations.iterator();
        while (associationIterator.hasNext()) {
            KeyImpl associationKey = (KeyImpl)((Association)associationIterator.next()).getKey();
            associationKeys.add(associationKey);
        }
        return this.getProcessor().processRequestJAXB(publisherAssertions, true, associationKeys, "save");
    }

    public BulkResponse saveAllAssociations(Collection associations, boolean replace) throws JAXRException {
        SetPublisherAssertions publisherAssertions = null;
        publisherAssertions = this.objFactory.createSetPublisherAssertions();
        publisherAssertions.setGeneric("2.0");
        String authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credential_or_Invalid_Credential_Information"));
        }
        publisherAssertions.setAuthInfo(authInfo);
        Collection assertions = this.associations2PublisherAssertions(associations);
        publisherAssertions.getPublisherAssertion().addAll(assertions);
        ArrayList<KeyImpl> associationKeys = new ArrayList<KeyImpl>();
        Iterator associationIterator = associations.iterator();
        while (associationIterator.hasNext()) {
            KeyImpl associationKey = (KeyImpl)((Association)associationIterator.next()).getKey();
            associationKeys.add(associationKey);
        }
        return this.getProcessor().processRequestJAXB(publisherAssertions, true, associationKeys, "save");
    }

    public BulkResponse findAssociations(Collection findQualifiers, String sourceKeyId, String targetKeyId, Collection associationTypes) throws JAXRException {
        int filteredOutcome = -1;
        FindRelatedBusinesses relatedBusiness = null;
        relatedBusiness = this.objFactory.createFindRelatedBusinesses();
        relatedBusiness.setGeneric("2.0");
        String maxrows = this.getConnection().getMaxRows();
        if (maxrows != null) {
            int rows = Integer.parseInt(maxrows);
            relatedBusiness.setMaxRows(rows);
        }
        if (sourceKeyId == null && targetKeyId == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:RegistryObject_required_for_FindAssociatedObjects_method._"));
        }
        ArrayList<KeyImpl> keys = new ArrayList<KeyImpl>();
        if (sourceKeyId != null && targetKeyId != null) {
            filteredOutcome = 300;
            relatedBusiness.setBusinessKey(sourceKeyId);
            keys.add(new KeyImpl(sourceKeyId));
        } else if (sourceKeyId != null) {
            filteredOutcome = 100;
            relatedBusiness.setBusinessKey(sourceKeyId);
            keys.add(new KeyImpl(sourceKeyId));
        } else if (targetKeyId != null) {
            filteredOutcome = 200;
            relatedBusiness.setBusinessKey(targetKeyId);
            keys.add(new KeyImpl(targetKeyId));
        } else {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Registry_Object_Key_required_for_findAssociatedObjects._"));
        }
        FindQualifiers fQualifiers = this.strings2FindQualifiers(findQualifiers);
        if (fQualifiers != null) {
            relatedBusiness.setFindQualifiers(fQualifiers);
        }
        Collection keyedReferences = this.associationTypes2KeyedReferences(associationTypes);
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>();
        BulkResponse bulkResponse = null;
        if (keyedReferences != null && !keyedReferences.isEmpty()) {
            Iterator iter = keyedReferences.iterator();
            while (iter.hasNext()) {
                relatedBusiness.setKeyedReference((KeyedReference)iter.next());
                responses.add(this.getProcessor().processRequestJAXB(relatedBusiness, false, keys, "find"));
            }
            bulkResponse = BulkResponseImpl.combineBulkResponses(responses);
        } else {
            bulkResponse = this.getProcessor().processRequestJAXB(relatedBusiness, false, keys, "find");
        }
        if (bulkResponse.getExceptions() != null) {
            return bulkResponse;
        }
        return this.helper.filterAssociations(bulkResponse, filteredOutcome, sourceKeyId, targetKeyId);
    }

    public BulkResponse findCallerAssociations(Collection findQualifiers, Boolean callerIsConfirmed, Boolean otherIsConfirmed, Collection associationTypes) throws JAXRException {
        GetAssertionStatusReport getAssertionStatus = null;
        getAssertionStatus = this.objFactory.createGetAssertionStatusReport();
        String authInfo = null;
        authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_present"));
        }
        getAssertionStatus.setGeneric("2.0");
        getAssertionStatus.setAuthInfo(authInfo);
        ArrayList<BulkResponse> responses = new ArrayList<BulkResponse>();
        Collection statuses = this.confirmationState2CompletionStatus(callerIsConfirmed, otherIsConfirmed);
        this.fromKeysOwned = new ArrayList();
        this.toKeysOwned = new ArrayList();
        for (String completionStatus : statuses) {
            getAssertionStatus.setCompletionStatus(completionStatus);
            responses.add(this.getProcessor().processRequestJAXB(getAssertionStatus, true, null, "find"));
        }
        BulkResponse bResponse = BulkResponseImpl.combineBulkResponses(responses);
        if (bResponse.getExceptions() == null) {
            BulkResponse bulkResponse = this.helper.filterAssociationsByConfirmationState(bResponse, callerIsConfirmed, otherIsConfirmed, this.fromKeysOwned, this.toKeysOwned);
            if (associationTypes != null) {
                return this.helper.filterByAssociationTypes(bulkResponse, associationTypes);
            }
            return bulkResponse;
        }
        return bResponse;
    }

    void confirmAssociation(Association association) throws JAXRException {
        if (association != null) {
            Collection exceptions;
            Iterator exIter;
            ArrayList<Association> associations = new ArrayList<Association>();
            associations.add(association);
            BulkResponse bulkResponse = this.saveAssociations(associations, false);
            if (bulkResponse.getExceptions() != null && (exIter = (exceptions = bulkResponse.getExceptions()).iterator()).hasNext()) {
                throw (JAXRException)((Object)exIter.next());
            }
        }
    }

    void unConfirmAssociation(Association association) throws JAXRException {
        if (association != null) {
            ArrayList<String> associationIds = new ArrayList<String>();
            String id = association.getKey().getId();
            if (id != null) {
                Collection exceptions;
                Iterator exIter;
                associationIds.add(id);
                BulkResponse bulkResponse = this.deleteAssociations(associationIds);
                if (bulkResponse.getExceptions() != null && (exIter = (exceptions = bulkResponse.getExceptions()).iterator()).hasNext()) {
                    throw (JAXRException)((Object)exIter.next());
                }
            }
        }
    }

    BulkResponse findSourceAssociations(Collection findQualifiers, Boolean sourceObjectConfirmed, Boolean targetObjectConfirmed, Collection associationTypes) throws JAXRException {
        GetPublisherAssertions getAssertions = null;
        getAssertions = this.objFactory.createGetPublisherAssertions();
        String authInfo = null;
        authInfo = this.getAuthInfo();
        if (authInfo == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_Credentials_present"));
        }
        getAssertions.setGeneric("2.0");
        getAssertions.setAuthInfo(authInfo);
        return this.getProcessor().processRequestJAXB(getAssertions, true, null, "find");
    }

    String makeRegistrySpecificRequest(String request, boolean secure) throws JAXRException {
        if (request == null) {
            return null;
        }
        this.logger.finest(request);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(request.getBytes());
        SOAPMessage msg = null;
        try {
            Object obj = MarshallerUtil.getInstance().jaxbUnmarshalInputStream(inputStream);
            msg = MarshallerUtil.getInstance().jaxbMarshalObject(obj);
        }
        catch (JAXBException jbe) {
            throw new JAXRException((Throwable)jbe);
        }
        Node response = this.service.send(msg, secure);
        Node resultNode = null;
        String name = response.getNodeName();
        if (((SOAPBody)response).hasFault()) {
            int listLength;
            NodeList list;
            if (response instanceof Element && (list = ((Element)response).getElementsByTagName("dispositionReport")) != null && (listLength = list.getLength()) > 0) {
                for (int i = 0; i < listLength; ++i) {
                    Node n = list.item(i);
                    if (n == null) continue;
                    resultNode = n;
                    name = "dispositionReport";
                    break;
                }
            }
        } else {
            resultNode = response.getFirstChild();
        }
        ByteArrayOutputStream outStream = null;
        try {
            Object obj = MarshallerUtil.getInstance().jaxbUnmarshalObject(resultNode);
            outStream = (ByteArrayOutputStream)MarshallerUtil.getInstance().jaxbMarshalOutStream(obj);
        }
        catch (JAXBException jbe) {
            throw new JAXRException((Throwable)jbe);
        }
        return outStream.toString();
    }

    Collection confirmationState2CompletionStatus(Boolean callerIsConfirmed, Boolean otherIsConfirmed) {
        ArrayList<String> statuses = new ArrayList<String>();
        Object completionStatus = null;
        if (callerIsConfirmed != null && otherIsConfirmed != null) {
            if (callerIsConfirmed.booleanValue() && otherIsConfirmed.booleanValue()) {
                statuses.add("status:complete");
            } else {
                statuses.add("status:toKey_incomplete");
                statuses.add("status:fromKey_incomplete");
            }
        } else {
            statuses.add("status:complete");
            statuses.add("status:toKey_incomplete");
            statuses.add("status:fromKey_incomplete");
        }
        return statuses;
    }

    Collection associationKeys2PublisherAssertions(Collection associationKeys) throws JAXRException {
        ArrayList<PublisherAssertion> assertions = new ArrayList<PublisherAssertion>();
        if (associationKeys != null) {
            Iterator keyIter = associationKeys.iterator();
            try {
                while (keyIter.hasNext()) {
                    KeyImpl associationKey = (KeyImpl)keyIter.next();
                    PublisherAssertion assertion = this.associationKey2PublisherAssertion(associationKey);
                    if (assertion == null) continue;
                    assertions.add(assertion);
                }
            }
            catch (ClassCastException cce) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_javax.xml.infomodel.Key"), (Throwable)cce);
            }
        }
        return assertions;
    }

    PublisherAssertion associationKey2PublisherAssertion(KeyImpl associationKey) throws JAXRException {
        String id;
        PublisherAssertion assertion = null;
        if (associationKey != null && (id = associationKey.getId()) != null) {
            StringTokenizer tokens = new StringTokenizer(id, ":", false);
            if (tokens.countTokens() == 3) {
                String sourceKeyId = tokens.nextToken();
                String targetKeyId = tokens.nextToken();
                String associationType = tokens.nextToken();
                assertion = null;
                assertion = this.objFactory.createPublisherAssertion();
                assertion.setFromKey(sourceKeyId);
                assertion.setToKey(targetKeyId);
                KeyedReference keyedRef = this.associationType2KeyedReference(associationType);
                if (keyedRef != null) {
                    assertion.setKeyedReference(keyedRef);
                }
            } else {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Association_Key_id_is_incorrectly_formated_-_expected_SourceObjectKeyId:TargetObjectKeyId:AssociationTypeString._"));
            }
        }
        return assertion;
    }

    Collection publisherAssertions2Associations(Collection publisherAssertions) throws JAXRException {
        ArrayList<Association> associations = null;
        if (publisherAssertions != null) {
            associations = new ArrayList<Association>();
            Iterator iter = publisherAssertions.iterator();
            while (iter.hasNext()) {
                Association association = this.publisherAssertion2Association((PublisherAssertion)iter.next());
                if (association == null) continue;
                associations.add(association);
            }
        }
        return associations;
    }

    Association publisherAssertion2Association(PublisherAssertion assertion) throws JAXRException {
        AssociationImpl association = null;
        if (assertion != null) {
            KeyedReference keyedRef;
            Concept associationType;
            String associationTypeValue;
            String toKey;
            String fromKey = assertion.getFromKey();
            KeyImpl key = this.buildAssociationKey(fromKey, toKey = assertion.getToKey(), associationTypeValue = (associationType = this.keyedReference2AssociationType(keyedRef = assertion.getKeyedReference())).getValue());
            association = (AssociationImpl)this.objectManager.fetchObjectFromCache(key.getId());
            if (association == null) {
                association = new AssociationImpl();
                association.setServiceId(this.service.getServiceId());
                association.setRegistryService(this.service);
            }
            if (!fromKey.equalsIgnoreCase(toKey)) {
                association.setIsExtramural(true);
            }
            association.setAssociationType(associationType);
            association.setIsRetrieved(true);
            association.setIsNew(false);
            if (key != null) {
                association.setKey(key);
            }
            association.setIsLoaded(false);
            Organization sourceObject = null;
            if (fromKey != null && association.getSourceObject() == null) {
                sourceObject = (Organization)this.objectManager.fetchObjectFromCache(fromKey);
                if (sourceObject == null) {
                    sourceObject = (Organization)this.getRegistryObject(fromKey, "Organization");
                }
                if (sourceObject != null) {
                    association.setSourceObject((RegistryObject)sourceObject);
                    sourceObject.addAssociation((Association)association);
                }
            }
            Organization targetObject = null;
            if (toKey != null && association.getTargetObject() == null) {
                targetObject = (Organization)this.objectManager.fetchObjectFromCache(toKey);
                if (targetObject == null) {
                    targetObject = (Organization)this.getRegistryObject(toKey, "Organization");
                }
                if (targetObject != null) {
                    association.setTargetObject((RegistryObject)targetObject);
                }
            }
            if (association != null) {
                this.objectManager.addObjectToCache(association, this.service.getServiceId());
            }
            return association;
        }
        return null;
    }

    Collection assertionStatusItems2Associations(Collection assertionStatusItems) throws JAXRException {
        ArrayList<Association> associations = null;
        if (assertionStatusItems != null) {
            associations = new ArrayList<Association>(assertionStatusItems.size());
            Iterator iter = assertionStatusItems.iterator();
            while (iter.hasNext()) {
                Association association = this.assertionStatusItem2Association((AssertionStatusItem)iter.next());
                if (association == null) continue;
                associations.add(association);
            }
            return associations;
        }
        return null;
    }

    Association assertionStatusItem2Association(AssertionStatusItem item) throws JAXRException {
        AssociationImpl association = null;
        if (item != null) {
            this.logger.finest("Got assertionStatusItem");
            String completionStatus = item.getCompletionStatus();
            String fromKey = item.getFromKey();
            String toKey = item.getToKey();
            KeyedReference keyedRef = item.getKeyedReference();
            Concept type = null;
            if (keyedRef != null) {
                type = this.keyedReference2AssociationType(keyedRef);
            }
            String typeString = null;
            if (type != null) {
                typeString = type.getValue();
            }
            KeyImpl key = this.buildAssociationKey(fromKey, toKey, typeString);
            this.logger.finest("AssociationKeyIs " + key.getId());
            association = (AssociationImpl)this.objectManager.fetchObjectFromCache(key.getId());
            if (association == null) {
                association = new AssociationImpl();
                association.setServiceId(this.service.getServiceId());
                association.setRegistryService(this.service);
            }
            if (key != null) {
                association.setKey(key);
            }
            if (!fromKey.equalsIgnoreCase(toKey)) {
                association.setIsExtramural(true);
            }
            association.setIsRetrieved(true);
            association.setIsNew(false);
            association.setIsLoaded(true);
            KeysOwned keysOwned = item.getKeysOwned();
            String ownedFromKey = keysOwned.getFromKey();
            String ownedToKey = keysOwned.getToKey();
            if (ownedFromKey != null) {
                this.fromKeysOwned.add(ownedFromKey);
            } else if (ownedToKey != null) {
                this.toKeysOwned.add(ownedToKey);
            }
            if (type != null) {
                association.setAssociationType(type);
            }
            this.logger.finest("Setting confirmationState");
            if (completionStatus.equals("status:complete")) {
                association.setIsConfirmedBySourceOwner(true);
                association.setIsConfirmedByTargetOwner(true);
            } else if (completionStatus.equals("status:toKey_incomplete")) {
                association.setIsConfirmedBySourceOwner(true);
                association.setIsConfirmedByTargetOwner(false);
            } else if (completionStatus.equals("status:fromKey_incomplete")) {
                association.setIsConfirmedBySourceOwner(false);
                association.setIsConfirmedByTargetOwner(true);
            }
            Organization sourceObject = null;
            if (fromKey != null && association.getSourceObject() == null) {
                sourceObject = (Organization)this.objectManager.fetchObjectFromCache(fromKey);
                if (sourceObject == null) {
                    sourceObject = (Organization)this.getRegistryObject(fromKey, "Organization");
                }
                if (sourceObject != null) {
                    association.setSourceObject((RegistryObject)sourceObject);
                    sourceObject.addAssociation((Association)association);
                }
            }
            Organization targetObject = null;
            if (toKey != null && association.getTargetObject() == null) {
                targetObject = (Organization)this.objectManager.fetchObjectFromCache(toKey);
                if (targetObject == null) {
                    targetObject = (Organization)this.getRegistryObject(toKey, "Organization");
                }
                if (targetObject != null) {
                    association.setTargetObject((RegistryObject)targetObject);
                }
            }
            if (association != null) {
                this.objectManager.addObjectToCache(association, this.service.getServiceId());
            }
            this.logger.finest("Returning association with a value");
            return association;
        }
        return null;
    }

    KeyImpl buildAssociationKey(String fromKey, String toKey, String typeString) {
        StringBuffer keyBuf = new StringBuffer(400);
        keyBuf.append(fromKey);
        keyBuf.append(":");
        keyBuf.append(toKey);
        keyBuf.append(":");
        keyBuf.append(typeString);
        return new KeyImpl(keyBuf.toString());
    }

    Concept keyedReference2AssociationType(KeyedReference keyedRef) throws JAXRException {
        ConceptImpl type = null;
        if (keyedRef != null) {
            String key = keyedRef.getTModelKey();
            String name = keyedRef.getKeyName();
            String value = keyedRef.getKeyValue();
            String newName = null;
            String newValue = null;
            if (value.equalsIgnoreCase("peer-peer")) {
                newName = "RelatedTo";
                newValue = "RelatedTo";
            } else if (value.equalsIgnoreCase("identity")) {
                newName = "EquivalentTo";
                newValue = "EquivalentTo";
            } else if (value.equalsIgnoreCase("parent-child")) {
                newName = "HasChild";
                newValue = "HasChild";
            } else {
                newName = name;
                newValue = value;
            }
            type = new ConceptImpl();
            if (key != null) {
                type.setKey(new KeyImpl(key));
            }
            if (name != null) {
                type.setName(new InternationalStringImpl(newName));
            }
            if (value != null) {
                type.setValue(newValue);
            }
        }
        return type;
    }

    public BulkResponse getRegistryObjects(String objectType) throws JAXRException {
        BulkResponse br;
        BulkResponseImpl sbr = new BulkResponseImpl();
        ArrayList organizations = new ArrayList();
        ArrayList services = new ArrayList();
        ArrayList serviceBindings = new ArrayList();
        ArrayList concepts = new ArrayList();
        ArrayList classificationSchemes = new ArrayList();
        if (objectType != null && (br = this.getRegistryObjects()) != null && br.getExceptions() == null) {
            Collection objects = br.getCollection();
            for (Object cObject : objects) {
                if (cObject instanceof Organization) {
                    organizations.add(cObject);
                    continue;
                }
                if (cObject instanceof Service) {
                    services.add(cObject);
                    continue;
                }
                if (cObject instanceof ServiceBinding) {
                    serviceBindings.add(cObject);
                    continue;
                }
                if (cObject instanceof Concept) {
                    concepts.add(cObject);
                    continue;
                }
                if (cObject instanceof ClassificationScheme) {
                    classificationSchemes.add(cObject);
                    continue;
                }
                throw new UnexpectedObjectException();
            }
            if (objectType.equals("Organization")) {
                sbr.setCollection(organizations);
            } else if (objectType.equals("Service")) {
                sbr.setCollection(this.helper.getAllServicesFromOrganizations(organizations));
            } else if (objectType.equals("ServiceBinding")) {
                sbr.setCollection(this.helper.getAllServiceBindingsFromOrganizations(organizations));
            } else if (objectType.equals("Concept")) {
                sbr.setCollection(concepts);
            } else if (objectType.equals("ClassificationScheme")) {
                sbr.setCollection(classificationSchemes);
            } else {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Unexpected_Object_type"));
            }
        }
        return sbr;
    }

    Collection associations2PublisherAssertions(Collection associations) throws JAXRException {
        ArrayList<PublisherAssertion> assertions = new ArrayList<PublisherAssertion>();
        if (associations != null) {
            Iterator associationIterator = associations.iterator();
            try {
                while (associationIterator.hasNext()) {
                    Association association = (Association)associationIterator.next();
                    PublisherAssertion assertion = this.association2PublisherAssertion(association);
                    if (assertion == null) continue;
                    assertions.add(assertion);
                }
            }
            catch (ClassCastException cce) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Expected_Association_Object"), (Throwable)cce);
            }
        }
        return assertions;
    }

    PublisherAssertion association2PublisherAssertion(Association association) throws JAXRException {
        String toKeyString;
        String fromKeyString;
        Concept associationType = association.getAssociationType();
        boolean isConfirmedBySourceOwner = association.isConfirmedBySourceOwner();
        boolean isConfirmedByTargetOwner = association.isConfirmedByTargetOwner();
        Organization sourceObject = null;
        Organization targetObject = null;
        try {
            sourceObject = (Organization)association.getSourceObject();
            targetObject = (Organization)association.getTargetObject();
        }
        catch (ClassCastException cce) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:The_Source_Object_and_the_Target_Object_of_the_Association_must_be_of_type_Organization."), (Throwable)cce);
        }
        PublisherAssertion assertion = null;
        assertion = this.objFactory.createPublisherAssertion();
        KeyImpl fromKey = (KeyImpl)sourceObject.getKey();
        if (fromKey != null) {
            fromKeyString = fromKey.getId();
            if (fromKeyString == null) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Source_Object_key_id_needs_to_be_provided._"));
            }
        } else {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Target_Object_Key_needs_to_be_provided._"));
        }
        assertion.setFromKey(fromKeyString);
        KeyImpl toKey = (KeyImpl)targetObject.getKey();
        if (toKey != null) {
            toKeyString = toKey.getId();
            if (toKeyString == null) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Source_Object_key_id_needs_to_be_provided._"));
            }
        } else {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Target_Object_Key_needs_to_be_provided._"));
        }
        assertion.setToKey(toKeyString);
        if (associationType != null) {
            KeyedReference keyedRef = this.associationType2KeyedReference(associationType);
            if (keyedRef != null) {
                assertion.setKeyedReference(keyedRef);
            }
        } else {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Association_type_required_to_save_an_Association_in_the_Registry"));
        }
        return assertion;
    }

    private Description getDescription(RegistryObject ro) throws JAXRException {
        Description description = null;
        Description dupDescription = null;
        String desc = null;
        Object lang = null;
        try {
            InternationalString iString = ro.getDescription();
            if (iString != null) {
                desc = iString.getValue();
            }
        }
        catch (JAXRException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (desc == null) {
            desc = "";
        }
        description = null;
        description = this.objFactory.createDescription();
        dupDescription = this.objFactory.createDescription();
        description.setValue(desc);
        dupDescription.setValue(desc);
        String lng = Locale.getDefault().getLanguage();
        dupDescription.setLang(lng);
        String cty = Locale.getDefault().getCountry();
        if (cty != null && !cty.equals("")) {
            lng = lng + "-" + cty;
        }
        description.setLang(lng);
        return description;
    }

    private Name getName(RegistryObject ro) throws JAXRException {
        Name name = null;
        String sname = null;
        try {
            InternationalString iString = ro.getName();
            sname = iString.getValue();
        }
        catch (JAXRException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (sname == null) {
            sname = "";
        }
        name = null;
        name = this.objFactory.createName();
        name.setValue(sname);
        String lng = Locale.getDefault().getLanguage();
        String cty = Locale.getDefault().getCountry();
        if (cty != null && !cty.equals("")) {
            lng = lng + "-" + cty;
        }
        name.setLang(lng);
        return name;
    }

    private Collection getNames(RegistryObject ro, boolean publish) {
        Collection names = null;
        try {
            InternationalString iString = ro.getName();
            Collection localizedNames = iString.getLocalizedStrings();
            names = this.localizedStrings2Names(localizedNames, publish);
        }
        catch (JAXRException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        return names;
    }

    private Collection getDescriptions(RegistryObject ro, boolean publish) {
        Collection descriptions = null;
        try {
            InternationalString iString = ro.getDescription();
            Collection localizedDescriptions = iString.getLocalizedStrings();
            descriptions = this.localizedStrings2Descriptions(localizedDescriptions, publish);
        }
        catch (JAXRException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        return descriptions;
    }

    Collection internationalString2Names(InternationalString internationalString, boolean publish) throws JAXRException {
        Collection names = null;
        try {
            if (internationalString != null) {
                Collection localizedNames = internationalString.getLocalizedStrings();
                names = this.localizedStrings2Names(localizedNames, publish);
            }
        }
        catch (JAXRException ex) {
            throw new JAXRException(ex.getMessage(), (Throwable)ex);
        }
        return names;
    }

    Collection localizedStrings2Names(Collection localizedStrings, boolean publish) throws JAXRException {
        ArrayList<Name> names = new ArrayList<Name>();
        if (localizedStrings != null) {
            for (LocalizedString lstring : localizedStrings) {
                String country;
                Locale locale = lstring.getLocale();
                String nameValue = lstring.getValue();
                String charset = lstring.getCharsetName();
                Name name = null;
                Name dupName = null;
                name = this.objFactory.createName();
                dupName = this.objFactory.createName();
                name.setValue(nameValue);
                dupName.setValue(nameValue);
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                String lang = locale.getLanguage().toLowerCase();
                if (!publish) {
                    dupName.setLang(lang);
                    names.add(dupName);
                }
                if ((country = locale.getCountry().toUpperCase()) != null && !country.equals("")) {
                    lang = lang + "-" + country;
                }
                name.setLang(lang);
                names.add(name);
            }
        }
        return names;
    }

    Collection internationalString2Descriptions(InternationalString internationalString, boolean publish) throws JAXRException {
        Collection descriptions = null;
        try {
            if (internationalString != null) {
                Collection localizedDescriptions = internationalString.getLocalizedStrings();
                descriptions = this.localizedStrings2Descriptions(localizedDescriptions, publish);
            }
        }
        catch (JAXRException ex) {
            throw new JAXRException(ex.getMessage(), (Throwable)ex);
        }
        return descriptions;
    }

    Collection localizedStrings2Descriptions(Collection localizedStrings, boolean publish) throws JAXRException {
        ArrayList<Description> descriptions = new ArrayList<Description>();
        if (localizedStrings != null) {
            for (LocalizedString lstring : localizedStrings) {
                String country;
                Locale locale = lstring.getLocale();
                String descriptionValue = lstring.getValue();
                String charset = lstring.getCharsetName();
                Description description = null;
                Description dupDescription = null;
                description = this.objFactory.createDescription();
                dupDescription = this.objFactory.createDescription();
                description.setValue(descriptionValue);
                dupDescription.setValue(descriptionValue);
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                String lang = locale.getLanguage().toLowerCase();
                if (!publish) {
                    dupDescription.setLang(lang);
                    descriptions.add(dupDescription);
                }
                if ((country = locale.getCountry().toUpperCase()) != null && !country.equals("")) {
                    lang = lang + "-" + country;
                }
                description.setLang(lang);
                descriptions.add(description);
            }
        }
        return descriptions;
    }

    Collection descriptions2LocalizedStrings(Collection descriptions) throws JAXRException {
        ArrayList<LocalizedStringImpl> localizedDescriptions = new ArrayList<LocalizedStringImpl>();
        Iterator diter = descriptions.iterator();
        while (diter.hasNext()) {
            LocalizedStringImpl localizedString = new LocalizedStringImpl();
            Description description = (Description)diter.next();
            String descriptionValue = description.getValue();
            String langTag = description.getLang();
            if (descriptionValue != null) {
                localizedString.setValue(descriptionValue);
            }
            Locale locale = null;
            if (langTag != null) {
                int delimIndex = langTag.indexOf(45);
                if (delimIndex != -1) {
                    String lang = langTag.substring(0, delimIndex).toLowerCase();
                    String cntry = langTag.substring(delimIndex + 1).toUpperCase();
                    locale = new Locale(lang, cntry);
                } else {
                    locale = new Locale(langTag.toLowerCase(), "");
                }
            } else {
                locale = Locale.getDefault();
            }
            localizedString.setLocale(locale);
            localizedDescriptions.add(localizedString);
        }
        return localizedDescriptions;
    }

    Collection names2LocalizedStrings(Collection names) throws JAXRException {
        ArrayList<LocalizedStringImpl> localizedNames = new ArrayList<LocalizedStringImpl>();
        for (Name name : names) {
            String nameValue = name.getValue();
            String langTag = name.getLang();
            LocalizedStringImpl localizedString = new LocalizedStringImpl();
            if (nameValue != null) {
                localizedString.setValue(nameValue);
            }
            Locale locale = null;
            if (langTag != null) {
                int delimIndex = langTag.indexOf(45);
                if (delimIndex != -1) {
                    String lang = langTag.substring(0, delimIndex).toLowerCase();
                    String cntry = langTag.substring(delimIndex + 1).toUpperCase();
                    locale = new Locale(lang, cntry);
                } else {
                    locale = new Locale(langTag.toLowerCase(), "");
                }
            } else {
                locale = Locale.getDefault();
            }
            localizedString.setLocale(locale);
            localizedNames.add(localizedString);
        }
        return localizedNames;
    }

    LocalizedString name2LocalizedString(Name name) throws JAXRException {
        String nameValue = name.getValue();
        String langTag = name.getLang();
        LocalizedStringImpl localizedString = new LocalizedStringImpl();
        if (nameValue != null) {
            localizedString.setValue(nameValue);
        }
        Locale locale = null;
        if (langTag != null) {
            int delimIndex = langTag.indexOf(45);
            if (delimIndex != -1) {
                String lang = langTag.substring(0, delimIndex).toLowerCase();
                String cntry = langTag.substring(delimIndex + 1).toUpperCase();
                locale = new Locale(lang, cntry);
            } else {
                locale = new Locale(langTag.toLowerCase(), "");
            }
        } else {
            locale = Locale.getDefault();
        }
        localizedString.setLocale(locale);
        return localizedString;
    }

    InternationalString name2InternationalString(Name name) throws JAXRException {
        LocalizedString localizedString;
        InternationalStringImpl internationalString = new InternationalStringImpl();
        if (name != null && (localizedString = this.name2LocalizedString(name)) != null) {
            internationalString = new InternationalStringImpl();
            internationalString.addLocalizedString(localizedString);
        }
        return internationalString;
    }

    InternationalString names2InternationalString(Collection name) throws JAXRException {
        Collection localizedStrings;
        InternationalStringImpl internationalString = new InternationalStringImpl();
        if (name != null && (localizedStrings = this.names2LocalizedStrings(name)) != null) {
            internationalString = new InternationalStringImpl();
            internationalString.addLocalizedStrings(localizedStrings);
        }
        return internationalString;
    }

    InternationalString descriptions2InternationalString(Collection desc) throws JAXRException {
        Collection localizedStrings;
        InternationalStringImpl internationalString = new InternationalStringImpl();
        if (desc != null && (localizedStrings = this.descriptions2LocalizedStrings(desc)) != null) {
            internationalString = new InternationalStringImpl();
            internationalString.addLocalizedStrings(localizedStrings);
        }
        return internationalString;
    }

    private void mapPostalAddressAttributes(ClassificationScheme postalScheme) throws JAXRException {
        if (this.equivalentConcepts == null) {
            this.initSemanticEquivalences();
            if (this.equivalentConcepts == null) {
                this.logger.finest("equivalent concepts are null");
                return;
            }
        }
        this.defaultPostalScheme = this.service.getDefaultPostalScheme();
        if (this.postalAddressMap == null) {
            this.postalAddressMap = new HashMap();
        }
        Collection jaxrChildren = null;
        Collection defaultChildren = null;
        if (this.jaxrPostalAddressScheme != null) {
            jaxrChildren = this.jaxrPostalAddressScheme.getChildrenConcepts();
        }
        Object postalAddressDefault = null;
        if (postalScheme == null) {
            if (this.defaultPostalScheme != null) {
                this.defaultPostalScheme = this.getClassificationSchemeById(this.defaultPostalScheme.getKey().getId().trim());
                defaultChildren = this.defaultPostalScheme.getChildrenConcepts();
            }
        } else if (postalScheme != null) {
            defaultChildren = postalScheme.getChildrenConcepts();
        }
        Iterator jaxrIterator = jaxrChildren.iterator();
        while (jaxrIterator.hasNext()) {
            boolean match = false;
            this.logger.finest("checking to see if there are equivalent concepts for postalAddressMapping");
            Concept jaxrPostalConcept = (Concept)jaxrIterator.next();
            this.logger.finest("first postal key " + jaxrPostalConcept.getKey().getId());
            Concept jaxrEquivalentConcept = (Concept)this.equivalentConcepts.get(jaxrPostalConcept.getValue());
            if (jaxrEquivalentConcept == null) {
                this.logger.finest("no Equivalent Concept found in equivalentConcepts");
                this.postalAddressMap.put(jaxrPostalConcept.getValue(), null);
            }
            if (jaxrEquivalentConcept == null) continue;
            String equivConceptValue = jaxrEquivalentConcept.getValue();
            this.logger.finest("Equivalent Concept id " + equivConceptValue);
            if (defaultChildren != null) {
                for (Concept defaultPostalConcept : defaultChildren) {
                    String defaultValue = defaultPostalConcept.getValue();
                    this.logger.finest("defaultI value " + defaultValue);
                    if (!defaultValue.equalsIgnoreCase(equivConceptValue)) continue;
                    this.logger.finest("putting in postalAddressMap");
                    this.postalAddressMap.put(jaxrPostalConcept.getValue(), defaultPostalConcept);
                    match = true;
                }
            } else {
                this.postalAddressMap.put(jaxrPostalConcept.getValue(), null);
            }
            if (match) continue;
            this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:No_match_found_for_JAXR_Postal_Address_Atribute_") + jaxrPostalConcept.getValue());
        }
    }

    ClassificationScheme getClassificationSchemeById(String id) throws JAXRException {
        if (id == null) {
            return null;
        }
        return this.getConceptsManager().getClassificationSchemeById(id);
    }

    void initPostalSchemes() throws JAXRException {
        this.initSemanticEquivalences();
        Collection jaxrPostalChildren = null;
        this.jaxrPostalAddressScheme = this.getConceptsManager().getClassificationSchemeById("PostalAddressAttributes");
        if (this.jaxrPostalAddressScheme == null) {
            this.logger.finest("Didn't find JAXR PostalAddressAttributes");
        } else {
            jaxrPostalChildren = this.jaxrPostalAddressScheme.getChildrenConcepts();
            if (jaxrPostalChildren != null) {
                this.logger.finest("got jaxr postal children");
            }
        }
        this.defaultPostalScheme = this.service.getDefaultPostalScheme();
        Collection defaultChildren = null;
        if (this.defaultPostalScheme != null) {
            defaultChildren = this.defaultPostalScheme.getChildrenConcepts();
            if (defaultChildren != null) {
                this.logger.finest("got default children");
            }
        } else {
            this.logger.finest("default Postal Scheme not found");
        }
    }

    private void initSemanticEquivalences() throws JAXRException {
        this.semanticEquivalences = this.getConnection().getSemanticEquivalences();
        if (this.semanticEquivalences == null) {
            this.logger.finest("SemanticEquivalences are null");
            return;
        }
        Collection jaxrPostalChildren = null;
        this.jaxrPostalAddressScheme = this.getConceptsManager().getClassificationSchemeById("PostalAddressAttributes");
        if (this.jaxrPostalAddressScheme == null) {
            this.logger.finest("Didn't find JAXR PostalAddressAttributes");
        } else {
            jaxrPostalChildren = this.jaxrPostalAddressScheme.getChildrenConcepts();
            if (jaxrPostalChildren != null) {
                this.logger.finest("got jaxr postal children " + jaxrPostalChildren.size());
            }
        }
        ClassificationScheme defaultScheme = this.service.getDefaultPostalScheme();
        Collection childConcepts = null;
        if (defaultScheme != null) {
            childConcepts = defaultScheme.getChildrenConcepts();
        }
        Set keys = this.semanticEquivalences.keySet();
        Iterator keyIter = keys.iterator();
        Collection values = this.semanticEquivalences.values();
        Iterator valIter = values.iterator();
        while (keyIter.hasNext()) {
            String value;
            String key = (String)keyIter.next();
            if (valIter.hasNext()) {
                String string2 = (String)valIter.next();
            }
            if (key == null) {
                this.logger.finest("key is null");
            }
            if ((value = (String)this.semanticEquivalences.get(key)) == null) {
                this.logger.finest("Value is null");
            }
            Concept keyConcept = null;
            Concept valueConcept = null;
            if (key == null || value == null) continue;
            key = key.trim();
            value = value.trim();
            for (Concept jconcept : jaxrPostalChildren) {
                if (!jconcept.getKey().getId().equalsIgnoreCase(key)) continue;
                keyConcept = jconcept;
                break;
            }
            if (keyConcept == null) {
                this.logger.finest("Did not find jaxr child key Equivalent Concept");
                continue;
            }
            if (childConcepts != null) {
                for (Concept child : childConcepts) {
                    Key ckey = child.getKey();
                    String cid = null;
                    if (ckey != null) {
                        cid = ckey.getId();
                    }
                    if (cid == null || !cid.equalsIgnoreCase(value)) continue;
                    valueConcept = child;
                    break;
                }
            }
            if (valueConcept == null) {
                this.logger.finest("Did not find value Equivalent Concept");
            }
            if (this.equivalentConcepts == null) {
                this.equivalentConcepts = new HashMap();
            }
            this.logger.finest("putting keyConcept valueConcept");
            this.equivalentConcepts.put(keyConcept.getValue(), valueConcept);
        }
    }

    static {
        manager = null;
    }
}

